import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#create_option ManagedDisk#create_option}
    */
    readonly createOption: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#disk_size_gb ManagedDisk#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#hyper_v_generation ManagedDisk#hyper_v_generation}
    */
    readonly hyperVGeneration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#id ManagedDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#image_reference_id ManagedDisk#image_reference_id}
    */
    readonly imageReferenceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#location ManagedDisk#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#name ManagedDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#os_type ManagedDisk#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#resource_group_name ManagedDisk#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#source_resource_id ManagedDisk#source_resource_id}
    */
    readonly sourceResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#source_uri ManagedDisk#source_uri}
    */
    readonly sourceUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#storage_account_id ManagedDisk#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#storage_account_type ManagedDisk#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#tags ManagedDisk#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#encryption ManagedDisk#encryption}
    */
    readonly encryption?: ManagedDiskEncryption;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#timeouts ManagedDisk#timeouts}
    */
    readonly timeouts?: ManagedDiskTimeouts;
}
export interface ManagedDiskEncryptionDiskEncryptionKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#secret_url ManagedDisk#secret_url}
    */
    readonly secretUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#source_vault_id ManagedDisk#source_vault_id}
    */
    readonly sourceVaultId: string;
}
export declare function managedDiskEncryptionDiskEncryptionKeyToTerraform(struct?: ManagedDiskEncryptionDiskEncryptionKeyOutputReference | ManagedDiskEncryptionDiskEncryptionKey): any;
export declare class ManagedDiskEncryptionDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDiskEncryptionDiskEncryptionKey | undefined;
    set internalValue(value: ManagedDiskEncryptionDiskEncryptionKey | undefined);
    private _secretUrl?;
    get secretUrl(): string;
    set secretUrl(value: string);
    get secretUrlInput(): string | undefined;
    private _sourceVaultId?;
    get sourceVaultId(): string;
    set sourceVaultId(value: string);
    get sourceVaultIdInput(): string | undefined;
}
export interface ManagedDiskEncryptionKeyEncryptionKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#key_url ManagedDisk#key_url}
    */
    readonly keyUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#source_vault_id ManagedDisk#source_vault_id}
    */
    readonly sourceVaultId: string;
}
export declare function managedDiskEncryptionKeyEncryptionKeyToTerraform(struct?: ManagedDiskEncryptionKeyEncryptionKeyOutputReference | ManagedDiskEncryptionKeyEncryptionKey): any;
export declare class ManagedDiskEncryptionKeyEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDiskEncryptionKeyEncryptionKey | undefined;
    set internalValue(value: ManagedDiskEncryptionKeyEncryptionKey | undefined);
    private _keyUrl?;
    get keyUrl(): string;
    set keyUrl(value: string);
    get keyUrlInput(): string | undefined;
    private _sourceVaultId?;
    get sourceVaultId(): string;
    set sourceVaultId(value: string);
    get sourceVaultIdInput(): string | undefined;
}
export interface ManagedDiskEncryption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#enabled ManagedDisk#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#disk_encryption_key ManagedDisk#disk_encryption_key}
    */
    readonly diskEncryptionKey?: ManagedDiskEncryptionDiskEncryptionKey;
    /**
    * key_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#key_encryption_key ManagedDisk#key_encryption_key}
    */
    readonly keyEncryptionKey?: ManagedDiskEncryptionKeyEncryptionKey;
}
export declare function managedDiskEncryptionToTerraform(struct?: ManagedDiskEncryptionOutputReference | ManagedDiskEncryption): any;
export declare class ManagedDiskEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDiskEncryption | undefined;
    set internalValue(value: ManagedDiskEncryption | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diskEncryptionKey;
    get diskEncryptionKey(): ManagedDiskEncryptionDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: ManagedDiskEncryptionDiskEncryptionKey): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): ManagedDiskEncryptionDiskEncryptionKey | undefined;
    private _keyEncryptionKey;
    get keyEncryptionKey(): ManagedDiskEncryptionKeyEncryptionKeyOutputReference;
    putKeyEncryptionKey(value: ManagedDiskEncryptionKeyEncryptionKey): void;
    resetKeyEncryptionKey(): void;
    get keyEncryptionKeyInput(): ManagedDiskEncryptionKeyEncryptionKey | undefined;
}
export interface ManagedDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#create ManagedDisk#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#delete ManagedDisk#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#read ManagedDisk#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk#update ManagedDisk#update}
    */
    readonly update?: string;
}
export declare function managedDiskTimeoutsToTerraform(struct?: ManagedDiskTimeoutsOutputReference | ManagedDiskTimeouts | cdktf.IResolvable): any;
export declare class ManagedDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDiskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedDiskTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk azurestack_managed_disk}
*/
export declare class ManagedDisk extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurestack_managed_disk";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/r/managed_disk azurestack_managed_disk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedDiskConfig
    */
    constructor(scope: Construct, id: string, config: ManagedDiskConfig);
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    get createOptionInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _hyperVGeneration?;
    get hyperVGeneration(): string;
    set hyperVGeneration(value: string);
    resetHyperVGeneration(): void;
    get hyperVGenerationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageReferenceId?;
    get imageReferenceId(): string;
    set imageReferenceId(value: string);
    resetImageReferenceId(): void;
    get imageReferenceIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceResourceId?;
    get sourceResourceId(): string;
    set sourceResourceId(value: string);
    resetSourceResourceId(): void;
    get sourceResourceIdInput(): string | undefined;
    private _sourceUri?;
    get sourceUri(): string;
    set sourceUri(value: string);
    resetSourceUri(): void;
    get sourceUriInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _encryption;
    get encryption(): ManagedDiskEncryptionOutputReference;
    putEncryption(value: ManagedDiskEncryption): void;
    resetEncryption(): void;
    get encryptionInput(): ManagedDiskEncryption | undefined;
    private _timeouts;
    get timeouts(): ManagedDiskTimeoutsOutputReference;
    putTimeouts(value: ManagedDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ManagedDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
