import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackVirtualNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network#id DataAzurestackVirtualNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network#name DataAzurestackVirtualNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network#resource_group_name DataAzurestackVirtualNetwork#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network#timeouts DataAzurestackVirtualNetwork#timeouts}
    */
    readonly timeouts?: DataAzurestackVirtualNetworkTimeouts;
}
export interface DataAzurestackVirtualNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network#read DataAzurestackVirtualNetwork#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackVirtualNetworkTimeoutsToTerraform(struct?: DataAzurestackVirtualNetworkTimeoutsOutputReference | DataAzurestackVirtualNetworkTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackVirtualNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackVirtualNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackVirtualNetworkTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network azurestack_virtual_network}
*/
export declare class DataAzurestackVirtualNetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_virtual_network";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network azurestack_virtual_network} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackVirtualNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackVirtualNetworkConfig);
    get addressSpace(): string[];
    get dnsServers(): string[];
    get guid(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get subnets(): string[];
    private _vnetPeerings;
    get vnetPeerings(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurestackVirtualNetworkTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackVirtualNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackVirtualNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
