import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackVirtualNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway#id DataAzurestackVirtualNetworkGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway#name DataAzurestackVirtualNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway#resource_group_name DataAzurestackVirtualNetworkGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway#timeouts DataAzurestackVirtualNetworkGateway#timeouts}
    */
    readonly timeouts?: DataAzurestackVirtualNetworkGatewayTimeouts;
}
export interface DataAzurestackVirtualNetworkGatewayBgpSettings {
}
export declare function dataAzurestackVirtualNetworkGatewayBgpSettingsToTerraform(struct?: DataAzurestackVirtualNetworkGatewayBgpSettings): any;
export declare class DataAzurestackVirtualNetworkGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackVirtualNetworkGatewayBgpSettings | undefined;
    set internalValue(value: DataAzurestackVirtualNetworkGatewayBgpSettings | undefined);
    get asn(): number;
    get peerWeight(): number;
    get peeringAddress(): string;
}
export declare class DataAzurestackVirtualNetworkGatewayBgpSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackVirtualNetworkGatewayBgpSettingsOutputReference;
}
export interface DataAzurestackVirtualNetworkGatewayIpConfiguration {
}
export declare function dataAzurestackVirtualNetworkGatewayIpConfigurationToTerraform(struct?: DataAzurestackVirtualNetworkGatewayIpConfiguration): any;
export declare class DataAzurestackVirtualNetworkGatewayIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackVirtualNetworkGatewayIpConfiguration | undefined;
    set internalValue(value: DataAzurestackVirtualNetworkGatewayIpConfiguration | undefined);
    get name(): string;
    get privateIpAddressAllocation(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurestackVirtualNetworkGatewayIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackVirtualNetworkGatewayIpConfigurationOutputReference;
}
export interface DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate {
}
export declare function dataAzurestackVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateToTerraform(struct?: DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate): any;
export declare class DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate | undefined;
    set internalValue(value: DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate | undefined);
    get name(): string;
    get thumbprint(): string;
}
export declare class DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateOutputReference;
}
export interface DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRootCertificate {
}
export declare function dataAzurestackVirtualNetworkGatewayVpnClientConfigurationRootCertificateToTerraform(struct?: DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRootCertificate): any;
export declare class DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRootCertificate | undefined;
    set internalValue(value: DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRootCertificate | undefined);
    get name(): string;
    get publicCertData(): string;
}
export declare class DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRootCertificateOutputReference;
}
export interface DataAzurestackVirtualNetworkGatewayVpnClientConfiguration {
}
export declare function dataAzurestackVirtualNetworkGatewayVpnClientConfigurationToTerraform(struct?: DataAzurestackVirtualNetworkGatewayVpnClientConfiguration): any;
export declare class DataAzurestackVirtualNetworkGatewayVpnClientConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackVirtualNetworkGatewayVpnClientConfiguration | undefined;
    set internalValue(value: DataAzurestackVirtualNetworkGatewayVpnClientConfiguration | undefined);
    get addressSpace(): string[];
    get radiusServerAddress(): string;
    get radiusServerSecret(): string;
    private _revokedCertificate;
    get revokedCertificate(): DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateList;
    private _rootCertificate;
    get rootCertificate(): DataAzurestackVirtualNetworkGatewayVpnClientConfigurationRootCertificateList;
    get vpnClientProtocols(): string[];
}
export declare class DataAzurestackVirtualNetworkGatewayVpnClientConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackVirtualNetworkGatewayVpnClientConfigurationOutputReference;
}
export interface DataAzurestackVirtualNetworkGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway#read DataAzurestackVirtualNetworkGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackVirtualNetworkGatewayTimeoutsToTerraform(struct?: DataAzurestackVirtualNetworkGatewayTimeoutsOutputReference | DataAzurestackVirtualNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackVirtualNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackVirtualNetworkGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackVirtualNetworkGatewayTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway azurestack_virtual_network_gateway}
*/
export declare class DataAzurestackVirtualNetworkGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_virtual_network_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/virtual_network_gateway azurestack_virtual_network_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackVirtualNetworkGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackVirtualNetworkGatewayConfig);
    get activeActive(): cdktf.IResolvable;
    private _bgpSettings;
    get bgpSettings(): DataAzurestackVirtualNetworkGatewayBgpSettingsList;
    get defaultLocalNetworkGatewayId(): string;
    get enableBgp(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipConfiguration;
    get ipConfiguration(): DataAzurestackVirtualNetworkGatewayIpConfigurationList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
    private _vpnClientConfiguration;
    get vpnClientConfiguration(): DataAzurestackVirtualNetworkGatewayVpnClientConfigurationList;
    get vpnType(): string;
    private _timeouts;
    get timeouts(): DataAzurestackVirtualNetworkGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackVirtualNetworkGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackVirtualNetworkGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
