import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackNetworkInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_interface#id DataAzurestackNetworkInterface#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_interface#name DataAzurestackNetworkInterface#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_interface#resource_group_name DataAzurestackNetworkInterface#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_interface#timeouts DataAzurestackNetworkInterface#timeouts}
    */
    readonly timeouts?: DataAzurestackNetworkInterfaceTimeouts;
}
export interface DataAzurestackNetworkInterfaceIpConfiguration {
}
export declare function dataAzurestackNetworkInterfaceIpConfigurationToTerraform(struct?: DataAzurestackNetworkInterfaceIpConfiguration): any;
export declare class DataAzurestackNetworkInterfaceIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackNetworkInterfaceIpConfiguration | undefined;
    set internalValue(value: DataAzurestackNetworkInterfaceIpConfiguration | undefined);
    get applicationGatewayBackendAddressPoolsIds(): string[];
    get loadBalancerBackendAddressPoolsIds(): string[];
    get loadBalancerInboundNatRulesIds(): string[];
    get name(): string;
    get primary(): cdktf.IResolvable;
    get privateIpAddress(): string;
    get privateIpAddressAllocation(): string;
    get privateIpAddressVersion(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurestackNetworkInterfaceIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackNetworkInterfaceIpConfigurationOutputReference;
}
export interface DataAzurestackNetworkInterfaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_interface#read DataAzurestackNetworkInterface#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackNetworkInterfaceTimeoutsToTerraform(struct?: DataAzurestackNetworkInterfaceTimeoutsOutputReference | DataAzurestackNetworkInterfaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackNetworkInterfaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackNetworkInterfaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackNetworkInterfaceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/network_interface azurestack_network_interface}
*/
export declare class DataAzurestackNetworkInterface extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_network_interface";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/network_interface azurestack_network_interface} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackNetworkInterfaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackNetworkInterfaceConfig);
    get appliedDnsServers(): string[];
    get dnsServers(): string[];
    get enableIpForwarding(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get internalDnsNameLabel(): string;
    private _ipConfiguration;
    get ipConfiguration(): DataAzurestackNetworkInterfaceIpConfigurationList;
    get location(): string;
    get macAddress(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkSecurityGroupId(): string;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get virtualMachineId(): string;
    private _timeouts;
    get timeouts(): DataAzurestackNetworkInterfaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackNetworkInterfaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackNetworkInterfaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
