import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackLocalNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/local_network_gateway#id DataAzurestackLocalNetworkGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/local_network_gateway#name DataAzurestackLocalNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/local_network_gateway#resource_group_name DataAzurestackLocalNetworkGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/local_network_gateway#timeouts DataAzurestackLocalNetworkGateway#timeouts}
    */
    readonly timeouts?: DataAzurestackLocalNetworkGatewayTimeouts;
}
export interface DataAzurestackLocalNetworkGatewayBgpSettings {
}
export declare function dataAzurestackLocalNetworkGatewayBgpSettingsToTerraform(struct?: DataAzurestackLocalNetworkGatewayBgpSettings): any;
export declare class DataAzurestackLocalNetworkGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackLocalNetworkGatewayBgpSettings | undefined;
    set internalValue(value: DataAzurestackLocalNetworkGatewayBgpSettings | undefined);
    get asn(): number;
    get bgpPeeringAddress(): string;
    get peerWeight(): number;
}
export declare class DataAzurestackLocalNetworkGatewayBgpSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackLocalNetworkGatewayBgpSettingsOutputReference;
}
export interface DataAzurestackLocalNetworkGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/local_network_gateway#read DataAzurestackLocalNetworkGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackLocalNetworkGatewayTimeoutsToTerraform(struct?: DataAzurestackLocalNetworkGatewayTimeoutsOutputReference | DataAzurestackLocalNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackLocalNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackLocalNetworkGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackLocalNetworkGatewayTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/local_network_gateway azurestack_local_network_gateway}
*/
export declare class DataAzurestackLocalNetworkGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_local_network_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/local_network_gateway azurestack_local_network_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackLocalNetworkGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackLocalNetworkGatewayConfig);
    get addressSpace(): string[];
    private _bgpSettings;
    get bgpSettings(): DataAzurestackLocalNetworkGatewayBgpSettingsList;
    get gatewayAddress(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurestackLocalNetworkGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackLocalNetworkGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackLocalNetworkGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
