import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackKeyVaultAccessPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault_access_policy#id DataAzurestackKeyVaultAccessPolicyA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault_access_policy#name DataAzurestackKeyVaultAccessPolicyA#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault_access_policy#timeouts DataAzurestackKeyVaultAccessPolicyA#timeouts}
    */
    readonly timeouts?: DataAzurestackKeyVaultAccessPolicyTimeouts;
}
export interface DataAzurestackKeyVaultAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault_access_policy#read DataAzurestackKeyVaultAccessPolicyA#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackKeyVaultAccessPolicyTimeoutsToTerraform(struct?: DataAzurestackKeyVaultAccessPolicyTimeoutsOutputReference | DataAzurestackKeyVaultAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackKeyVaultAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackKeyVaultAccessPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackKeyVaultAccessPolicyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault_access_policy azurestack_key_vault_access_policy}
*/
export declare class DataAzurestackKeyVaultAccessPolicyA extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_key_vault_access_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault_access_policy azurestack_key_vault_access_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackKeyVaultAccessPolicyAConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackKeyVaultAccessPolicyAConfig);
    get certificatePermissions(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyPermissions(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get secretPermissions(): string[];
    private _timeouts;
    get timeouts(): DataAzurestackKeyVaultAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackKeyVaultAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackKeyVaultAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
