# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['facebook_scraper']

package_data = \
{'': ['*']}

install_requires = \
['browser-cookie3>=0.13.0,<0.14.0',
 'dateparser>=1.0.0,<2.0.0',
 'demjson3>=3.0.5,<4.0.0',
 'requests-html>=0.10.0,<0.11.0']

extras_require = \
{'youtube-dl': ['youtube_dl']}

entry_points = \
{'console_scripts': ['facebook-scraper = facebook_scraper.__main__:run']}

setup_kwargs = {
    'name': 'facebook-scraper',
    'version': '0.2.52',
    'description': 'Scrape Facebook public pages without an API key',
    'long_description': '# Facebook Scraper\n\n[![PyPI download month](https://img.shields.io/pypi/dm/facebook-scraper.svg)](https://pypi.python.org/pypi/facebook-scraper/)\n[![PyPI download week](https://img.shields.io/pypi/dw/facebook-scraper.svg)](https://pypi.python.org/pypi/facebook-scraper/)\n[![PyPI download day](https://img.shields.io/pypi/dd/facebook-scraper.svg)](https://pypi.python.org/pypi/facebook-scraper/)\n\n[![PyPI version](https://img.shields.io/pypi/v/facebook-scraper?color=blue)](https://pypi.python.org/pypi/facebook-scraper/)\n[![PyPI pyversions](https://img.shields.io/pypi/pyversions/facebook-scraper.svg)](https://pypi.python.org/pypi/facebook-scraper/)\n[![GitHub commits since tagged version](https://img.shields.io/github/commits-since/kevinzg/facebook-scraper/v0.2.52)](https://github.com/kevinzg/facebook-scraper/commits/)\n\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n\nScrape Facebook public pages without an API key. Inspired by [twitter-scraper](https://github.com/kennethreitz/twitter-scraper).\n\n\n## Install\n\nTo install the latest release from PyPI:\n\n```sh\npip install facebook-scraper\n```\n\nOr, to install the latest master branch:\n\n```sh\npip install git+https://github.com/kevinzg/facebook-scraper.git\n```\n\n## Usage\n\nSend the unique **page name, profile name, or ID** as the first parameter and you\'re good to go:\n\n```python\n>>> from facebook_scraper import get_posts\n\n>>> for post in get_posts(\'nintendo\', pages=1):\n...     print(post[\'text\'][:50])\n...\nThe final step on the road to the Super Smash Bros\nWe’re headed to PAX East 3/28-3/31 with new games\n```\n\n\n### Optional parameters\n\n*(For the `get_posts` function)*.\n\n- **group**: group id, to scrape groups instead of pages. Default is `None`.\n- **pages**: how many pages of posts to request, the first 2 pages may have no results, so try with a number greater than 2. Default is 10.\n- **timeout**: how many seconds to wait before timing out. Default is 30.\n- **credentials**: tuple of user and password to login before requesting the posts. Default is `None`.\n- **extra_info**: bool, if true the function will try to do an extra request to get the post reactions. Default is False.\n- **youtube_dl**: bool, use Youtube-DL for (high-quality) video extraction. You need to have youtube-dl installed on your environment. Default is False.\n- **post_urls**: list, URLs or post IDs to extract posts from. Alternative to fetching based on username.\n- **cookies**: One of:\n  - The path to a file containing cookies in Netscape or JSON format. You can extract cookies from your browser after logging into Facebook with an extension like [EditThisCookie (Chrome)](https://chrome.google.com/webstore/detail/editthiscookie/fngmhnnpilhplaeedifhccceomclgfbg?hl=en) or [Cookie Quick Manager (Firefox)](https://addons.mozilla.org/en-US/firefox/addon/cookie-quick-manager/). Make sure that you include both the c_user cookie and the xs cookie, you will get an InvalidCookies exception if you don\'t.\n  - A [CookieJar](https://docs.python.org/3.9/library/http.cookiejar.html#http.cookiejar.CookieJar)\n  - A dictionary that can be converted to a CookieJar with [cookiejar_from_dict](https://2.python-requests.org/en/master/api/#requests.cookies.cookiejar_from_dict)\n  - The string `"from_browser"` to try extract Facebook cookies from your browser\n- **options**: Dictionary of options. Set `options={"comments": True}` to extract comments, set `options={"reactors": True}` to extract the people reacting to the post.\nBoth `comments` and `reactors` can also be set to a number to set a limit for the amount of comments/reactors to retrieve.\nThe default limit for comments is 5000 and the default limit for reactors is 3000.\nSet `options={"progress": True}` to get a `tqdm` progress bar while extracting comments and replies.\nSet `options={"allow_extra_requests": False}` to disable making extra requests when extracting post data (required for some things like full text and image links).\nSet `options={"posts_per_page": 200}` to request 200 posts per page. The default is 4.\n\n## CLI usage\n\n```sh\n$ facebook-scraper --filename nintendo_page_posts.csv --pages 10 nintendo\n```\n\nRun `facebook-scraper --help` for more details on CLI usage.\n\n**Note:** If you get a `UnicodeEncodeError` try adding `--encoding utf-8`.\n\n\n## Post example\n\n```python\n{\'available\': True,\n \'comments\': 459,\n \'comments_full\': None,\n \'factcheck\': None,\n \'fetched_time\': datetime.datetime(2021, 4, 20, 13, 39, 53, 651417),\n \'image\': \'https://scontent.fhlz2-1.fna.fbcdn.net/v/t1.6435-9/fr/cp0/e15/q65/58745049_2257182057699568_1761478225390731264_n.jpg?_nc_cat=111&ccb=1-3&_nc_sid=8024bb&_nc_ohc=ygH2fPmfQpAAX92ABYY&_nc_ht=scontent.fhlz2-1.fna&tp=14&oh=7a8a7b4904deb55ec696ae255fff97dd&oe=60A36717\',\n \'images\': [\'https://scontent.fhlz2-1.fna.fbcdn.net/v/t1.6435-9/fr/cp0/e15/q65/58745049_2257182057699568_1761478225390731264_n.jpg?_nc_cat=111&ccb=1-3&_nc_sid=8024bb&_nc_ohc=ygH2fPmfQpAAX92ABYY&_nc_ht=scontent.fhlz2-1.fna&tp=14&oh=7a8a7b4904deb55ec696ae255fff97dd&oe=60A36717\'],\n \'is_live\': False,\n \'likes\': 3509,\n \'link\': \'https://www.nintendo.com/amiibo/line-up/\',\n \'post_id\': \'2257188721032235\',\n \'post_text\': \'Don’t let this diminutive version of the Hero of Time fool you, \'\n              \'Young Link is just as heroic as his fully grown version! Young \'\n              \'Link joins the Super Smash Bros. series of amiibo figures!\\n\'\n              \'\\n\'\n              \'https://www.nintendo.com/amiibo/line-up/\',\n \'post_url\': \'https://facebook.com/story.php?story_fbid=2257188721032235&id=119240841493711\',\n \'reactions\': {\'haha\': 22, \'like\': 2657, \'love\': 706, \'sorry\': 1, \'wow\': 123}, # if `extra_info` was set\n \'reactors\': None,\n \'shared_post_id\': None,\n \'shared_post_url\': None,\n \'shared_text\': \'\',\n \'shared_time\': None,\n \'shared_user_id\': None,\n \'shared_username\': None,\n \'shares\': 441,\n \'text\': \'Don’t let this diminutive version of the Hero of Time fool you, \'\n         \'Young Link is just as heroic as his fully grown version! Young Link \'\n         \'joins the Super Smash Bros. series of amiibo figures!\\n\'\n         \'\\n\'\n         \'https://www.nintendo.com/amiibo/line-up/\',\n \'time\': datetime.datetime(2019, 4, 30, 5, 0, 1),\n \'user_id\': \'119240841493711\',\n \'username\': \'Nintendo\',\n \'video\': None,\n \'video_id\': None,\n \'video_thumbnail\': None,\n \'w3_fb_url\': \'https://www.facebook.com/Nintendo/posts/2257188721032235\'}\n```\n\n\n### Notes\n\n- There is no guarantee that every field will be extracted (they might be `None`).\n- Group posts may be missing some fields like `time` and `post_url`.\n- Group scraping may return only one page and not work on private groups.\n- If you scrape too much, Facebook might temporarily ban your IP.\n- The vast majority of unique IDs on facebook (post IDs, video IDs, photo IDs, comment IDs, profile IDs, etc) can be appended to https://www.facebook.com/ to result in a redirect to the corresponding object.\n- Some functions (such as extracting reactions) require you to be logged into Facebook (pass cookies). If something isn\'t working as expected, try pass cookies and see if that fixes it.\n\n## Profiles\n\nThe `get_profile` function can extract information from a profile\'s about section. Pass in the account name or ID as the first parameter.  \nNote that Facebook serves different information depending on whether you\'re logged in (cookies parameter), such as Date of birth and Gender. Usage:\n\n```python\nfrom facebook_scraper import get_profile\nget_profile("zuck") # Or get_profile("zuck", cookies="cookies.txt")\n```\nOutputs:\n```python\n{\'About\': "I\'m trying to make the world a more open place.",\n \'Education\': \'Harvard University\\n\'\n              \'Computer Science and Psychology\\n\'\n              \'30 August 2002 - 30 April 2004\\n\'\n              \'Phillips Exeter Academy\\n\'\n              \'Classics\\n\'\n              \'School year 2002\\n\'\n              \'Ardsley High School\\n\'\n              \'High School\\n\'\n              \'September 1998 - June 2000\',\n \'Favourite Quotes\': \'"Fortune favors the bold."\\n\'\n                     \'- Virgil, Aeneid X.284\\n\'\n                     \'\\n\'\n                     \'"All children are artists. The problem is how to remain \'\n                     \'an artist once you grow up."\\n\'\n                     \'- Pablo Picasso\\n\'\n                     \'\\n\'\n                     \'"Make things as simple as possible but no simpler."\\n\'\n                     \'- Albert Einstein\',\n \'Name\': \'Mark Zuckerberg\',\n \'Places lived\': [{\'link\': \'/profile.php?id=104022926303756&refid=17\',\n                   \'text\': \'Palo Alto, California\',\n                   \'type\': \'Current town/city\'},\n                  {\'link\': \'/profile.php?id=105506396148790&refid=17\',\n                   \'text\': \'Dobbs Ferry, New York\',\n                   \'type\': \'Home town\'}],\n \'Work\': \'Chan Zuckerberg Initiative\\n\'\n         \'1 December 2015 - Present\\n\'\n         \'Facebook\\n\'\n         \'Founder and CEO\\n\'\n         \'4 February 2004 - Present\\n\'\n         \'Palo Alto, California\\n\'\n         \'Bringing the world closer together.\'}\n```\n\nTo extract friends, pass the argument `friends=True`, or to limit the amount of friends retrieved, set `friends` to the desired number.\n\n## Group info\n\nThe `get_group_info` function can extract info about a group. Pass in the group name or ID as the first parameter.  \nNote that in order to see the list of admins, you need to be logged in (cookies parameter).\n\nUsage:\n\n```python\nfrom facebook_scraper import get_group_info\nget_group_info("latesthairstyles") # or get_group_info("latesthairstyles", cookies="cookies.txt")\n```\n\nOutput:\n\n```python\n{\'admins\': [{\'link\': \'/africanstylemagazinecom/?refid=18\',\n             \'name\': \'African Style Magazine\'},\n            {\'link\': \'/connectfluencer/?refid=18\',\n             \'name\': \'Everythingbrightandbeautiful\'},\n            {\'link\': \'/Kaakakigroup/?refid=18\', \'name\': \'Kaakaki Group\'},\n            {\'link\': \'/opentohelp/?refid=18\', \'name\': \'Open to Help\'}],\n \'id\': \'579169815767106\',\n \'members\': 6814229,\n \'name\': \'HAIRSTYLES\',\n \'type\': \'Public group\'}\n```\n\n## To-Do\n\n- Async support\n- ~~Image galleries~~ (`images` entry)\n- ~~Profiles or post authors~~ (`get_profile()`)\n- ~~Comments~~ (with `options={\'comments\': True}`)\n\n\n## Alternatives and related projects\n\n- [facebook-post-scraper](https://github.com/brutalsavage/facebook-post-scraper). Has comments. Uses Selenium.\n- [facebook-scraper-selenium](https://github.com/apurvmishra99/facebook-scraper-selenium). "Scrape posts from any group or user into a .csv file without needing to register for any API access".\n- [Ultimate Facebook Scraper](https://github.com/harismuneer/Ultimate-Facebook-Scraper).  "Scrapes almost everything about a Facebook user\'s profile". Uses Selenium.\n- [Unofficial APIs](https://github.com/Rolstenhouse/unofficial-apis). List of unofficial APIs for various services, none for Facebook for now, but might be worth to check in the future.\n- [major-scrapy-spiders](https://github.com/talhashraf/major-scrapy-spiders). Has a profile spider for Scrapy.\n- [facebook-page-post-scraper](https://github.com/minimaxir/facebook-page-post-scraper). Seems abandoned.\n    - [FBLYZE](https://github.com/isaacmg/fb_scraper). Fork (?).\n- [RSSHub](https://github.com/DIYgod/RSSHub/blob/master/lib/routes/facebook/page.js). Generates an RSS feed from Facebook pages.\n- [RSS-Bridge](https://github.com/RSS-Bridge/rss-bridge/blob/master/bridges/FacebookBridge.php). Also generates RSS feeds from Facebook pages.\n',
    'author': 'Kevin Zúñiga',
    'author_email': 'kevin.zun@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kevinzg/facebook-scraper',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
