# datashaper

This project provides a collection of utilities for doing lightweight data wrangling.

There are two goals of the project:

1. Create a shareable client/server schema for serialized wrangling instructions
2. Maintain an implementation of a basic wrangling engine (based on Arquero) and in the case of python implemented in Pandas

# Building

- You need to install [poetry](https://python-poetry.org/docs/) python package manager.
- Run: `poetry install`

# Usage

This project is intended to be used as a library for lightweight data wrangling. In the examples folder there is a [Notebook](examples/examples.ipynb) which provides several examples of how to create data wrangling pipelines and how to read json specifications that can be generated by the js implementation.

Example of joining two tables:

```python
from datashaper.pipeline import Pipeline
import datashaper.types as types
import pandas as pd

# id   name
# 1    bob
# 2    joe
# 3    jane
parents = pd.DataFrame({
    "id": [1, 2, 3],
    "name": ['bob', 'joe', 'jane']
})

# id   kid
# 1    billy
# 1    jill
# 2    kaden
# 2    kyle
# 3    moe
kids = pd.DataFrame({
    "id": [1, 1, 2, 2, 3],
    "kid": ['billy', 'jill', 'kaden', 'kyle', 'moe']
})

pipeline = Pipeline()

pipeline.add_dataset('parents', parents)
pipeline.add_dataset('kids', kids)

pipeline.add(Step(
    verb=Verb.join,
    input="parents",
    output="output",
    args={
        "other": "kids",
        "on":["id"]
    }
))

# id   name    kid
# 1    bob     billy
# 1    bob     jill
# 2    joe     kaden
# 2    joe     kyle
# 3    jane    moe
result = pipeline.run()
```

# Contributing

This project welcomes contributions and suggestions. Most contributions require you to agree to a
Contributor License Agreement (CLA) declaring that you have the right to, and actually do, grant us
the rights to use your contribution. For details, visit https://cla.opensource.microsoft.com.

When you submit a pull request, a CLA bot will automatically determine whether you need to provide
a CLA and decorate the PR appropriately (e.g., status check, comment). Simply follow the instructions
provided by the bot. You will only need to do this once across all repos using our CLA.

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or
contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.

# Trademarks

This project may contain trademarks or logos for projects, products, or services. Authorized use of Microsoft
trademarks or logos is subject to and must follow
[Microsoft's Trademark & Brand Guidelines](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general).
Use of Microsoft trademarks or logos in modified versions of this project must not cause confusion or imply Microsoft sponsorship.
Any use of third-party trademarks or logos are subject to those third-party's policies.
