#!/usr/bin/env python
import os
from setuptools import setup, find_packages
import translator

with open(os.path.join(os.path.dirname(__file__), 'README.md')) as f:
    long_description = f.read()

setup(
    name='interpres',
    author='Danny Waser',
    version=translator.__version__,
    license='LICENSE',
    url='https://github.com/wasertech/Translator',
    description='Translate from one language to another.',
    long_description=long_description,
    long_description_content_type='text/markdown',
    packages=find_packages('.'),
    python_requires='>=3.8,<3.11',
    install_requires = [
        'transformers~=4.25.1',
        'langcodes~=3.3.0',
        'datasets~=2.10.1',
        'halo~=0.0.31',
        'psutil~=5.9.4',
        'shutils~=0.1.0',
        'accelerate~=0.17.0',
        'questionary~=1.10.0',
    ],
    entry_points={
        'console_scripts': [
            'translate = translator.main:main',
        ]
    },
    project_urls={
        "Documentation": "https://github.com/wasertech/Translator/blob/main/README.md",
        "Code": "https://github.com/wasertech/Translator",
        "Issue tracker": "https://github.com/wasertech/Translator/issues",
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "License :: OSI Approved :: Mozilla Public License 2.0 (MPL 2.0)",
        "Operating System :: OS Independent",
        "Topic :: Text Processing",
        "Topic :: Terminals",
        "Topic :: System :: Shells",
        "Programming Language :: Unix Shell",
        "Natural Language :: Afrikaans",
        "Natural Language :: Arabic",
        "Natural Language :: Basque",
        "Natural Language :: Bengali",
        "Natural Language :: Bosnian",
        "Natural Language :: Bulgarian",
        "Natural Language :: Cantonese",
        "Natural Language :: Catalan",
        "Natural Language :: Chinese (Simplified)",
        "Natural Language :: Chinese (Traditional)",
        "Natural Language :: Croatian",
        "Natural Language :: Czech",
        "Natural Language :: Danish",
        "Natural Language :: Dutch",
        "Natural Language :: English",
        "Natural Language :: Esperanto",
        "Natural Language :: Finnish",
        "Natural Language :: French",
        "Natural Language :: Galician",
        "Natural Language :: German",
        "Natural Language :: Greek",
        "Natural Language :: Hebrew",
        "Natural Language :: Hindi",
        "Natural Language :: Hungarian",
        "Natural Language :: Icelandic",
        "Natural Language :: Indonesian",
        "Natural Language :: Irish",
        "Natural Language :: Italian",
        "Natural Language :: Japanese",
        "Natural Language :: Javanese",
        "Natural Language :: Korean",
        "Natural Language :: Latin",
        "Natural Language :: Latvian",
        "Natural Language :: Lithuanian",
        "Natural Language :: Macedonian",
        "Natural Language :: Malay",
        "Natural Language :: Marathi",
        "Natural Language :: Nepali",
        "Natural Language :: Norwegian",
        "Natural Language :: Panjabi",
        "Natural Language :: Persian",
        "Natural Language :: Polish",
        "Natural Language :: Portuguese",
        "Natural Language :: Portuguese (Brazilian)",
        "Natural Language :: Romanian",
        "Natural Language :: Russian",
        "Natural Language :: Serbian",
        "Natural Language :: Slovak",
        "Natural Language :: Slovenian",
        "Natural Language :: Spanish",
        "Natural Language :: Swedish",
        "Natural Language :: Tamil",
        "Natural Language :: Telugu",
        "Natural Language :: Thai",
        "Natural Language :: Tibetan",
        "Natural Language :: Turkish",
        "Natural Language :: Ukrainian",
        "Natural Language :: Urdu",
        "Natural Language :: Vietnamese",
    ],
)
