"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallRuleGroup = exports.DnsBlockResponse = exports.FirewallRuleAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const firewall_rule_group_association_1 = require("./firewall-rule-group-association");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * (experimental) A Firewall Rule.
 *
 * @experimental
 */
class FirewallRuleAction {
    /**
     * (experimental) Permit the request to go through.
     *
     * @experimental
     */
    static allow() {
        return { action: 'ALLOW' };
    }
    /**
     * (experimental) Permit the request to go through but send an alert to the logs.
     *
     * @experimental
     */
    static alert() {
        return { action: 'ALERT' };
    }
    /**
     * (experimental) Disallow the request.
     *
     * @param response The way that you want DNS Firewall to block the request.
     * @experimental
     */
    static block(response) {
        return {
            action: 'BLOCK',
            blockResponse: response !== null && response !== void 0 ? response : DnsBlockResponse.noData(),
        };
    }
}
exports.FirewallRuleAction = FirewallRuleAction;
_a = JSII_RTTI_SYMBOL_1;
FirewallRuleAction[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleAction", version: "1.127.0" };
/**
 * (experimental) The way that you want DNS Firewall to block the request.
 *
 * @experimental
 */
class DnsBlockResponse {
    /**
     * (experimental) Respond indicating that the query was successful, but no response is available for it.
     *
     * @experimental
     */
    static noData() {
        return { blockResponse: 'NODATA' };
    }
    /**
     * (experimental) Respond indicating that the domain name that's in the query doesn't exist.
     *
     * @experimental
     */
    static nxDomain() {
        return { blockResponse: 'NXDOMAIN' };
    }
    /**
     * (experimental) Provides a custom override response to the query.
     *
     * @param domain The custom DNS record to send back in response to the query.
     * @param ttl The recommended amount of time for the DNS resolver or web browser to cache the provided override record.
     * @experimental
     */
    static override(domain, ttl) {
        return {
            blockResponse: 'OVERRIDE',
            blockOverrideDnsType: 'CNAME',
            blockOverrideDomain: domain,
            blockOverrideTtl: ttl !== null && ttl !== void 0 ? ttl : core_1.Duration.seconds(0),
        };
    }
}
exports.DnsBlockResponse = DnsBlockResponse;
_b = JSII_RTTI_SYMBOL_1;
DnsBlockResponse[_b] = { fqn: "@aws-cdk/aws-route53resolver.DnsBlockResponse", version: "1.127.0" };
/**
 * (experimental) A Firewall Rule Group.
 *
 * @experimental
 */
class FirewallRuleGroup extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _d;
        super(scope, id);
        this.rules = (_d = props.rules) !== null && _d !== void 0 ? _d : [];
        const ruleGroup = new route53resolver_generated_1.CfnFirewallRuleGroup(this, 'Resource', {
            name: props.name,
            firewallRules: core_1.Lazy.any({ produce: () => this.rules.map(renderRule) }),
        });
        this.firewallRuleGroupId = ruleGroup.attrId;
        this.firewallRuleGroupArn = ruleGroup.attrArn;
        this.firewallRuleGroupCreationTime = ruleGroup.attrCreationTime;
        this.firewallRuleGroupCreatorRequestId = ruleGroup.attrCreatorRequestId;
        this.firewallRuleGroupModificationTime = ruleGroup.attrModificationTime;
        this.firewallRuleGroupOwnerId = ruleGroup.attrOwnerId;
        this.firewallRuleGroupRuleCount = ruleGroup.attrRuleCount;
        this.firewallRuleGroupShareStatus = ruleGroup.attrShareStatus;
        this.firewallRuleGroupStatus = ruleGroup.attrStatus;
        this.firewallRuleGroupStatusMessage = ruleGroup.attrStatusMessage;
    }
    /**
     * (experimental) Import an existing Firewall Rule Group.
     *
     * @experimental
     */
    static fromFirewallRuleGroupId(scope, id, firewallRuleGroupId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.firewallRuleGroupId = firewallRuleGroupId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Adds a rule to this group.
     *
     * @experimental
     */
    addRule(rule) {
        this.rules.push(rule);
        return this;
    }
    /**
     * (experimental) Associates this Firewall Rule Group with a VPC.
     *
     * @experimental
     */
    associate(id, props) {
        return new firewall_rule_group_association_1.FirewallRuleGroupAssociation(this, id, {
            ...props,
            firewallRuleGroup: this,
        });
    }
}
exports.FirewallRuleGroup = FirewallRuleGroup;
_c = JSII_RTTI_SYMBOL_1;
FirewallRuleGroup[_c] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleGroup", version: "1.127.0" };
function renderRule(rule) {
    var _d, _e, _f, _g, _h;
    return {
        action: rule.action.action,
        firewallDomainListId: rule.firewallDomainList.firewallDomainListId,
        priority: rule.priority,
        blockOverrideDnsType: (_d = rule.action.blockResponse) === null || _d === void 0 ? void 0 : _d.blockOverrideDnsType,
        blockOverrideDomain: (_e = rule.action.blockResponse) === null || _e === void 0 ? void 0 : _e.blockOverrideDomain,
        blockOverrideTtl: (_g = (_f = rule.action.blockResponse) === null || _f === void 0 ? void 0 : _f.blockOverrideTtl) === null || _g === void 0 ? void 0 : _g.toSeconds(),
        blockResponse: (_h = rule.action.blockResponse) === null || _h === void 0 ? void 0 : _h.blockResponse,
    };
}
//# sourceMappingURL=data:application/json;base64,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