"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnReplicaKey = exports.CfnKey = exports.CfnAlias = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-04-07T10:24:53.258Z","fingerprint":"VqL9eJBoIJdn4QXIkwd3IpVarXm2iOEWsmkjJ6RR8iU="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnAliasProps`
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the result of the validation.
 */
function CfnAliasPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aliasName', cdk.requiredValidator)(properties.aliasName));
    errors.collect(cdk.propertyValidator('aliasName', cdk.validateString)(properties.aliasName));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.requiredValidator)(properties.targetKeyId));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.validateString)(properties.targetKeyId));
    return errors.wrap('supplied properties not correct for "CfnAliasProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Alias` resource
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Alias` resource.
 */
// @ts-ignore TS6133
function cfnAliasPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAliasPropsValidator(properties).assertSuccess();
    return {
        AliasName: cdk.stringToCloudFormation(properties.aliasName),
        TargetKeyId: cdk.stringToCloudFormation(properties.targetKeyId),
    };
}
// @ts-ignore TS6133
function CfnAliasPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aliasName', 'AliasName', cfn_parse.FromCloudFormation.getString(properties.AliasName));
    ret.addPropertyResult('targetKeyId', 'TargetKeyId', cfn_parse.FromCloudFormation.getString(properties.TargetKeyId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Alias`
 *
 * The `AWS::KMS::Alias` resource specifies a display name for a [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) . You can use an alias to identify a KMS key in the AWS KMS console, in the [DescribeKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html) operation, and in [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) , such as [Decrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html) and [GenerateDataKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKey.html) .
 *
 * > Adding, deleting, or updating an alias can allow or deny permission to the KMS key. For details, see [ABAC for AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in the *AWS Key Management Service Developer Guide* .
 *
 * Using an alias to refer to a KMS key can help you simplify key management. For example, an alias in your code can be associated with different KMS keys in different AWS Regions . For more information, see [Using aliases](https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html) in the *AWS Key Management Service Developer Guide* .
 *
 * When specifying an alias, observe the following rules.
 *
 * - Each alias is associated with one KMS key, but multiple aliases can be associated with the same KMS key.
 * - The alias and its associated KMS key must be in the same AWS account and Region.
 * - The alias name must be unique in the AWS account and Region. However, you can create aliases with the same name in different AWS Regions . For example, you can have an `alias/projectKey` in multiple Regions, each of which is associated with a KMS key in its Region.
 * - Each alias name must begin with `alias/` followed by a name, such as `alias/exampleKey` . The alias name can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). Alias names cannot begin with `alias/aws/` . That alias name prefix is reserved for [AWS managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk) .
 *
 * @cloudformationResource AWS::KMS::Alias
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html
 */
class CfnAlias extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAlias.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnAliasProps(props);
        cdk.requireProperty(props, 'aliasName', this);
        cdk.requireProperty(props, 'targetKeyId', this);
        this.aliasName = props.aliasName;
        this.targetKeyId = props.targetKeyId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAliasPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAlias(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAlias.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            aliasName: this.aliasName,
            targetKeyId: this.targetKeyId,
        };
    }
    renderProperties(props) {
        return cfnAliasPropsToCloudFormation(props);
    }
}
exports.CfnAlias = CfnAlias;
_a = JSII_RTTI_SYMBOL_1;
CfnAlias[_a] = { fqn: "@aws-cdk/aws-kms.CfnAlias", version: "1.152.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAlias.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Alias";
/**
 * Determine whether the given properties match those of a `CfnKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enableKeyRotation', cdk.validateBoolean)(properties.enableKeyRotation));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keySpec', cdk.validateString)(properties.keySpec));
    errors.collect(cdk.propertyValidator('keyUsage', cdk.validateString)(properties.keyUsage));
    errors.collect(cdk.propertyValidator('multiRegion', cdk.validateBoolean)(properties.multiRegion));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Key` resource
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Key` resource.
 */
// @ts-ignore TS6133
function cfnKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EnableKeyRotation: cdk.booleanToCloudFormation(properties.enableKeyRotation),
        KeySpec: cdk.stringToCloudFormation(properties.keySpec),
        KeyUsage: cdk.stringToCloudFormation(properties.keyUsage),
        MultiRegion: cdk.booleanToCloudFormation(properties.multiRegion),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('enableKeyRotation', 'EnableKeyRotation', properties.EnableKeyRotation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableKeyRotation) : undefined);
    ret.addPropertyResult('keySpec', 'KeySpec', properties.KeySpec != null ? cfn_parse.FromCloudFormation.getString(properties.KeySpec) : undefined);
    ret.addPropertyResult('keyUsage', 'KeyUsage', properties.KeyUsage != null ? cfn_parse.FromCloudFormation.getString(properties.KeyUsage) : undefined);
    ret.addPropertyResult('multiRegion', 'MultiRegion', properties.MultiRegion != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiRegion) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Key`
 *
 * The `AWS::KMS::Key` resource specifies a [symmetric or asymmetric](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) in AWS Key Management Service ( AWS KMS ).
 *
 * You can use the `AWS::KMS::Key` resource to specify a symmetric or asymmetric multi-Region primary key. To specify a replica key, use the [AWS::KMS::ReplicaKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html) resource. For information about multi-Region keys, see [Multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You cannot use the `AWS::KMS::Key` resource to specify a KMS key with [imported key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html) or a KMS key in a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) .
 *
 * > AWS KMS is replacing the term *customer master key (CMK)* with *AWS KMS key* and *KMS key* . The concept has not changed. To prevent breaking changes, AWS KMS is keeping some variations of this term.
 *
 * You can use symmetric KMS keys to encrypt and decrypt small amounts of data, but they are more commonly used to generate data keys and data key pairs. You can also use symmetric KMS key to encrypt data stored in AWS services that are [integrated with AWS KMS](https://docs.aws.amazon.com//kms/features/#AWS_Service_Integration) . For more information, see [What is AWS Key Management Service ?](https://docs.aws.amazon.com/kms/latest/developerguide/overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You can use asymmetric KMS keys to encrypt and decrypt data or sign messages and verify signatures. To create an asymmetric key, you must specify an asymmetric `KeySpec` value and a `KeyUsage` value.
 *
 * > If you change the value of the `KeyUsage` , `KeySpec` , or `MultiRegion` property on an existing KMS key, the existing KMS key is [scheduled for deletion](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html) and a new KMS key is created with the specified value.
 * >
 * > While scheduled for deletion, the existing KMS key becomes unusable. If you don't [cancel the scheduled deletion](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion) of the existing KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are supported in all Regions in which AWS CloudFormation is supported. However, in the  (ap-southeast-3), you cannot use a CloudFormation template to create or manage asymmetric KMS keys or multi-Region KMS keys (primary or replica).
 *
 * @cloudformationResource AWS::KMS::Key
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html
 */
class CfnKey extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::Key`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnKeyProps(props);
        cdk.requireProperty(props, 'keyPolicy', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId'));
        this.keyPolicy = props.keyPolicy;
        this.description = props.description;
        this.enabled = props.enabled;
        this.enableKeyRotation = props.enableKeyRotation;
        this.keySpec = props.keySpec;
        this.keyUsage = props.keyUsage;
        this.multiRegion = props.multiRegion;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::Key", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            description: this.description,
            enabled: this.enabled,
            enableKeyRotation: this.enableKeyRotation,
            keySpec: this.keySpec,
            keyUsage: this.keyUsage,
            multiRegion: this.multiRegion,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnKeyPropsToCloudFormation(props);
    }
}
exports.CfnKey = CfnKey;
_b = JSII_RTTI_SYMBOL_1;
CfnKey[_b] = { fqn: "@aws-cdk/aws-kms.CfnKey", version: "1.152.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Key";
/**
 * Determine whether the given properties match those of a `CfnReplicaKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicaKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.requiredValidator)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.validateString)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnReplicaKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource.
 */
// @ts-ignore TS6133
function cfnReplicaKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicaKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        PrimaryKeyArn: cdk.stringToCloudFormation(properties.primaryKeyArn),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnReplicaKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('primaryKeyArn', 'PrimaryKeyArn', cfn_parse.FromCloudFormation.getString(properties.PrimaryKeyArn));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::ReplicaKey`
 *
 * The `AWS::KMS::ReplicaKey` resource specifies a multi-Region replica key that is based on a multi-Region primary key.
 *
 * *Multi-Region keys* are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see [Multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * A multi-Region *primary key* is a fully functional symmetric or asymmetric KMS key that is also the model for replica keys in other AWS Regions . To create a multi-Region primary key, add an [AWS::KMS::Key](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html) resource to your CloudFormation stack. Set its `MultiRegion` property to true.
 *
 * A multi-Region *replica key* is a fully functional symmetric or asymmetric KMS key that has the same key ID and key material as a multi-Region primary key, but is located in a different AWS Region of the same AWS partition. There can be multiple replicas of a primary key, but each must be in a different AWS Region .
 *
 * A primary key and its replicas have the same key ID and key material. They also have the same key spec, key usage, key material origin, and automatic key rotation status. These properties are known as *shared properties* . If they change, AWS KMS synchronizes the change to all related multi-Region keys. All other properties of a replica key can differ, including its key policy, tags, aliases, and key state. AWS KMS does not synchronize these properties.
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are supported in all Regions in which AWS CloudFormation is supported. However, in the  (ap-southeast-3), you cannot use a CloudFormation template to create or manage multi-Region KMS keys (primary or replica).
 *
 * @cloudformationResource AWS::KMS::ReplicaKey
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html
 */
class CfnReplicaKey extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::ReplicaKey`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicaKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnReplicaKeyProps(props);
        cdk.requireProperty(props, 'keyPolicy', this);
        cdk.requireProperty(props, 'primaryKeyArn', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId'));
        this.keyPolicy = props.keyPolicy;
        this.primaryKeyArn = props.primaryKeyArn;
        this.description = props.description;
        this.enabled = props.enabled;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::ReplicaKey", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicaKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicaKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicaKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            primaryKeyArn: this.primaryKeyArn,
            description: this.description,
            enabled: this.enabled,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnReplicaKeyPropsToCloudFormation(props);
    }
}
exports.CfnReplicaKey = CfnReplicaKey;
_c = JSII_RTTI_SYMBOL_1;
CfnReplicaKey[_c] = { fqn: "@aws-cdk/aws-kms.CfnReplicaKey", version: "1.152.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicaKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::ReplicaKey";
//# sourceMappingURL=data:application/json;base64,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