"""
Easy-to-read color definitions

This module defines intuitive color names in a normalised RGB format w/ floating-point values 
between 0.0 and 1.0 (incl. "alpha" opacity as 4th value) as shown below. For some **kwargs, 
owever, these last values may be disregarded if transparency can be set directly.

Format:
    cName = ( R.rr, G.gg, B.bb, alpha )     # ( RRR, GGG, BBB ) | #hexcode

Reference:
    https://www.rapidtables.com/web/color/RGB_Color.html
"""

from matplotlib.colors import rgb2hex # Note: Use this for conversion to HEX (e.g. '#ff0000')


# EXPORTED DATA

#%% RGB-style (1 dominant, additive)

# 100% |   0% |   0%
cRed        = ( 1.00, 0.00, 0.00, 1.00 )    # ( 255,   0,   0 ) | #FF0000
cLime       = ( 0.00, 1.00, 0.00, 1.00 )    # (   0, 255,   0 ) | #00FF00
cBlue       = ( 0.00, 0.00, 1.00, 1.00 )    # (   0,   0, 255 ) | #0000FF
#  50% |   0% |   0%
cMaroon     = ( 0.50, 0.00, 0.00, 1.00 )    # ( 128,   0,   0 ) | #800000
cGreen      = ( 0.00, 0.50, 0.00, 1.00 )    # (   0, 128,   0 ) | #008000
cNavy       = ( 0.00, 0.00, 0.50, 1.00 )    # (   0,   0, 128 ) | #000080
# 100% |  50% |  50%
cRose       = ( 1.00, 0.50, 0.50, 1.00 )    # ( 255, 128, 128 ) | #FF8080
cFig        = ( 0.50, 1.00, 0.50, 1.00 )    # ( 128, 255, 128 ) | #80FF80
cLila       = ( 0.50, 0.50, 1.00, 1.00 )    # ( 128, 128, 255 ) | #8080FF
# ...aliases...
cRed_dark       = cMaroon
cGreen_dark     = cGreen
cBlue_dark      = cNavy
cRed_light      = cRose
cGreen_light    = cFig
cBlue_light     = cLila 


#%% CMY-style (1 missing, subtractive)

#   0% | 100% | 100%
cCyan       = ( 0.00, 1.00, 1.00, 1.00 )    # (   0, 255, 255 ) | #00FFFF
cMagenta    = ( 1.00, 0.00, 1.00, 1.00 )    # ( 255,   0, 255 ) | #FF00FF
cYellow     = ( 1.00, 1.00, 0.00, 1.00 )    # ( 255, 255,   0 ) | #FFFF00
#   0% |  50% |  50%
cTeal       = ( 0.00, 0.50, 0.50, 1.00 )    # (   0, 128, 128 ) | #008080
cPurple     = ( 0.50, 0.00, 0.50, 1.00 )    # ( 128,   0, 128 ) | #800080
cOlive      = ( 0.00, 0.50, 0.50, 1.00 )    # ( 128, 128,   0 ) | #808000
#  50% | 100% | 100%
cIce        = ( 0.50, 1.00, 1.00, 1.00 )    # ( 128, 255, 255 ) | #80FFFF
cPink       = ( 1.00, 0.50, 1.00, 1.00 )    # ( 255, 128, 255 ) | #FF80FF
cCitrus     = ( 1.00, 1.00, 0.50, 1.00 )    # ( 255, 255, 128 ) | #FFFF80
# ...aliases...
cRed_dark       = cMaroon
cGreen_dark     = cGreen
cBlue_dark      = cNavy
cRed_light      = cRose
cGreen_light    = cFig
cBlue_light     = cLila
cAqua           = cCyan
cFuchsia        = cMagenta


#%% MIXED COLORS (w/ "dull names")

# 100% |  50% |   0%
cRed210     = ( 1.00, 0.50, 0.00, 1.00 )    # ( 255, 128,   0 ) | #FF8000
cRed201     = ( 1.00, 0.00, 0.50, 1.00 )    # ( 255,   0, 128 ) | #FF0080
cGreen210   = ( 0.00, 1.00, 0.50, 1.00 )    # (   0, 255, 128 ) | #00FF80
cGreen201   = ( 0.50, 1.00, 0.00, 1.00 )    # ( 128, 255,   0 ) | #80FF00
cBlue210    = ( 0.50, 0.00, 1.00, 1.00 )    # ( 128,   0, 255 ) | #8000FF
cBlue201    = ( 0.00, 0.50, 1.00, 1.00 )    # (   0, 128, 255 ) | #0080FF
# 100% |  67% |  33%
cRed321     = ( 1.00, 0.67, 0.33, 1.00 )    # ( 255, 171,  85 ) | #FFAB55
cRed313     = ( 1.00, 0.33, 0.67, 1.00 )    # ( 255,  85, 171 ) | #FF55AB
cGreen321   = ( 0.33, 1.00, 0.67, 1.00 )    # (  85, 255, 171 ) | #55FFAB
cGreen312   = ( 0.67, 1.00, 0.33, 1.00 )    # ( 171, 255,  85 ) | #ABFF55
cBlue321    = ( 0.67, 0.33, 1.00, 1.00 )    # ( 171,  85, 255 ) | #AB55FF
cBlue312    = ( 0.33, 0.67, 1.00, 1.00 )    # (  85, 171, 255 ) | #55ABFF
# 100% |  75% |  25%
cRed431     = ( 1.00, 0.75, 0.25, 1.00 )    # ( 255, 192,  64 ) | #FFC040
cRed413     = ( 1.00, 0.25, 0.75, 1.00 )    # ( 255,  64, 192 ) | #FF40C0
cGreen431   = ( 0.25, 1.00, 0.75, 1.00 )    # (  64, 255, 192 ) | #40FFC0
cGreen413   = ( 0.75, 1.00, 0.25, 1.00 )    # ( 192, 255,  64 ) | #C0FF40
cBlue431    = ( 0.75, 0.25, 1.00, 1.00 )    # ( 192,  64, 255 ) | #C040FF
cBlue413    = ( 0.25, 0.75, 1.00, 1.00 )    # (  64, 192, 255 ) | #40C0FF
# 100% | 87.5% | 12.5%
cRed871     = ( 1.00, 0.875, 0.125, 1.00 )  # ( 255, 224,  32 ) | #FFE020
cRed817     = ( 1.00, 0.125, 0.875, 1.00 )  # ( 224,  32, 192 ) | #FF20E0
cGreen871   = ( 0.125, 1.00, 0.875, 1.00 )  # (  32, 224, 192 ) | #20FFE0
cGreen817   = ( 0.875, 1.00, 0.125, 1.00 )  # ( 224, 255,  32 ) | #E0FF20
cBlue871    = ( 0.875, 0.125, 1.00, 1.00 )  # ( 224,  32, 255 ) | #E020FF
cBlue817    = ( 0.125, 0.875, 1.00, 1.00 )  # (  32, 224, 255 ) | #20E0FF


#%% POPULAR COLORS (slightly modified from "rapidtables", see above)

# Red-ish
cFirebrick  = ( 0.625000, 0.125000, 0.125000, 1.0 ) # ( 160,  32,  32 ) | #A02020
cCrimson    = ( 0.859375, 0.078125, 0.234375, 1.0 ) # ( 220,  20,  60 ) | #DC143C
cTomato     = ( 1.000000, 0.234375, 0.062500, 1.0 ) # ( 255,  60,  16 ) | #FF3C10
cCoral      = ( 1.000000, 0.496094, 0.312500, 1.0 ) # ( 255, 127,  80 ) | #FF7F50
cSalmon     = ( 1.000000, 0.687500, 0.531250, 1.0 ) # ( 255, 176, 136 ) | #FFB088
# Yellow-ish
cGoldenRod  = ( 0.851563, 0.644531, 0.125000, 1.0 ) # ( 218, 165,  32 ) | #DAA520
cGold       = ( 1.000000, 0.839844, 0.000000, 1.0 ) # ( 255, 215,   0 ) | #FFD700
cKhaki      = ( 0.738281, 0.714844, 0.417969, 1.0 ) # ( 189, 183, 107 ) | #BDB76B
cWheat      = ( 0.957031, 0.867188, 0.699219, 1.0 ) # ( 245, 222, 179 ) | #F5DEB3
# Green-ish
cForest     = ( 0.125000, 0.578125, 0.125000, 1.0 ) # (  32, 148,  32 ) | #209420
cSeaGreen   = ( 0.234375, 0.699219, 0.441406, 1.0 ) # (  60, 179, 113 ) | #3CB371
cSpring     = ( 0.000000, 1.000000, 0.496094, 1.0 ) # (   0, 255, 127 ) | #00FF7F
cPaleGreen  = ( 0.593750, 1.000000, 0.593750, 1.0 ) # ( 152, 255, 152 ) | #98FF98
cGreenYello = ( 0.671875, 1.000000, 0.187500, 1.0 ) # ( 172, 255,  48 ) | #ACFF30
# Lila-ish
cDeepPink   = ( 1.000000, 0.078125, 0.574219, 1.0 ) # ( 255,  20, 147 ) | #FF1493
cWarmPink   = ( 1.000000, 0.437500, 0.703125, 1.0 ) # ( 255, 112, 180 ) | #FF70B4
cViolet     = ( 0.929688, 0.507812, 0.929688, 1.0 ) # ( 238, 130, 238 ) | #EE82EE
cDarkViolet = ( 0.750000, 0.000000, 0.875000, 1.0 ) # ( 192,   0, 224 ) | #C000E0
cBlueViolet = ( 0.539063, 0.167969, 0.882813, 1.0 ) # ( 138,  43, 226 ) | #8A2BE2
# Turk-ish *g*
cSteelBlue  = ( 0.312500, 0.531250, 0.703125, 1.0 ) # (  80, 136, 180 ) | #5088B4
cCadetBlue  = ( 0.359375, 0.625000, 0.625000, 1.0 ) # (  92, 160, 160 ) | #5CA0A0
cDarkTurq   = ( 0.000000, 0.804688, 0.816406, 1.0 ) # (   0, 206, 209 ) | #00CED1
cTurquoise  = ( 0.250000, 0.875000, 0.812500, 1.0 ) # (  64, 224, 208 ) | #40E0D0
# Blue-ish
cMidnight   = ( 0.093750, 0.093750, 0.500000, 1.0 ) # (  24,  24, 128 ) | #181880
cMedBlue    = ( 0.000000, 0.000000, 0.796875, 1.0 ) # (   0,   0, 204 ) | #0000CC
cDodgerBlue = ( 0.117188, 0.562500, 1.000000, 1.0 ) # (  30, 144, 255 ) | #1E90FF
cDeepSky    = ( 0.000000, 0.750000, 1.000000, 1.0 ) # (   0, 192, 255 ) | #00BFFF
cLightSky   = ( 0.625000, 0.875000, 1.000000, 1.0 ) # ( 160, 224, 255 ) | #A0E0FF
# ...aliases...
cOrange     = cTomato
cSkyBlue    = cDeepSky


#%% SPECIALS

# Grayscale
cBlack      = ( 0.0000, 0.0000, 0.0000, 1.00 )  # (   0,   0,   0 ) | #000000
cGray75     = ( 0.2500, 0.2500, 0.2500, 1.00 )  # (  64,  64,  64 ) | #404040
cGray50     = ( 0.5000, 0.5000, 0.5000, 1.00 )  # ( 128, 128, 128 ) | #808080
cGray25     = ( 0.7500, 0.7500, 0.7500, 1.00 )  # ( 192, 192, 192 ) | #C0C0C0
cGray12     = ( 0.8750, 0.8750, 0.8750, 1.00 )  # ( 224, 224, 224 ) | #C0C0C0
cGray06     = ( 0.9375, 0.9375, 0.9375, 1.00 )  # ( 240, 240, 240 ) | #D0D0D0
cGray06     = ( 0.9375, 0.9375, 0.9375, 1.00 )  # ( 240, 240, 240 ) | #D0D0D0
cGray03     = ( 0.9688, 0.9688, 0.9688, 1.00 )  # ( 248, 248, 248 ) | #D0D0D0
cWhite      = ( 1.0000, 1.0000, 1.0000, 1.00 )  # ( 255, 255, 255 ) | #FFFFFF
# ...aliases...
cGray       = cGray50
cSilver     = cGray25

# Siemens
cSiemens_dark  = ( 0.000, 0.438, 0.438, 1.00 )  # (   0, 112, 112 ) | #007070
cSiemens       = ( 0.000, 0.600, 0.600, 1.00 )  # (   0, 153, 153 ) | #009999
cSiemens_light = ( 0.500, 0.797, 0.797, 1.00 )  # ( 128, 204, 204 ) | #80CCCC
cSiemens_pale  = ( 0.750, 0.906, 0.906, 1.00 )  # ( 192, 232, 232 ) | #C0E8E8
cSiemens_flat  = ( 0.875, 0.969, 0.969, 1.00 )  # ( 224, 248, 248 ) | #E0F8F8

# Siemens ENERGY
cSEpurple_dark  = ( 0.105, 0.082, 0.203, 1.00 )  # (  27,  21,  52 ) | #1B1534
cSEpurple       = ( 0.301, 0.129, 0.477, 1.00 )  # (  77,  33, 122 ) | #4D217A
cSEpurple_light = ( 0.539, 0.000, 0.895, 1.00 )  # ( 138,   0, 229 ) | #8A00E5
cSEpurple_pale  = ( 0.820, 0.559, 1.000, 1.00 )  # ( 210, 143, 255 ) | #D28FFF
cSEpurple_flat  = ( 0.910, 0.777, 1.000, 1.00 )  # ( 233, 199, 255 ) | #E9C7FF


#--------------------------------------------------------
# Siemens ENERGY (secondary colors)

# brown:
# light_very    207 192 190
# light         175 158 156
# med           143 124 122
# dark          125 103 102

# gray
# light_very    215 228 238
# light         184 206 219
# med           150 176 192
# dark          123 145 157

# blue
# light_very    106 221 255
# light         33 192 255
# med           0 132 225
# dark          0 87 198

# green
# light_very    0 253 121
# light         20 218 121
# med           39 182 109
# dark          0 155 85

# yellow
# light /sunny 255 249 31  ;)
# light /sandy 246 230 0 ;)
# ocre          226 208 0
# dark          198 174 0

#--------------------------------------------------------
