# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AppDynamicsApiToken',
    'AppDynamicsUsernamePassword',
    'ArtifactoryCredentials',
    'AwsCCCrossAccountAccess',
    'AwsCrossAccountAccess',
    'AwsInheritFromDelegate',
    'AwsIrsa',
    'AwsKmsCredentials',
    'AwsKmsCredentialsAssumeRole',
    'AwsKmsCredentialsManual',
    'AwsManual',
    'AwsSecretManagerCredentials',
    'AwsSecretManagerCredentialsAssumeRole',
    'AwsSecretManagerCredentialsManual',
    'BitbucketApiAuthentication',
    'BitbucketCredentials',
    'BitbucketCredentialsHttp',
    'BitbucketCredentialsSsh',
    'DockerCredentials',
    'GcpInheritFromDelegate',
    'GcpManual',
    'GitCredentials',
    'GitCredentialsHttp',
    'GitCredentialsSsh',
    'GithubApiAuthentication',
    'GithubApiAuthenticationGithubApp',
    'GithubCredentials',
    'GithubCredentialsHttp',
    'GithubCredentialsSsh',
    'GitlabApiAuthentication',
    'GitlabCredentials',
    'GitlabCredentialsHttp',
    'GitlabCredentialsSsh',
    'HelmCredentials',
    'KubernetesClientKeyCert',
    'KubernetesInheritFromDelegate',
    'KubernetesOpenidConnect',
    'KubernetesServiceAccount',
    'KubernetesUsernamePassword',
    'NexusCredentials',
    'GetAppDynamicsApiTokenResult',
    'GetAppDynamicsUsernamePasswordResult',
    'GetArtifactoryCredentialResult',
    'GetAwsCCCrossAccountAccessResult',
    'GetAwsCrossAccountAccessResult',
    'GetAwsInheritFromDelegateResult',
    'GetAwsIrsaResult',
    'GetAwsKmsCredentialResult',
    'GetAwsKmsCredentialAssumeRoleResult',
    'GetAwsKmsCredentialManualResult',
    'GetAwsManualResult',
    'GetAwsSecretManagerCredentialResult',
    'GetAwsSecretManagerCredentialAssumeRoleResult',
    'GetAwsSecretManagerCredentialManualResult',
    'GetBitbucketApiAuthenticationResult',
    'GetBitbucketCredentialResult',
    'GetBitbucketCredentialHttpResult',
    'GetBitbucketCredentialSshResult',
    'GetDockerCredentialResult',
    'GetGcpInheritFromDelegateResult',
    'GetGcpManualResult',
    'GetGitCredentialResult',
    'GetGitCredentialHttpResult',
    'GetGitCredentialSshResult',
    'GetGithubApiAuthenticationResult',
    'GetGithubApiAuthenticationGithubAppResult',
    'GetGithubCredentialResult',
    'GetGithubCredentialHttpResult',
    'GetGithubCredentialSshResult',
    'GetGitlabApiAuthenticationResult',
    'GetGitlabCredentialResult',
    'GetGitlabCredentialHttpResult',
    'GetGitlabCredentialSshResult',
    'GetHelmCredentialResult',
    'GetKubernetesClientKeyCertResult',
    'GetKubernetesInheritFromDelegateResult',
    'GetKubernetesOpenidConnectResult',
    'GetKubernetesServiceAccountResult',
    'GetKubernetesUsernamePasswordResult',
    'GetNexusCredentialResult',
]

@pulumi.output_type
class AppDynamicsApiToken(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecretRef":
            suggest = "client_secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppDynamicsApiToken. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppDynamicsApiToken.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppDynamicsApiToken.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret_ref: str):
        """
        :param str client_id: The client id used for connecting to App Dynamics.
        :param str client_secret_ref: Reference to the Harness secret containing the App Dynamics client secret.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret_ref", client_secret_ref)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id used for connecting to App Dynamics.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecretRef")
    def client_secret_ref(self) -> str:
        """
        Reference to the Harness secret containing the App Dynamics client secret.
        """
        return pulumi.get(self, "client_secret_ref")


@pulumi.output_type
class AppDynamicsUsernamePassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppDynamicsUsernamePassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppDynamicsUsernamePassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppDynamicsUsernamePassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: str):
        """
        :param str password_ref: Reference to a secret containing the password to use for authentication.
        :param str username: Username to use for authentication.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to a secret containing the password to use for authentication.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ArtifactoryCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArtifactoryCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArtifactoryCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArtifactoryCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str password_ref: Reference to a secret containing the password to use for authentication.
        :param str username: Username to use for authentication.
        :param str username_ref: Reference to a secret containing the username to use for authentication.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to a secret containing the password to use for authentication.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to a secret containing the username to use for authentication.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class AwsCCCrossAccountAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsCCCrossAccountAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsCCCrossAccountAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsCCCrossAccountAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_id: str,
                 role_arn: str):
        """
        :param str external_id: The external id of the role to use for cross-account access. This is a random unique value to provide additional secure authentication.
        :param str role_arn: The ARN of the role to use for cross-account access.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        """
        The external id of the role to use for cross-account access. This is a random unique value to provide additional secure authentication.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role to use for cross-account access.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class AwsCrossAccountAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsCrossAccountAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsCrossAccountAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsCrossAccountAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 external_id: Optional[str] = None):
        """
        :param str role_arn: The Amazon Resource Name (ARN) of the role that you want to assume. This is an IAM role in the target AWS account.
        :param str external_id: If the administrator of the account to which the role belongs provided you with an external ID, then enter that value.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the role that you want to assume. This is an IAM role in the target AWS account.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        """
        If the administrator of the account to which the role belongs provided you with an external ID, then enter that value.
        """
        return pulumi.get(self, "external_id")


@pulumi.output_type
class AwsInheritFromDelegate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsInheritFromDelegate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsInheritFromDelegate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsInheritFromDelegate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: The delegates to inherit the credentials from.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class AwsIrsa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsIrsa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsIrsa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsIrsa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: The delegates to inherit the credentials from.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class AwsKmsCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assumeRole":
            suggest = "assume_role"
        elif key == "inheritFromDelegate":
            suggest = "inherit_from_delegate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsKmsCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsKmsCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsKmsCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assume_role: Optional['outputs.AwsKmsCredentialsAssumeRole'] = None,
                 inherit_from_delegate: Optional[bool] = None,
                 manual: Optional['outputs.AwsKmsCredentialsManual'] = None):
        """
        :param 'AwsKmsCredentialsAssumeRoleArgs' assume_role: Connect using STS assume role.
        :param bool inherit_from_delegate: Inherit the credentials from from the delegate.
        :param 'AwsKmsCredentialsManualArgs' manual: Specify the AWS key and secret used for authenticating.
        """
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)

    @property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional['outputs.AwsKmsCredentialsAssumeRole']:
        """
        Connect using STS assume role.
        """
        return pulumi.get(self, "assume_role")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[bool]:
        """
        Inherit the credentials from from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter
    def manual(self) -> Optional['outputs.AwsKmsCredentialsManual']:
        """
        Specify the AWS key and secret used for authenticating.
        """
        return pulumi.get(self, "manual")


@pulumi.output_type
class AwsKmsCredentialsAssumeRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsKmsCredentialsAssumeRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsKmsCredentialsAssumeRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsKmsCredentialsAssumeRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: int,
                 role_arn: str,
                 external_id: Optional[str] = None):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "role_arn", role_arn)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        return pulumi.get(self, "external_id")


@pulumi.output_type
class AwsKmsCredentialsManual(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyRef":
            suggest = "access_key_ref"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsKmsCredentialsManual. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsKmsCredentialsManual.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsKmsCredentialsManual.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_ref: str,
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class AwsManual(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"
        elif key == "accessKey":
            suggest = "access_key"
        elif key == "accessKeyRef":
            suggest = "access_key_ref"
        elif key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsManual. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsManual.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsManual.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: str,
                 access_key: Optional[str] = None,
                 access_key_ref: Optional[str] = None,
                 delegate_selectors: Optional[Sequence[str]] = None):
        """
        :param str secret_key_ref: Reference to the Harness secret containing the aws secret key.
        :param str access_key: AWS access key.
        :param str access_key_ref: Reference to the Harness secret containing the aws access key.
        :param Sequence[str] delegate_selectors: Connect only use delegates with these tags.
        """
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if access_key_ref is not None:
            pulumi.set(__self__, "access_key_ref", access_key_ref)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        """
        Reference to the Harness secret containing the aws secret key.
        """
        return pulumi.get(self, "secret_key_ref")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        AWS access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> Optional[str]:
        """
        Reference to the Harness secret containing the aws access key.
        """
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[Sequence[str]]:
        """
        Connect only use delegates with these tags.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class AwsSecretManagerCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assumeRole":
            suggest = "assume_role"
        elif key == "inheritFromDelegate":
            suggest = "inherit_from_delegate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsSecretManagerCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsSecretManagerCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsSecretManagerCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assume_role: Optional['outputs.AwsSecretManagerCredentialsAssumeRole'] = None,
                 inherit_from_delegate: Optional[bool] = None,
                 manual: Optional['outputs.AwsSecretManagerCredentialsManual'] = None):
        """
        :param 'AwsSecretManagerCredentialsAssumeRoleArgs' assume_role: Connect using STS assume role.
        :param bool inherit_from_delegate: Inherit the credentials from from the delegate.
        :param 'AwsSecretManagerCredentialsManualArgs' manual: Specify the AWS key and secret used for authenticating.
        """
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)

    @property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional['outputs.AwsSecretManagerCredentialsAssumeRole']:
        """
        Connect using STS assume role.
        """
        return pulumi.get(self, "assume_role")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[bool]:
        """
        Inherit the credentials from from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter
    def manual(self) -> Optional['outputs.AwsSecretManagerCredentialsManual']:
        """
        Specify the AWS key and secret used for authenticating.
        """
        return pulumi.get(self, "manual")


@pulumi.output_type
class AwsSecretManagerCredentialsAssumeRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsSecretManagerCredentialsAssumeRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsSecretManagerCredentialsAssumeRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsSecretManagerCredentialsAssumeRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: int,
                 role_arn: str,
                 external_id: Optional[str] = None):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "role_arn", role_arn)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        return pulumi.get(self, "external_id")


@pulumi.output_type
class AwsSecretManagerCredentialsManual(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyRef":
            suggest = "access_key_ref"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsSecretManagerCredentialsManual. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsSecretManagerCredentialsManual.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsSecretManagerCredentialsManual.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_ref: str,
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class BitbucketApiAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenRef":
            suggest = "token_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketApiAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketApiAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketApiAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 token_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str token_ref: Personal access token for interacting with the BitBucket api.
        :param str username: The username used for connecting to the api.
        :param str username_ref: The name of the Harness secret containing the username.
        """
        pulumi.set(__self__, "token_ref", token_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        """
        Personal access token for interacting with the BitBucket api.
        """
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username used for connecting to the api.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        The name of the Harness secret containing the username.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class BitbucketCredentials(dict):
    def __init__(__self__, *,
                 http: Optional['outputs.BitbucketCredentialsHttp'] = None,
                 ssh: Optional['outputs.BitbucketCredentialsSsh'] = None):
        """
        :param 'BitbucketCredentialsHttpArgs' http: Authenticate using Username and password over http(s) for the connection.
        :param 'BitbucketCredentialsSshArgs' ssh: Authenticate using SSH for the connection.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.BitbucketCredentialsHttp']:
        """
        Authenticate using Username and password over http(s) for the connection.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.BitbucketCredentialsSsh']:
        """
        Authenticate using SSH for the connection.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class BitbucketCredentialsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketCredentialsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketCredentialsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketCredentialsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: Optional[str] = None,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        if password_ref is not None:
            pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> Optional[str]:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class BitbucketCredentialsSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeyRef":
            suggest = "ssh_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketCredentialsSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketCredentialsSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketCredentialsSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class DockerCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str password_ref: The reference to the password to use for the docker registry.
        :param str username: The username to use for the docker registry.
        :param str username_ref: The reference to the username to use for the docker registry.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        The reference to the password to use for the docker registry.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username to use for the docker registry.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        The reference to the username to use for the docker registry.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GcpInheritFromDelegate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpInheritFromDelegate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpInheritFromDelegate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpInheritFromDelegate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: The delegates to inherit the credentials from.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GcpManual(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpManual. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpManual.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpManual.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str],
                 secret_key_ref: str):
        """
        :param Sequence[str] delegate_selectors: The delegates to connect with.
        :param str secret_key_ref: Reference to the Harness secret containing the secret key.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        The delegates to connect with.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        """
        Reference to the Harness secret containing the secret key.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GitCredentials(dict):
    def __init__(__self__, *,
                 http: Optional['outputs.GitCredentialsHttp'] = None,
                 ssh: Optional['outputs.GitCredentialsSsh'] = None):
        """
        :param 'GitCredentialsHttpArgs' http: Authenticate using Username and password over http(s) for the connection.
        :param 'GitCredentialsSshArgs' ssh: Authenticate using SSH for the connection.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.GitCredentialsHttp']:
        """
        Authenticate using Username and password over http(s) for the connection.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.GitCredentialsSsh']:
        """
        Authenticate using SSH for the connection.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class GitCredentialsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitCredentialsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitCredentialsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitCredentialsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GitCredentialsSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeyRef":
            suggest = "ssh_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitCredentialsSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitCredentialsSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitCredentialsSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GithubApiAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "githubApp":
            suggest = "github_app"
        elif key == "tokenRef":
            suggest = "token_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubApiAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubApiAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubApiAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 github_app: Optional['outputs.GithubApiAuthenticationGithubApp'] = None,
                 token_ref: Optional[str] = None):
        """
        :param 'GithubApiAuthenticationGithubAppArgs' github_app: Configuration for using the github app for interacting with the github api.
        :param str token_ref: Personal access token for interacting with the github api.
        """
        if github_app is not None:
            pulumi.set(__self__, "github_app", github_app)
        if token_ref is not None:
            pulumi.set(__self__, "token_ref", token_ref)

    @property
    @pulumi.getter(name="githubApp")
    def github_app(self) -> Optional['outputs.GithubApiAuthenticationGithubApp']:
        """
        Configuration for using the github app for interacting with the github api.
        """
        return pulumi.get(self, "github_app")

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> Optional[str]:
        """
        Personal access token for interacting with the github api.
        """
        return pulumi.get(self, "token_ref")


@pulumi.output_type
class GithubApiAuthenticationGithubApp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "installationId":
            suggest = "installation_id"
        elif key == "privateKeyRef":
            suggest = "private_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubApiAuthenticationGithubApp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubApiAuthenticationGithubApp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubApiAuthenticationGithubApp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: str,
                 installation_id: str,
                 private_key_ref: str):
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "installation_id", installation_id)
        pulumi.set(__self__, "private_key_ref", private_key_ref)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> str:
        return pulumi.get(self, "installation_id")

    @property
    @pulumi.getter(name="privateKeyRef")
    def private_key_ref(self) -> str:
        return pulumi.get(self, "private_key_ref")


@pulumi.output_type
class GithubCredentials(dict):
    def __init__(__self__, *,
                 http: Optional['outputs.GithubCredentialsHttp'] = None,
                 ssh: Optional['outputs.GithubCredentialsSsh'] = None):
        """
        :param 'GithubCredentialsHttpArgs' http: Authenticate using Username and password over http(s) for the connection.
        :param 'GithubCredentialsSshArgs' ssh: Authenticate using SSH for the connection.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.GithubCredentialsHttp']:
        """
        Authenticate using Username and password over http(s) for the connection.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.GithubCredentialsSsh']:
        """
        Authenticate using SSH for the connection.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class GithubCredentialsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenRef":
            suggest = "token_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubCredentialsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubCredentialsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubCredentialsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 token_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        pulumi.set(__self__, "token_ref", token_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GithubCredentialsSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeyRef":
            suggest = "ssh_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubCredentialsSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubCredentialsSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubCredentialsSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GitlabApiAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenRef":
            suggest = "token_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitlabApiAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitlabApiAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitlabApiAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 token_ref: str):
        """
        :param str token_ref: Personal access token for interacting with the gitlab api.
        """
        pulumi.set(__self__, "token_ref", token_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        """
        Personal access token for interacting with the gitlab api.
        """
        return pulumi.get(self, "token_ref")


@pulumi.output_type
class GitlabCredentials(dict):
    def __init__(__self__, *,
                 http: Optional['outputs.GitlabCredentialsHttp'] = None,
                 ssh: Optional['outputs.GitlabCredentialsSsh'] = None):
        """
        :param 'GitlabCredentialsHttpArgs' http: Authenticate using Username and password over http(s) for the connection.
        :param 'GitlabCredentialsSshArgs' ssh: Authenticate using SSH for the connection.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.GitlabCredentialsHttp']:
        """
        Authenticate using Username and password over http(s) for the connection.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.GitlabCredentialsSsh']:
        """
        Authenticate using SSH for the connection.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class GitlabCredentialsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "tokenRef":
            suggest = "token_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitlabCredentialsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitlabCredentialsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitlabCredentialsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: Optional[str] = None,
                 token_ref: Optional[str] = None,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        if password_ref is not None:
            pulumi.set(__self__, "password_ref", password_ref)
        if token_ref is not None:
            pulumi.set(__self__, "token_ref", token_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> Optional[str]:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> Optional[str]:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GitlabCredentialsSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeyRef":
            suggest = "ssh_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitlabCredentialsSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitlabCredentialsSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitlabCredentialsSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class HelmCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HelmCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HelmCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HelmCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str password_ref: Reference to a secret containing the password to use for authentication.
        :param str username: Username to use for authentication.
        :param str username_ref: Reference to a secret containing the username to use for authentication.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to a secret containing the password to use for authentication.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to a secret containing the username to use for authentication.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class KubernetesClientKeyCert(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertRef":
            suggest = "client_cert_ref"
        elif key == "clientKeyAlgorithm":
            suggest = "client_key_algorithm"
        elif key == "clientKeyRef":
            suggest = "client_key_ref"
        elif key == "masterUrl":
            suggest = "master_url"
        elif key == "caCertRef":
            suggest = "ca_cert_ref"
        elif key == "clientKeyPassphraseRef":
            suggest = "client_key_passphrase_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClientKeyCert. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClientKeyCert.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClientKeyCert.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_cert_ref: str,
                 client_key_algorithm: str,
                 client_key_ref: str,
                 master_url: str,
                 ca_cert_ref: Optional[str] = None,
                 client_key_passphrase_ref: Optional[str] = None):
        """
        :param str client_cert_ref: Reference to the secret containing the client certificate for the connector.
        :param str client_key_algorithm: The algorithm used to generate the client key for the connector. Valid values are RSA, EC
        :param str client_key_ref: Reference to the secret containing the client key for the connector.
        :param str master_url: The URL of the Kubernetes cluster.
        :param str ca_cert_ref: Reference to the secret containing the CA certificate for the connector.
        :param str client_key_passphrase_ref: Reference to the secret containing the client key passphrase for the connector.
        """
        pulumi.set(__self__, "client_cert_ref", client_cert_ref)
        pulumi.set(__self__, "client_key_algorithm", client_key_algorithm)
        pulumi.set(__self__, "client_key_ref", client_key_ref)
        pulumi.set(__self__, "master_url", master_url)
        if ca_cert_ref is not None:
            pulumi.set(__self__, "ca_cert_ref", ca_cert_ref)
        if client_key_passphrase_ref is not None:
            pulumi.set(__self__, "client_key_passphrase_ref", client_key_passphrase_ref)

    @property
    @pulumi.getter(name="clientCertRef")
    def client_cert_ref(self) -> str:
        """
        Reference to the secret containing the client certificate for the connector.
        """
        return pulumi.get(self, "client_cert_ref")

    @property
    @pulumi.getter(name="clientKeyAlgorithm")
    def client_key_algorithm(self) -> str:
        """
        The algorithm used to generate the client key for the connector. Valid values are RSA, EC
        """
        return pulumi.get(self, "client_key_algorithm")

    @property
    @pulumi.getter(name="clientKeyRef")
    def client_key_ref(self) -> str:
        """
        Reference to the secret containing the client key for the connector.
        """
        return pulumi.get(self, "client_key_ref")

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        """
        The URL of the Kubernetes cluster.
        """
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="caCertRef")
    def ca_cert_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the CA certificate for the connector.
        """
        return pulumi.get(self, "ca_cert_ref")

    @property
    @pulumi.getter(name="clientKeyPassphraseRef")
    def client_key_passphrase_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the client key passphrase for the connector.
        """
        return pulumi.get(self, "client_key_passphrase_ref")


@pulumi.output_type
class KubernetesInheritFromDelegate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateSelectors":
            suggest = "delegate_selectors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesInheritFromDelegate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesInheritFromDelegate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesInheritFromDelegate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: Selectors to use for the delegate.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        Selectors to use for the delegate.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class KubernetesOpenidConnect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientIdRef":
            suggest = "client_id_ref"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "masterUrl":
            suggest = "master_url"
        elif key == "passwordRef":
            suggest = "password_ref"
        elif key == "secretRef":
            suggest = "secret_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesOpenidConnect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesOpenidConnect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesOpenidConnect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id_ref: str,
                 issuer_url: str,
                 master_url: str,
                 password_ref: str,
                 scopes: Optional[Sequence[str]] = None,
                 secret_ref: Optional[str] = None,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str client_id_ref: Reference to the secret containing the client ID for the connector.
        :param str issuer_url: The URL of the OpenID Connect issuer.
        :param str master_url: The URL of the Kubernetes cluster.
        :param str password_ref: Reference to the secret containing the password for the connector.
        :param Sequence[str] scopes: Scopes to request for the connector.
        :param str secret_ref: Reference to the secret containing the client secret for the connector.
        :param str username: Username for the connector.
        :param str username_ref: Reference to the secret containing the username for the connector.
        """
        pulumi.set(__self__, "client_id_ref", client_id_ref)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "password_ref", password_ref)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="clientIdRef")
    def client_id_ref(self) -> str:
        """
        Reference to the secret containing the client ID for the connector.
        """
        return pulumi.get(self, "client_id_ref")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> str:
        """
        The URL of the OpenID Connect issuer.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        """
        The URL of the Kubernetes cluster.
        """
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to the secret containing the password for the connector.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Scopes to request for the connector.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the client secret for the connector.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username for the connector.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the username for the connector.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class KubernetesServiceAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterUrl":
            suggest = "master_url"
        elif key == "serviceAccountTokenRef":
            suggest = "service_account_token_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesServiceAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesServiceAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesServiceAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_url: str,
                 service_account_token_ref: str):
        """
        :param str master_url: The URL of the Kubernetes cluster.
        :param str service_account_token_ref: Reference to the secret containing the service account token for the connector.
        """
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "service_account_token_ref", service_account_token_ref)

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        """
        The URL of the Kubernetes cluster.
        """
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="serviceAccountTokenRef")
    def service_account_token_ref(self) -> str:
        """
        Reference to the secret containing the service account token for the connector.
        """
        return pulumi.get(self, "service_account_token_ref")


@pulumi.output_type
class KubernetesUsernamePassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterUrl":
            suggest = "master_url"
        elif key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesUsernamePassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesUsernamePassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesUsernamePassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_url: str,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str master_url: The URL of the Kubernetes cluster.
        :param str password_ref: Reference to the secret containing the password for the connector.
        :param str username: Username for the connector.
        :param str username_ref: Reference to the secret containing the username for the connector.
        """
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        """
        The URL of the Kubernetes cluster.
        """
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to the secret containing the password for the connector.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username for the connector.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to the secret containing the username for the connector.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class NexusCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRef":
            suggest = "password_ref"
        elif key == "usernameRef":
            suggest = "username_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NexusCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NexusCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NexusCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_ref: str,
                 username: Optional[str] = None,
                 username_ref: Optional[str] = None):
        """
        :param str password_ref: Reference to a secret containing the password to use for authentication.
        :param str username: Username to use for authentication.
        :param str username_ref: Reference to a secret containing the username to use for authentication.
        """
        pulumi.set(__self__, "password_ref", password_ref)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_ref is not None:
            pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        """
        Reference to a secret containing the password to use for authentication.
        """
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use for authentication.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> Optional[str]:
        """
        Reference to a secret containing the username to use for authentication.
        """
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetAppDynamicsApiTokenResult(dict):
    def __init__(__self__, *,
                 client_id: str,
                 client_secret_ref: str):
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret_ref", client_secret_ref)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecretRef")
    def client_secret_ref(self) -> str:
        return pulumi.get(self, "client_secret_ref")


@pulumi.output_type
class GetAppDynamicsUsernamePasswordResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetArtifactoryCredentialResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetAwsCCCrossAccountAccessResult(dict):
    def __init__(__self__, *,
                 external_id: str,
                 role_arn: str):
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetAwsCrossAccountAccessResult(dict):
    def __init__(__self__, *,
                 external_id: str,
                 role_arn: str):
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetAwsInheritFromDelegateResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GetAwsIrsaResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GetAwsKmsCredentialResult(dict):
    def __init__(__self__, *,
                 assume_roles: Sequence['outputs.GetAwsKmsCredentialAssumeRoleResult'],
                 inherit_from_delegate: bool,
                 manuals: Sequence['outputs.GetAwsKmsCredentialManualResult']):
        pulumi.set(__self__, "assume_roles", assume_roles)
        pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        pulumi.set(__self__, "manuals", manuals)

    @property
    @pulumi.getter(name="assumeRoles")
    def assume_roles(self) -> Sequence['outputs.GetAwsKmsCredentialAssumeRoleResult']:
        return pulumi.get(self, "assume_roles")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> bool:
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter
    def manuals(self) -> Sequence['outputs.GetAwsKmsCredentialManualResult']:
        return pulumi.get(self, "manuals")


@pulumi.output_type
class GetAwsKmsCredentialAssumeRoleResult(dict):
    def __init__(__self__, *,
                 duration: int,
                 external_id: str,
                 role_arn: str):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetAwsKmsCredentialManualResult(dict):
    def __init__(__self__, *,
                 access_key_ref: str,
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GetAwsManualResult(dict):
    def __init__(__self__, *,
                 access_key: str,
                 access_key_ref: str,
                 delegate_selectors: Sequence[str],
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GetAwsSecretManagerCredentialResult(dict):
    def __init__(__self__, *,
                 assume_roles: Sequence['outputs.GetAwsSecretManagerCredentialAssumeRoleResult'],
                 inherit_from_delegate: bool,
                 manuals: Sequence['outputs.GetAwsSecretManagerCredentialManualResult']):
        pulumi.set(__self__, "assume_roles", assume_roles)
        pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        pulumi.set(__self__, "manuals", manuals)

    @property
    @pulumi.getter(name="assumeRoles")
    def assume_roles(self) -> Sequence['outputs.GetAwsSecretManagerCredentialAssumeRoleResult']:
        return pulumi.get(self, "assume_roles")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> bool:
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter
    def manuals(self) -> Sequence['outputs.GetAwsSecretManagerCredentialManualResult']:
        return pulumi.get(self, "manuals")


@pulumi.output_type
class GetAwsSecretManagerCredentialAssumeRoleResult(dict):
    def __init__(__self__, *,
                 duration: int,
                 external_id: str,
                 role_arn: str):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetAwsSecretManagerCredentialManualResult(dict):
    def __init__(__self__, *,
                 access_key_ref: str,
                 secret_key_ref: str):
        pulumi.set(__self__, "access_key_ref", access_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="accessKeyRef")
    def access_key_ref(self) -> str:
        return pulumi.get(self, "access_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GetBitbucketApiAuthenticationResult(dict):
    def __init__(__self__, *,
                 token_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "token_ref", token_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetBitbucketCredentialResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetBitbucketCredentialHttpResult'],
                 sshes: Sequence['outputs.GetBitbucketCredentialSshResult']):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetBitbucketCredentialHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def sshes(self) -> Sequence['outputs.GetBitbucketCredentialSshResult']:
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetBitbucketCredentialHttpResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetBitbucketCredentialSshResult(dict):
    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GetDockerCredentialResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetGcpInheritFromDelegateResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GetGcpManualResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str],
                 secret_key_ref: str):
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> str:
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class GetGitCredentialResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetGitCredentialHttpResult'],
                 sshes: Sequence['outputs.GetGitCredentialSshResult']):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetGitCredentialHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def sshes(self) -> Sequence['outputs.GetGitCredentialSshResult']:
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetGitCredentialHttpResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetGitCredentialSshResult(dict):
    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GetGithubApiAuthenticationResult(dict):
    def __init__(__self__, *,
                 github_apps: Sequence['outputs.GetGithubApiAuthenticationGithubAppResult'],
                 token_ref: str):
        pulumi.set(__self__, "github_apps", github_apps)
        pulumi.set(__self__, "token_ref", token_ref)

    @property
    @pulumi.getter(name="githubApps")
    def github_apps(self) -> Sequence['outputs.GetGithubApiAuthenticationGithubAppResult']:
        return pulumi.get(self, "github_apps")

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")


@pulumi.output_type
class GetGithubApiAuthenticationGithubAppResult(dict):
    def __init__(__self__, *,
                 application_id: str,
                 installation_id: str,
                 private_key_ref: str):
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "installation_id", installation_id)
        pulumi.set(__self__, "private_key_ref", private_key_ref)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> str:
        return pulumi.get(self, "installation_id")

    @property
    @pulumi.getter(name="privateKeyRef")
    def private_key_ref(self) -> str:
        return pulumi.get(self, "private_key_ref")


@pulumi.output_type
class GetGithubCredentialResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetGithubCredentialHttpResult'],
                 sshes: Sequence['outputs.GetGithubCredentialSshResult']):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetGithubCredentialHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def sshes(self) -> Sequence['outputs.GetGithubCredentialSshResult']:
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetGithubCredentialHttpResult(dict):
    def __init__(__self__, *,
                 token_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "token_ref", token_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetGithubCredentialSshResult(dict):
    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GetGitlabApiAuthenticationResult(dict):
    def __init__(__self__, *,
                 token_ref: str):
        pulumi.set(__self__, "token_ref", token_ref)

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")


@pulumi.output_type
class GetGitlabCredentialResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetGitlabCredentialHttpResult'],
                 sshes: Sequence['outputs.GetGitlabCredentialSshResult']):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetGitlabCredentialHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def sshes(self) -> Sequence['outputs.GetGitlabCredentialSshResult']:
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetGitlabCredentialHttpResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 token_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "token_ref", token_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter(name="tokenRef")
    def token_ref(self) -> str:
        return pulumi.get(self, "token_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetGitlabCredentialSshResult(dict):
    def __init__(__self__, *,
                 ssh_key_ref: str):
        pulumi.set(__self__, "ssh_key_ref", ssh_key_ref)

    @property
    @pulumi.getter(name="sshKeyRef")
    def ssh_key_ref(self) -> str:
        return pulumi.get(self, "ssh_key_ref")


@pulumi.output_type
class GetHelmCredentialResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetKubernetesClientKeyCertResult(dict):
    def __init__(__self__, *,
                 ca_cert_ref: str,
                 client_cert_ref: str,
                 client_key_algorithm: str,
                 client_key_passphrase_ref: str,
                 client_key_ref: str,
                 master_url: str):
        pulumi.set(__self__, "ca_cert_ref", ca_cert_ref)
        pulumi.set(__self__, "client_cert_ref", client_cert_ref)
        pulumi.set(__self__, "client_key_algorithm", client_key_algorithm)
        pulumi.set(__self__, "client_key_passphrase_ref", client_key_passphrase_ref)
        pulumi.set(__self__, "client_key_ref", client_key_ref)
        pulumi.set(__self__, "master_url", master_url)

    @property
    @pulumi.getter(name="caCertRef")
    def ca_cert_ref(self) -> str:
        return pulumi.get(self, "ca_cert_ref")

    @property
    @pulumi.getter(name="clientCertRef")
    def client_cert_ref(self) -> str:
        return pulumi.get(self, "client_cert_ref")

    @property
    @pulumi.getter(name="clientKeyAlgorithm")
    def client_key_algorithm(self) -> str:
        return pulumi.get(self, "client_key_algorithm")

    @property
    @pulumi.getter(name="clientKeyPassphraseRef")
    def client_key_passphrase_ref(self) -> str:
        return pulumi.get(self, "client_key_passphrase_ref")

    @property
    @pulumi.getter(name="clientKeyRef")
    def client_key_ref(self) -> str:
        return pulumi.get(self, "client_key_ref")

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        return pulumi.get(self, "master_url")


@pulumi.output_type
class GetKubernetesInheritFromDelegateResult(dict):
    def __init__(__self__, *,
                 delegate_selectors: Sequence[str]):
        """
        :param Sequence[str] delegate_selectors: Selectors to use for the delegate.
        """
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[str]:
        """
        Selectors to use for the delegate.
        """
        return pulumi.get(self, "delegate_selectors")


@pulumi.output_type
class GetKubernetesOpenidConnectResult(dict):
    def __init__(__self__, *,
                 client_id_ref: str,
                 issuer_url: str,
                 master_url: str,
                 password_ref: str,
                 scopes: Sequence[str],
                 secret_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "client_id_ref", client_id_ref)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "secret_ref", secret_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="clientIdRef")
    def client_id_ref(self) -> str:
        return pulumi.get(self, "client_id_ref")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> str:
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> str:
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetKubernetesServiceAccountResult(dict):
    def __init__(__self__, *,
                 master_url: str,
                 service_account_token_ref: str):
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "service_account_token_ref", service_account_token_ref)

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="serviceAccountTokenRef")
    def service_account_token_ref(self) -> str:
        return pulumi.get(self, "service_account_token_ref")


@pulumi.output_type
class GetKubernetesUsernamePasswordResult(dict):
    def __init__(__self__, *,
                 master_url: str,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "master_url", master_url)
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="masterUrl")
    def master_url(self) -> str:
        return pulumi.get(self, "master_url")

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


@pulumi.output_type
class GetNexusCredentialResult(dict):
    def __init__(__self__, *,
                 password_ref: str,
                 username: str,
                 username_ref: str):
        pulumi.set(__self__, "password_ref", password_ref)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "username_ref", username_ref)

    @property
    @pulumi.getter(name="passwordRef")
    def password_ref(self) -> str:
        return pulumi.get(self, "password_ref")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameRef")
    def username_ref(self) -> str:
        return pulumi.get(self, "username_ref")


