# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesArgs', 'Kubernetes']

@pulumi.input_type
class KubernetesArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[str],
                 client_key_cert: Optional[pulumi.Input['KubernetesClientKeyCertArgs']] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input['KubernetesInheritFromDelegateArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 openid_connect: Optional[pulumi.Input['KubernetesOpenidConnectArgs']] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input['KubernetesServiceAccountArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_password: Optional[pulumi.Input['KubernetesUsernamePasswordArgs']] = None):
        """
        The set of arguments for constructing a Kubernetes resource.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input['KubernetesClientKeyCertArgs'] client_key_cert: Client key and certificate config for the connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Selectors to use for the delegate.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input['KubernetesInheritFromDelegateArgs'] inherit_from_delegate: Credentials are inherited from the delegate.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input['KubernetesOpenidConnectArgs'] openid_connect: OpenID configuration for the connector.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input['KubernetesServiceAccountArgs'] service_account: Service account for the connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        :param pulumi.Input['KubernetesUsernamePasswordArgs'] username_password: Username and password for the connector.
        """
        pulumi.set(__self__, "identifier", identifier)
        if client_key_cert is not None:
            pulumi.set(__self__, "client_key_cert", client_key_cert)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openid_connect is not None:
            pulumi.set(__self__, "openid_connect", openid_connect)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if username_password is not None:
            pulumi.set(__self__, "username_password", username_password)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="clientKeyCert")
    def client_key_cert(self) -> Optional[pulumi.Input['KubernetesClientKeyCertArgs']]:
        """
        Client key and certificate config for the connector.
        """
        return pulumi.get(self, "client_key_cert")

    @client_key_cert.setter
    def client_key_cert(self, value: Optional[pulumi.Input['KubernetesClientKeyCertArgs']]):
        pulumi.set(self, "client_key_cert", value)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Selectors to use for the delegate.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[pulumi.Input['KubernetesInheritFromDelegateArgs']]:
        """
        Credentials are inherited from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @inherit_from_delegate.setter
    def inherit_from_delegate(self, value: Optional[pulumi.Input['KubernetesInheritFromDelegateArgs']]):
        pulumi.set(self, "inherit_from_delegate", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openidConnect")
    def openid_connect(self) -> Optional[pulumi.Input['KubernetesOpenidConnectArgs']]:
        """
        OpenID configuration for the connector.
        """
        return pulumi.get(self, "openid_connect")

    @openid_connect.setter
    def openid_connect(self, value: Optional[pulumi.Input['KubernetesOpenidConnectArgs']]):
        pulumi.set(self, "openid_connect", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['KubernetesServiceAccountArgs']]:
        """
        Service account for the connector.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['KubernetesServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="usernamePassword")
    def username_password(self) -> Optional[pulumi.Input['KubernetesUsernamePasswordArgs']]:
        """
        Username and password for the connector.
        """
        return pulumi.get(self, "username_password")

    @username_password.setter
    def username_password(self, value: Optional[pulumi.Input['KubernetesUsernamePasswordArgs']]):
        pulumi.set(self, "username_password", value)


@pulumi.input_type
class _KubernetesState:
    def __init__(__self__, *,
                 client_key_cert: Optional[pulumi.Input['KubernetesClientKeyCertArgs']] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input['KubernetesInheritFromDelegateArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 openid_connect: Optional[pulumi.Input['KubernetesOpenidConnectArgs']] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input['KubernetesServiceAccountArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_password: Optional[pulumi.Input['KubernetesUsernamePasswordArgs']] = None):
        """
        Input properties used for looking up and filtering Kubernetes resources.
        :param pulumi.Input['KubernetesClientKeyCertArgs'] client_key_cert: Client key and certificate config for the connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Selectors to use for the delegate.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input['KubernetesInheritFromDelegateArgs'] inherit_from_delegate: Credentials are inherited from the delegate.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input['KubernetesOpenidConnectArgs'] openid_connect: OpenID configuration for the connector.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input['KubernetesServiceAccountArgs'] service_account: Service account for the connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        :param pulumi.Input['KubernetesUsernamePasswordArgs'] username_password: Username and password for the connector.
        """
        if client_key_cert is not None:
            pulumi.set(__self__, "client_key_cert", client_key_cert)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openid_connect is not None:
            pulumi.set(__self__, "openid_connect", openid_connect)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if username_password is not None:
            pulumi.set(__self__, "username_password", username_password)

    @property
    @pulumi.getter(name="clientKeyCert")
    def client_key_cert(self) -> Optional[pulumi.Input['KubernetesClientKeyCertArgs']]:
        """
        Client key and certificate config for the connector.
        """
        return pulumi.get(self, "client_key_cert")

    @client_key_cert.setter
    def client_key_cert(self, value: Optional[pulumi.Input['KubernetesClientKeyCertArgs']]):
        pulumi.set(self, "client_key_cert", value)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Selectors to use for the delegate.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[pulumi.Input['KubernetesInheritFromDelegateArgs']]:
        """
        Credentials are inherited from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @inherit_from_delegate.setter
    def inherit_from_delegate(self, value: Optional[pulumi.Input['KubernetesInheritFromDelegateArgs']]):
        pulumi.set(self, "inherit_from_delegate", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openidConnect")
    def openid_connect(self) -> Optional[pulumi.Input['KubernetesOpenidConnectArgs']]:
        """
        OpenID configuration for the connector.
        """
        return pulumi.get(self, "openid_connect")

    @openid_connect.setter
    def openid_connect(self, value: Optional[pulumi.Input['KubernetesOpenidConnectArgs']]):
        pulumi.set(self, "openid_connect", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['KubernetesServiceAccountArgs']]:
        """
        Service account for the connector.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['KubernetesServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="usernamePassword")
    def username_password(self) -> Optional[pulumi.Input['KubernetesUsernamePasswordArgs']]:
        """
        Username and password for the connector.
        """
        return pulumi.get(self, "username_password")

    @username_password.setter
    def username_password(self, value: Optional[pulumi.Input['KubernetesUsernamePasswordArgs']]):
        pulumi.set(self, "username_password", value)


class Kubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_key_cert: Optional[pulumi.Input[pulumi.InputType['KubernetesClientKeyCertArgs']]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input[pulumi.InputType['KubernetesInheritFromDelegateArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 openid_connect: Optional[pulumi.Input[pulumi.InputType['KubernetesOpenidConnectArgs']]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[pulumi.InputType['KubernetesServiceAccountArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_password: Optional[pulumi.Input[pulumi.InputType['KubernetesUsernamePasswordArgs']]] = None,
                 __props__=None):
        """
        Resource for creating a K8s connector.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        client_key_cert = harness.platform_connector.Kubernetes("clientKeyCert",
            client_key_cert=harness.platform_connector.KubernetesClientKeyCertArgs(
                ca_cert_ref="account.TEST_k8ss_client_stuff",
                client_cert_ref="account.test_k8s_client_cert",
                client_key_algorithm="RSA",
                client_key_passphrase_ref="account.TEST_k8s_client_test",
                client_key_ref="account.TEST_k8s_client_key",
                master_url="https://kubernetes.example.com",
            ),
            delegate_selectors=["harness-delegate"],
            description="description",
            identifier="identifier",
            tags=["foo:bar"])
        username_password = harness.platform_connector.Kubernetes("usernamePassword",
            delegate_selectors=["harness-delegate"],
            description="description",
            identifier="identifier",
            tags=["foo:bar"],
            username_password=harness.platform_connector.KubernetesUsernamePasswordArgs(
                master_url="https://kubernetes.example.com",
                password_ref="account.TEST_k8s_client_test",
                username="admin",
            ))
        service_account = harness.platform_connector.Kubernetes("serviceAccount",
            delegate_selectors=["harness-delegate"],
            description="description",
            identifier="identifier",
            service_account=harness.platform_connector.KubernetesServiceAccountArgs(
                master_url="https://kubernetes.example.com",
                service_account_token_ref="account.TEST_k8s_client_test",
            ),
            tags=["foo:bar"])
        open_id_connect = harness.platform_connector.Kubernetes("openIDConnect",
            delegate_selectors=["harness-delegate"],
            description="description",
            identifier="%[1]s",
            openid_connect=harness.platform_connector.KubernetesOpenidConnectArgs(
                client_id_ref="account.TEST_k8s_client_test",
                issuer_url="https://oidc.example.com",
                master_url="https://kubernetes.example.com",
                password_ref="account.TEST_k8s_client_test",
                scopes=[
                    "scope1",
                    "scope2",
                ],
                secret_ref="account.TEST_k8s_client_test",
                username_ref="account.TEST_k8s_client_test",
            ),
            tags=["foo:bar"])
        inherit_from_delegate = harness.platform_connector.Kubernetes("inheritFromDelegate",
            description="description",
            identifier="identifier",
            inherit_from_delegate=harness.platform_connector.KubernetesInheritFromDelegateArgs(
                delegate_selectors=["harness-delegate"],
            ),
            tags=["foo:bar"])
        ```

        ## Import

        # Import using kubernetes connector id

        ```sh
         $ pulumi import harness:PlatformConnector/kubernetes:Kubernetes example <connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['KubernetesClientKeyCertArgs']] client_key_cert: Client key and certificate config for the connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Selectors to use for the delegate.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[pulumi.InputType['KubernetesInheritFromDelegateArgs']] inherit_from_delegate: Credentials are inherited from the delegate.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[pulumi.InputType['KubernetesOpenidConnectArgs']] openid_connect: OpenID configuration for the connector.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[pulumi.InputType['KubernetesServiceAccountArgs']] service_account: Service account for the connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        :param pulumi.Input[pulumi.InputType['KubernetesUsernamePasswordArgs']] username_password: Username and password for the connector.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a K8s connector.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        client_key_cert = harness.platform_connector.Kubernetes("clientKeyCert",
            client_key_cert=harness.platform_connector.KubernetesClientKeyCertArgs(
                ca_cert_ref="account.TEST_k8ss_client_stuff",
                client_cert_ref="account.test_k8s_client_cert",
                client_key_algorithm="RSA",
                client_key_passphrase_ref="account.TEST_k8s_client_test",
                client_key_ref="account.TEST_k8s_client_key",
                master_url="https://kubernetes.example.com",
            ),
            delegate_selectors=["harness-delegate"],
            description="description",
            identifier="identifier",
            tags=["foo:bar"])
        username_password = harness.platform_connector.Kubernetes("usernamePassword",
            delegate_selectors=["harness-delegate"],
            description="description",
            identifier="identifier",
            tags=["foo:bar"],
            username_password=harness.platform_connector.KubernetesUsernamePasswordArgs(
                master_url="https://kubernetes.example.com",
                password_ref="account.TEST_k8s_client_test",
                username="admin",
            ))
        service_account = harness.platform_connector.Kubernetes("serviceAccount",
            delegate_selectors=["harness-delegate"],
            description="description",
            identifier="identifier",
            service_account=harness.platform_connector.KubernetesServiceAccountArgs(
                master_url="https://kubernetes.example.com",
                service_account_token_ref="account.TEST_k8s_client_test",
            ),
            tags=["foo:bar"])
        open_id_connect = harness.platform_connector.Kubernetes("openIDConnect",
            delegate_selectors=["harness-delegate"],
            description="description",
            identifier="%[1]s",
            openid_connect=harness.platform_connector.KubernetesOpenidConnectArgs(
                client_id_ref="account.TEST_k8s_client_test",
                issuer_url="https://oidc.example.com",
                master_url="https://kubernetes.example.com",
                password_ref="account.TEST_k8s_client_test",
                scopes=[
                    "scope1",
                    "scope2",
                ],
                secret_ref="account.TEST_k8s_client_test",
                username_ref="account.TEST_k8s_client_test",
            ),
            tags=["foo:bar"])
        inherit_from_delegate = harness.platform_connector.Kubernetes("inheritFromDelegate",
            description="description",
            identifier="identifier",
            inherit_from_delegate=harness.platform_connector.KubernetesInheritFromDelegateArgs(
                delegate_selectors=["harness-delegate"],
            ),
            tags=["foo:bar"])
        ```

        ## Import

        # Import using kubernetes connector id

        ```sh
         $ pulumi import harness:PlatformConnector/kubernetes:Kubernetes example <connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_key_cert: Optional[pulumi.Input[pulumi.InputType['KubernetesClientKeyCertArgs']]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input[pulumi.InputType['KubernetesInheritFromDelegateArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 openid_connect: Optional[pulumi.Input[pulumi.InputType['KubernetesOpenidConnectArgs']]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[pulumi.InputType['KubernetesServiceAccountArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_password: Optional[pulumi.Input[pulumi.InputType['KubernetesUsernamePasswordArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesArgs.__new__(KubernetesArgs)

            __props__.__dict__["client_key_cert"] = client_key_cert
            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["description"] = description
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["inherit_from_delegate"] = inherit_from_delegate
            __props__.__dict__["name"] = name
            __props__.__dict__["openid_connect"] = openid_connect
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["tags"] = tags
            __props__.__dict__["username_password"] = username_password
        super(Kubernetes, __self__).__init__(
            'harness:PlatformConnector/kubernetes:Kubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_key_cert: Optional[pulumi.Input[pulumi.InputType['KubernetesClientKeyCertArgs']]] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            inherit_from_delegate: Optional[pulumi.Input[pulumi.InputType['KubernetesInheritFromDelegateArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            openid_connect: Optional[pulumi.Input[pulumi.InputType['KubernetesOpenidConnectArgs']]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            service_account: Optional[pulumi.Input[pulumi.InputType['KubernetesServiceAccountArgs']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            username_password: Optional[pulumi.Input[pulumi.InputType['KubernetesUsernamePasswordArgs']]] = None) -> 'Kubernetes':
        """
        Get an existing Kubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['KubernetesClientKeyCertArgs']] client_key_cert: Client key and certificate config for the connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Selectors to use for the delegate.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[pulumi.InputType['KubernetesInheritFromDelegateArgs']] inherit_from_delegate: Credentials are inherited from the delegate.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[pulumi.InputType['KubernetesOpenidConnectArgs']] openid_connect: OpenID configuration for the connector.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[pulumi.InputType['KubernetesServiceAccountArgs']] service_account: Service account for the connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        :param pulumi.Input[pulumi.InputType['KubernetesUsernamePasswordArgs']] username_password: Username and password for the connector.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesState.__new__(_KubernetesState)

        __props__.__dict__["client_key_cert"] = client_key_cert
        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["description"] = description
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["inherit_from_delegate"] = inherit_from_delegate
        __props__.__dict__["name"] = name
        __props__.__dict__["openid_connect"] = openid_connect
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["tags"] = tags
        __props__.__dict__["username_password"] = username_password
        return Kubernetes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientKeyCert")
    def client_key_cert(self) -> pulumi.Output[Optional['outputs.KubernetesClientKeyCert']]:
        """
        Client key and certificate config for the connector.
        """
        return pulumi.get(self, "client_key_cert")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Selectors to use for the delegate.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> pulumi.Output[Optional['outputs.KubernetesInheritFromDelegate']]:
        """
        Credentials are inherited from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openidConnect")
    def openid_connect(self) -> pulumi.Output[Optional['outputs.KubernetesOpenidConnect']]:
        """
        OpenID configuration for the connector.
        """
        return pulumi.get(self, "openid_connect")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional['outputs.KubernetesServiceAccount']]:
        """
        Service account for the connector.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="usernamePassword")
    def username_password(self) -> pulumi.Output[Optional['outputs.KubernetesUsernamePassword']]:
        """
        Username and password for the connector.
        """
        return pulumi.get(self, "username_password")

