# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UsergroupArgs', 'Usergroup']

@pulumi.input_type
class UsergroupArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 externally_managed: Optional[pulumi.Input[bool]] = None,
                 linked_sso_display_name: Optional[pulumi.Input[str]] = None,
                 linked_sso_id: Optional[pulumi.Input[str]] = None,
                 linked_sso_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input['UsergroupNotificationConfigArgs']]]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 sso_group_id: Optional[pulumi.Input[str]] = None,
                 sso_group_name: Optional[pulumi.Input[str]] = None,
                 sso_linked: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Usergroup resource.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] externally_managed: Whether the user group is externally managed.
        :param pulumi.Input[str] linked_sso_display_name: Name of the linked SSO.
        :param pulumi.Input[str] linked_sso_id: The SSO account ID that the user group is linked to.
        :param pulumi.Input[str] linked_sso_type: Type of linked SSO
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['UsergroupNotificationConfigArgs']]] notification_configs: List of notification settings.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] sso_group_id: Identifier of the userGroup in SSO.
        :param pulumi.Input[str] sso_group_name: Name of the SSO userGroup.
        :param pulumi.Input[bool] sso_linked: Whether sso is linked or not
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: List of users in the UserGroup.
        """
        pulumi.set(__self__, "identifier", identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if externally_managed is not None:
            pulumi.set(__self__, "externally_managed", externally_managed)
        if linked_sso_display_name is not None:
            pulumi.set(__self__, "linked_sso_display_name", linked_sso_display_name)
        if linked_sso_id is not None:
            pulumi.set(__self__, "linked_sso_id", linked_sso_id)
        if linked_sso_type is not None:
            pulumi.set(__self__, "linked_sso_type", linked_sso_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_configs is not None:
            pulumi.set(__self__, "notification_configs", notification_configs)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if sso_group_id is not None:
            pulumi.set(__self__, "sso_group_id", sso_group_id)
        if sso_group_name is not None:
            pulumi.set(__self__, "sso_group_name", sso_group_name)
        if sso_linked is not None:
            pulumi.set(__self__, "sso_linked", sso_linked)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externallyManaged")
    def externally_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the user group is externally managed.
        """
        return pulumi.get(self, "externally_managed")

    @externally_managed.setter
    def externally_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "externally_managed", value)

    @property
    @pulumi.getter(name="linkedSsoDisplayName")
    def linked_sso_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the linked SSO.
        """
        return pulumi.get(self, "linked_sso_display_name")

    @linked_sso_display_name.setter
    def linked_sso_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_sso_display_name", value)

    @property
    @pulumi.getter(name="linkedSsoId")
    def linked_sso_id(self) -> Optional[pulumi.Input[str]]:
        """
        The SSO account ID that the user group is linked to.
        """
        return pulumi.get(self, "linked_sso_id")

    @linked_sso_id.setter
    def linked_sso_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_sso_id", value)

    @property
    @pulumi.getter(name="linkedSsoType")
    def linked_sso_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of linked SSO
        """
        return pulumi.get(self, "linked_sso_type")

    @linked_sso_type.setter
    def linked_sso_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_sso_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationConfigs")
    def notification_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsergroupNotificationConfigArgs']]]]:
        """
        List of notification settings.
        """
        return pulumi.get(self, "notification_configs")

    @notification_configs.setter
    def notification_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsergroupNotificationConfigArgs']]]]):
        pulumi.set(self, "notification_configs", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="ssoGroupId")
    def sso_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the userGroup in SSO.
        """
        return pulumi.get(self, "sso_group_id")

    @sso_group_id.setter
    def sso_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sso_group_id", value)

    @property
    @pulumi.getter(name="ssoGroupName")
    def sso_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SSO userGroup.
        """
        return pulumi.get(self, "sso_group_name")

    @sso_group_name.setter
    def sso_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sso_group_name", value)

    @property
    @pulumi.getter(name="ssoLinked")
    def sso_linked(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether sso is linked or not
        """
        return pulumi.get(self, "sso_linked")

    @sso_linked.setter
    def sso_linked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso_linked", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of users in the UserGroup.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _UsergroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 externally_managed: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 linked_sso_display_name: Optional[pulumi.Input[str]] = None,
                 linked_sso_id: Optional[pulumi.Input[str]] = None,
                 linked_sso_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input['UsergroupNotificationConfigArgs']]]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 sso_group_id: Optional[pulumi.Input[str]] = None,
                 sso_group_name: Optional[pulumi.Input[str]] = None,
                 sso_linked: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Usergroup resources.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] externally_managed: Whether the user group is externally managed.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] linked_sso_display_name: Name of the linked SSO.
        :param pulumi.Input[str] linked_sso_id: The SSO account ID that the user group is linked to.
        :param pulumi.Input[str] linked_sso_type: Type of linked SSO
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['UsergroupNotificationConfigArgs']]] notification_configs: List of notification settings.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] sso_group_id: Identifier of the userGroup in SSO.
        :param pulumi.Input[str] sso_group_name: Name of the SSO userGroup.
        :param pulumi.Input[bool] sso_linked: Whether sso is linked or not
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: List of users in the UserGroup.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if externally_managed is not None:
            pulumi.set(__self__, "externally_managed", externally_managed)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if linked_sso_display_name is not None:
            pulumi.set(__self__, "linked_sso_display_name", linked_sso_display_name)
        if linked_sso_id is not None:
            pulumi.set(__self__, "linked_sso_id", linked_sso_id)
        if linked_sso_type is not None:
            pulumi.set(__self__, "linked_sso_type", linked_sso_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_configs is not None:
            pulumi.set(__self__, "notification_configs", notification_configs)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if sso_group_id is not None:
            pulumi.set(__self__, "sso_group_id", sso_group_id)
        if sso_group_name is not None:
            pulumi.set(__self__, "sso_group_name", sso_group_name)
        if sso_linked is not None:
            pulumi.set(__self__, "sso_linked", sso_linked)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externallyManaged")
    def externally_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the user group is externally managed.
        """
        return pulumi.get(self, "externally_managed")

    @externally_managed.setter
    def externally_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "externally_managed", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="linkedSsoDisplayName")
    def linked_sso_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the linked SSO.
        """
        return pulumi.get(self, "linked_sso_display_name")

    @linked_sso_display_name.setter
    def linked_sso_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_sso_display_name", value)

    @property
    @pulumi.getter(name="linkedSsoId")
    def linked_sso_id(self) -> Optional[pulumi.Input[str]]:
        """
        The SSO account ID that the user group is linked to.
        """
        return pulumi.get(self, "linked_sso_id")

    @linked_sso_id.setter
    def linked_sso_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_sso_id", value)

    @property
    @pulumi.getter(name="linkedSsoType")
    def linked_sso_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of linked SSO
        """
        return pulumi.get(self, "linked_sso_type")

    @linked_sso_type.setter
    def linked_sso_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_sso_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationConfigs")
    def notification_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsergroupNotificationConfigArgs']]]]:
        """
        List of notification settings.
        """
        return pulumi.get(self, "notification_configs")

    @notification_configs.setter
    def notification_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsergroupNotificationConfigArgs']]]]):
        pulumi.set(self, "notification_configs", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="ssoGroupId")
    def sso_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the userGroup in SSO.
        """
        return pulumi.get(self, "sso_group_id")

    @sso_group_id.setter
    def sso_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sso_group_id", value)

    @property
    @pulumi.getter(name="ssoGroupName")
    def sso_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SSO userGroup.
        """
        return pulumi.get(self, "sso_group_name")

    @sso_group_name.setter
    def sso_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sso_group_name", value)

    @property
    @pulumi.getter(name="ssoLinked")
    def sso_linked(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether sso is linked or not
        """
        return pulumi.get(self, "sso_linked")

    @sso_linked.setter
    def sso_linked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso_linked", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of users in the UserGroup.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users", value)


class Usergroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 externally_managed: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 linked_sso_display_name: Optional[pulumi.Input[str]] = None,
                 linked_sso_id: Optional[pulumi.Input[str]] = None,
                 linked_sso_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UsergroupNotificationConfigArgs']]]]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 sso_group_id: Optional[pulumi.Input[str]] = None,
                 sso_group_name: Optional[pulumi.Input[str]] = None,
                 sso_linked: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for creating a Harness User Group.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        example = harness.platform.Usergroup("example",
            externally_managed=False,
            identifier="identifier",
            linked_sso_display_name="linked_sso_display_name",
            linked_sso_id="linked_sso_id",
            linked_sso_type="SAML",
            notification_configs=[
                harness.platform.UsergroupNotificationConfigArgs(
                    slack_webhook_url="https://google.com",
                    type="SLACK",
                ),
                harness.platform.UsergroupNotificationConfigArgs(
                    group_email="email@email.com",
                    type="EMAIL",
                ),
                harness.platform.UsergroupNotificationConfigArgs(
                    microsoft_teams_webhook_url="https://google.com",
                    type="MSTEAMS",
                ),
                harness.platform.UsergroupNotificationConfigArgs(
                    pager_duty_key="pagerDutyKey",
                    type="PAGERDUTY",
                ),
            ],
            org_id="org_id",
            project_id="project_id",
            sso_group_id="sso_group_id",
            sso_group_name="sso_group_name",
            sso_linked=True,
            users=["user_id"])
        ```

        ## Import

        # Import using user group id

        ```sh
         $ pulumi import harness:platform/usergroup:Usergroup example <usergroup_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] externally_managed: Whether the user group is externally managed.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] linked_sso_display_name: Name of the linked SSO.
        :param pulumi.Input[str] linked_sso_id: The SSO account ID that the user group is linked to.
        :param pulumi.Input[str] linked_sso_type: Type of linked SSO
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UsergroupNotificationConfigArgs']]]] notification_configs: List of notification settings.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] sso_group_id: Identifier of the userGroup in SSO.
        :param pulumi.Input[str] sso_group_name: Name of the SSO userGroup.
        :param pulumi.Input[bool] sso_linked: Whether sso is linked or not
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: List of users in the UserGroup.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UsergroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness User Group.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        example = harness.platform.Usergroup("example",
            externally_managed=False,
            identifier="identifier",
            linked_sso_display_name="linked_sso_display_name",
            linked_sso_id="linked_sso_id",
            linked_sso_type="SAML",
            notification_configs=[
                harness.platform.UsergroupNotificationConfigArgs(
                    slack_webhook_url="https://google.com",
                    type="SLACK",
                ),
                harness.platform.UsergroupNotificationConfigArgs(
                    group_email="email@email.com",
                    type="EMAIL",
                ),
                harness.platform.UsergroupNotificationConfigArgs(
                    microsoft_teams_webhook_url="https://google.com",
                    type="MSTEAMS",
                ),
                harness.platform.UsergroupNotificationConfigArgs(
                    pager_duty_key="pagerDutyKey",
                    type="PAGERDUTY",
                ),
            ],
            org_id="org_id",
            project_id="project_id",
            sso_group_id="sso_group_id",
            sso_group_name="sso_group_name",
            sso_linked=True,
            users=["user_id"])
        ```

        ## Import

        # Import using user group id

        ```sh
         $ pulumi import harness:platform/usergroup:Usergroup example <usergroup_id>
        ```

        :param str resource_name: The name of the resource.
        :param UsergroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UsergroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 externally_managed: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 linked_sso_display_name: Optional[pulumi.Input[str]] = None,
                 linked_sso_id: Optional[pulumi.Input[str]] = None,
                 linked_sso_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UsergroupNotificationConfigArgs']]]]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 sso_group_id: Optional[pulumi.Input[str]] = None,
                 sso_group_name: Optional[pulumi.Input[str]] = None,
                 sso_linked: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UsergroupArgs.__new__(UsergroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["externally_managed"] = externally_managed
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["linked_sso_display_name"] = linked_sso_display_name
            __props__.__dict__["linked_sso_id"] = linked_sso_id
            __props__.__dict__["linked_sso_type"] = linked_sso_type
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_configs"] = notification_configs
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["sso_group_id"] = sso_group_id
            __props__.__dict__["sso_group_name"] = sso_group_name
            __props__.__dict__["sso_linked"] = sso_linked
            __props__.__dict__["tags"] = tags
            __props__.__dict__["users"] = users
        super(Usergroup, __self__).__init__(
            'harness:platform/usergroup:Usergroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            externally_managed: Optional[pulumi.Input[bool]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            linked_sso_display_name: Optional[pulumi.Input[str]] = None,
            linked_sso_id: Optional[pulumi.Input[str]] = None,
            linked_sso_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UsergroupNotificationConfigArgs']]]]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            sso_group_id: Optional[pulumi.Input[str]] = None,
            sso_group_name: Optional[pulumi.Input[str]] = None,
            sso_linked: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Usergroup':
        """
        Get an existing Usergroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] externally_managed: Whether the user group is externally managed.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] linked_sso_display_name: Name of the linked SSO.
        :param pulumi.Input[str] linked_sso_id: The SSO account ID that the user group is linked to.
        :param pulumi.Input[str] linked_sso_type: Type of linked SSO
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UsergroupNotificationConfigArgs']]]] notification_configs: List of notification settings.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] sso_group_id: Identifier of the userGroup in SSO.
        :param pulumi.Input[str] sso_group_name: Name of the SSO userGroup.
        :param pulumi.Input[bool] sso_linked: Whether sso is linked or not
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: List of users in the UserGroup.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UsergroupState.__new__(_UsergroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["externally_managed"] = externally_managed
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["linked_sso_display_name"] = linked_sso_display_name
        __props__.__dict__["linked_sso_id"] = linked_sso_id
        __props__.__dict__["linked_sso_type"] = linked_sso_type
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_configs"] = notification_configs
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["sso_group_id"] = sso_group_id
        __props__.__dict__["sso_group_name"] = sso_group_name
        __props__.__dict__["sso_linked"] = sso_linked
        __props__.__dict__["tags"] = tags
        __props__.__dict__["users"] = users
        return Usergroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externallyManaged")
    def externally_managed(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the user group is externally managed.
        """
        return pulumi.get(self, "externally_managed")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="linkedSsoDisplayName")
    def linked_sso_display_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the linked SSO.
        """
        return pulumi.get(self, "linked_sso_display_name")

    @property
    @pulumi.getter(name="linkedSsoId")
    def linked_sso_id(self) -> pulumi.Output[Optional[str]]:
        """
        The SSO account ID that the user group is linked to.
        """
        return pulumi.get(self, "linked_sso_id")

    @property
    @pulumi.getter(name="linkedSsoType")
    def linked_sso_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of linked SSO
        """
        return pulumi.get(self, "linked_sso_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationConfigs")
    def notification_configs(self) -> pulumi.Output[Optional[Sequence['outputs.UsergroupNotificationConfig']]]:
        """
        List of notification settings.
        """
        return pulumi.get(self, "notification_configs")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="ssoGroupId")
    def sso_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of the userGroup in SSO.
        """
        return pulumi.get(self, "sso_group_id")

    @property
    @pulumi.getter(name="ssoGroupName")
    def sso_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the SSO userGroup.
        """
        return pulumi.get(self, "sso_group_name")

    @property
    @pulumi.getter(name="ssoLinked")
    def sso_linked(self) -> pulumi.Output[bool]:
        """
        Whether sso is linked or not
        """
        return pulumi.get(self, "sso_linked")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of users in the UserGroup.
        """
        return pulumi.get(self, "users")

