# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 is_manual_trigger_authorized: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[str] description: The application description
        :param pulumi.Input[bool] is_manual_trigger_authorized: When this is set to true, all manual triggers will require API Key authorization
        :param pulumi.Input[str] name: The name of the application
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_manual_trigger_authorized is not None:
            pulumi.set(__self__, "is_manual_trigger_authorized", is_manual_trigger_authorized)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The application description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isManualTriggerAuthorized")
    def is_manual_trigger_authorized(self) -> Optional[pulumi.Input[bool]]:
        """
        When this is set to true, all manual triggers will require API Key authorization
        """
        return pulumi.get(self, "is_manual_trigger_authorized")

    @is_manual_trigger_authorized.setter
    def is_manual_trigger_authorized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_manual_trigger_authorized", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 git_sync_connector_id: Optional[pulumi.Input[str]] = None,
                 git_sync_enabled: Optional[pulumi.Input[bool]] = None,
                 is_manual_trigger_authorized: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input[str] description: The application description
        :param pulumi.Input[str] git_sync_connector_id: The id of the git sync connector
        :param pulumi.Input[bool] git_sync_enabled: True if git sync is enabled on this application
        :param pulumi.Input[bool] is_manual_trigger_authorized: When this is set to true, all manual triggers will require API Key authorization
        :param pulumi.Input[str] name: The name of the application
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if git_sync_connector_id is not None:
            pulumi.set(__self__, "git_sync_connector_id", git_sync_connector_id)
        if git_sync_enabled is not None:
            pulumi.set(__self__, "git_sync_enabled", git_sync_enabled)
        if is_manual_trigger_authorized is not None:
            pulumi.set(__self__, "is_manual_trigger_authorized", is_manual_trigger_authorized)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The application description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gitSyncConnectorId")
    def git_sync_connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the git sync connector
        """
        return pulumi.get(self, "git_sync_connector_id")

    @git_sync_connector_id.setter
    def git_sync_connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "git_sync_connector_id", value)

    @property
    @pulumi.getter(name="gitSyncEnabled")
    def git_sync_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if git sync is enabled on this application
        """
        return pulumi.get(self, "git_sync_enabled")

    @git_sync_enabled.setter
    def git_sync_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "git_sync_enabled", value)

    @property
    @pulumi.getter(name="isManualTriggerAuthorized")
    def is_manual_trigger_authorized(self) -> Optional[pulumi.Input[bool]]:
        """
        When this is set to true, all manual triggers will require API Key authorization
        """
        return pulumi.get(self, "is_manual_trigger_authorized")

    @is_manual_trigger_authorized.setter
    def is_manual_trigger_authorized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_manual_trigger_authorized", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_manual_trigger_authorized: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for creating a Harness application

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        myapp = harness.Application("myapp",
            description="This is my first Harness application",
            tags=[
                "mytag:myvalue",
                "team:development",
            ])
        ```

        ## Import

        # Import using the Harness application id

        ```sh
         $ pulumi import harness:index/application:Application myapp Xyz123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The application description
        :param pulumi.Input[bool] is_manual_trigger_authorized: When this is set to true, all manual triggers will require API Key authorization
        :param pulumi.Input[str] name: The name of the application
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApplicationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness application

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness

        myapp = harness.Application("myapp",
            description="This is my first Harness application",
            tags=[
                "mytag:myvalue",
                "team:development",
            ])
        ```

        ## Import

        # Import using the Harness application id

        ```sh
         $ pulumi import harness:index/application:Application myapp Xyz123
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_manual_trigger_authorized: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["is_manual_trigger_authorized"] = is_manual_trigger_authorized
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["git_sync_connector_id"] = None
            __props__.__dict__["git_sync_enabled"] = None
        super(Application, __self__).__init__(
            'harness:index/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            git_sync_connector_id: Optional[pulumi.Input[str]] = None,
            git_sync_enabled: Optional[pulumi.Input[bool]] = None,
            is_manual_trigger_authorized: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The application description
        :param pulumi.Input[str] git_sync_connector_id: The id of the git sync connector
        :param pulumi.Input[bool] git_sync_enabled: True if git sync is enabled on this application
        :param pulumi.Input[bool] is_manual_trigger_authorized: When this is set to true, all manual triggers will require API Key authorization
        :param pulumi.Input[str] name: The name of the application
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["description"] = description
        __props__.__dict__["git_sync_connector_id"] = git_sync_connector_id
        __props__.__dict__["git_sync_enabled"] = git_sync_enabled
        __props__.__dict__["is_manual_trigger_authorized"] = is_manual_trigger_authorized
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The application description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="gitSyncConnectorId")
    def git_sync_connector_id(self) -> pulumi.Output[str]:
        """
        The id of the git sync connector
        """
        return pulumi.get(self, "git_sync_connector_id")

    @property
    @pulumi.getter(name="gitSyncEnabled")
    def git_sync_enabled(self) -> pulumi.Output[bool]:
        """
        True if git sync is enabled on this application
        """
        return pulumi.get(self, "git_sync_enabled")

    @property
    @pulumi.getter(name="isManualTriggerAuthorized")
    def is_manual_trigger_authorized(self) -> pulumi.Output[Optional[bool]]:
        """
        When this is set to true, all manual triggers will require API Key authorization
        """
        return pulumi.get(self, "is_manual_trigger_authorized")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")

