# PyPXR

Open-source python utilities for modeling Polarized X-ray Reflectivity using an anisotropic transfer matrix formalism. The roots of this package were originally forked from the refnx.reflect layer model developed by Andrew Nelson.

This package requires the use of [refnx](https://refnx.readthedocs.io/en/latest/index.html) in order to model and fit data.

Some functionalities have been forked and repurposed from other open-source utilities:

  - [D. Dietze : FSRStools](https://github.com/ddietze/FSRStools)
  - [M. Jeannin : pyGTM](https://github.com/pyMatJ/pyGTM)
  - [P. Dmitriev : PyATMM](https://github.com/kitchenknif/PyATMM)


Results produced from the main-branch uniaxial calculation have been published and can be found online

  - [ACS Appl. Mater. Interfaces 2022, 14, 2, 3455–3466 (DOI:10.1021/acsami.1c19948)](https://pubs.acs.org/doi/abs/10.1021/acsami.1c19948)


### Contact information:
 - Authors: Thomas J. Ferron & Daniel F. Sunday
 - Affiliation: Materials Measurement Laboratory / Material Science and Engineering Division / Polymers Processing Group
 - Website: 
    - [Detailed Documentation (ReadTheDocs)](https://p-rsoxr.readthedocs.io/en/latest/)
    - [Resonant Soft X-ray Scattering Group](https://www.nist.gov/programs-projects/resonant-soft-x-ray-scattering-rsoxs)
 - Email: daniel.sunday@nist.gov
