Unification Mainnet Helpers
===========================

Miscellaneous tools to help support the maintenance of Unification
Mainnet EVs can be found here.

Defaults
--------

Due to the complexity of the beast, these tools will only work with our
standard environments. This library also only currently supports Linux.
There is some room for differences that the codebase can be modified to
handle.

To view what the expected defaults are:

    python -m undmainchain.cli.defaults show

All the helpers take a `--machine` option that loads custom values.
These values are defined in the `undmainchain.const` module.

Reset All
---------

This command will wipe all your chain data, use the latest published und
versions and genesis. Whilst it may take much time to catch up, this is
a good fresh slate if needed.

    python -m undmainchain.cli.upgrade revert

### Install a specific version

    python -m undmainchain.cli.upgrade binaries 1.4.1

Export to S3
------------

### Genesis Export

The export helper will stop the EV, export the chain data to a JSON file
and upload it to Amazon S3, and start the EV again.

    python -m undmainchain.cli.export genesis <HEIGHT> <AWSKEY> <AWSSECRET>

### Chain Export

The entire chain can be compressed and exported to S3. Warning: chains
can be large and uploading to S3 can incur cost.

    python -m undmainchain.cli.export chain <AWSKEY> <AWSSECRET>

Network upgrades
----------------

There is also a helper that support network upgrades

    python -m undmainchain.cli.upgrade genesis 700000

The helper will wait until the specified block and then perform an
upgrade.
