# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['django_non_dark_admin', 'django_non_dark_admin.templatetags']

package_data = \
{'': ['*'],
 'django_non_dark_admin': ['static/django_non_dark_admin/*',
                           'templates/admin/*',
                           'templates/django_non_dark_admin/*']}

install_requires = \
['django>=3.2']

setup_kwargs = {
    'name': 'django-non-dark-admin',
    'version': '2.0.1',
    'description': 'Disable dark mode in Django admin user interface in Django 3.2.x.',
    'long_description': 'Django Non Dark Admin\n=====================\n\nDisable or enable dark mode user interface in Django admin panel (Django==3.2).\n\nInstallation\n------------\nFor install this app run in terminal:\n::\n\n    pip install django-non-dark-admin\n\nConfiguration for all users\n---------------------------\n\nAdd \'\'django_non_dark_admin\'\' to your ``INSTALLED_APPS`` settings. This is must be added **BEFORE** \'\'django.contrib.admin\'\'.\n\nSet \'\'DISABLE_DARK_MODE = True\'\' in your settings module to disable dark mode in admin panel user interface to all users.\n\nConfiguration per user\n----------------------\n\nTo have the theme configured as a user preference you will need to have a custom user model (model configured in ``settings.AUTH_USER_MODEL``) as described in Django documentation:\n\n* https://docs.djangoproject.com/en/4.0/topics/auth/customizing/#substituting-a-custom-user-model\n* https://docs.djangoproject.com/en/4.0/ref/settings/#auth-user-model\n\nAdd a boolean field `disable_dark_mode` to your custom user model:\n\n.. code-block:: python\n\n    disable_dark_mode = models.BooleanField(\n        verbose_name="Django Admin Theme",\n        default=False choices=((False, "Dark"),\n        (True, "Light")),\n        null=True\n    )\n\n\nAfter adding the field, run:\n\n::\n\n    python manage.py makemigrations\n\n\nIt should generate a migration like this:\n\n.. code-block:: python\n\n    # Generated by Django 3.2.9 on 2021-12-27 19:17\n\n    from django.db import migrations, models\n\n\n    class Migration(migrations.Migration):\n\n        dependencies = [\n            ("app_for_the_auth_custom_model", "0XXX_previous_migration"),\n        ]\n\n        operations = [\n            migrations.AddField(\n                model_name="<Your Custom Auth User model>",\n                name="disable_dark_mode",\n                field=models.BooleanField(\n                    choices=[(False, "Dark"), (True, "Light")],\n                    default=False,\n                    null=True,\n                ),\n            ),\n        ]\n\n\nRun the migration:\n\n::\n\n    python manage.py migrate\n\n\nAnd the field will be added to your ``AUTH_USER_MODEL``.\n\nGo to the Django admin for your custom user model and add the field to be editable.\n\nLicense\n-------\nLicensed under BSD license. See `license link`_ in documentation.\n\n.. _license link: LICENSE.rst',
    'author': 'Artem Galichkin',
    'author_email': 'doomer3d@gmail.com',
    'maintainer': 'Artem Galichkin',
    'maintainer_email': 'doomer3d@gmail.com',
    'url': 'https://github.com/DOOMer/django-non-dark-admin',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
