import pytest
import orjson
import msgpack


json_str = b"""{
        "str":"h",
        "int":3,
        "bool":true,
        "float":0.34,
        "float_arr":[[1.254439975231648,-0.6893827594332794],[-0.2922560025562806,0.5204819306523419]],
        "int_arr":[[-100,-25],[-41,-62]],
        "uint_arr":[[100, 25],[41, 62]],
        "bool_arr":[[false, true],[true, false]],
        "stream0":[[-1.720294114558863,0.5990469735869592,0.0506514091042812,0.7204746283872987,1.5351637640639662],
                   [72,45,-58,-16,-14],
                   [1,0,0,1,0]],
        "stream1":[[-1.720294114558863,0.5990469735869592,0.0506514091042812,0.7204746283872987,1.5351637640639662],
                   [72,45,-58,-16,-14],
                   [true,false,false,true,false]],
        "stream2":[[-2.1727126743596266,false,"a"],
                   [-0.06389102863189458,true,"b"],
                   [1.3716941547285826,true,"c"]],
        "stream3":[[-2.1727126743596266,0,1],
                   [-0.06389102863189458,1,2],
                   [1.3716941547285826,1,3]],
        "stream4":[{"x":-2.1727126743596266,"y":0,"z":1},
                   {"x":-0.06389102863189458,"y":1,"z":2},
                   {"x":1.3716941547285826,"y":1,"z":3}],
        "nest":{
            "is_nest":true,
            "nestiness":0.9999,
            "stream0":[[-0.11954010897451912,28],
                       [0.21599243355210992,9]],
            "stream1":[[0, 28],
                       [0, 9]],
            "arr3":[true,false,true],
            "unused_key":"a"}}"""

msgpack_bytes = msgpack.dumps(orjson.loads(json_str))
    
wonky_json_str = b"""{
        "irregular":[[1.254439975231648,-0.6893827594332794],[-0.2922560025562806]],
        "irregular_columns":[[-1.720294114558863,0.5990469735869592],
                             [72,45,-58,-16,-14],
                             [1]],
        "irregular_transpose_sequence":[[-2.1727126743596266,false,"a"],
                                        [-0.06389102863189458,true],
                                        [true,"c"]],
        "irregular_transpose_map":[{"x":-2.1727126743596266, "z":1},
                                   {"x":-0.06389102863189458,"y":1,"z":2},
                                   {"y":1,"z":3}]
                                   }
        """

wonky_msgpack_bytes = msgpack.dumps(orjson.loads(wonky_json_str))