Linear regression, with p-values and AIC for the full model, p-values per coefficient, and tests of linear constraints on regression coefficients. The formulas are based on Bingham & Fry.

The module uses only the modules numpy and math (built-in).

## Basic usage

By default, do not add an explicit intercept to the predictors. The intercept will be appended as an additional predictor, unless the argument explicit_intercept is given and set to True (for if you want to define constraints involving the intercept).

Example, using simulated data:

import numpy as np

import teg_regression

nObs = 300

nPred = 5

fix_coeffs = {0: 1, 3: 2} # Set to empty dict to simulate the null model.

X, y = teg_regression.sim_data(nObs, nPred, fix_coeffs=fix_coeffs, fix_intercept=20)

O = teg_regression.run_regression(X, y)

The function returns a dictionary O with statistical values and prints out (unless report=False is set as an argument):

Test of the model:

	F(5,294) = 0.544, p = 0.743

	AIC constrained - free = -1.41e+03 (negative supports constraints).

Tests per coefficient.

	Predictor 0: b = 0.012, F(1,294) = 0.0437, p = 0.835

	Predictor 1: b = -0.0466, F(1,294) = 0.655, p = 0.419

	Predictor 2: b = -0.0601, F(1,294) = 1.2, p = 0.275

	Predictor 3: b = -0.00762, F(1,294) = 0.018, p = 0.893

	Predictor 4: b = 0.0482, F(1,294) = 0.787, p = 0.376

	Intercept: b = 20.5, F(1,294) = 1.05e+05, p = 1.11e-16

### Linear constraints

Linear constraints specify hypotheses in terms of weighted sums of the coefficients, to be tested against the free model. E.g., assuming we have four predictors, the matrix equation

[1 0 0 0]           [0]

[0 1 0 0] * betas = [0]

[0 0 1 0]           [0]

would constrain the first three predictors to be zero.

Similarly,

[1 -1 0 0] * betas = 0

Would constrain the first and second predictor to be equal.

The Constraints argument, specifying the desired hypothesis, is a dictionary with the "coefficients" matrix, as a 2D array, and the "constants" vector, also as an array. The example below shows the Constraints setup to set two specific predictor-coefficients to 0.

pred_to_test = [1, 2]

Constraints = {}

Constraints['coefficients'] = np.array([[0 for a in range(X.shape[1])] for newrow in range(2)]).reshape(2, X.shape[1])

Constraints['coefficients'][0][pred_to_test[0]] = 1

Constraints['coefficients'][1][pred_to_test[1]] = 1

Constraints['constants'] = np.array([0, 0])

O = teg_regression.run_regression(X, y, Constraints)
