# #############################################################################
#  pySAP - Copyright (C) CEA, 2017 - 2018                                     #
#  Distributed under the terms of the CeCILL-B license,                       #
#  as published by the CEA-CNRS-INRIA. Refer to the LICENSE file or to        #
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html for details.   #
# #############################################################################

"""
Base Operator.

Every operator should have an `op` and `adj_op` methods.
"""

class OperatorBase:
    """Base Operator class.

    Every linear operator inherits from this class,
    to ensure that we have all the functions rightly implemented
    as required by Modopt
    """

    def op(self, data):
        """Compute operator transform.

        Parameters
        ----------
        data: numpy.ndarray
            input as array.

        Returns
        -------
        result: numpy.ndarray
            operator transform of the input.
        """
        raise NotImplementedError("'op' is an abstract method.")

    def adj_op(self, coeffs):
        """Compute adjoint operator transform.

        Parameters
        ----------
        x: numpy.ndarray
            input data array.

        Returns
        -------
        results: numpy.ndarray
            adjoint operator transform.
        """
        raise NotImplementedError("'adj_op' is an abstract method.")
