from pyspark.sql.types import *
from optimus import Optimus
from optimus.helpers.json import json_enconding
from optimus.helpers.functions import deep_sort
import unittest
import numpy as np
nan = np.nan
import datetime
op = Optimus(master='local')
source_df=op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
class Test_df_cols_pandas(unittest.TestCase):
	maxDiff = None
	@staticmethod
	def test_cols_abs():
		actual_df =source_df.cols.abs('weight(t)')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_abs_all_columns():
		actual_df =source_df.cols.abs('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"rank":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"last position seen":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"date arrival":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"last date seen":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"attributes":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"Date Type":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"Cybertronian":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function(binary)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"NullType":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"Mixed":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function_new":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"height(ft)":{"0":28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":null},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"last position seen":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"date arrival":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"last date seen":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"attributes":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Date Type":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"timestamp":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Cybertronian":{"0":1.0,"1":1.0,"2":1.0,"3":1.0,"4":1.0,"5":1.0,"6":null},"function(binary)":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":null,"1":null,"2":null,"3":5123456789123456.0,"4":11529.0,"5":3.0,"6":null},"function_new":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_add():
		actual_df =source_df.cols.add(['height(ft)','rank'])
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"sum":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"sum":{"0":-18.0,"1":24.0,"2":33.0,"3":21.0,"4":10.0,"5":308.0,"6":0.0}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_add_all_columns():
		actual_df =source_df.cols.add('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"sum":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"sum":{"0":3999987.2999999998,"1":5000027.0,"2":7000038.0,"3":5123456794123480.0,"4":5011545.7000000002,"5":5000312.0,"6":0.0}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_cast():
		actual_df =source_df.cols.cast('function','string')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_cast_all_columns():
		actual_df =source_df.cols.cast('*','str')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"weight(t)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":"None"},"height(ft)":{"0":"-28.0","1":"17.0","2":"26.0","3":"13.0","4":"nan","5":"300.0","6":"nan"},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":"10.0","1":"7.0","2":"7.0","3":"8.0","4":"10.0","5":"8.0","6":"NaN"},"age":{"0":"4000000.0","1":"5000000.0","2":"7000000.0","3":"5000000.0","4":"5000000.0","5":"5000000.0","6":"nan"},"weight(t)":{"0":"4.3","1":"2.0","2":"4.0","3":"1.8","4":"5.7","5":"nan","6":"nan"},"japanese name":{"0":"['Inochi', 'Convoy']","1":"['Bumble', 'Goldback']","2":"['Roadbuster']","3":"['Meister']","4":"['Megatron']","5":"['Metroflex']","6":"None"},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":"None","5":"None","6":"None"},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":"None"},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":"None"},"attributes":{"0":"[8.5344, 4300.0]","1":"[5.334, 2000.0]","2":"[7.9248, 4000.0]","3":"[3.9624, 1800.0]","4":"[None, 5700.0]","5":"[91.44, None]","6":"None"},"Date Type":{"0":"2016-09-10","1":"2015-08-10","2":"2014-06-24","3":"2013-06-24","4":"2012-05-10","5":"2011-04-10","6":"None"},"timestamp":{"0":"2014-06-24 00:00:00","1":"2014-06-24 00:00:00","2":"2014-06-24 00:00:00","3":"2014-06-24 00:00:00","4":"2014-06-24 00:00:00","5":"2014-06-24 00:00:00","6":"NaT"},"Cybertronian":{"0":"True","1":"True","2":"True","3":"True","4":"True","5":"True","6":"None"},"function(binary)":{"0":"bytearray(b'Leader')","1":"bytearray(b'Espionage')","2":"bytearray(b'Security')","3":"bytearray(b'First Lieutenant')","4":"bytearray(b'None')","5":"bytearray(b'Battle Station')","6":"None"},"NullType":{"0":"None","1":"None","2":"None","3":"None","4":"None","5":"None","6":"None"},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_clip():
		actual_df =source_df.cols.clip('rank',3,5)
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":5.0,"1":5.0,"2":5.0,"3":5.0,"4":5.0,"5":5.0,"6":null},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_clip_all_columns():
		actual_df =source_df.cols.clip('*',3,5)
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"rank":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"last position seen":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"date arrival":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"last date seen":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"attributes":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"Date Type":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"Cybertronian":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function(binary)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"NullType":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"Mixed":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function_new":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"height(ft)":{"0":3.0,"1":5.0,"2":5.0,"3":5.0,"4":null,"5":5.0,"6":null},"function":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"rank":{"0":5.0,"1":5.0,"2":5.0,"3":5.0,"4":5.0,"5":5.0,"6":null},"age":{"0":5.0,"1":5.0,"2":5.0,"3":5.0,"4":5.0,"5":5.0,"6":null},"weight(t)":{"0":4.3,"1":3.0,"2":4.0,"3":3.0,"4":5.0,"5":null,"6":null},"japanese name":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"last position seen":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"date arrival":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"last date seen":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"attributes":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Date Type":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"timestamp":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Cybertronian":{"0":3.0,"1":3.0,"2":3.0,"3":3.0,"4":3.0,"5":3.0,"6":null},"function(binary)":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":null,"1":null,"2":null,"3":5.0,"4":5.0,"5":3.0,"6":null},"function_new":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_count():
		actual_df =source_df.cols.count()
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(18)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_array():
		actual_df =source_df.cols.count_mismatch({"Mixed": "array"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 7, 'missing': 0, 'mismatch': 0, 'profiler_dtype': 'array'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_boolean():
		actual_df =source_df.cols.count_mismatch({"Mixed": "boolean"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 0, 'missing': 0, 'mismatch': 7, 'profiler_dtype': 'boolean'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_credit_card():
		actual_df =source_df.cols.count_mismatch({"Mixed": "credit_card_number"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 1, 'missing': 0, 'mismatch': 6, 'profiler_dtype': 'credit_card_number'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_date():
		actual_df =source_df.cols.count_mismatch({"Mixed": "date"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 7, 'missing': 0, 'mismatch': 0, 'profiler_dtype': 'date'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_decimal():
		actual_df =source_df.cols.count_mismatch({"Mixed": "decimal"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 0, 'missing': 0, 'mismatch': 7, 'profiler_dtype': 'decimal'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_email():
		actual_df =source_df.cols.count_mismatch({"Mixed": "email"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 0, 'missing': 0, 'mismatch': 7, 'profiler_dtype': 'email'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_int():
		actual_df =source_df.cols.count_mismatch({"Mixed": "int"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 3, 'missing': 0, 'mismatch': 4, 'profiler_dtype': 'int'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_ip():
		actual_df =source_df.cols.count_mismatch({"Mixed": "ip"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 1, 'missing': 0, 'mismatch': 6, 'profiler_dtype': 'ip'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_object():
		actual_df =source_df.cols.count_mismatch({"Mixed": "object"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 7, 'missing': 0, 'mismatch': 0, 'profiler_dtype': 'object'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_string():
		actual_df =source_df.cols.count_mismatch({"Mixed": "string"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 7, 'missing': 0, 'mismatch': 0, 'profiler_dtype': 'string'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_url():
		actual_df =source_df.cols.count_mismatch({"Mixed": "url"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 1, 'missing': 0, 'mismatch': 6, 'profiler_dtype': 'url'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_zip_code():
		actual_df =source_df.cols.count_mismatch({"Mixed": "zip_code"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'match': 1, 'missing': 0, 'mismatch': 6, 'profiler_dtype': 'zip_code'}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_na():
		actual_df =source_df.cols.count_na('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(2)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_na_all_columns():
		actual_df =source_df.cols.count_na('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': 1, 'height(ft)': 2, 'function': 0, 'rank': 0, 'age': 1, 'weight(t)': 2, 'japanese name': 1, 'last position seen': 3, 'date arrival': 1, 'last date seen': 1, 'attributes': 1, 'Date Type': 1, 'timestamp': 1, 'Cybertronian': 1, 'function(binary)': 1, 'NullType': 7, 'Mixed': 0, 'function_new': 0})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_uniques():
		actual_df =source_df.cols.count_uniques('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(6)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_uniques_all_columns():
		actual_df =source_df.cols.count_uniques('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': 7, 'height(ft)': 6, 'function': 6, 'rank': 4, 'age': 4, 'weight(t)': 6, 'japanese name': 7, 'last position seen': 5, 'date arrival': 2, 'last date seen': 7, 'attributes': 7, 'Date Type': 7, 'timestamp': 2, 'Cybertronian': 2, 'function(binary)': 7, 'NullType': 1, 'Mixed': 7, 'function_new': 6})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_zeros():
		actual_df =source_df.cols.count_zeros('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(0)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_zeros_all_columns():
		actual_df =source_df.cols.count_zeros('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': 0, 'height(ft)': 0, 'function': 0, 'rank': 0, 'age': 0, 'weight(t)': 0, 'japanese name': 0, 'last position seen': 0, 'date arrival': 0, 'last date seen': 0, 'attributes': 0, 'Date Type': 0, 'timestamp': 0, 'Cybertronian': 0, 'function(binary)': 0, 'NullType': 0, 'Mixed': 0, 'function_new': 0})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_date_format():
		actual_df =source_df.cols.date_format('date arrival','%Y/%m/%d','%d/%m/%Y')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"10\/04\/1980","1":"10\/04\/1980","2":"10\/04\/1980","3":"10\/04\/1980","4":"10\/04\/1980","5":"10\/04\/1980","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_date_format_all_columns():
		actual_df =source_df.cols.date_format(['date arrival','last date seen'],'%Y/%m/%d','%d/%m/%Y')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"10\/04\/1980","1":"10\/04\/1980","2":"10\/04\/1980","3":"10\/04\/1980","4":"10\/04\/1980","5":"10\/04\/1980","6":null},"last date seen":{"0":"10\/09\/2016","1":"10\/08\/2015","2":"10\/07\/2014","3":"10\/06\/2013","4":"10\/05\/2012","5":"10\/04\/2011","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_div():
		actual_df =source_df.cols.div(['height(ft)','rank'])
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"div":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"div":{"0":-2.8,"1":2.4285714286,"2":3.7142857143,"3":1.625,"4":0.0,"5":37.5,"6":null}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_div_all_columns():
		actual_df =source_df.cols.div('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"div":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"div":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_drop():
		actual_df =source_df.cols.drop('rank')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_dtypes():
		actual_df =source_df.cols.dtypes('rank')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'rank': 'object'})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_dtypes_all_columns():
		actual_df =source_df.cols.dtypes('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'function_new': 'object'})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_fill_na():
		actual_df =source_df.cols.fill_na('Cybertronian',False)
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":1,"byteorder":"|","descr":[["","|b1"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"b","name":"bool","ndim":0,"num":0,"str":"|b1"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":false},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_fill_na_all_columns():
		actual_df =source_df.cols.fill_na(['names','height(ft)','function','rank','age'],'2')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":"2"},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":"2","5":300.0,"6":"2"},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":"2"},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	def test_cols_frequency(self):
		actual_df =source_df.cols.frequency('rank',4)
		expected_value ={'rank': {'frequency': [{'value': '7.0', 'count': 2}, {'value': '10.0', 'count': 2}, {'value': '8.0', 'count': 2}, {'value': 'NaN', 'count': 1}]}}
		self.assertDictEqual(deep_sort(expected_value),  deep_sort(actual_df))
	def test_cols_frequency_all_columns(self):
		actual_df =source_df.cols.frequency('*',4)
		expected_value ={'names': {'frequency': [{'value': 'Metroplex_)^$', 'count': 1}, {'value': 'Jazz', 'count': 1}, {'value': 'bumbl#ebéé  ', 'count': 1}, {'value': 'None', 'count': 1}]}, 'height(ft)': {'frequency': [{'value': 'nan', 'count': 2}, {'value': '13.0', 'count': 1}, {'value': '26.0', 'count': 1}, {'value': '17.0', 'count': 1}]}, 'function': {'frequency': [{'value': 'None', 'count': 2}, {'value': 'ponge', 'count': 1}, {'value': 'Securty', 'count': 1}, {'value': 'Frst Leutennt', 'count': 1}]}, 'rank': {'frequency': [{'value': '7.0', 'count': 2}, {'value': '10.0', 'count': 2}, {'value': '8.0', 'count': 2}, {'value': 'NaN', 'count': 1}]}, 'age': {'frequency': [{'value': '5000000.0', 'count': 4}, {'value': 'nan', 'count': 1}, {'value': '4000000.0', 'count': 1}, {'value': '7000000.0', 'count': 1}]}, 'weight(t)': {'frequency': [{'value': 'nan', 'count': 2}, {'value': '2.0', 'count': 1}, {'value': '1.8', 'count': 1}, {'value': '4.0', 'count': 1}]}, 'japanese name': {'frequency': [{'value': "['Roadbuster']", 'count': 1}, {'value': 'None', 'count': 1}, {'value': "['Megatron']", 'count': 1}, {'value': "['Metroflex']", 'count': 1}]}, 'last position seen': {'frequency': [{'value': 'None', 'count': 3}, {'value': '19.442735,-99.201111', 'count': 1}, {'value': '10.642707,-71.612534', 'count': 1}, {'value': '33.670666,-117.841553', 'count': 1}]}, 'date arrival': {'frequency': [{'value': '1980/04/10', 'count': 6}, {'value': 'None', 'count': 1}]}, 'last date seen': {'frequency': [{'value': 'None', 'count': 1}, {'value': '2013/06/10', 'count': 1}, {'value': '2015/08/10', 'count': 1}, {'value': '2014/07/10', 'count': 1}]}, 'attributes': {'frequency': [{'value': 'None', 'count': 1}, {'value': '[3.9624, 1800.0]', 'count': 1}, {'value': '[7.9248, 4000.0]', 'count': 1}, {'value': '[91.44, None]', 'count': 1}]}, 'Date Type': {'frequency': [{'value': 'None', 'count': 1}, {'value': '2011-04-10', 'count': 1}, {'value': '2014-06-24', 'count': 1}, {'value': '2012-05-10', 'count': 1}]}, 'timestamp': {'frequency': [{'value': '2014-06-24', 'count': 6}, {'value': 'NaT', 'count': 1}]}, 'Cybertronian': {'frequency': [{'value': 'True', 'count': 6}, {'value': 'None', 'count': 1}]}, 'function(binary)': {'frequency': [{'value': "bytearray(b'Security')", 'count': 1}, {'value': 'None', 'count': 1}, {'value': "bytearray(b'Espionage')", 'count': 1}, {'value': "bytearray(b'First Lieutenant')", 'count': 1}]}, 'NullType': {'frequency': [{'value': 'None', 'count': 7}]}, 'Mixed': {'frequency': [{'value': 'male', 'count': 1}, {'value': '1.1.1.1', 'count': 1}, {'value': '3', 'count': 1}, {'value': '5123456789123456', 'count': 1}]}, 'function_new': {'frequency': [{'value': 'None', 'count': 2}, {'value': 'ponge', 'count': 1}, {'value': 'Securty', 'count': 1}, {'value': 'Frst Leutennt', 'count': 1}]}}
		self.assertDictEqual(deep_sort(expected_value),  deep_sort(actual_df))
	@staticmethod
	def test_cols_hist():
		actual_df =source_df.cols.hist(['height(ft)','rank'],4)
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'hist': [{'count': 1.0, 'lower': -28.0, 'upper': -14.5}, {'count': 0.0, 'lower': -14.5, 'upper': -1.0}, {'count': 0.0, 'lower': -1.0, 'upper': 12.5}, {'count': 5.0, 'lower': 12.5, 'upper': 26.0}]}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_hist_all_columns():
		actual_df =source_df.cols.hist('*',4)
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'hist': [{'count': 1.0, 'lower': -28.0, 'upper': -14.5}, {'count': 0.0, 'lower': -14.5, 'upper': -1.0}, {'count': 0.0, 'lower': -1.0, 'upper': 12.5}, {'count': 5.0, 'lower': 12.5, 'upper': 26.0}]}, 'age': {'hist': [{'count': 1.0, 'lower': 4000000.0, 'upper': 4750000.0}, {'count': 4.0, 'lower': 4750000.0, 'upper': 5500000.0}, {'count': 0.0, 'lower': 5500000.0, 'upper': 6250000.0}, {'count': 2.0, 'lower': 6250000.0, 'upper': 7000000.0}]}, 'weight(t)': {'hist': [{'count': 2.0, 'lower': 1.8, 'upper': 2.7750000000000004}, {'count': 0.0, 'lower': 2.7750000000000004, 'upper': 3.75}, {'count': 2.0, 'lower': 3.75, 'upper': 4.7250000000000005}, {'count': 3.0, 'lower': 4.7250000000000005, 'upper': 5.7}]}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_impute():
		actual_df =source_df.cols.impute('rank')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leader","1":"Espionage","2":"Security","3":"First Lieutenant","4":"None","5":"Battle Station","6":null},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":8.3333333333},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_impute_multiple_columns():
		actual_df =source_df.cols.impute('rank','categorical')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank***STRING_TO_INDEX":{"alignment":8,"byteorder":"=","descr":[["","<i8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"i","name":"int64","ndim":0,"num":9,"str":"<i8"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":8.3333333333},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"rank***STRING_TO_INDEX":{"0":3,"1":0,"2":0,"3":1,"4":3,"5":1,"6":2},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_iqr():
		actual_df =source_df.cols.iqr(None,'height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'iqr': 13.0, 'q1': 13.0, 'q2': 17.0, 'q3': 26.0}, 'age': {'iqr': 0.0, 'q1': 5000000.0, 'q2': 5000000.0, 'q3': 5000000.0}, 'weight(t)': {'iqr': 2.3, 'q1': 2.0, 'q2': 4.0, 'q3': 4.3}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_iqr_all_columns():
		actual_df =source_df.cols.iqr('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': 13.0, 'age': 0.0, 'weight(t)': 2.3})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_keep():
		actual_df =source_df.cols.keep('rank')
		expected_df = op.create.df({"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_kurtosis():
		actual_df =source_df.cols.kurtosis('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': 4.554534592603288})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_kurtosis_all_columns():
		actual_df =source_df.cols.kurtosis('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': nan, 'height(ft)': 4.554534592603288, 'function': nan, 'rank': -1.8750000000000009, 'age': 3.6028537455410117, 'weight(t)': -1.745623079495064, 'japanese name': nan, 'last position seen': nan, 'date arrival': nan, 'last date seen': nan, 'attributes': nan, 'Date Type': nan, 'timestamp': nan, 'Cybertronian': 0.0, 'function(binary)': nan, 'NullType': nan, 'Mixed': nan, 'function_new': nan})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_lower():
		actual_df =source_df.cols.lower('function')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"leder","1":"ponge","2":"securty","3":"frst leutennt","4":"none","5":"bttle stton","6":"none"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_lower_all_columns():
		actual_df =source_df.cols.lower('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"jazz","4":"megatron","5":"metroplex_)^$","6":"none"},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"leder","1":"ponge","2":"securty","3":"frst leutennt","4":"none","5":"bttle stton","6":"none"},"rank":{"0":"10.0","1":"7.0","2":"7.0","3":"8.0","4":"10.0","5":"8.0","6":"nan"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":"['inochi', 'convoy']","1":"['bumble', 'goldback']","2":"['roadbuster']","3":"['meister']","4":"['megatron']","5":"['metroflex']","6":"none"},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":"none","5":"none","6":"none"},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":"none"},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":"none"},"attributes":{"0":"[8.5344, 4300.0]","1":"[5.334, 2000.0]","2":"[7.9248, 4000.0]","3":"[3.9624, 1800.0]","4":"[none, 5700.0]","5":"[91.44, none]","6":"none"},"Date Type":{"0":"2016-09-10","1":"2015-08-10","2":"2014-06-24","3":"2013-06-24","4":"2012-05-10","5":"2011-04-10","6":"none"},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":"true","1":"true","2":"true","3":"true","4":"true","5":"true","6":"none"},"function(binary)":{"0":"bytearray(b'leader')","1":"bytearray(b'espionage')","2":"bytearray(b'security')","3":"bytearray(b'first lieutenant')","4":"bytearray(b'none')","5":"bytearray(b'battle station')","6":"none"},"NullType":{"0":"none","1":"none","2":"none","3":"none","4":"none","5":"none","6":"none"},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"leder","1":"ponge","2":"securty","3":"frst leutennt","4":"none","5":"bttle stton","6":"none"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_mad():
		actual_df =source_df.cols.mad('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'mad': height(ft)    9.0
Name: 0.5, dtype: float64, 'median': 17.0})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mad_all_columns():
		actual_df =source_df.cols.mad('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'mad': Mixed           11526.0
function_new        NaN
Name: 0.5, dtype: float64, 'median': nan})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_max():
		actual_df =source_df.cols.max('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(300.0)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_max_all_columns():
		actual_df =source_df.cols.max('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': nan, 'height(ft)': 300.0, 'function': nan, 'rank': 10.0, 'age': 7000000.0, 'weight(t)': 5.7, 'japanese name': nan, 'last position seen': nan, 'date arrival': nan, 'last date seen': nan, 'attributes': nan, 'Date Type': nan, 'timestamp': nan, 'Cybertronian': 1.0, 'function(binary)': nan, 'NullType': nan, 'Mixed': 5123456789123456.0, 'function_new': nan})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mean():
		actual_df =source_df.cols.mean('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(65.6)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mean_all_columns():
		actual_df =source_df.cols.mean('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': nan, 'height(ft)': 65.6, 'function': nan, 'rank': 8.333333333333334, 'age': 5166666.666666667, 'weight(t)': 3.56, 'japanese name': nan, 'last position seen': nan, 'date arrival': nan, 'last date seen': nan, 'attributes': nan, 'Date Type': nan, 'timestamp': nan, 'Cybertronian': 1.0, 'function(binary)': nan, 'NullType': nan, 'Mixed': 1707818929711662.8, 'function_new': nan})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_median():
		actual_df =source_df.cols.median('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(17.0)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_median_all_columns():
		actual_df =source_df.cols.median('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': nan, 'height(ft)': 17.0, 'function': nan, 'rank': 8.0, 'age': 5000000.0, 'weight(t)': 4.0, 'japanese name': nan, 'last position seen': nan, 'date arrival': nan, 'last date seen': nan, 'attributes': nan, 'Date Type': nan, 'timestamp': nan, 'Cybertronian': 1.0, 'function(binary)': nan, 'NullType': nan, 'Mixed': 11529.0, 'function_new': nan})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_min():
		actual_df =source_df.cols.min('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(-28.0)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_min_all_columns():
		actual_df =source_df.cols.min('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': nan, 'height(ft)': -28.0, 'function': nan, 'rank': 7.0, 'age': 4000000.0, 'weight(t)': 1.8, 'japanese name': nan, 'last position seen': nan, 'date arrival': nan, 'last date seen': nan, 'attributes': nan, 'Date Type': nan, 'timestamp': nan, 'Cybertronian': 1.0, 'function(binary)': nan, 'NullType': nan, 'Mixed': 3.0, 'function_new': nan})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mode():
		actual_df =source_df.cols.mode('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(0    -28.0
1     13.0
2     17.0
3     26.0
4    300.0
dtype: float64)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mode_all_columns():
		actual_df =source_df.cols.mode('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': Series([], dtype: float64), 'height(ft)': 0    -28.0
1     13.0
2     17.0
3     26.0
4    300.0
dtype: float64, 'function': Series([], dtype: float64), 'rank': 0     7.0
1     8.0
2    10.0
dtype: float64, 'age': 0    5000000.0
dtype: float64, 'weight(t)': 0    1.8
1    2.0
2    4.0
3    4.3
4    5.7
dtype: float64, 'japanese name': Series([], dtype: float64), 'last position seen': Series([], dtype: float64), 'date arrival': Series([], dtype: float64), 'last date seen': Series([], dtype: float64), 'attributes': Series([], dtype: float64), 'Date Type': Series([], dtype: float64), 'timestamp': Series([], dtype: float64), 'Cybertronian': 0    1.0
dtype: float64, 'function(binary)': Series([], dtype: float64), 'NullType': Series([], dtype: float64), 'Mixed': 0    3.000000e+00
1    1.152900e+04
2    5.123457e+15
dtype: float64, 'function_new': Series([], dtype: float64)})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_move_after():
		actual_df =source_df.cols.move('rank','after','attributes')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_move_before():
		actual_df =source_df.cols.move('rank','before','attributes')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_move_beginning():
		actual_df =source_df.cols.move('rank','beginning')
		expected_df = op.create.df({"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_move_end():
		actual_df =source_df.cols.move('rank','end')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_mul():
		actual_df =source_df.cols.mul(['height(ft)','rank'])
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"mul":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"mul":{"0":-280.0,"1":119.0,"2":182.0,"3":104.0,"4":0.0,"5":2400.0,"6":0.0}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_mul_all_columns():
		actual_df =source_df.cols.mul('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"mul":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"mul":{"0":0.0,"1":0.0,"2":0.0,"3":0.0,"4":0.0,"5":0.0,"6":0.0}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_names():
		actual_df =source_df.cols.names()
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(['names', 'height(ft)', 'function', 'rank', 'age', 'weight(t)', 'japanese name', 'last position seen', 'date arrival', 'last date seen', 'attributes', 'Date Type', 'timestamp', 'Cybertronian', 'function(binary)', 'NullType', 'Mixed', 'function_new'])
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_nest():
		actual_df =source_df.cols.nest(['height(ft)','rank'],separator=' ',output_col='new col')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_percentile():
		actual_df =source_df.cols.percentile('height(ft)',[0.05,0.25],1)
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({0.05: -19.8, 0.25: 13.0})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_percentile_all_columns():
		actual_df =source_df.cols.percentile('*',[0.05,0.25],1)
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': {0.05: nan, 0.25: nan}, 'height(ft)': {0.05: -19.8, 0.25: 13.0}, 'function': {0.05: nan, 0.25: nan}, 'rank': {0.05: 7.0, 0.25: 7.25}, 'age': {0.05: 4250000.0, 0.25: 5000000.0}, 'weight(t)': {0.05: 1.8400000000000003, 0.25: 2.0}, 'japanese name': {0.05: nan, 0.25: nan}, 'last position seen': {0.05: nan, 0.25: nan}, 'date arrival': {0.05: nan, 0.25: nan}, 'last date seen': {0.05: nan, 0.25: nan}, 'attributes': {0.05: nan, 0.25: nan}, 'Date Type': {0.05: nan, 0.25: nan}, 'timestamp': {0.05: nan, 0.25: nan}, 'Cybertronian': {0.05: 1.0, 0.25: 1.0}, 'function(binary)': {0.05: nan, 0.25: nan}, 'NullType': {0.05: nan, 0.25: nan}, 'Mixed': {0.05: 1155.6000000000001, 0.25: 5766.0}, 'function_new': {0.05: nan, 0.25: nan}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_range():
		actual_df =source_df.cols.range('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'min': -28.0, 'max': 300.0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_range_all_columns():
		actual_df =source_df.cols.range('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': {'min': nan, 'max': nan}, 'height(ft)': {'min': -28.0, 'max': 300.0}, 'function': {'min': nan, 'max': nan}, 'rank': {'min': 7.0, 'max': 10.0}, 'age': {'min': 4000000.0, 'max': 7000000.0}, 'weight(t)': {'min': 1.8, 'max': 5.7}, 'japanese name': {'min': nan, 'max': nan}, 'last position seen': {'min': nan, 'max': nan}, 'date arrival': {'min': nan, 'max': nan}, 'last date seen': {'min': nan, 'max': nan}, 'attributes': {'min': nan, 'max': nan}, 'Date Type': {'min': nan, 'max': nan}, 'timestamp': {'min': nan, 'max': nan}, 'Cybertronian': {'min': 1.0, 'max': 1.0}, 'function(binary)': {'min': nan, 'max': nan}, 'NullType': {'min': nan, 'max': nan}, 'Mixed': {'min': 3.0, 'max': 5123456789123456.0}, 'function_new': {'min': nan, 'max': nan}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_remove():
		actual_df =source_df.cols.remove('function','i')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leader","1":"Esponage","2":"Securty","3":"Frst Leutenant","4":"None","5":"Battle Staton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_accents():
		actual_df =source_df.cols.remove_accents('function')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_accents_all_columns():
		actual_df =source_df.cols.remove_accents('function')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_list():
		actual_df =source_df.cols.remove('function',['a','i','Es'])
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_list_output():
		actual_df =source_df.cols.remove('function',['a','i','Es'],output_cols='function_new')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_numbers():
		actual_df =source_df.cols.remove_numbers('function')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_special_chars():
		actual_df =source_df.cols.remove_special_chars('function')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"FrstLeutennt","4":"None","5":"BttleStton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_special_chars_all_columns():
		actual_df =source_df.cols.remove_special_chars('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optimus","1":"bumbleb","2":"ironhide","3":"Jazz","4":"Megatron","5":"Metroplex","6":"None"},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"FrstLeutennt","4":"None","5":"BttleStton","6":"None"},"rank":{"0":"100","1":"70","2":"70","3":"80","4":"100","5":"80","6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":"InochiConvoy","1":"BumbleGoldback","2":"Roadbuster","3":"Meister","4":"Megatron","5":"Metroflex","6":"None"},"last position seen":{"0":"1944273599201111","1":"1064270771612534","2":"37789563122400356","3":"33670666117841553","4":"None","5":"None","6":"None"},"date arrival":{"0":"19800410","1":"19800410","2":"19800410","3":"19800410","4":"19800410","5":"19800410","6":"None"},"last date seen":{"0":"20160910","1":"20150810","2":"20140710","3":"20130610","4":"20120510","5":"20110410","6":"None"},"attributes":{"0":"8534443000","1":"533420000","2":"7924840000","3":"3962418000","4":"None57000","5":"9144None","6":"None"},"Date Type":{"0":"20160910","1":"20150810","2":"20140624","3":"20130624","4":"20120510","5":"20110410","6":"None"},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":"True","1":"True","2":"True","3":"True","4":"True","5":"True","6":"None"},"function(binary)":{"0":"bytearraybLeader","1":"bytearraybEspionage","2":"bytearraybSecurity","3":"bytearraybFirstLieutenant","4":"bytearraybNone","5":"bytearraybBattleStation","6":"None"},"NullType":{"0":"None","1":"None","2":"None","3":"None","4":"None","5":"None","6":"None"},"Mixed":{"0":"male","1":"1111","2":"httphioptimuscom","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"FrstLeutennt","4":"None","5":"BttleStton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_white_spaces():
		actual_df =source_df.cols.remove_white_spaces('function')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"FrstLeutennt","4":"None","5":"BttleStton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_white_spaces_all_columns():
		actual_df =source_df.cols.remove_white_spaces('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":"None"},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"FrstLeutennt","4":"None","5":"BttleStton","6":"None"},"rank":{"0":"10.0","1":"7.0","2":"7.0","3":"8.0","4":"10.0","5":"8.0","6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":"['Inochi','Convoy']","1":"['Bumble','Goldback']","2":"['Roadbuster']","3":"['Meister']","4":"['Megatron']","5":"['Metroflex']","6":"None"},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":"None","5":"None","6":"None"},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":"None"},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":"None"},"attributes":{"0":"[8.5344,4300.0]","1":"[5.334,2000.0]","2":"[7.9248,4000.0]","3":"[3.9624,1800.0]","4":"[None,5700.0]","5":"[91.44,None]","6":"None"},"Date Type":{"0":"2016-09-10","1":"2015-08-10","2":"2014-06-24","3":"2013-06-24","4":"2012-05-10","5":"2011-04-10","6":"None"},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":"True","1":"True","2":"True","3":"True","4":"True","5":"True","6":"None"},"function(binary)":{"0":"bytearray(b'Leader')","1":"bytearray(b'Espionage')","2":"bytearray(b'Security')","3":"bytearray(b'FirstLieutenant')","4":"bytearray(b'None')","5":"bytearray(b'BattleStation')","6":"None"},"NullType":{"0":"None","1":"None","2":"None","3":"None","4":"None","5":"None","6":"None"},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"FrstLeutennt","4":"None","5":"BttleStton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_rename():
		actual_df =source_df.cols.rename('rank','rank(old)')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank(old)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank(old)":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_rename_function():
		actual_df =source_df.cols.rename(str.upper)
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_rename_list():
		actual_df =source_df.cols.rename(['height(ft)','height(ft)(tons)','rank','rank(old)'])
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_replace_all_columns():
		actual_df =source_df.cols.replace('*',['Jazz','Leader'],'Match')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"weight(t)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Match","4":"Megatron","5":"Metroplex_)^$","6":"None"},"height(ft)":{"0":"-28.0","1":"17.0","2":"26.0","3":"13.0","4":"nan","5":"300.0","6":"nan"},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":"10.0","1":"7.0","2":"7.0","3":"8.0","4":"10.0","5":"8.0","6":"NaN"},"age":{"0":"4000000.0","1":"5000000.0","2":"7000000.0","3":"5000000.0","4":"5000000.0","5":"5000000.0","6":"nan"},"weight(t)":{"0":"4.3","1":"2.0","2":"4.0","3":"1.8","4":"5.7","5":"nan","6":"nan"},"japanese name":{"0":"['Inochi', 'Convoy']","1":"['Bumble', 'Goldback']","2":"['Roadbuster']","3":"['Meister']","4":"['Megatron']","5":"['Metroflex']","6":"None"},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":"None","5":"None","6":"None"},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":"None"},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":"None"},"attributes":{"0":"[8.5344, 4300.0]","1":"[5.334, 2000.0]","2":"[7.9248, 4000.0]","3":"[3.9624, 1800.0]","4":"[None, 5700.0]","5":"[91.44, None]","6":"None"},"Date Type":{"0":"2016-09-10","1":"2015-08-10","2":"2014-06-24","3":"2013-06-24","4":"2012-05-10","5":"2011-04-10","6":"None"},"timestamp":{"0":"2014-06-24","1":"2014-06-24","2":"2014-06-24","3":"2014-06-24","4":"2014-06-24","5":"2014-06-24","6":"NaT"},"Cybertronian":{"0":"True","1":"True","2":"True","3":"True","4":"True","5":"True","6":"None"},"function(binary)":{"0":"bytearray(b'Match')","1":"bytearray(b'Espionage')","2":"bytearray(b'Security')","3":"bytearray(b'First Lieutenant')","4":"bytearray(b'None')","5":"bytearray(b'Battle Station')","6":"None"},"NullType":{"0":"None","1":"None","2":"None","3":"None","4":"None","5":"None","6":"None"},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_replace_chars():
		actual_df =source_df.cols.replace('function',['F','E'],'Match',search_by='chars')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Matchrst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_replace_full():
		actual_df =source_df.cols.replace('function',['First Lieutenant','Battle'],'Match',search_by='full')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_replace_words():
		actual_df =source_df.cols.replace('function',['Security','Leader'],'Match',search_by='words')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_reverse():
		actual_df =source_df.cols.reverse('function')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","1":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","2":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","3":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","4":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","5":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","6":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_reverse_all_columns():
		actual_df =source_df.cols.reverse('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"tcejbo :epytd ,seman :emaN\nenoN             6\n$^)_xelporteM    5\nnortageM         4\nzzaJ             3\n&edihnori        2\n  \u00e9\u00e9be#lbmub     1\nsu'mitpO         0","1":"tcejbo :epytd ,seman :emaN\nenoN             6\n$^)_xelporteM    5\nnortageM         4\nzzaJ             3\n&edihnori        2\n  \u00e9\u00e9be#lbmub     1\nsu'mitpO         0","2":"tcejbo :epytd ,seman :emaN\nenoN             6\n$^)_xelporteM    5\nnortageM         4\nzzaJ             3\n&edihnori        2\n  \u00e9\u00e9be#lbmub     1\nsu'mitpO         0","3":"tcejbo :epytd ,seman :emaN\nenoN             6\n$^)_xelporteM    5\nnortageM         4\nzzaJ             3\n&edihnori        2\n  \u00e9\u00e9be#lbmub     1\nsu'mitpO         0","4":"tcejbo :epytd ,seman :emaN\nenoN             6\n$^)_xelporteM    5\nnortageM         4\nzzaJ             3\n&edihnori        2\n  \u00e9\u00e9be#lbmub     1\nsu'mitpO         0","5":"tcejbo :epytd ,seman :emaN\nenoN             6\n$^)_xelporteM    5\nnortageM         4\nzzaJ             3\n&edihnori        2\n  \u00e9\u00e9be#lbmub     1\nsu'mitpO         0","6":"tcejbo :epytd ,seman :emaN\nenoN             6\n$^)_xelporteM    5\nnortageM         4\nzzaJ             3\n&edihnori        2\n  \u00e9\u00e9be#lbmub     1\nsu'mitpO         0"},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","1":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","2":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","3":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","4":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","5":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","6":"tcejbo :epytd ,noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0"},"rank":{"0":"tcejbo :epytd ,knar :emaN\nNaN    6\n8      5\n01     4\n8      3\n7      2\n7      1\n01     0","1":"tcejbo :epytd ,knar :emaN\nNaN    6\n8      5\n01     4\n8      3\n7      2\n7      1\n01     0","2":"tcejbo :epytd ,knar :emaN\nNaN    6\n8      5\n01     4\n8      3\n7      2\n7      1\n01     0","3":"tcejbo :epytd ,knar :emaN\nNaN    6\n8      5\n01     4\n8      3\n7      2\n7      1\n01     0","4":"tcejbo :epytd ,knar :emaN\nNaN    6\n8      5\n01     4\n8      3\n7      2\n7      1\n01     0","5":"tcejbo :epytd ,knar :emaN\nNaN    6\n8      5\n01     4\n8      3\n7      2\n7      1\n01     0","6":"tcejbo :epytd ,knar :emaN\nNaN    6\n8      5\n01     4\n8      3\n7      2\n7      1\n01     0"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":"tcejbo :epytd ,eman esenapaj :emaN\nenoN                  6\n]xelforteM[           5\n]nortageM[            4\n]retsieM[             3\n]retsubdaoR[          2\n]kcabdloG ,elbmuB[    1\n]yovnoC ,ihconI[      0","1":"tcejbo :epytd ,eman esenapaj :emaN\nenoN                  6\n]xelforteM[           5\n]nortageM[            4\n]retsieM[             3\n]retsubdaoR[          2\n]kcabdloG ,elbmuB[    1\n]yovnoC ,ihconI[      0","2":"tcejbo :epytd ,eman esenapaj :emaN\nenoN                  6\n]xelforteM[           5\n]nortageM[            4\n]retsieM[             3\n]retsubdaoR[          2\n]kcabdloG ,elbmuB[    1\n]yovnoC ,ihconI[      0","3":"tcejbo :epytd ,eman esenapaj :emaN\nenoN                  6\n]xelforteM[           5\n]nortageM[            4\n]retsieM[             3\n]retsubdaoR[          2\n]kcabdloG ,elbmuB[    1\n]yovnoC ,ihconI[      0","4":"tcejbo :epytd ,eman esenapaj :emaN\nenoN                  6\n]xelforteM[           5\n]nortageM[            4\n]retsieM[             3\n]retsubdaoR[          2\n]kcabdloG ,elbmuB[    1\n]yovnoC ,ihconI[      0","5":"tcejbo :epytd ,eman esenapaj :emaN\nenoN                  6\n]xelforteM[           5\n]nortageM[            4\n]retsieM[             3\n]retsubdaoR[          2\n]kcabdloG ,elbmuB[    1\n]yovnoC ,ihconI[      0","6":"tcejbo :epytd ,eman esenapaj :emaN\nenoN                  6\n]xelforteM[           5\n]nortageM[            4\n]retsieM[             3\n]retsubdaoR[          2\n]kcabdloG ,elbmuB[    1\n]yovnoC ,ihconI[      0"},"last position seen":{"0":"tcejbo :epytd ,nees noitisop tsal :emaN\nenoN                     6\nenoN                     5\nenoN                     4\n355148.711-,666076.33    3\n653004.221-,365987.73    2\n435216.17-,707246.01     1\n111102.99-,537244.91     0","1":"tcejbo :epytd ,nees noitisop tsal :emaN\nenoN                     6\nenoN                     5\nenoN                     4\n355148.711-,666076.33    3\n653004.221-,365987.73    2\n435216.17-,707246.01     1\n111102.99-,537244.91     0","2":"tcejbo :epytd ,nees noitisop tsal :emaN\nenoN                     6\nenoN                     5\nenoN                     4\n355148.711-,666076.33    3\n653004.221-,365987.73    2\n435216.17-,707246.01     1\n111102.99-,537244.91     0","3":"tcejbo :epytd ,nees noitisop tsal :emaN\nenoN                     6\nenoN                     5\nenoN                     4\n355148.711-,666076.33    3\n653004.221-,365987.73    2\n435216.17-,707246.01     1\n111102.99-,537244.91     0","4":"tcejbo :epytd ,nees noitisop tsal :emaN\nenoN                     6\nenoN                     5\nenoN                     4\n355148.711-,666076.33    3\n653004.221-,365987.73    2\n435216.17-,707246.01     1\n111102.99-,537244.91     0","5":"tcejbo :epytd ,nees noitisop tsal :emaN\nenoN                     6\nenoN                     5\nenoN                     4\n355148.711-,666076.33    3\n653004.221-,365987.73    2\n435216.17-,707246.01     1\n111102.99-,537244.91     0","6":"tcejbo :epytd ,nees noitisop tsal :emaN\nenoN                     6\nenoN                     5\nenoN                     4\n355148.711-,666076.33    3\n653004.221-,365987.73    2\n435216.17-,707246.01     1\n111102.99-,537244.91     0"},"date arrival":{"0":"tcejbo :epytd ,lavirra etad :emaN\nenoN          6\n01\/40\/0891    5\n01\/40\/0891    4\n01\/40\/0891    3\n01\/40\/0891    2\n01\/40\/0891    1\n01\/40\/0891    0","1":"tcejbo :epytd ,lavirra etad :emaN\nenoN          6\n01\/40\/0891    5\n01\/40\/0891    4\n01\/40\/0891    3\n01\/40\/0891    2\n01\/40\/0891    1\n01\/40\/0891    0","2":"tcejbo :epytd ,lavirra etad :emaN\nenoN          6\n01\/40\/0891    5\n01\/40\/0891    4\n01\/40\/0891    3\n01\/40\/0891    2\n01\/40\/0891    1\n01\/40\/0891    0","3":"tcejbo :epytd ,lavirra etad :emaN\nenoN          6\n01\/40\/0891    5\n01\/40\/0891    4\n01\/40\/0891    3\n01\/40\/0891    2\n01\/40\/0891    1\n01\/40\/0891    0","4":"tcejbo :epytd ,lavirra etad :emaN\nenoN          6\n01\/40\/0891    5\n01\/40\/0891    4\n01\/40\/0891    3\n01\/40\/0891    2\n01\/40\/0891    1\n01\/40\/0891    0","5":"tcejbo :epytd ,lavirra etad :emaN\nenoN          6\n01\/40\/0891    5\n01\/40\/0891    4\n01\/40\/0891    3\n01\/40\/0891    2\n01\/40\/0891    1\n01\/40\/0891    0","6":"tcejbo :epytd ,lavirra etad :emaN\nenoN          6\n01\/40\/0891    5\n01\/40\/0891    4\n01\/40\/0891    3\n01\/40\/0891    2\n01\/40\/0891    1\n01\/40\/0891    0"},"last date seen":{"0":"tcejbo :epytd ,nees etad tsal :emaN\nenoN          6\n01\/40\/1102    5\n01\/50\/2102    4\n01\/60\/3102    3\n01\/70\/4102    2\n01\/80\/5102    1\n01\/90\/6102    0","1":"tcejbo :epytd ,nees etad tsal :emaN\nenoN          6\n01\/40\/1102    5\n01\/50\/2102    4\n01\/60\/3102    3\n01\/70\/4102    2\n01\/80\/5102    1\n01\/90\/6102    0","2":"tcejbo :epytd ,nees etad tsal :emaN\nenoN          6\n01\/40\/1102    5\n01\/50\/2102    4\n01\/60\/3102    3\n01\/70\/4102    2\n01\/80\/5102    1\n01\/90\/6102    0","3":"tcejbo :epytd ,nees etad tsal :emaN\nenoN          6\n01\/40\/1102    5\n01\/50\/2102    4\n01\/60\/3102    3\n01\/70\/4102    2\n01\/80\/5102    1\n01\/90\/6102    0","4":"tcejbo :epytd ,nees etad tsal :emaN\nenoN          6\n01\/40\/1102    5\n01\/50\/2102    4\n01\/60\/3102    3\n01\/70\/4102    2\n01\/80\/5102    1\n01\/90\/6102    0","5":"tcejbo :epytd ,nees etad tsal :emaN\nenoN          6\n01\/40\/1102    5\n01\/50\/2102    4\n01\/60\/3102    3\n01\/70\/4102    2\n01\/80\/5102    1\n01\/90\/6102    0","6":"tcejbo :epytd ,nees etad tsal :emaN\nenoN          6\n01\/40\/1102    5\n01\/50\/2102    4\n01\/60\/3102    3\n01\/70\/4102    2\n01\/80\/5102    1\n01\/90\/6102    0"},"attributes":{"0":"tcejbo :epytd ,setubirtta :emaN\nenoN                6\n]enoN ,44.19[       5\n]0.0075 ,enoN[      4\n]0.0081 ,4269.3[    3\n]0.0004 ,8429.7[    2\n]0.0002 ,433.5[     1\n]0.0034 ,4435.8[    0","1":"tcejbo :epytd ,setubirtta :emaN\nenoN                6\n]enoN ,44.19[       5\n]0.0075 ,enoN[      4\n]0.0081 ,4269.3[    3\n]0.0004 ,8429.7[    2\n]0.0002 ,433.5[     1\n]0.0034 ,4435.8[    0","2":"tcejbo :epytd ,setubirtta :emaN\nenoN                6\n]enoN ,44.19[       5\n]0.0075 ,enoN[      4\n]0.0081 ,4269.3[    3\n]0.0004 ,8429.7[    2\n]0.0002 ,433.5[     1\n]0.0034 ,4435.8[    0","3":"tcejbo :epytd ,setubirtta :emaN\nenoN                6\n]enoN ,44.19[       5\n]0.0075 ,enoN[      4\n]0.0081 ,4269.3[    3\n]0.0004 ,8429.7[    2\n]0.0002 ,433.5[     1\n]0.0034 ,4435.8[    0","4":"tcejbo :epytd ,setubirtta :emaN\nenoN                6\n]enoN ,44.19[       5\n]0.0075 ,enoN[      4\n]0.0081 ,4269.3[    3\n]0.0004 ,8429.7[    2\n]0.0002 ,433.5[     1\n]0.0034 ,4435.8[    0","5":"tcejbo :epytd ,setubirtta :emaN\nenoN                6\n]enoN ,44.19[       5\n]0.0075 ,enoN[      4\n]0.0081 ,4269.3[    3\n]0.0004 ,8429.7[    2\n]0.0002 ,433.5[     1\n]0.0034 ,4435.8[    0","6":"tcejbo :epytd ,setubirtta :emaN\nenoN                6\n]enoN ,44.19[       5\n]0.0075 ,enoN[      4\n]0.0081 ,4269.3[    3\n]0.0004 ,8429.7[    2\n]0.0002 ,433.5[     1\n]0.0034 ,4435.8[    0"},"Date Type":{"0":"tcejbo :epytd ,epyT etaD :emaN\nenoN          6\n01-40-1102    5\n01-50-2102    4\n42-60-3102    3\n42-60-4102    2\n01-80-5102    1\n01-90-6102    0","1":"tcejbo :epytd ,epyT etaD :emaN\nenoN          6\n01-40-1102    5\n01-50-2102    4\n42-60-3102    3\n42-60-4102    2\n01-80-5102    1\n01-90-6102    0","2":"tcejbo :epytd ,epyT etaD :emaN\nenoN          6\n01-40-1102    5\n01-50-2102    4\n42-60-3102    3\n42-60-4102    2\n01-80-5102    1\n01-90-6102    0","3":"tcejbo :epytd ,epyT etaD :emaN\nenoN          6\n01-40-1102    5\n01-50-2102    4\n42-60-3102    3\n42-60-4102    2\n01-80-5102    1\n01-90-6102    0","4":"tcejbo :epytd ,epyT etaD :emaN\nenoN          6\n01-40-1102    5\n01-50-2102    4\n42-60-3102    3\n42-60-4102    2\n01-80-5102    1\n01-90-6102    0","5":"tcejbo :epytd ,epyT etaD :emaN\nenoN          6\n01-40-1102    5\n01-50-2102    4\n42-60-3102    3\n42-60-4102    2\n01-80-5102    1\n01-90-6102    0","6":"tcejbo :epytd ,epyT etaD :emaN\nenoN          6\n01-40-1102    5\n01-50-2102    4\n42-60-3102    3\n42-60-4102    2\n01-80-5102    1\n01-90-6102    0"},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":"tcejbo :epytd ,nainortrebyC :emaN\nenoN    6\neurT    5\neurT    4\neurT    3\neurT    2\neurT    1\neurT    0","1":"tcejbo :epytd ,nainortrebyC :emaN\nenoN    6\neurT    5\neurT    4\neurT    3\neurT    2\neurT    1\neurT    0","2":"tcejbo :epytd ,nainortrebyC :emaN\nenoN    6\neurT    5\neurT    4\neurT    3\neurT    2\neurT    1\neurT    0","3":"tcejbo :epytd ,nainortrebyC :emaN\nenoN    6\neurT    5\neurT    4\neurT    3\neurT    2\neurT    1\neurT    0","4":"tcejbo :epytd ,nainortrebyC :emaN\nenoN    6\neurT    5\neurT    4\neurT    3\neurT    2\neurT    1\neurT    0","5":"tcejbo :epytd ,nainortrebyC :emaN\nenoN    6\neurT    5\neurT    4\neurT    3\neurT    2\neurT    1\neurT    0","6":"tcejbo :epytd ,nainortrebyC :emaN\nenoN    6\neurT    5\neurT    4\neurT    3\neurT    2\neurT    1\neurT    0"},"function(binary)":{"0":"tcejbo :epytd ,)yranib(noitcnuf :emaN\nenoN                                                 6\n... ,79 ,611 ,38 ,23 ,101 ,801 ,611 ,611 ,79 ,66[    5\n]101 ,011 ,111 ,87[                                  4\n...711 ,101 ,501 ,67 ,23 ,611 ,511 ,411 ,501 ,07[    3\n]121 ,611 ,501 ,411 ,711 ,99 ,101 ,38[               2\n]101 ,301 ,79 ,011 ,111 ,501 ,211 ,511 ,96[          1\n]411 ,101 ,001 ,79 ,101 ,67[                         0","1":"tcejbo :epytd ,)yranib(noitcnuf :emaN\nenoN                                                 6\n... ,79 ,611 ,38 ,23 ,101 ,801 ,611 ,611 ,79 ,66[    5\n]101 ,011 ,111 ,87[                                  4\n...711 ,101 ,501 ,67 ,23 ,611 ,511 ,411 ,501 ,07[    3\n]121 ,611 ,501 ,411 ,711 ,99 ,101 ,38[               2\n]101 ,301 ,79 ,011 ,111 ,501 ,211 ,511 ,96[          1\n]411 ,101 ,001 ,79 ,101 ,67[                         0","2":"tcejbo :epytd ,)yranib(noitcnuf :emaN\nenoN                                                 6\n... ,79 ,611 ,38 ,23 ,101 ,801 ,611 ,611 ,79 ,66[    5\n]101 ,011 ,111 ,87[                                  4\n...711 ,101 ,501 ,67 ,23 ,611 ,511 ,411 ,501 ,07[    3\n]121 ,611 ,501 ,411 ,711 ,99 ,101 ,38[               2\n]101 ,301 ,79 ,011 ,111 ,501 ,211 ,511 ,96[          1\n]411 ,101 ,001 ,79 ,101 ,67[                         0","3":"tcejbo :epytd ,)yranib(noitcnuf :emaN\nenoN                                                 6\n... ,79 ,611 ,38 ,23 ,101 ,801 ,611 ,611 ,79 ,66[    5\n]101 ,011 ,111 ,87[                                  4\n...711 ,101 ,501 ,67 ,23 ,611 ,511 ,411 ,501 ,07[    3\n]121 ,611 ,501 ,411 ,711 ,99 ,101 ,38[               2\n]101 ,301 ,79 ,011 ,111 ,501 ,211 ,511 ,96[          1\n]411 ,101 ,001 ,79 ,101 ,67[                         0","4":"tcejbo :epytd ,)yranib(noitcnuf :emaN\nenoN                                                 6\n... ,79 ,611 ,38 ,23 ,101 ,801 ,611 ,611 ,79 ,66[    5\n]101 ,011 ,111 ,87[                                  4\n...711 ,101 ,501 ,67 ,23 ,611 ,511 ,411 ,501 ,07[    3\n]121 ,611 ,501 ,411 ,711 ,99 ,101 ,38[               2\n]101 ,301 ,79 ,011 ,111 ,501 ,211 ,511 ,96[          1\n]411 ,101 ,001 ,79 ,101 ,67[                         0","5":"tcejbo :epytd ,)yranib(noitcnuf :emaN\nenoN                                                 6\n... ,79 ,611 ,38 ,23 ,101 ,801 ,611 ,611 ,79 ,66[    5\n]101 ,011 ,111 ,87[                                  4\n...711 ,101 ,501 ,67 ,23 ,611 ,511 ,411 ,501 ,07[    3\n]121 ,611 ,501 ,411 ,711 ,99 ,101 ,38[               2\n]101 ,301 ,79 ,011 ,111 ,501 ,211 ,511 ,96[          1\n]411 ,101 ,001 ,79 ,101 ,67[                         0","6":"tcejbo :epytd ,)yranib(noitcnuf :emaN\nenoN                                                 6\n... ,79 ,611 ,38 ,23 ,101 ,801 ,611 ,611 ,79 ,66[    5\n]101 ,011 ,111 ,87[                                  4\n...711 ,101 ,501 ,67 ,23 ,611 ,511 ,411 ,501 ,07[    3\n]121 ,611 ,501 ,411 ,711 ,99 ,101 ,38[               2\n]101 ,301 ,79 ,011 ,111 ,501 ,211 ,511 ,96[          1\n]411 ,101 ,001 ,79 ,101 ,67[                         0"},"NullType":{"0":"tcejbo :epytd ,epyTlluN :emaN\nenoN    6\nenoN    5\nenoN    4\nenoN    3\nenoN    2\nenoN    1\nenoN    0","1":"tcejbo :epytd ,epyTlluN :emaN\nenoN    6\nenoN    5\nenoN    4\nenoN    3\nenoN    2\nenoN    1\nenoN    0","2":"tcejbo :epytd ,epyTlluN :emaN\nenoN    6\nenoN    5\nenoN    4\nenoN    3\nenoN    2\nenoN    1\nenoN    0","3":"tcejbo :epytd ,epyTlluN :emaN\nenoN    6\nenoN    5\nenoN    4\nenoN    3\nenoN    2\nenoN    1\nenoN    0","4":"tcejbo :epytd ,epyTlluN :emaN\nenoN    6\nenoN    5\nenoN    4\nenoN    3\nenoN    2\nenoN    1\nenoN    0","5":"tcejbo :epytd ,epyTlluN :emaN\nenoN    6\nenoN    5\nenoN    4\nenoN    3\nenoN    2\nenoN    1\nenoN    0","6":"tcejbo :epytd ,epyTlluN :emaN\nenoN    6\nenoN    5\nenoN    4\nenoN    3\nenoN    2\nenoN    1\nenoN    0"},"Mixed":{"0":"tcejbo :epytd ,dexiM :emaN\nsumitpo                  6\n3                        5\n92511                    4\n6543219876543215         3\nmoc.sumitpo-ih\/\/:ptth    2\n1.1.1.1                  1\nelam                     0","1":"tcejbo :epytd ,dexiM :emaN\nsumitpo                  6\n3                        5\n92511                    4\n6543219876543215         3\nmoc.sumitpo-ih\/\/:ptth    2\n1.1.1.1                  1\nelam                     0","2":"tcejbo :epytd ,dexiM :emaN\nsumitpo                  6\n3                        5\n92511                    4\n6543219876543215         3\nmoc.sumitpo-ih\/\/:ptth    2\n1.1.1.1                  1\nelam                     0","3":"tcejbo :epytd ,dexiM :emaN\nsumitpo                  6\n3                        5\n92511                    4\n6543219876543215         3\nmoc.sumitpo-ih\/\/:ptth    2\n1.1.1.1                  1\nelam                     0","4":"tcejbo :epytd ,dexiM :emaN\nsumitpo                  6\n3                        5\n92511                    4\n6543219876543215         3\nmoc.sumitpo-ih\/\/:ptth    2\n1.1.1.1                  1\nelam                     0","5":"tcejbo :epytd ,dexiM :emaN\nsumitpo                  6\n3                        5\n92511                    4\n6543219876543215         3\nmoc.sumitpo-ih\/\/:ptth    2\n1.1.1.1                  1\nelam                     0","6":"tcejbo :epytd ,dexiM :emaN\nsumitpo                  6\n3                        5\n92511                    4\n6543219876543215         3\nmoc.sumitpo-ih\/\/:ptth    2\n1.1.1.1                  1\nelam                     0"},"function_new":{"0":"tcejbo :epytd ,wen_noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","1":"tcejbo :epytd ,wen_noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","2":"tcejbo :epytd ,wen_noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","3":"tcejbo :epytd ,wen_noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","4":"tcejbo :epytd ,wen_noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","5":"tcejbo :epytd ,wen_noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0","6":"tcejbo :epytd ,wen_noitcnuf :emaN\nenoN             6\nnottS elttB      5\nenoN             4\ntnnetueL tsrF    3\nytruceS          2\negnop            1\nredeL            0"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_schema_dtype():
		actual_df =source_df.cols.schema_dtype('rank')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(<class 'numpy.object_'>)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_select():
		actual_df =source_df.cols.select(0,'height(ft)')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_select_regex():
		actual_df =source_df.cols.select('n.*',regex=True)
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_skewness():
		actual_df =source_df.cols.skewness('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': 2.094300314023384})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_skewness_all_columns():
		actual_df =source_df.cols.skewness('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': nan, 'height(ft)': 2.094300314023384, 'function': nan, 'rank': 0.5228036105081408, 'age': 1.437962257678613, 'weight(t)': 0.09721093626041664, 'japanese name': nan, 'last position seen': nan, 'date arrival': nan, 'last date seen': nan, 'attributes': nan, 'Date Type': nan, 'timestamp': nan, 'Cybertronian': 0.0, 'function(binary)': nan, 'NullType': nan, 'Mixed': 1.7320508075688767, 'function_new': nan})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_sort():
		actual_df =source_df.cols.sort()
		expected_df = op.create.df({"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sort_asc():
		actual_df =source_df.cols.sort('asc')
		expected_df = op.create.df({"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sort_desc():
		actual_df =source_df.cols.sort('desc')
		expected_df = op.create.df({"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"},"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_std():
		actual_df =source_df.cols.std('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(132.66612227694)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_std_all_columns():
		actual_df =source_df.cols.std('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': nan, 'height(ft)': 132.66612227694, 'function': nan, 'rank': 1.3662601021279464, 'age': 983192.0802501752, 'weight(t)': 1.6471186963907611, 'japanese name': nan, 'last position seen': nan, 'date arrival': nan, 'last date seen': nan, 'attributes': nan, 'Date Type': nan, 'timestamp': nan, 'Cybertronian': 0.0, 'function(binary)': nan, 'NullType': nan, 'Mixed': 2958029156378514.0, 'function_new': nan})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_string_to_index():
		actual_df =_.cols.string_to_index('rank')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank***STRING_TO_INDEX":{"alignment":4,"byteorder":"=","descr":[["","<i4"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"i","name":"int32","ndim":0,"num":7,"str":"<i4"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leader","1":"Espionage","2":"Security","3":"First Lieutenant","4":"None","5":"Battle Station","6":null},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"rank***STRING_TO_INDEX":{"0":0,"1":1,"2":1,"3":2,"4":0,"5":2,"6":3},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sub():
		actual_df =source_df.cols.sub(['height(ft)','rank'])
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"sub":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"sub":{"0":-38.0,"1":10.0,"2":19.0,"3":5.0,"4":-10.0,"5":292.0,"6":0.0}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sub_all_columns():
		actual_df =source_df.cols.sub('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"sub":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"sub":{"0":-3999987.2999999998,"1":-5000027.0,"2":-7000038.0,"3":-5123456794123480.0,"4":-5011545.7000000002,"5":-5000312.0,"6":0.0}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sum():
		actual_df =source_df.cols.sum('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(328.0)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_sum_all_columns():
		actual_df =source_df.cols.sum('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': 0.0, 'height(ft)': 328.0, 'function': 0.0, 'rank': 50.0, 'age': 31000000.0, 'weight(t)': 17.8, 'japanese name': 0.0, 'last position seen': 0.0, 'date arrival': 0.0, 'last date seen': 0.0, 'attributes': 0.0, 'Date Type': 0.0, 'timestamp': 0.0, 'Cybertronian': 6.0, 'function(binary)': 0.0, 'NullType': 0.0, 'Mixed': 5123456789134988.0, 'function_new': 0.0})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_trim():
		actual_df =source_df.cols.trim('function')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_trim_all_columns():
		actual_df =source_df.cols.trim('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":"None"},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":"10.0","1":"7.0","2":"7.0","3":"8.0","4":"10.0","5":"8.0","6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":"['Inochi', 'Convoy']","1":"['Bumble', 'Goldback']","2":"['Roadbuster']","3":"['Meister']","4":"['Megatron']","5":"['Metroflex']","6":"None"},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":"None","5":"None","6":"None"},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":"None"},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":"None"},"attributes":{"0":"[8.5344, 4300.0]","1":"[5.334, 2000.0]","2":"[7.9248, 4000.0]","3":"[3.9624, 1800.0]","4":"[None, 5700.0]","5":"[91.44, None]","6":"None"},"Date Type":{"0":"2016-09-10","1":"2015-08-10","2":"2014-06-24","3":"2013-06-24","4":"2012-05-10","5":"2011-04-10","6":"None"},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":"True","1":"True","2":"True","3":"True","4":"True","5":"True","6":"None"},"function(binary)":{"0":"bytearray(b'Leader')","1":"bytearray(b'Espionage')","2":"bytearray(b'Security')","3":"bytearray(b'First Lieutenant')","4":"bytearray(b'None')","5":"bytearray(b'Battle Station')","6":"None"},"NullType":{"0":"None","1":"None","2":"None","3":"None","4":"None","5":"None","6":"None"},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unique():
		actual_df =source_df.cols.unique('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(['-28.0', '17.0', '26.0', '13.0', 'nan', '300.0'])
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_unique_all_columns():
		actual_df =source_df.cols.unique('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': ["Optim'us", 'bumbl#ebéé  ', 'ironhide&', 'Jazz', 'Megatron', 'Metroplex_)^$', 'None'], 'height(ft)': ['-28.0', '17.0', '26.0', '13.0', 'nan', '300.0'], 'function': ['Leder', 'ponge', 'Securty', 'Frst Leutennt', 'None', 'Bttle Stton'], 'rank': ['10.0', '7.0', '8.0', 'NaN'], 'age': ['4000000.0', '5000000.0', '7000000.0', 'nan'], 'weight(t)': ['4.3', '2.0', '4.0', '1.8', '5.7', 'nan'], 'japanese name': ["['Inochi', 'Convoy']", "['Bumble', 'Goldback']", "['Roadbuster']", "['Meister']", "['Megatron']", "['Metroflex']", 'None'], 'last position seen': ['19.442735,-99.201111', '10.642707,-71.612534', '37.789563,-122.400356', '33.670666,-117.841553', 'None'], 'date arrival': ['1980/04/10', 'None'], 'last date seen': ['2016/09/10', '2015/08/10', '2014/07/10', '2013/06/10', '2012/05/10', '2011/04/10', 'None'], 'attributes': ['[8.5344, 4300.0]', '[5.334, 2000.0]', '[7.9248, 4000.0]', '[3.9624, 1800.0]', '[None, 5700.0]', '[91.44, None]', 'None'], 'Date Type': ['2016-09-10', '2015-08-10', '2014-06-24', '2013-06-24', '2012-05-10', '2011-04-10', 'None'], 'timestamp': ['2014-06-24', 'NaT'], 'Cybertronian': ['True', 'None'], 'function(binary)': ["bytearray(b'Leader')", "bytearray(b'Espionage')", "bytearray(b'Security')", "bytearray(b'First Lieutenant')", "bytearray(b'None')", "bytearray(b'Battle Station')", 'None'], 'NullType': ['None'], 'Mixed': ['male', '1.1.1.1', 'http://hi-optimus.com', '5123456789123456', '11529', '3', 'optimus'], 'function_new': ['Leder', 'ponge', 'Securty', 'Frst Leutennt', 'None', 'Bttle Stton']})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_unnest_string_index():
		actual_df =source_df.cols.unnest('date arrival','/',splits=3)
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival_0":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival_1":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival_2":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"date arrival_0":{"0":"1980","1":"1980","2":"1980","3":"1980","4":"1980","5":"1980","6":"None"},"date arrival_1":{"0":"04","1":"04","2":"04","3":"04","4":"04","5":"04","6":null},"date arrival_2":{"0":"10","1":"10","2":"10","3":"10","4":"10","5":"10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_infer_split():
		actual_df =source_df.cols.unnest('date arrival','/')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival_0":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival_1":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"date arrival_0":{"0":"1980","1":"1980","2":"1980","3":"1980","4":"1980","5":"1980","6":"None"},"date arrival_1":{"0":"04\/10","1":"04\/10","2":"04\/10","3":"04\/10","4":"04\/10","5":"04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_multi_index():
		actual_df =source_df.cols.unnest('date arrival','/',splits=3,index=[1, 2])
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival_1":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"date arrival_1":{"0":"04","1":"04","2":"04","3":"04","4":"04","5":"04","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_no_index():
		actual_df =source_df.cols.unnest('date arrival','/',splits=3)
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival_0":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival_1":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival_2":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"date arrival_0":{"0":"1980","1":"1980","2":"1980","3":"1980","4":"1980","5":"1980","6":"None"},"date arrival_1":{"0":"04","1":"04","2":"04","3":"04","4":"04","5":"04","6":null},"date arrival_2":{"0":"10","1":"10","2":"10","3":"10","4":"10","5":"10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_output_columns():
		actual_df =source_df.cols.unnest('date arrival','/',splits=3,output_cols=['year', 'month', 'day'])
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"year":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"month":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"day":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"new col":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"year":{"0":"1980","1":"1980","2":"1980","3":"1980","4":"1980","5":"1980","6":"None"},"month":{"0":"04","1":"04","2":"04","3":"04","4":"04","5":"04","6":null},"day":{"0":"10","1":"10","2":"10","3":"10","4":"10","5":"10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"new col":{"0":"-28.0 10.0","1":"17.0 7.0","2":"26.0 7.0","3":"13.0 8.0","4":"nan 10.0","5":"300.0 8.0","6":"nan NaN"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_upper():
		actual_df =source_df.cols.upper('function')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"LEDER","1":"PONGE","2":"SECURTY","3":"FRST LEUTENNT","4":"NONE","5":"BTTLE STTON","6":"NONE"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_upper_all_columns():
		actual_df =source_df.cols.upper('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"OPTIM'US","1":"BUMBL#EB\u00c9\u00c9  ","2":"IRONHIDE&","3":"JAZZ","4":"MEGATRON","5":"METROPLEX_)^$","6":"NONE"},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"LEDER","1":"PONGE","2":"SECURTY","3":"FRST LEUTENNT","4":"NONE","5":"BTTLE STTON","6":"NONE"},"rank":{"0":"10.0","1":"7.0","2":"7.0","3":"8.0","4":"10.0","5":"8.0","6":"NAN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":"['INOCHI', 'CONVOY']","1":"['BUMBLE', 'GOLDBACK']","2":"['ROADBUSTER']","3":"['MEISTER']","4":"['MEGATRON']","5":"['METROFLEX']","6":"NONE"},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":"NONE","5":"NONE","6":"NONE"},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":"NONE"},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":"NONE"},"attributes":{"0":"[8.5344, 4300.0]","1":"[5.334, 2000.0]","2":"[7.9248, 4000.0]","3":"[3.9624, 1800.0]","4":"[NONE, 5700.0]","5":"[91.44, NONE]","6":"NONE"},"Date Type":{"0":"2016-09-10","1":"2015-08-10","2":"2014-06-24","3":"2013-06-24","4":"2012-05-10","5":"2011-04-10","6":"NONE"},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":"TRUE","1":"TRUE","2":"TRUE","3":"TRUE","4":"TRUE","5":"TRUE","6":"NONE"},"function(binary)":{"0":"BYTEARRAY(B'LEADER')","1":"BYTEARRAY(B'ESPIONAGE')","2":"BYTEARRAY(B'SECURITY')","3":"BYTEARRAY(B'FIRST LIEUTENANT')","4":"BYTEARRAY(B'NONE')","5":"BYTEARRAY(B'BATTLE STATION')","6":"NONE"},"NullType":{"0":"NONE","1":"NONE","2":"NONE","3":"NONE","4":"NONE","5":"NONE","6":"NONE"},"Mixed":{"0":"MALE","1":"1.1.1.1","2":"HTTP:\/\/HI-OPTIMUS.COM","3":"5123456789123456","4":"11529","5":"3","6":"OPTIMUS"},"function_new":{"0":"LEDER","1":"PONGE","2":"SECURTY","3":"FRST LEUTENNT","4":"NONE","5":"BTTLE STTON","6":"NONE"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_var():
		actual_df =source_df.cols.var('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(17600.3)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_var_all_columns():
		actual_df =source_df.cols.var('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': nan, 'height(ft)': 17600.3, 'function': nan, 'rank': 1.8666666666666665, 'age': 966666666666.667, 'weight(t)': 2.713, 'japanese name': nan, 'last position seen': nan, 'date arrival': nan, 'last date seen': nan, 'attributes': nan, 'Date Type': nan, 'timestamp': nan, 'Cybertronian': 0.0, 'function(binary)': nan, 'NullType': nan, 'Mixed': 8.749936489985383e+30, 'function_new': nan})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_years_between():
		actual_df =source_df.cols.years_between('date arrival','%Y/%m/%d')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":-40.2712328767,"1":-40.2712328767,"2":-40.2712328767,"3":-40.2712328767,"4":-40.2712328767,"5":-40.2712328767,"6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_years_between_multiple_columns():
		actual_df =source_df.cols.years_between(['date arrival','last date seen'],'%Y/%m/%d')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"last date seen":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-28.0,"1":17.0,"2":26.0,"3":13.0,"4":null,"5":300.0,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":-40.2712328767,"1":-40.2712328767,"2":-40.2712328767,"3":-40.2712328767,"4":-40.2712328767,"5":-40.2712328767,"6":null},"last date seen":{"0":-3.8273972603,"1":-4.9150684932,"2":-6.0,"3":-7.0821917808,"4":-8.1671232877,"5":-9.2520547945,"6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_z_score():
		actual_df =source_df.cols.z_score('height(ft)')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-0.7888071163,"1":-0.4095729258,"2":-0.3337260877,"3":-0.4432826316,"4":null,"5":1.9753887614,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":4000000.0,"1":5000000.0,"2":7000000.0,"3":5000000.0,"4":5000000.0,"5":5000000.0,"6":null},"weight(t)":{"0":4.3,"1":2.0,"2":4.0,"3":1.8,"4":5.7,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_z_score_all_columns():
		actual_df =source_df.cols.z_score('*')
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Mixed":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function_new":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {"names":{"0":"Optim'us","1":"bumbl#eb\u00e9\u00e9  ","2":"ironhide&","3":"Jazz","4":"Megatron","5":"Metroplex_)^$","6":null},"height(ft)":{"0":-0.7888071163,"1":-0.4095729258,"2":-0.3337260877,"3":-0.4432826316,"4":null,"5":1.9753887614,"6":null},"function":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"},"rank":{"0":10.0,"1":7.0,"2":7.0,"3":8.0,"4":10.0,"5":8.0,"6":"NaN"},"age":{"0":-1.2998673672,"1":-0.1856953382,"2":2.0426487199,"3":-0.1856953382,"4":-0.1856953382,"5":-0.1856953382,"6":null},"weight(t)":{"0":0.50229844,"1":-1.058899414,"2":0.2986639373,"3":-1.1946557492,"4":1.4525927859,"5":null,"6":null},"japanese name":{"0":["Inochi","Convoy"],"1":["Bumble","Goldback"],"2":["Roadbuster"],"3":["Meister"],"4":["Megatron"],"5":["Metroflex"],"6":null},"last position seen":{"0":"19.442735,-99.201111","1":"10.642707,-71.612534","2":"37.789563,-122.400356","3":"33.670666,-117.841553","4":null,"5":null,"6":null},"date arrival":{"0":"1980\/04\/10","1":"1980\/04\/10","2":"1980\/04\/10","3":"1980\/04\/10","4":"1980\/04\/10","5":"1980\/04\/10","6":null},"last date seen":{"0":"2016\/09\/10","1":"2015\/08\/10","2":"2014\/07\/10","3":"2013\/06\/10","4":"2012\/05\/10","5":"2011\/04\/10","6":null},"attributes":{"0":[8.5344,4300.0],"1":[5.334,2000.0],"2":[7.9248,4000.0],"3":[3.9624,1800.0],"4":[null,5700.0],"5":[91.44,null],"6":null},"Date Type":{"0":1473465600000,"1":1439164800000,"2":1403568000000,"3":1372032000000,"4":1336608000000,"5":1302393600000,"6":null},"timestamp":{"0":1403568000000,"1":1403568000000,"2":1403568000000,"3":1403568000000,"4":1403568000000,"5":1403568000000,"6":null},"Cybertronian":{"0":true,"1":true,"2":true,"3":true,"4":true,"5":true,"6":null},"function(binary)":{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":null},"NullType":{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null},"Mixed":{"0":"male","1":"1.1.1.1","2":"http:\/\/hi-optimus.com","3":"5123456789123456","4":"11529","5":"3","6":"optimus"},"function_new":{"0":"Leder","1":"ponge","2":"Securty","3":"Frst Leutennt","4":"None","5":"Bttle Stton","6":"None"}})
		assert (expected_df.collect() == actual_df.collect())
