# Generated by Django 3.2.8 on 2021-12-29 19:57

import crm.utilities
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Lead',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fullname', models.CharField(max_length=100)),
                ('phone', models.CharField(max_length=14)),
                ('address_line_1', models.CharField(max_length=200)),
                ('address_line_2', models.CharField(blank=True, max_length=200)),
                ('city', models.CharField(max_length=200)),
                ('state', models.CharField(max_length=200)),
                ('zipcode', models.CharField(max_length=200)),
                ('email', models.EmailField(blank=True, max_length=250, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('is_active', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='WorkOrder',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('job_description', models.TextField(max_length=1000)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('estimate_date', models.DateField(blank=True, null=True)),
                ('estimate_time', models.TimeField(blank=True, null=True)),
                ('appointment_date', models.DateField(blank=True, null=True)),
                ('appointment_time', models.TimeField(blank=True, null=True)),
                ('is_complete', models.BooleanField(default=False)),
                ('is_canceled', models.BooleanField(default=False)),
                ('reviewed', models.BooleanField(default=False)),
                ('lead', models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, to='crm.lead')),
            ],
        ),
        migrations.CreateModel(
            name='WorkOrderTechnicians',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('technician', models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('work_order', models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, to='crm.workorder')),
            ],
        ),
        migrations.CreateModel(
            name='WorkOrderImages',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to=crm.utilities.get_image_filename, verbose_name='Image')),
                ('work_order', models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, to='crm.workorder')),
            ],
        ),
    ]
