"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-7766
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.display_names import DisplayNames
    from intersight.model.equipment_base import EquipmentBase
    from intersight.model.equipment_fru_relationship import EquipmentFruRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.storage_controller_relationship import StorageControllerRelationship
    from intersight.model.storage_disk_group_relationship import StorageDiskGroupRelationship
    from intersight.model.storage_physical_disk_usage_relationship import StoragePhysicalDiskUsageRelationship
    from intersight.model.storage_vd_member_ep_relationship import StorageVdMemberEpRelationship
    from intersight.model.storage_virtual_drive_all_of import StorageVirtualDriveAllOf
    from intersight.model.storage_virtual_drive_container_relationship import StorageVirtualDriveContainerRelationship
    from intersight.model.storage_virtual_drive_extension_relationship import StorageVirtualDriveExtensionRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['DisplayNames'] = DisplayNames
    globals()['EquipmentBase'] = EquipmentBase
    globals()['EquipmentFruRelationship'] = EquipmentFruRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['StorageControllerRelationship'] = StorageControllerRelationship
    globals()['StorageDiskGroupRelationship'] = StorageDiskGroupRelationship
    globals()['StoragePhysicalDiskUsageRelationship'] = StoragePhysicalDiskUsageRelationship
    globals()['StorageVdMemberEpRelationship'] = StorageVdMemberEpRelationship
    globals()['StorageVirtualDriveAllOf'] = StorageVirtualDriveAllOf
    globals()['StorageVirtualDriveContainerRelationship'] = StorageVirtualDriveContainerRelationship
    globals()['StorageVirtualDriveExtensionRelationship'] = StorageVirtualDriveExtensionRelationship


class StorageVirtualDrive(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
        },
        ('object_type',): {
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'access_policy': (str,),  # noqa: E501
            'actual_write_cache_policy': (str,),  # noqa: E501
            'available_size': (str,),  # noqa: E501
            'block_size': (str,),  # noqa: E501
            'bootable': (str,),  # noqa: E501
            'config_state': (str,),  # noqa: E501
            'configured_write_cache_policy': (str,),  # noqa: E501
            'connection_protocol': (str,),  # noqa: E501
            'drive_cache': (str,),  # noqa: E501
            'drive_security': (str,),  # noqa: E501
            'drive_state': (str,),  # noqa: E501
            'io_policy': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'num_blocks': (str,),  # noqa: E501
            'oper_state': (str,),  # noqa: E501
            'operability': (str,),  # noqa: E501
            'physical_block_size': (str,),  # noqa: E501
            'read_policy': (str,),  # noqa: E501
            'security_flags': (str,),  # noqa: E501
            'size': (str,),  # noqa: E501
            'strip_size': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
            'vendor_uuid': (str,),  # noqa: E501
            'virtual_drive_id': (str,),  # noqa: E501
            'disk_group': (StorageDiskGroupRelationship,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'physical_disk_usages': ([StoragePhysicalDiskUsageRelationship], none_type,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'storage_controller': (StorageControllerRelationship,),  # noqa: E501
            'storage_virtual_drive_container': (StorageVirtualDriveContainerRelationship,),  # noqa: E501
            'vd_member_eps': ([StorageVdMemberEpRelationship], none_type,),  # noqa: E501
            'virtual_drive_extension': (StorageVirtualDriveExtensionRelationship,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'device_mo_id': (str,),  # noqa: E501
            'dn': (str,),  # noqa: E501
            'rn': (str,),  # noqa: E501
            'model': (str,),  # noqa: E501
            'presence': (str,),  # noqa: E501
            'revision': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'previous_fru': (EquipmentFruRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'access_policy': 'AccessPolicy',  # noqa: E501
        'actual_write_cache_policy': 'ActualWriteCachePolicy',  # noqa: E501
        'available_size': 'AvailableSize',  # noqa: E501
        'block_size': 'BlockSize',  # noqa: E501
        'bootable': 'Bootable',  # noqa: E501
        'config_state': 'ConfigState',  # noqa: E501
        'configured_write_cache_policy': 'ConfiguredWriteCachePolicy',  # noqa: E501
        'connection_protocol': 'ConnectionProtocol',  # noqa: E501
        'drive_cache': 'DriveCache',  # noqa: E501
        'drive_security': 'DriveSecurity',  # noqa: E501
        'drive_state': 'DriveState',  # noqa: E501
        'io_policy': 'IoPolicy',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'num_blocks': 'NumBlocks',  # noqa: E501
        'oper_state': 'OperState',  # noqa: E501
        'operability': 'Operability',  # noqa: E501
        'physical_block_size': 'PhysicalBlockSize',  # noqa: E501
        'read_policy': 'ReadPolicy',  # noqa: E501
        'security_flags': 'SecurityFlags',  # noqa: E501
        'size': 'Size',  # noqa: E501
        'strip_size': 'StripSize',  # noqa: E501
        'type': 'Type',  # noqa: E501
        'uuid': 'Uuid',  # noqa: E501
        'vendor_uuid': 'VendorUuid',  # noqa: E501
        'virtual_drive_id': 'VirtualDriveId',  # noqa: E501
        'disk_group': 'DiskGroup',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'physical_disk_usages': 'PhysicalDiskUsages',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'storage_controller': 'StorageController',  # noqa: E501
        'storage_virtual_drive_container': 'StorageVirtualDriveContainer',  # noqa: E501
        'vd_member_eps': 'VdMemberEps',  # noqa: E501
        'virtual_drive_extension': 'VirtualDriveExtension',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'device_mo_id': 'DeviceMoId',  # noqa: E501
        'dn': 'Dn',  # noqa: E501
        'rn': 'Rn',  # noqa: E501
        'model': 'Model',  # noqa: E501
        'presence': 'Presence',  # noqa: E501
        'revision': 'Revision',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'previous_fru': 'PreviousFru',  # noqa: E501
    }

    read_only_vars = {
        'access_policy',  # noqa: E501
        'actual_write_cache_policy',  # noqa: E501
        'available_size',  # noqa: E501
        'block_size',  # noqa: E501
        'bootable',  # noqa: E501
        'config_state',  # noqa: E501
        'configured_write_cache_policy',  # noqa: E501
        'connection_protocol',  # noqa: E501
        'drive_cache',  # noqa: E501
        'drive_security',  # noqa: E501
        'drive_state',  # noqa: E501
        'io_policy',  # noqa: E501
        'name',  # noqa: E501
        'num_blocks',  # noqa: E501
        'oper_state',  # noqa: E501
        'operability',  # noqa: E501
        'physical_block_size',  # noqa: E501
        'read_policy',  # noqa: E501
        'security_flags',  # noqa: E501
        'size',  # noqa: E501
        'strip_size',  # noqa: E501
        'type',  # noqa: E501
        'uuid',  # noqa: E501
        'vendor_uuid',  # noqa: E501
        'virtual_drive_id',  # noqa: E501
        'vd_member_eps',  # noqa: E501
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'device_mo_id',  # noqa: E501
        'dn',  # noqa: E501
        'rn',  # noqa: E501
        'model',  # noqa: E501
        'presence',  # noqa: E501
        'revision',  # noqa: E501
        'serial',  # noqa: E501
        'vendor',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """StorageVirtualDrive - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "storage.VirtualDrive", must be one of ["storage.VirtualDrive", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "storage.VirtualDrive", must be one of ["storage.VirtualDrive", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_policy (str): The access policy of the virtual drive.. [optional]  # noqa: E501
            actual_write_cache_policy (str): The current write cache policy of the virtual drive.. [optional]  # noqa: E501
            available_size (str): Available storage capacity of the virtual drive.. [optional]  # noqa: E501
            block_size (str): Block size of the virtual drive.. [optional]  # noqa: E501
            bootable (str): The virtual drive bootable state.. [optional]  # noqa: E501
            config_state (str): The configuration state of the virtual drive.. [optional]  # noqa: E501
            configured_write_cache_policy (str): The requested write cache policy of the virtual drive.. [optional]  # noqa: E501
            connection_protocol (str): The connection protocol of the virtual drive.. [optional]  # noqa: E501
            drive_cache (str): The state of the drive cache of the virtual drive.. [optional]  # noqa: E501
            drive_security (str): The driveSecurity state of the Virtual drive.. [optional]  # noqa: E501
            drive_state (str): The state of the Virtual drive.. [optional]  # noqa: E501
            io_policy (str): The Input/Output Policy defined on the Virtual drive.. [optional]  # noqa: E501
            name (str): The name of the Virtual drive.. [optional]  # noqa: E501
            num_blocks (str): Number of Blocks on the Physical Disk.. [optional]  # noqa: E501
            oper_state (str): The current operational state of Virtual drive.. [optional]  # noqa: E501
            operability (str): The current operability state of Virtual drive.. [optional]  # noqa: E501
            physical_block_size (str): The block size of the the virtual drive.. [optional]  # noqa: E501
            read_policy (str): The read-ahead cache mode of the virtual drive.. [optional]  # noqa: E501
            security_flags (str): The security flags set for this virtual drive.. [optional]  # noqa: E501
            size (str): The size of the virtual drive in MB.. [optional]  # noqa: E501
            strip_size (str): The strip size is the portion of a stripe that resides on a single drive in the drive group, this is measured in KB.. [optional]  # noqa: E501
            type (str): The raid type of the virtual drive.. [optional]  # noqa: E501
            uuid (str): The uuid of the virtual drive.. [optional]  # noqa: E501
            vendor_uuid (str): The UUID value of the vendor.. [optional]  # noqa: E501
            virtual_drive_id (str): The identifier for this Virtual drive.. [optional]  # noqa: E501
            disk_group (StorageDiskGroupRelationship): [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            physical_disk_usages ([StoragePhysicalDiskUsageRelationship], none_type): An array of relationships to storagePhysicalDiskUsage resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            storage_controller (StorageControllerRelationship): [optional]  # noqa: E501
            storage_virtual_drive_container (StorageVirtualDriveContainerRelationship): [optional]  # noqa: E501
            vd_member_eps ([StorageVdMemberEpRelationship], none_type): An array of relationships to storageVdMemberEp resources.. [optional]  # noqa: E501
            virtual_drive_extension (StorageVirtualDriveExtensionRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            model (str): This field identifies the model of the given component.. [optional]  # noqa: E501
            presence (str): This field identifies the presence (equipped) or absence of the given component.. [optional]  # noqa: E501
            revision (str): This field identifies the revision of the given component.. [optional]  # noqa: E501
            serial (str): This field identifies the serial of the given component.. [optional]  # noqa: E501
            vendor (str): This field identifies the vendor of the given component.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "storage.VirtualDrive")
        object_type = kwargs.get('object_type', "storage.VirtualDrive")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """StorageVirtualDrive - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "storage.VirtualDrive", must be one of ["storage.VirtualDrive", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "storage.VirtualDrive", must be one of ["storage.VirtualDrive", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_policy (str): The access policy of the virtual drive.. [optional]  # noqa: E501
            actual_write_cache_policy (str): The current write cache policy of the virtual drive.. [optional]  # noqa: E501
            available_size (str): Available storage capacity of the virtual drive.. [optional]  # noqa: E501
            block_size (str): Block size of the virtual drive.. [optional]  # noqa: E501
            bootable (str): The virtual drive bootable state.. [optional]  # noqa: E501
            config_state (str): The configuration state of the virtual drive.. [optional]  # noqa: E501
            configured_write_cache_policy (str): The requested write cache policy of the virtual drive.. [optional]  # noqa: E501
            connection_protocol (str): The connection protocol of the virtual drive.. [optional]  # noqa: E501
            drive_cache (str): The state of the drive cache of the virtual drive.. [optional]  # noqa: E501
            drive_security (str): The driveSecurity state of the Virtual drive.. [optional]  # noqa: E501
            drive_state (str): The state of the Virtual drive.. [optional]  # noqa: E501
            io_policy (str): The Input/Output Policy defined on the Virtual drive.. [optional]  # noqa: E501
            name (str): The name of the Virtual drive.. [optional]  # noqa: E501
            num_blocks (str): Number of Blocks on the Physical Disk.. [optional]  # noqa: E501
            oper_state (str): The current operational state of Virtual drive.. [optional]  # noqa: E501
            operability (str): The current operability state of Virtual drive.. [optional]  # noqa: E501
            physical_block_size (str): The block size of the the virtual drive.. [optional]  # noqa: E501
            read_policy (str): The read-ahead cache mode of the virtual drive.. [optional]  # noqa: E501
            security_flags (str): The security flags set for this virtual drive.. [optional]  # noqa: E501
            size (str): The size of the virtual drive in MB.. [optional]  # noqa: E501
            strip_size (str): The strip size is the portion of a stripe that resides on a single drive in the drive group, this is measured in KB.. [optional]  # noqa: E501
            type (str): The raid type of the virtual drive.. [optional]  # noqa: E501
            uuid (str): The uuid of the virtual drive.. [optional]  # noqa: E501
            vendor_uuid (str): The UUID value of the vendor.. [optional]  # noqa: E501
            virtual_drive_id (str): The identifier for this Virtual drive.. [optional]  # noqa: E501
            disk_group (StorageDiskGroupRelationship): [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            physical_disk_usages ([StoragePhysicalDiskUsageRelationship], none_type): An array of relationships to storagePhysicalDiskUsage resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            storage_controller (StorageControllerRelationship): [optional]  # noqa: E501
            storage_virtual_drive_container (StorageVirtualDriveContainerRelationship): [optional]  # noqa: E501
            vd_member_eps ([StorageVdMemberEpRelationship], none_type): An array of relationships to storageVdMemberEp resources.. [optional]  # noqa: E501
            virtual_drive_extension (StorageVirtualDriveExtensionRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            model (str): This field identifies the model of the given component.. [optional]  # noqa: E501
            presence (str): This field identifies the presence (equipped) or absence of the given component.. [optional]  # noqa: E501
            revision (str): This field identifies the revision of the given component.. [optional]  # noqa: E501
            serial (str): This field identifies the serial of the given component.. [optional]  # noqa: E501
            vendor (str): This field identifies the vendor of the given component.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "storage.VirtualDrive")
        object_type = kwargs.get('object_type', "storage.VirtualDrive")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              EquipmentBase,
              StorageVirtualDriveAllOf,
          ],
          'oneOf': [
          ],
        }
