"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-7766
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.compute_alarm_summary import ComputeAlarmSummary
    from intersight.model.console_console_config_relationship import ConsoleConsoleConfigRelationship
    from intersight.model.equipment_fan_module_relationship import EquipmentFanModuleRelationship
    from intersight.model.equipment_psu_relationship import EquipmentPsuRelationship
    from intersight.model.equipment_switch_card_relationship import EquipmentSwitchCardRelationship
    from intersight.model.fc_port_channel_relationship import FcPortChannelRelationship
    from intersight.model.firmware_running_firmware_relationship import FirmwareRunningFirmwareRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    from intersight.model.management_controller_relationship import ManagementControllerRelationship
    from intersight.model.management_entity_relationship import ManagementEntityRelationship
    from intersight.model.network_fc_zone_info_relationship import NetworkFcZoneInfoRelationship
    from intersight.model.network_feature_control_relationship import NetworkFeatureControlRelationship
    from intersight.model.network_interface_list_relationship import NetworkInterfaceListRelationship
    from intersight.model.network_license_file_relationship import NetworkLicenseFileRelationship
    from intersight.model.network_supervisor_card_relationship import NetworkSupervisorCardRelationship
    from intersight.model.network_vlan_port_info_relationship import NetworkVlanPortInfoRelationship
    from intersight.model.network_vrf_relationship import NetworkVrfRelationship
    from intersight.model.ntp_ntp_server_relationship import NtpNtpServerRelationship
    from intersight.model.port_mac_binding_relationship import PortMacBindingRelationship
    from intersight.model.processor_unit_relationship import ProcessorUnitRelationship
    from intersight.model.storage_item_relationship import StorageItemRelationship
    from intersight.model.top_system_relationship import TopSystemRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['ComputeAlarmSummary'] = ComputeAlarmSummary
    globals()['ConsoleConsoleConfigRelationship'] = ConsoleConsoleConfigRelationship
    globals()['EquipmentFanModuleRelationship'] = EquipmentFanModuleRelationship
    globals()['EquipmentPsuRelationship'] = EquipmentPsuRelationship
    globals()['EquipmentSwitchCardRelationship'] = EquipmentSwitchCardRelationship
    globals()['FcPortChannelRelationship'] = FcPortChannelRelationship
    globals()['FirmwareRunningFirmwareRelationship'] = FirmwareRunningFirmwareRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship
    globals()['ManagementControllerRelationship'] = ManagementControllerRelationship
    globals()['ManagementEntityRelationship'] = ManagementEntityRelationship
    globals()['NetworkFcZoneInfoRelationship'] = NetworkFcZoneInfoRelationship
    globals()['NetworkFeatureControlRelationship'] = NetworkFeatureControlRelationship
    globals()['NetworkInterfaceListRelationship'] = NetworkInterfaceListRelationship
    globals()['NetworkLicenseFileRelationship'] = NetworkLicenseFileRelationship
    globals()['NetworkSupervisorCardRelationship'] = NetworkSupervisorCardRelationship
    globals()['NetworkVlanPortInfoRelationship'] = NetworkVlanPortInfoRelationship
    globals()['NetworkVrfRelationship'] = NetworkVrfRelationship
    globals()['NtpNtpServerRelationship'] = NtpNtpServerRelationship
    globals()['PortMacBindingRelationship'] = PortMacBindingRelationship
    globals()['ProcessorUnitRelationship'] = ProcessorUnitRelationship
    globals()['StorageItemRelationship'] = StorageItemRelationship
    globals()['TopSystemRelationship'] = TopSystemRelationship


class NetworkElementAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'NETWORK.ELEMENT': "network.Element",
        },
        ('object_type',): {
            'NETWORK.ELEMENT': "network.Element",
        },
        ('ethernet_switching_mode',): {
            'END-HOST': "end-host",
            'SWITCH': "switch",
        },
        ('fc_switching_mode',): {
            'END-HOST': "end-host",
            'SWITCH': "switch",
        },
        ('management_mode',): {
            'INTERSIGHTSTANDALONE': "IntersightStandalone",
            'UCSM': "UCSM",
            'INTERSIGHT': "Intersight",
        },
        ('switch_type',): {
            'FABRICINTERCONNECT': "FabricInterconnect",
            'NEXUSDEVICE': "NexusDevice",
            'MDSDEVICE': "MDSDevice",
        },
        ('thermal',): {
            'UNKNOWN': "unknown",
            'OK': "ok",
            'UPPER-NON-RECOVERABLE': "upper-non-recoverable",
            'UPPER-CRITICAL': "upper-critical",
            'UPPER-NON-CRITICAL': "upper-non-critical",
            'LOWER-NON-CRITICAL': "lower-non-critical",
            'LOWER-CRITICAL': "lower-critical",
            'LOWER-NON-RECOVERABLE': "lower-non-recoverable",
        },
    }

    validations = {
        ('default_domain',): {
            'max_length': 255,
            'min_length': 0,
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9]+([-.]{1}[a-zA-Z0-9]+)*$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'admin_evac_state': (str,),  # noqa: E501
            'admin_inband_interface_state': (str,),  # noqa: E501
            'alarm_summary': (ComputeAlarmSummary,),  # noqa: E501
            'available_memory': (str,),  # noqa: E501
            'chassis': (str,),  # noqa: E501
            'conf_mod_ts': (str,),  # noqa: E501
            'conf_mod_ts_backup': (str,),  # noqa: E501
            'default_domain': (str,),  # noqa: E501
            'ethernet_mode': (str,),  # noqa: E501
            'ethernet_switching_mode': (str,),  # noqa: E501
            'fault_summary': (int,),  # noqa: E501
            'fc_mode': (str,),  # noqa: E501
            'fc_switching_mode': (str,),  # noqa: E501
            'inband_ip_address': (str,),  # noqa: E501
            'inband_ip_gateway': (str,),  # noqa: E501
            'inband_ip_mask': (str,),  # noqa: E501
            'inband_vlan': (int,),  # noqa: E501
            'management_mode': (str,),  # noqa: E501
            'oper_evac_state': (str,),  # noqa: E501
            'operability': (str,),  # noqa: E501
            'out_of_band_ip_address': (str,),  # noqa: E501
            'out_of_band_ip_gateway': (str,),  # noqa: E501
            'out_of_band_ip_mask': (str,),  # noqa: E501
            'out_of_band_ipv4_address': (str,),  # noqa: E501
            'out_of_band_ipv4_gateway': (str,),  # noqa: E501
            'out_of_band_ipv4_mask': (str,),  # noqa: E501
            'out_of_band_ipv6_address': (str,),  # noqa: E501
            'out_of_band_ipv6_gateway': (str,),  # noqa: E501
            'out_of_band_ipv6_prefix': (str,),  # noqa: E501
            'out_of_band_mac': (str,),  # noqa: E501
            'part_number': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'switch_id': (str,),  # noqa: E501
            'switch_type': (str,),  # noqa: E501
            'system_up_time': (str,),  # noqa: E501
            'thermal': (str,),  # noqa: E501
            'total_memory': (int,),  # noqa: E501
            'version': (str,),  # noqa: E501
            'cards': ([EquipmentSwitchCardRelationship], none_type,),  # noqa: E501
            'console': ([ConsoleConsoleConfigRelationship], none_type,),  # noqa: E501
            'fanmodules': ([EquipmentFanModuleRelationship], none_type,),  # noqa: E501
            'fc_port_channels': ([FcPortChannelRelationship], none_type,),  # noqa: E501
            'feature_control': ([NetworkFeatureControlRelationship], none_type,),  # noqa: E501
            'interface_list': ([NetworkInterfaceListRelationship], none_type,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'license_file': ([NetworkLicenseFileRelationship], none_type,),  # noqa: E501
            'management_controller': (ManagementControllerRelationship,),  # noqa: E501
            'management_entity': (ManagementEntityRelationship,),  # noqa: E501
            'network_fc_zone_info': (NetworkFcZoneInfoRelationship,),  # noqa: E501
            'network_vlan_port_info': (NetworkVlanPortInfoRelationship,),  # noqa: E501
            'ntp_server': ([NtpNtpServerRelationship], none_type,),  # noqa: E501
            'port_mac_bindings': ([PortMacBindingRelationship], none_type,),  # noqa: E501
            'processor_unit': ([ProcessorUnitRelationship], none_type,),  # noqa: E501
            'psus': ([EquipmentPsuRelationship], none_type,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'storage_items': ([StorageItemRelationship], none_type,),  # noqa: E501
            'supervisor_card': ([NetworkSupervisorCardRelationship], none_type,),  # noqa: E501
            'top_system': (TopSystemRelationship,),  # noqa: E501
            'ucsm_running_firmware': (FirmwareRunningFirmwareRelationship,),  # noqa: E501
            'vrf': ([NetworkVrfRelationship], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'admin_evac_state': 'AdminEvacState',  # noqa: E501
        'admin_inband_interface_state': 'AdminInbandInterfaceState',  # noqa: E501
        'alarm_summary': 'AlarmSummary',  # noqa: E501
        'available_memory': 'AvailableMemory',  # noqa: E501
        'chassis': 'Chassis',  # noqa: E501
        'conf_mod_ts': 'ConfModTs',  # noqa: E501
        'conf_mod_ts_backup': 'ConfModTsBackup',  # noqa: E501
        'default_domain': 'DefaultDomain',  # noqa: E501
        'ethernet_mode': 'EthernetMode',  # noqa: E501
        'ethernet_switching_mode': 'EthernetSwitchingMode',  # noqa: E501
        'fault_summary': 'FaultSummary',  # noqa: E501
        'fc_mode': 'FcMode',  # noqa: E501
        'fc_switching_mode': 'FcSwitchingMode',  # noqa: E501
        'inband_ip_address': 'InbandIpAddress',  # noqa: E501
        'inband_ip_gateway': 'InbandIpGateway',  # noqa: E501
        'inband_ip_mask': 'InbandIpMask',  # noqa: E501
        'inband_vlan': 'InbandVlan',  # noqa: E501
        'management_mode': 'ManagementMode',  # noqa: E501
        'oper_evac_state': 'OperEvacState',  # noqa: E501
        'operability': 'Operability',  # noqa: E501
        'out_of_band_ip_address': 'OutOfBandIpAddress',  # noqa: E501
        'out_of_band_ip_gateway': 'OutOfBandIpGateway',  # noqa: E501
        'out_of_band_ip_mask': 'OutOfBandIpMask',  # noqa: E501
        'out_of_band_ipv4_address': 'OutOfBandIpv4Address',  # noqa: E501
        'out_of_band_ipv4_gateway': 'OutOfBandIpv4Gateway',  # noqa: E501
        'out_of_band_ipv4_mask': 'OutOfBandIpv4Mask',  # noqa: E501
        'out_of_band_ipv6_address': 'OutOfBandIpv6Address',  # noqa: E501
        'out_of_band_ipv6_gateway': 'OutOfBandIpv6Gateway',  # noqa: E501
        'out_of_band_ipv6_prefix': 'OutOfBandIpv6Prefix',  # noqa: E501
        'out_of_band_mac': 'OutOfBandMac',  # noqa: E501
        'part_number': 'PartNumber',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'switch_id': 'SwitchId',  # noqa: E501
        'switch_type': 'SwitchType',  # noqa: E501
        'system_up_time': 'SystemUpTime',  # noqa: E501
        'thermal': 'Thermal',  # noqa: E501
        'total_memory': 'TotalMemory',  # noqa: E501
        'version': 'Version',  # noqa: E501
        'cards': 'Cards',  # noqa: E501
        'console': 'Console',  # noqa: E501
        'fanmodules': 'Fanmodules',  # noqa: E501
        'fc_port_channels': 'FcPortChannels',  # noqa: E501
        'feature_control': 'FeatureControl',  # noqa: E501
        'interface_list': 'InterfaceList',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'license_file': 'LicenseFile',  # noqa: E501
        'management_controller': 'ManagementController',  # noqa: E501
        'management_entity': 'ManagementEntity',  # noqa: E501
        'network_fc_zone_info': 'NetworkFcZoneInfo',  # noqa: E501
        'network_vlan_port_info': 'NetworkVlanPortInfo',  # noqa: E501
        'ntp_server': 'NtpServer',  # noqa: E501
        'port_mac_bindings': 'PortMacBindings',  # noqa: E501
        'processor_unit': 'ProcessorUnit',  # noqa: E501
        'psus': 'Psus',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'storage_items': 'StorageItems',  # noqa: E501
        'supervisor_card': 'SupervisorCard',  # noqa: E501
        'top_system': 'TopSystem',  # noqa: E501
        'ucsm_running_firmware': 'UcsmRunningFirmware',  # noqa: E501
        'vrf': 'Vrf',  # noqa: E501
    }

    read_only_vars = {
        'admin_evac_state',  # noqa: E501
        'admin_inband_interface_state',  # noqa: E501
        'available_memory',  # noqa: E501
        'ethernet_mode',  # noqa: E501
        'ethernet_switching_mode',  # noqa: E501
        'fc_mode',  # noqa: E501
        'fc_switching_mode',  # noqa: E501
        'inband_ip_address',  # noqa: E501
        'inband_ip_gateway',  # noqa: E501
        'inband_ip_mask',  # noqa: E501
        'inband_vlan',  # noqa: E501
        'oper_evac_state',  # noqa: E501
        'operability',  # noqa: E501
        'out_of_band_ip_address',  # noqa: E501
        'out_of_band_ip_gateway',  # noqa: E501
        'out_of_band_ip_mask',  # noqa: E501
        'out_of_band_ipv4_address',  # noqa: E501
        'out_of_band_ipv4_gateway',  # noqa: E501
        'out_of_band_ipv4_mask',  # noqa: E501
        'out_of_band_mac',  # noqa: E501
        'switch_id',  # noqa: E501
        'switch_type',  # noqa: E501
        'total_memory',  # noqa: E501
        'cards',  # noqa: E501
        'fanmodules',  # noqa: E501
        'ntp_server',  # noqa: E501
        'psus',  # noqa: E501
        'storage_items',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """NetworkElementAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "network.Element", must be one of ["network.Element", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "network.Element", must be one of ["network.Element", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_evac_state (str): Administratively configured state of Fabric Evacuation feature, for this switch.. [optional]  # noqa: E501
            admin_inband_interface_state (str): The administrative state of the network Element inband management interface.. [optional]  # noqa: E501
            alarm_summary (ComputeAlarmSummary): [optional]  # noqa: E501
            available_memory (str): Available memory (un-used) on this switch platform.. [optional]  # noqa: E501
            chassis (str): Chassis IP of the switch.. [optional]  # noqa: E501
            conf_mod_ts (str): Configuration modified timestamp of the switch.. [optional]  # noqa: E501
            conf_mod_ts_backup (str): Configuration modified backup timestamp of the switch.. [optional]  # noqa: E501
            default_domain (str): The default domain name configured on the switch.. [optional]  # noqa: E501
            ethernet_mode (str): The user configured Ethernet operational mode for this switch (End-Host or Switching).. [optional]  # noqa: E501
            ethernet_switching_mode (str): The user configured Ethernet operational mode for this switch (End-Host or Switching). * `end-host` - In end-host mode, the fabric interconnects appear to the upstream devices as end hosts with multiple links.In this mode, the switch does not run Spanning Tree Protocol and avoids loops by following a set of rules for traffic forwarding.In case of ethernet switching mode - Ethernet end-host mode is also known as Ethernet host virtualizer. * `switch` - In switch mode, the switch runs Spanning Tree Protocol to avoid loops, and broadcast and multicast packets are handled in the traditional way.This is the traditional switch mode.. [optional] if omitted the server will use the default value of "end-host"  # noqa: E501
            fault_summary (int): The fault summary of the network Element out-of-band management interface.. [optional]  # noqa: E501
            fc_mode (str): The user configured FC operational mode for this switch (End-Host or Switching).. [optional]  # noqa: E501
            fc_switching_mode (str): The user configured FC operational mode for this switch (End-Host or Switching). * `end-host` - In end-host mode, the fabric interconnects appear to the upstream devices as end hosts with multiple links.In this mode, the switch does not run Spanning Tree Protocol and avoids loops by following a set of rules for traffic forwarding.In case of ethernet switching mode - Ethernet end-host mode is also known as Ethernet host virtualizer. * `switch` - In switch mode, the switch runs Spanning Tree Protocol to avoid loops, and broadcast and multicast packets are handled in the traditional way.This is the traditional switch mode.. [optional] if omitted the server will use the default value of "end-host"  # noqa: E501
            inband_ip_address (str): The IP address of the network Element inband management interface.. [optional]  # noqa: E501
            inband_ip_gateway (str): The default gateway of the network Element inband management interface.. [optional]  # noqa: E501
            inband_ip_mask (str): The network mask of the network Element inband management interface.. [optional]  # noqa: E501
            inband_vlan (int): The VLAN ID of the network Element inband management interface.. [optional]  # noqa: E501
            management_mode (str): The management mode of the fabric interconnect. * `IntersightStandalone` - Intersight Standalone mode of operation. * `UCSM` - Unified Computing System Manager mode of operation. * `Intersight` - Intersight managed mode of operation.. [optional] if omitted the server will use the default value of "IntersightStandalone"  # noqa: E501
            oper_evac_state (str): Operational state of the Fabric Evacuation feature, for this switch.. [optional]  # noqa: E501
            operability (str): The switch's current overall operational/health state.. [optional]  # noqa: E501
            out_of_band_ip_address (str): The IP address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ip_gateway (str): The default gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ip_mask (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_address (str): The IPv4 address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_gateway (str): The default IPv4 gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_mask (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_address (str): The IPv6 address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_gateway (str): The default IPv6 gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_prefix (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_mac (str): The MAC address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            part_number (str): Part number of the switch.. [optional]  # noqa: E501
            status (str): The status of the switch.. [optional]  # noqa: E501
            switch_id (str): The Switch Id of the network Element.. [optional]  # noqa: E501
            switch_type (str): The Switch type that the network element is a part of. * `FabricInterconnect` - The default Switch type of UCSM and IMM mode devices. * `NexusDevice` - Switch type of Nexus devices. * `MDSDevice` - Switch type of Nexus MDS devices.. [optional] if omitted the server will use the default value of "FabricInterconnect"  # noqa: E501
            system_up_time (str): System up time of the switch.. [optional]  # noqa: E501
            thermal (str): The Thermal status of the fabric interconnect. * `unknown` - The default state of the sensor (in case no data is received). * `ok` - State of the sensor indicating the sensor's temperature range is okay. * `upper-non-recoverable` - State of the sensor indicating that the temperature is extremely high above normal range. * `upper-critical` - State of the sensor indicating that the temperature is above normal range. * `upper-non-critical` - State of the sensor indicating that the temperature is a little above the normal range. * `lower-non-critical` - State of the sensor indicating that the temperature is a little below the normal range. * `lower-critical` - State of the sensor indicating that the temperature is below normal range. * `lower-non-recoverable` - State of the sensor indicating that the temperature is extremely below normal range.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            total_memory (int): Total available memory on this switch platform.. [optional]  # noqa: E501
            version (str): Firmware version of the switch.. [optional]  # noqa: E501
            cards ([EquipmentSwitchCardRelationship], none_type): An array of relationships to equipmentSwitchCard resources.. [optional]  # noqa: E501
            console ([ConsoleConsoleConfigRelationship], none_type): An array of relationships to consoleConsoleConfig resources.. [optional]  # noqa: E501
            fanmodules ([EquipmentFanModuleRelationship], none_type): An array of relationships to equipmentFanModule resources.. [optional]  # noqa: E501
            fc_port_channels ([FcPortChannelRelationship], none_type): An array of relationships to fcPortChannel resources.. [optional]  # noqa: E501
            feature_control ([NetworkFeatureControlRelationship], none_type): An array of relationships to networkFeatureControl resources.. [optional]  # noqa: E501
            interface_list ([NetworkInterfaceListRelationship], none_type): An array of relationships to networkInterfaceList resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            license_file ([NetworkLicenseFileRelationship], none_type): An array of relationships to networkLicenseFile resources.. [optional]  # noqa: E501
            management_controller (ManagementControllerRelationship): [optional]  # noqa: E501
            management_entity (ManagementEntityRelationship): [optional]  # noqa: E501
            network_fc_zone_info (NetworkFcZoneInfoRelationship): [optional]  # noqa: E501
            network_vlan_port_info (NetworkVlanPortInfoRelationship): [optional]  # noqa: E501
            ntp_server ([NtpNtpServerRelationship], none_type): An array of relationships to ntpNtpServer resources.. [optional]  # noqa: E501
            port_mac_bindings ([PortMacBindingRelationship], none_type): An array of relationships to portMacBinding resources.. [optional]  # noqa: E501
            processor_unit ([ProcessorUnitRelationship], none_type): An array of relationships to processorUnit resources.. [optional]  # noqa: E501
            psus ([EquipmentPsuRelationship], none_type): An array of relationships to equipmentPsu resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            storage_items ([StorageItemRelationship], none_type): An array of relationships to storageItem resources.. [optional]  # noqa: E501
            supervisor_card ([NetworkSupervisorCardRelationship], none_type): An array of relationships to networkSupervisorCard resources.. [optional]  # noqa: E501
            top_system (TopSystemRelationship): [optional]  # noqa: E501
            ucsm_running_firmware (FirmwareRunningFirmwareRelationship): [optional]  # noqa: E501
            vrf ([NetworkVrfRelationship], none_type): An array of relationships to networkVrf resources.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "network.Element")
        object_type = kwargs.get('object_type', "network.Element")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """NetworkElementAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "network.Element", must be one of ["network.Element", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "network.Element", must be one of ["network.Element", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_evac_state (str): Administratively configured state of Fabric Evacuation feature, for this switch.. [optional]  # noqa: E501
            admin_inband_interface_state (str): The administrative state of the network Element inband management interface.. [optional]  # noqa: E501
            alarm_summary (ComputeAlarmSummary): [optional]  # noqa: E501
            available_memory (str): Available memory (un-used) on this switch platform.. [optional]  # noqa: E501
            chassis (str): Chassis IP of the switch.. [optional]  # noqa: E501
            conf_mod_ts (str): Configuration modified timestamp of the switch.. [optional]  # noqa: E501
            conf_mod_ts_backup (str): Configuration modified backup timestamp of the switch.. [optional]  # noqa: E501
            default_domain (str): The default domain name configured on the switch.. [optional]  # noqa: E501
            ethernet_mode (str): The user configured Ethernet operational mode for this switch (End-Host or Switching).. [optional]  # noqa: E501
            ethernet_switching_mode (str): The user configured Ethernet operational mode for this switch (End-Host or Switching). * `end-host` - In end-host mode, the fabric interconnects appear to the upstream devices as end hosts with multiple links.In this mode, the switch does not run Spanning Tree Protocol and avoids loops by following a set of rules for traffic forwarding.In case of ethernet switching mode - Ethernet end-host mode is also known as Ethernet host virtualizer. * `switch` - In switch mode, the switch runs Spanning Tree Protocol to avoid loops, and broadcast and multicast packets are handled in the traditional way.This is the traditional switch mode.. [optional] if omitted the server will use the default value of "end-host"  # noqa: E501
            fault_summary (int): The fault summary of the network Element out-of-band management interface.. [optional]  # noqa: E501
            fc_mode (str): The user configured FC operational mode for this switch (End-Host or Switching).. [optional]  # noqa: E501
            fc_switching_mode (str): The user configured FC operational mode for this switch (End-Host or Switching). * `end-host` - In end-host mode, the fabric interconnects appear to the upstream devices as end hosts with multiple links.In this mode, the switch does not run Spanning Tree Protocol and avoids loops by following a set of rules for traffic forwarding.In case of ethernet switching mode - Ethernet end-host mode is also known as Ethernet host virtualizer. * `switch` - In switch mode, the switch runs Spanning Tree Protocol to avoid loops, and broadcast and multicast packets are handled in the traditional way.This is the traditional switch mode.. [optional] if omitted the server will use the default value of "end-host"  # noqa: E501
            inband_ip_address (str): The IP address of the network Element inband management interface.. [optional]  # noqa: E501
            inband_ip_gateway (str): The default gateway of the network Element inband management interface.. [optional]  # noqa: E501
            inband_ip_mask (str): The network mask of the network Element inband management interface.. [optional]  # noqa: E501
            inband_vlan (int): The VLAN ID of the network Element inband management interface.. [optional]  # noqa: E501
            management_mode (str): The management mode of the fabric interconnect. * `IntersightStandalone` - Intersight Standalone mode of operation. * `UCSM` - Unified Computing System Manager mode of operation. * `Intersight` - Intersight managed mode of operation.. [optional] if omitted the server will use the default value of "IntersightStandalone"  # noqa: E501
            oper_evac_state (str): Operational state of the Fabric Evacuation feature, for this switch.. [optional]  # noqa: E501
            operability (str): The switch's current overall operational/health state.. [optional]  # noqa: E501
            out_of_band_ip_address (str): The IP address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ip_gateway (str): The default gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ip_mask (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_address (str): The IPv4 address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_gateway (str): The default IPv4 gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_mask (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_address (str): The IPv6 address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_gateway (str): The default IPv6 gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_prefix (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_mac (str): The MAC address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            part_number (str): Part number of the switch.. [optional]  # noqa: E501
            status (str): The status of the switch.. [optional]  # noqa: E501
            switch_id (str): The Switch Id of the network Element.. [optional]  # noqa: E501
            switch_type (str): The Switch type that the network element is a part of. * `FabricInterconnect` - The default Switch type of UCSM and IMM mode devices. * `NexusDevice` - Switch type of Nexus devices. * `MDSDevice` - Switch type of Nexus MDS devices.. [optional] if omitted the server will use the default value of "FabricInterconnect"  # noqa: E501
            system_up_time (str): System up time of the switch.. [optional]  # noqa: E501
            thermal (str): The Thermal status of the fabric interconnect. * `unknown` - The default state of the sensor (in case no data is received). * `ok` - State of the sensor indicating the sensor's temperature range is okay. * `upper-non-recoverable` - State of the sensor indicating that the temperature is extremely high above normal range. * `upper-critical` - State of the sensor indicating that the temperature is above normal range. * `upper-non-critical` - State of the sensor indicating that the temperature is a little above the normal range. * `lower-non-critical` - State of the sensor indicating that the temperature is a little below the normal range. * `lower-critical` - State of the sensor indicating that the temperature is below normal range. * `lower-non-recoverable` - State of the sensor indicating that the temperature is extremely below normal range.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            total_memory (int): Total available memory on this switch platform.. [optional]  # noqa: E501
            version (str): Firmware version of the switch.. [optional]  # noqa: E501
            cards ([EquipmentSwitchCardRelationship], none_type): An array of relationships to equipmentSwitchCard resources.. [optional]  # noqa: E501
            console ([ConsoleConsoleConfigRelationship], none_type): An array of relationships to consoleConsoleConfig resources.. [optional]  # noqa: E501
            fanmodules ([EquipmentFanModuleRelationship], none_type): An array of relationships to equipmentFanModule resources.. [optional]  # noqa: E501
            fc_port_channels ([FcPortChannelRelationship], none_type): An array of relationships to fcPortChannel resources.. [optional]  # noqa: E501
            feature_control ([NetworkFeatureControlRelationship], none_type): An array of relationships to networkFeatureControl resources.. [optional]  # noqa: E501
            interface_list ([NetworkInterfaceListRelationship], none_type): An array of relationships to networkInterfaceList resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            license_file ([NetworkLicenseFileRelationship], none_type): An array of relationships to networkLicenseFile resources.. [optional]  # noqa: E501
            management_controller (ManagementControllerRelationship): [optional]  # noqa: E501
            management_entity (ManagementEntityRelationship): [optional]  # noqa: E501
            network_fc_zone_info (NetworkFcZoneInfoRelationship): [optional]  # noqa: E501
            network_vlan_port_info (NetworkVlanPortInfoRelationship): [optional]  # noqa: E501
            ntp_server ([NtpNtpServerRelationship], none_type): An array of relationships to ntpNtpServer resources.. [optional]  # noqa: E501
            port_mac_bindings ([PortMacBindingRelationship], none_type): An array of relationships to portMacBinding resources.. [optional]  # noqa: E501
            processor_unit ([ProcessorUnitRelationship], none_type): An array of relationships to processorUnit resources.. [optional]  # noqa: E501
            psus ([EquipmentPsuRelationship], none_type): An array of relationships to equipmentPsu resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            storage_items ([StorageItemRelationship], none_type): An array of relationships to storageItem resources.. [optional]  # noqa: E501
            supervisor_card ([NetworkSupervisorCardRelationship], none_type): An array of relationships to networkSupervisorCard resources.. [optional]  # noqa: E501
            top_system (TopSystemRelationship): [optional]  # noqa: E501
            ucsm_running_firmware (FirmwareRunningFirmwareRelationship): [optional]  # noqa: E501
            vrf ([NetworkVrfRelationship], none_type): An array of relationships to networkVrf resources.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "network.Element")
        object_type = kwargs.get('object_type', "network.Element")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
