"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-7766
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.hyperflex_cluster_relationship import HyperflexClusterRelationship
    from intersight.model.hyperflex_volume_relationship import HyperflexVolumeRelationship
    from intersight.model.storage_storage_container_host_mount_status import StorageStorageContainerHostMountStatus
    globals()['HyperflexClusterRelationship'] = HyperflexClusterRelationship
    globals()['HyperflexVolumeRelationship'] = HyperflexVolumeRelationship
    globals()['StorageStorageContainerHostMountStatus'] = StorageStorageContainerHostMountStatus


class HyperflexStorageContainerAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'HYPERFLEX.STORAGECONTAINER': "hyperflex.StorageContainer",
        },
        ('object_type',): {
            'HYPERFLEX.STORAGECONTAINER': "hyperflex.StorageContainer",
        },
        ('accessibility_summary',): {
            'NOT_APPLICABLE': "NOT_APPLICABLE",
            'ACCESSIBLE': "ACCESSIBLE",
            'NOT_ACCESSIBLE': "NOT_ACCESSIBLE",
            'PARTIALLY_ACCESSIBLE': "PARTIALLY_ACCESSIBLE",
        },
        ('kind',): {
            'UNKNOWN': "UNKNOWN",
            'USER_CREATED': "USER_CREATED",
            'INTERNAL': "INTERNAL",
        },
        ('mount_status',): {
            'NOT_APPLICABLE': "NOT_APPLICABLE",
            'NORMAL': "NORMAL",
            'ALERT': "ALERT",
            'FAILED': "FAILED",
        },
        ('mount_summary',): {
            'NOT_APPLICABLE': "NOT_APPLICABLE",
            'MOUNTED': "MOUNTED",
            'UNMOUNTED': "UNMOUNTED",
            'MOUNT_FAILURE': "MOUNT_FAILURE",
            'UNMOUNT_FAILURE': "UNMOUNT_FAILURE",
        },
        ('type',): {
            'NFS': "NFS",
            'SMB': "SMB",
            'ISCSI': "iSCSI",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'accessibility_summary': (str,),  # noqa: E501
            'data_block_size': (int,),  # noqa: E501
            'encryption_enabled': (bool,),  # noqa: E501
            'host_mount_status': ([StorageStorageContainerHostMountStatus], none_type,),  # noqa: E501
            'in_use': (bool,),  # noqa: E501
            'kind': (str,),  # noqa: E501
            'last_access_time': (datetime,),  # noqa: E501
            'last_modified_time': (datetime,),  # noqa: E501
            'mount_status': (str,),  # noqa: E501
            'mount_summary': (str,),  # noqa: E501
            'provisioned_capacity': (int,),  # noqa: E501
            'provisioned_volume_capacity_utilization': (float,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'un_compressed_used_bytes': (int,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
            'volume_count': (int,),  # noqa: E501
            'cluster': (HyperflexClusterRelationship,),  # noqa: E501
            'volumes': ([HyperflexVolumeRelationship], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'accessibility_summary': 'AccessibilitySummary',  # noqa: E501
        'data_block_size': 'DataBlockSize',  # noqa: E501
        'encryption_enabled': 'EncryptionEnabled',  # noqa: E501
        'host_mount_status': 'HostMountStatus',  # noqa: E501
        'in_use': 'InUse',  # noqa: E501
        'kind': 'Kind',  # noqa: E501
        'last_access_time': 'LastAccessTime',  # noqa: E501
        'last_modified_time': 'LastModifiedTime',  # noqa: E501
        'mount_status': 'MountStatus',  # noqa: E501
        'mount_summary': 'MountSummary',  # noqa: E501
        'provisioned_capacity': 'ProvisionedCapacity',  # noqa: E501
        'provisioned_volume_capacity_utilization': 'ProvisionedVolumeCapacityUtilization',  # noqa: E501
        'type': 'Type',  # noqa: E501
        'un_compressed_used_bytes': 'UnCompressedUsedBytes',  # noqa: E501
        'uuid': 'Uuid',  # noqa: E501
        'volume_count': 'VolumeCount',  # noqa: E501
        'cluster': 'Cluster',  # noqa: E501
        'volumes': 'Volumes',  # noqa: E501
    }

    read_only_vars = {
        'accessibility_summary',  # noqa: E501
        'data_block_size',  # noqa: E501
        'encryption_enabled',  # noqa: E501
        'in_use',  # noqa: E501
        'kind',  # noqa: E501
        'last_access_time',  # noqa: E501
        'last_modified_time',  # noqa: E501
        'mount_status',  # noqa: E501
        'mount_summary',  # noqa: E501
        'provisioned_capacity',  # noqa: E501
        'provisioned_volume_capacity_utilization',  # noqa: E501
        'type',  # noqa: E501
        'un_compressed_used_bytes',  # noqa: E501
        'uuid',  # noqa: E501
        'volume_count',  # noqa: E501
        'volumes',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """HyperflexStorageContainerAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "hyperflex.StorageContainer", must be one of ["hyperflex.StorageContainer", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "hyperflex.StorageContainer", must be one of ["hyperflex.StorageContainer", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            accessibility_summary (str): Storage container accessibility summary. * `NOT_APPLICABLE` - The HyperFlex storage container accessibility summary is not applicable. * `ACCESSIBLE` - The HyperFlex storage container is accessible. * `NOT_ACCESSIBLE` - The HyperFlex storage container is not accessible. * `PARTIALLY_ACCESSIBLE` - The HyperFlex storage container is partially accessible.. [optional] if omitted the server will use the default value of "NOT_APPLICABLE"  # noqa: E501
            data_block_size (int): Storage container data block size in bytes.. [optional]  # noqa: E501
            encryption_enabled (bool): Indicate if encryption is enabled on this storage container.. [optional]  # noqa: E501
            host_mount_status ([StorageStorageContainerHostMountStatus], none_type): [optional]  # noqa: E501
            in_use (bool): Indicates whether the storage container has volumes.. [optional]  # noqa: E501
            kind (str): Indicates whether the storage container was user-created, or system-created. * `UNKNOWN` - The storage container creator is unknown. * `USER_CREATED` - The storage container was created by a user action. * `INTERNAL` - The storage container was created by the system.. [optional] if omitted the server will use the default value of "UNKNOWN"  # noqa: E501
            last_access_time (datetime): Storage container's last access time.. [optional]  # noqa: E501
            last_modified_time (datetime): Storage container's last modified time.. [optional]  # noqa: E501
            mount_status (str): Storage container mount status. Applicable only for NFS type. * `NOT_APPLICABLE` - The HyperFlex storage container mount status is not applicable. * `NORMAL` - The HyperFlex storage container mount status is normal. * `ALERT` - The HyperFlex storage container mount status is alert. * `FAILED` - The HyperFlex storage container mount status is failed.. [optional] if omitted the server will use the default value of "NOT_APPLICABLE"  # noqa: E501
            mount_summary (str): Storage container mount summary. Applicable only for NFS type. * `NOT_APPLICABLE` - The mount summary is not applicable for this HyperFlex storage container. * `MOUNTED` - The HyperFlex storage container is mounted. * `UNMOUNTED` - The HyperFlex storage container is unmounted. * `MOUNT_FAILURE` - The HyperFlex storage container mount summary is failure. * `UNMOUNT_FAILURE` - The HyperFlex storage container unmount summary is failure.. [optional] if omitted the server will use the default value of "NOT_APPLICABLE"  # noqa: E501
            provisioned_capacity (int): Provisioned capacity of the storage container in bytes.. [optional]  # noqa: E501
            provisioned_volume_capacity_utilization (float): Provisioned capacity utilization of all volumes associated with the storage container.. [optional]  # noqa: E501
            type (str): Storage container type (SMB/NFS/iSCSI). * `NFS` - Storage container created/accesed through NFS protocol. * `SMB` - Storage container created/accessed through SMB protocol. * `iSCSI` - Storage container created/accessed through iSCSI protocol.. [optional] if omitted the server will use the default value of "NFS"  # noqa: E501
            un_compressed_used_bytes (int): Uncompressed bytes on storage container.. [optional]  # noqa: E501
            uuid (str): UUID of the datastore/storage container.. [optional]  # noqa: E501
            volume_count (int): Number of volumes associated with the storage container.. [optional]  # noqa: E501
            cluster (HyperflexClusterRelationship): [optional]  # noqa: E501
            volumes ([HyperflexVolumeRelationship], none_type): An array of relationships to hyperflexVolume resources.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "hyperflex.StorageContainer")
        object_type = kwargs.get('object_type', "hyperflex.StorageContainer")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """HyperflexStorageContainerAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "hyperflex.StorageContainer", must be one of ["hyperflex.StorageContainer", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "hyperflex.StorageContainer", must be one of ["hyperflex.StorageContainer", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            accessibility_summary (str): Storage container accessibility summary. * `NOT_APPLICABLE` - The HyperFlex storage container accessibility summary is not applicable. * `ACCESSIBLE` - The HyperFlex storage container is accessible. * `NOT_ACCESSIBLE` - The HyperFlex storage container is not accessible. * `PARTIALLY_ACCESSIBLE` - The HyperFlex storage container is partially accessible.. [optional] if omitted the server will use the default value of "NOT_APPLICABLE"  # noqa: E501
            data_block_size (int): Storage container data block size in bytes.. [optional]  # noqa: E501
            encryption_enabled (bool): Indicate if encryption is enabled on this storage container.. [optional]  # noqa: E501
            host_mount_status ([StorageStorageContainerHostMountStatus], none_type): [optional]  # noqa: E501
            in_use (bool): Indicates whether the storage container has volumes.. [optional]  # noqa: E501
            kind (str): Indicates whether the storage container was user-created, or system-created. * `UNKNOWN` - The storage container creator is unknown. * `USER_CREATED` - The storage container was created by a user action. * `INTERNAL` - The storage container was created by the system.. [optional] if omitted the server will use the default value of "UNKNOWN"  # noqa: E501
            last_access_time (datetime): Storage container's last access time.. [optional]  # noqa: E501
            last_modified_time (datetime): Storage container's last modified time.. [optional]  # noqa: E501
            mount_status (str): Storage container mount status. Applicable only for NFS type. * `NOT_APPLICABLE` - The HyperFlex storage container mount status is not applicable. * `NORMAL` - The HyperFlex storage container mount status is normal. * `ALERT` - The HyperFlex storage container mount status is alert. * `FAILED` - The HyperFlex storage container mount status is failed.. [optional] if omitted the server will use the default value of "NOT_APPLICABLE"  # noqa: E501
            mount_summary (str): Storage container mount summary. Applicable only for NFS type. * `NOT_APPLICABLE` - The mount summary is not applicable for this HyperFlex storage container. * `MOUNTED` - The HyperFlex storage container is mounted. * `UNMOUNTED` - The HyperFlex storage container is unmounted. * `MOUNT_FAILURE` - The HyperFlex storage container mount summary is failure. * `UNMOUNT_FAILURE` - The HyperFlex storage container unmount summary is failure.. [optional] if omitted the server will use the default value of "NOT_APPLICABLE"  # noqa: E501
            provisioned_capacity (int): Provisioned capacity of the storage container in bytes.. [optional]  # noqa: E501
            provisioned_volume_capacity_utilization (float): Provisioned capacity utilization of all volumes associated with the storage container.. [optional]  # noqa: E501
            type (str): Storage container type (SMB/NFS/iSCSI). * `NFS` - Storage container created/accesed through NFS protocol. * `SMB` - Storage container created/accessed through SMB protocol. * `iSCSI` - Storage container created/accessed through iSCSI protocol.. [optional] if omitted the server will use the default value of "NFS"  # noqa: E501
            un_compressed_used_bytes (int): Uncompressed bytes on storage container.. [optional]  # noqa: E501
            uuid (str): UUID of the datastore/storage container.. [optional]  # noqa: E501
            volume_count (int): Number of volumes associated with the storage container.. [optional]  # noqa: E501
            cluster (HyperflexClusterRelationship): [optional]  # noqa: E501
            volumes ([HyperflexVolumeRelationship], none_type): An array of relationships to hyperflexVolume resources.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "hyperflex.StorageContainer")
        object_type = kwargs.get('object_type', "hyperflex.StorageContainer")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
