"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-7766
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.compute_alarm_summary import ComputeAlarmSummary
    from intersight.model.compute_ip_address import ComputeIpAddress
    from intersight.model.equipment_chassis_relationship import EquipmentChassisRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['ComputeAlarmSummary'] = ComputeAlarmSummary
    globals()['ComputeIpAddress'] = ComputeIpAddress
    globals()['EquipmentChassisRelationship'] = EquipmentChassisRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship


class ComputePhysicalSummaryAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'COMPUTE.PHYSICALSUMMARY': "compute.PhysicalSummary",
        },
        ('object_type',): {
            'COMPUTE.PHYSICALSUMMARY': "compute.PhysicalSummary",
        },
        ('management_mode',): {
            'INTERSIGHTSTANDALONE': "IntersightStandalone",
            'UCSM': "UCSM",
            'INTERSIGHT': "Intersight",
        },
        ('oper_reason',): {
            'None': None,
            'UNKNOWN': "Unknown",
            'WILLBOOTERROR': "WillBootError",
            'MEMORYINOPERABLE': "MemoryInoperable",
            'PROCESSORINOPERABLE': "ProcessorInoperable",
            'DEPRECATEDADAPTER': "DeprecatedAdapter",
            'PCINODEINSERTED': "PciNodeInserted",
            'PCINODEREMOVED': "PciNodeRemoved",
            'POWERCYCLEREQUIRED': "PowerCycleRequired",
            'POWERONREQUIRED': "PowerOnRequired",
            'PCIENODEUNSUPPORTED': "PCIeNodeUnsupported",
            'PCIENODEUNIDENTIFIED': "PCIeNodeUnidentified",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'admin_power_state': (str,),  # noqa: E501
            'alarm_summary': (ComputeAlarmSummary,),  # noqa: E501
            'asset_tag': (str,),  # noqa: E501
            'available_memory': (int,),  # noqa: E501
            'bios_post_complete': (bool,),  # noqa: E501
            'chassis_id': (str,),  # noqa: E501
            'connection_status': (str,),  # noqa: E501
            'cpu_capacity': (float,),  # noqa: E501
            'device_mo_id': (str,),  # noqa: E501
            'dn': (str,),  # noqa: E501
            'fault_summary': (int,),  # noqa: E501
            'firmware': (str,),  # noqa: E501
            'hardware_uuid': (str,),  # noqa: E501
            'ipv4_address': (str,),  # noqa: E501
            'kvm_ip_addresses': ([ComputeIpAddress], none_type,),  # noqa: E501
            'kvm_server_state_enabled': (bool,),  # noqa: E501
            'kvm_vendor': (str,),  # noqa: E501
            'management_mode': (str,),  # noqa: E501
            'memory_speed': (str,),  # noqa: E501
            'mgmt_ip_address': (str,),  # noqa: E501
            'model': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'num_adaptors': (int,),  # noqa: E501
            'num_cpu_cores': (int,),  # noqa: E501
            'num_cpu_cores_enabled': (int,),  # noqa: E501
            'num_cpus': (int,),  # noqa: E501
            'num_eth_host_interfaces': (int,),  # noqa: E501
            'num_fc_host_interfaces': (int,),  # noqa: E501
            'num_threads': (int,),  # noqa: E501
            'oper_power_state': (str,),  # noqa: E501
            'oper_reason': ([str], none_type,),  # noqa: E501
            'oper_state': (str,),  # noqa: E501
            'operability': (str,),  # noqa: E501
            'personality': (str,),  # noqa: E501
            'platform_type': (str,),  # noqa: E501
            'presence': (str,),  # noqa: E501
            'revision': (str,),  # noqa: E501
            'rn': (str,),  # noqa: E501
            'scaled_mode': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'server_id': (int,),  # noqa: E501
            'service_profile': (str,),  # noqa: E501
            'slot_id': (int,),  # noqa: E501
            'source_object_type': (str,),  # noqa: E501
            'topology_scan_status': (str,),  # noqa: E501
            'total_memory': (int,),  # noqa: E501
            'tunneled_kvm': (bool,),  # noqa: E501
            'user_label': (str,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'equipment_chassis': (EquipmentChassisRelationship,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'admin_power_state': 'AdminPowerState',  # noqa: E501
        'alarm_summary': 'AlarmSummary',  # noqa: E501
        'asset_tag': 'AssetTag',  # noqa: E501
        'available_memory': 'AvailableMemory',  # noqa: E501
        'bios_post_complete': 'BiosPostComplete',  # noqa: E501
        'chassis_id': 'ChassisId',  # noqa: E501
        'connection_status': 'ConnectionStatus',  # noqa: E501
        'cpu_capacity': 'CpuCapacity',  # noqa: E501
        'device_mo_id': 'DeviceMoId',  # noqa: E501
        'dn': 'Dn',  # noqa: E501
        'fault_summary': 'FaultSummary',  # noqa: E501
        'firmware': 'Firmware',  # noqa: E501
        'hardware_uuid': 'HardwareUuid',  # noqa: E501
        'ipv4_address': 'Ipv4Address',  # noqa: E501
        'kvm_ip_addresses': 'KvmIpAddresses',  # noqa: E501
        'kvm_server_state_enabled': 'KvmServerStateEnabled',  # noqa: E501
        'kvm_vendor': 'KvmVendor',  # noqa: E501
        'management_mode': 'ManagementMode',  # noqa: E501
        'memory_speed': 'MemorySpeed',  # noqa: E501
        'mgmt_ip_address': 'MgmtIpAddress',  # noqa: E501
        'model': 'Model',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'num_adaptors': 'NumAdaptors',  # noqa: E501
        'num_cpu_cores': 'NumCpuCores',  # noqa: E501
        'num_cpu_cores_enabled': 'NumCpuCoresEnabled',  # noqa: E501
        'num_cpus': 'NumCpus',  # noqa: E501
        'num_eth_host_interfaces': 'NumEthHostInterfaces',  # noqa: E501
        'num_fc_host_interfaces': 'NumFcHostInterfaces',  # noqa: E501
        'num_threads': 'NumThreads',  # noqa: E501
        'oper_power_state': 'OperPowerState',  # noqa: E501
        'oper_reason': 'OperReason',  # noqa: E501
        'oper_state': 'OperState',  # noqa: E501
        'operability': 'Operability',  # noqa: E501
        'personality': 'Personality',  # noqa: E501
        'platform_type': 'PlatformType',  # noqa: E501
        'presence': 'Presence',  # noqa: E501
        'revision': 'Revision',  # noqa: E501
        'rn': 'Rn',  # noqa: E501
        'scaled_mode': 'ScaledMode',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'server_id': 'ServerId',  # noqa: E501
        'service_profile': 'ServiceProfile',  # noqa: E501
        'slot_id': 'SlotId',  # noqa: E501
        'source_object_type': 'SourceObjectType',  # noqa: E501
        'topology_scan_status': 'TopologyScanStatus',  # noqa: E501
        'total_memory': 'TotalMemory',  # noqa: E501
        'tunneled_kvm': 'TunneledKvm',  # noqa: E501
        'user_label': 'UserLabel',  # noqa: E501
        'uuid': 'Uuid',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'equipment_chassis': 'EquipmentChassis',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
    }

    read_only_vars = {
        'admin_power_state',  # noqa: E501
        'asset_tag',  # noqa: E501
        'available_memory',  # noqa: E501
        'bios_post_complete',  # noqa: E501
        'chassis_id',  # noqa: E501
        'connection_status',  # noqa: E501
        'cpu_capacity',  # noqa: E501
        'device_mo_id',  # noqa: E501
        'dn',  # noqa: E501
        'fault_summary',  # noqa: E501
        'firmware',  # noqa: E501
        'hardware_uuid',  # noqa: E501
        'ipv4_address',  # noqa: E501
        'kvm_server_state_enabled',  # noqa: E501
        'kvm_vendor',  # noqa: E501
        'management_mode',  # noqa: E501
        'memory_speed',  # noqa: E501
        'mgmt_ip_address',  # noqa: E501
        'model',  # noqa: E501
        'name',  # noqa: E501
        'num_adaptors',  # noqa: E501
        'num_cpu_cores',  # noqa: E501
        'num_cpu_cores_enabled',  # noqa: E501
        'num_cpus',  # noqa: E501
        'num_eth_host_interfaces',  # noqa: E501
        'num_fc_host_interfaces',  # noqa: E501
        'num_threads',  # noqa: E501
        'oper_power_state',  # noqa: E501
        'oper_state',  # noqa: E501
        'operability',  # noqa: E501
        'personality',  # noqa: E501
        'platform_type',  # noqa: E501
        'presence',  # noqa: E501
        'revision',  # noqa: E501
        'rn',  # noqa: E501
        'scaled_mode',  # noqa: E501
        'serial',  # noqa: E501
        'server_id',  # noqa: E501
        'service_profile',  # noqa: E501
        'slot_id',  # noqa: E501
        'source_object_type',  # noqa: E501
        'topology_scan_status',  # noqa: E501
        'total_memory',  # noqa: E501
        'tunneled_kvm',  # noqa: E501
        'user_label',  # noqa: E501
        'uuid',  # noqa: E501
        'vendor',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """ComputePhysicalSummaryAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "compute.PhysicalSummary", must be one of ["compute.PhysicalSummary", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "compute.PhysicalSummary", must be one of ["compute.PhysicalSummary", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_power_state (str): The desired power state of the server.. [optional]  # noqa: E501
            alarm_summary (ComputeAlarmSummary): [optional]  # noqa: E501
            asset_tag (str): The user defined asset tag assigned to the server.. [optional]  # noqa: E501
            available_memory (int): The amount of memory available on the server.. [optional]  # noqa: E501
            bios_post_complete (bool): The BIOS POST completion status of the server.. [optional]  # noqa: E501
            chassis_id (str): The id of the chassis that the blade is discovered in.. [optional]  # noqa: E501
            connection_status (str): Connectivity Status of RackUnit to Switch - A or B or AB.. [optional]  # noqa: E501
            cpu_capacity (float): CPU Capacity = Number of CPU Sockets x Enabled Cores x Speed (GHz).. [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            fault_summary (int): The fault summary for the server.. [optional]  # noqa: E501
            firmware (str): The firmware version of the Cisco Integrated Management Controller (CIMC) for this server.. [optional]  # noqa: E501
            hardware_uuid (str): The universally unique hardware identity of the server provided by the manufacturer.. [optional]  # noqa: E501
            ipv4_address (str): The IPv4 address configured on the management interface of the Integrated Management Controller.. [optional]  # noqa: E501
            kvm_ip_addresses ([ComputeIpAddress], none_type): [optional]  # noqa: E501
            kvm_server_state_enabled (bool): The KVM server state of the server.. [optional]  # noqa: E501
            kvm_vendor (str): The KVM Vendor for the server.. [optional]  # noqa: E501
            management_mode (str): The management mode of the server. * `IntersightStandalone` - Intersight Standalone mode of operation. * `UCSM` - Unified Computing System Manager mode of operation. * `Intersight` - Intersight managed mode of operation.. [optional] if omitted the server will use the default value of "IntersightStandalone"  # noqa: E501
            memory_speed (str): The maximum memory speed in MHz available on the server.. [optional]  # noqa: E501
            mgmt_ip_address (str): Management address of the server.. [optional]  # noqa: E501
            model (str): This field identifies the model of the given component.. [optional]  # noqa: E501
            name (str): The name of the UCS Fabric Interconnect cluster or Cisco Integrated Management Controller (CIMC). When this server is attached to a UCS Fabric Interconnect, the value of this property is the name of the UCS Fabric Interconnect along with chassis/server Id. When this server configured in standalone mode, the value of this property is the name of the Cisco Integrated Management Controller. when this server is configired in IMM mode, the value of this property contains model and chassis/server Id.. [optional]  # noqa: E501
            num_adaptors (int): The total number of network adapters present on the server.. [optional]  # noqa: E501
            num_cpu_cores (int): The total number of CPU cores present on the server.. [optional]  # noqa: E501
            num_cpu_cores_enabled (int): The total number of CPU cores enabled on the server.. [optional]  # noqa: E501
            num_cpus (int): The total number of CPUs present on the server.. [optional]  # noqa: E501
            num_eth_host_interfaces (int): The total number of vNICs which are visible to a host on the server.. [optional]  # noqa: E501
            num_fc_host_interfaces (int): The total number of vHBAs which are visible to a host on the server.. [optional]  # noqa: E501
            num_threads (int): The total number of threads the server is capable of handling.. [optional]  # noqa: E501
            oper_power_state (str): The actual power state of the server.. [optional]  # noqa: E501
            oper_reason ([str], none_type): [optional]  # noqa: E501
            oper_state (str): The operational state of the server.. [optional]  # noqa: E501
            operability (str): The operability of the server.. [optional]  # noqa: E501
            personality (str): The Rack unit software Personality.. [optional]  # noqa: E501
            platform_type (str): The platform type of the registered device - whether managed by UCSM or operating in standalone mode.. [optional]  # noqa: E501
            presence (str): This field identifies the presence (equipped) or absence of the given component.. [optional]  # noqa: E501
            revision (str): This field identifies the revision of the given component.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            scaled_mode (str): The mode of the server that determines it is scaled.. [optional]  # noqa: E501
            serial (str): This field identifies the serial of the given component.. [optional]  # noqa: E501
            server_id (int): RackUnit ID that uniquely identifies the server.. [optional]  # noqa: E501
            service_profile (str): The distinguished name of the service profile to which the server is associated to. It is applicable only for servers which are managed via UCSM.. [optional]  # noqa: E501
            slot_id (int): The slot number in the chassis that the blade is discovered in.. [optional]  # noqa: E501
            source_object_type (str): The source object type of this view MO.. [optional]  # noqa: E501
            topology_scan_status (str): To maintain the Topology workflow run status.. [optional]  # noqa: E501
            total_memory (int): The total memory available on the server.. [optional]  # noqa: E501
            tunneled_kvm (bool): The Tunneled vKVM status of the server.. [optional]  # noqa: E501
            user_label (str): The user defined label assigned to the server.. [optional]  # noqa: E501
            uuid (str): The universally unique identity of the server.. [optional]  # noqa: E501
            vendor (str): This field identifies the vendor of the given component.. [optional]  # noqa: E501
            equipment_chassis (EquipmentChassisRelationship): [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "compute.PhysicalSummary")
        object_type = kwargs.get('object_type', "compute.PhysicalSummary")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """ComputePhysicalSummaryAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "compute.PhysicalSummary", must be one of ["compute.PhysicalSummary", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "compute.PhysicalSummary", must be one of ["compute.PhysicalSummary", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_power_state (str): The desired power state of the server.. [optional]  # noqa: E501
            alarm_summary (ComputeAlarmSummary): [optional]  # noqa: E501
            asset_tag (str): The user defined asset tag assigned to the server.. [optional]  # noqa: E501
            available_memory (int): The amount of memory available on the server.. [optional]  # noqa: E501
            bios_post_complete (bool): The BIOS POST completion status of the server.. [optional]  # noqa: E501
            chassis_id (str): The id of the chassis that the blade is discovered in.. [optional]  # noqa: E501
            connection_status (str): Connectivity Status of RackUnit to Switch - A or B or AB.. [optional]  # noqa: E501
            cpu_capacity (float): CPU Capacity = Number of CPU Sockets x Enabled Cores x Speed (GHz).. [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            fault_summary (int): The fault summary for the server.. [optional]  # noqa: E501
            firmware (str): The firmware version of the Cisco Integrated Management Controller (CIMC) for this server.. [optional]  # noqa: E501
            hardware_uuid (str): The universally unique hardware identity of the server provided by the manufacturer.. [optional]  # noqa: E501
            ipv4_address (str): The IPv4 address configured on the management interface of the Integrated Management Controller.. [optional]  # noqa: E501
            kvm_ip_addresses ([ComputeIpAddress], none_type): [optional]  # noqa: E501
            kvm_server_state_enabled (bool): The KVM server state of the server.. [optional]  # noqa: E501
            kvm_vendor (str): The KVM Vendor for the server.. [optional]  # noqa: E501
            management_mode (str): The management mode of the server. * `IntersightStandalone` - Intersight Standalone mode of operation. * `UCSM` - Unified Computing System Manager mode of operation. * `Intersight` - Intersight managed mode of operation.. [optional] if omitted the server will use the default value of "IntersightStandalone"  # noqa: E501
            memory_speed (str): The maximum memory speed in MHz available on the server.. [optional]  # noqa: E501
            mgmt_ip_address (str): Management address of the server.. [optional]  # noqa: E501
            model (str): This field identifies the model of the given component.. [optional]  # noqa: E501
            name (str): The name of the UCS Fabric Interconnect cluster or Cisco Integrated Management Controller (CIMC). When this server is attached to a UCS Fabric Interconnect, the value of this property is the name of the UCS Fabric Interconnect along with chassis/server Id. When this server configured in standalone mode, the value of this property is the name of the Cisco Integrated Management Controller. when this server is configired in IMM mode, the value of this property contains model and chassis/server Id.. [optional]  # noqa: E501
            num_adaptors (int): The total number of network adapters present on the server.. [optional]  # noqa: E501
            num_cpu_cores (int): The total number of CPU cores present on the server.. [optional]  # noqa: E501
            num_cpu_cores_enabled (int): The total number of CPU cores enabled on the server.. [optional]  # noqa: E501
            num_cpus (int): The total number of CPUs present on the server.. [optional]  # noqa: E501
            num_eth_host_interfaces (int): The total number of vNICs which are visible to a host on the server.. [optional]  # noqa: E501
            num_fc_host_interfaces (int): The total number of vHBAs which are visible to a host on the server.. [optional]  # noqa: E501
            num_threads (int): The total number of threads the server is capable of handling.. [optional]  # noqa: E501
            oper_power_state (str): The actual power state of the server.. [optional]  # noqa: E501
            oper_reason ([str], none_type): [optional]  # noqa: E501
            oper_state (str): The operational state of the server.. [optional]  # noqa: E501
            operability (str): The operability of the server.. [optional]  # noqa: E501
            personality (str): The Rack unit software Personality.. [optional]  # noqa: E501
            platform_type (str): The platform type of the registered device - whether managed by UCSM or operating in standalone mode.. [optional]  # noqa: E501
            presence (str): This field identifies the presence (equipped) or absence of the given component.. [optional]  # noqa: E501
            revision (str): This field identifies the revision of the given component.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            scaled_mode (str): The mode of the server that determines it is scaled.. [optional]  # noqa: E501
            serial (str): This field identifies the serial of the given component.. [optional]  # noqa: E501
            server_id (int): RackUnit ID that uniquely identifies the server.. [optional]  # noqa: E501
            service_profile (str): The distinguished name of the service profile to which the server is associated to. It is applicable only for servers which are managed via UCSM.. [optional]  # noqa: E501
            slot_id (int): The slot number in the chassis that the blade is discovered in.. [optional]  # noqa: E501
            source_object_type (str): The source object type of this view MO.. [optional]  # noqa: E501
            topology_scan_status (str): To maintain the Topology workflow run status.. [optional]  # noqa: E501
            total_memory (int): The total memory available on the server.. [optional]  # noqa: E501
            tunneled_kvm (bool): The Tunneled vKVM status of the server.. [optional]  # noqa: E501
            user_label (str): The user defined label assigned to the server.. [optional]  # noqa: E501
            uuid (str): The universally unique identity of the server.. [optional]  # noqa: E501
            vendor (str): This field identifies the vendor of the given component.. [optional]  # noqa: E501
            equipment_chassis (EquipmentChassisRelationship): [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "compute.PhysicalSummary")
        object_type = kwargs.get('object_type', "compute.PhysicalSummary")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
