"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-7766
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.adapter_unit_relationship import AdapterUnitRelationship
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.bios_boot_mode_relationship import BiosBootModeRelationship
    from intersight.model.bios_token_settings_relationship import BiosTokenSettingsRelationship
    from intersight.model.bios_unit_relationship import BiosUnitRelationship
    from intersight.model.bios_vf_select_memory_ras_configuration_relationship import BiosVfSelectMemoryRasConfigurationRelationship
    from intersight.model.boot_device_boot_mode_relationship import BootDeviceBootModeRelationship
    from intersight.model.compute_board_relationship import ComputeBoardRelationship
    from intersight.model.equipment_chassis_relationship import EquipmentChassisRelationship
    from intersight.model.equipment_io_expander_relationship import EquipmentIoExpanderRelationship
    from intersight.model.equipment_locator_led_relationship import EquipmentLocatorLedRelationship
    from intersight.model.graphics_card_relationship import GraphicsCardRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    from intersight.model.inventory_generic_inventory_holder_relationship import InventoryGenericInventoryHolderRelationship
    from intersight.model.management_controller_relationship import ManagementControllerRelationship
    from intersight.model.memory_array_relationship import MemoryArrayRelationship
    from intersight.model.pci_device_relationship import PciDeviceRelationship
    from intersight.model.pci_node_relationship import PciNodeRelationship
    from intersight.model.processor_unit_relationship import ProcessorUnitRelationship
    from intersight.model.storage_controller_relationship import StorageControllerRelationship
    from intersight.model.storage_enclosure_relationship import StorageEnclosureRelationship
    from intersight.model.top_system_relationship import TopSystemRelationship
    globals()['AdapterUnitRelationship'] = AdapterUnitRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['BiosBootModeRelationship'] = BiosBootModeRelationship
    globals()['BiosTokenSettingsRelationship'] = BiosTokenSettingsRelationship
    globals()['BiosUnitRelationship'] = BiosUnitRelationship
    globals()['BiosVfSelectMemoryRasConfigurationRelationship'] = BiosVfSelectMemoryRasConfigurationRelationship
    globals()['BootDeviceBootModeRelationship'] = BootDeviceBootModeRelationship
    globals()['ComputeBoardRelationship'] = ComputeBoardRelationship
    globals()['EquipmentChassisRelationship'] = EquipmentChassisRelationship
    globals()['EquipmentIoExpanderRelationship'] = EquipmentIoExpanderRelationship
    globals()['EquipmentLocatorLedRelationship'] = EquipmentLocatorLedRelationship
    globals()['GraphicsCardRelationship'] = GraphicsCardRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship
    globals()['InventoryGenericInventoryHolderRelationship'] = InventoryGenericInventoryHolderRelationship
    globals()['ManagementControllerRelationship'] = ManagementControllerRelationship
    globals()['MemoryArrayRelationship'] = MemoryArrayRelationship
    globals()['PciDeviceRelationship'] = PciDeviceRelationship
    globals()['PciNodeRelationship'] = PciNodeRelationship
    globals()['ProcessorUnitRelationship'] = ProcessorUnitRelationship
    globals()['StorageControllerRelationship'] = StorageControllerRelationship
    globals()['StorageEnclosureRelationship'] = StorageEnclosureRelationship
    globals()['TopSystemRelationship'] = TopSystemRelationship


class ComputeBladeAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'COMPUTE.BLADE': "compute.Blade",
        },
        ('object_type',): {
            'COMPUTE.BLADE': "compute.Blade",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'chassis_id': (str,),  # noqa: E501
            'scaled_mode': (str,),  # noqa: E501
            'slot_id': (int,),  # noqa: E501
            'adapters': ([AdapterUnitRelationship], none_type,),  # noqa: E501
            'bios_bootmode': (BiosBootModeRelationship,),  # noqa: E501
            'bios_token_settings': (BiosTokenSettingsRelationship,),  # noqa: E501
            'bios_units': ([BiosUnitRelationship], none_type,),  # noqa: E501
            'bios_vf_select_memory_ras_configuration': (BiosVfSelectMemoryRasConfigurationRelationship,),  # noqa: E501
            'bmc': (ManagementControllerRelationship,),  # noqa: E501
            'board': (ComputeBoardRelationship,),  # noqa: E501
            'boot_device_bootmode': (BootDeviceBootModeRelationship,),  # noqa: E501
            'equipment_chassis': (EquipmentChassisRelationship,),  # noqa: E501
            'equipment_io_expanders': ([EquipmentIoExpanderRelationship], none_type,),  # noqa: E501
            'generic_inventory_holders': ([InventoryGenericInventoryHolderRelationship], none_type,),  # noqa: E501
            'graphics_cards': ([GraphicsCardRelationship], none_type,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'locator_led': (EquipmentLocatorLedRelationship,),  # noqa: E501
            'memory_arrays': ([MemoryArrayRelationship], none_type,),  # noqa: E501
            'pci_devices': ([PciDeviceRelationship], none_type,),  # noqa: E501
            'pci_nodes': ([PciNodeRelationship], none_type,),  # noqa: E501
            'processors': ([ProcessorUnitRelationship], none_type,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'storage_controllers': ([StorageControllerRelationship], none_type,),  # noqa: E501
            'storage_enclosures': ([StorageEnclosureRelationship], none_type,),  # noqa: E501
            'top_system': (TopSystemRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'chassis_id': 'ChassisId',  # noqa: E501
        'scaled_mode': 'ScaledMode',  # noqa: E501
        'slot_id': 'SlotId',  # noqa: E501
        'adapters': 'Adapters',  # noqa: E501
        'bios_bootmode': 'BiosBootmode',  # noqa: E501
        'bios_token_settings': 'BiosTokenSettings',  # noqa: E501
        'bios_units': 'BiosUnits',  # noqa: E501
        'bios_vf_select_memory_ras_configuration': 'BiosVfSelectMemoryRasConfiguration',  # noqa: E501
        'bmc': 'Bmc',  # noqa: E501
        'board': 'Board',  # noqa: E501
        'boot_device_bootmode': 'BootDeviceBootmode',  # noqa: E501
        'equipment_chassis': 'EquipmentChassis',  # noqa: E501
        'equipment_io_expanders': 'EquipmentIoExpanders',  # noqa: E501
        'generic_inventory_holders': 'GenericInventoryHolders',  # noqa: E501
        'graphics_cards': 'GraphicsCards',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'locator_led': 'LocatorLed',  # noqa: E501
        'memory_arrays': 'MemoryArrays',  # noqa: E501
        'pci_devices': 'PciDevices',  # noqa: E501
        'pci_nodes': 'PciNodes',  # noqa: E501
        'processors': 'Processors',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'storage_controllers': 'StorageControllers',  # noqa: E501
        'storage_enclosures': 'StorageEnclosures',  # noqa: E501
        'top_system': 'TopSystem',  # noqa: E501
    }

    read_only_vars = {
        'chassis_id',  # noqa: E501
        'scaled_mode',  # noqa: E501
        'slot_id',  # noqa: E501
        'adapters',  # noqa: E501
        'bios_units',  # noqa: E501
        'equipment_io_expanders',  # noqa: E501
        'generic_inventory_holders',  # noqa: E501
        'pci_devices',  # noqa: E501
        'pci_nodes',  # noqa: E501
        'storage_enclosures',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """ComputeBladeAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "compute.Blade", must be one of ["compute.Blade", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "compute.Blade", must be one of ["compute.Blade", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            chassis_id (str): The id of the chassis that the blade is discovered in.. [optional]  # noqa: E501
            scaled_mode (str): The mode of the server that determines it is scaled.. [optional]  # noqa: E501
            slot_id (int): The slot number in the chassis that the blade is discovered in.. [optional]  # noqa: E501
            adapters ([AdapterUnitRelationship], none_type): An array of relationships to adapterUnit resources.. [optional]  # noqa: E501
            bios_bootmode (BiosBootModeRelationship): [optional]  # noqa: E501
            bios_token_settings (BiosTokenSettingsRelationship): [optional]  # noqa: E501
            bios_units ([BiosUnitRelationship], none_type): An array of relationships to biosUnit resources.. [optional]  # noqa: E501
            bios_vf_select_memory_ras_configuration (BiosVfSelectMemoryRasConfigurationRelationship): [optional]  # noqa: E501
            bmc (ManagementControllerRelationship): [optional]  # noqa: E501
            board (ComputeBoardRelationship): [optional]  # noqa: E501
            boot_device_bootmode (BootDeviceBootModeRelationship): [optional]  # noqa: E501
            equipment_chassis (EquipmentChassisRelationship): [optional]  # noqa: E501
            equipment_io_expanders ([EquipmentIoExpanderRelationship], none_type): An array of relationships to equipmentIoExpander resources.. [optional]  # noqa: E501
            generic_inventory_holders ([InventoryGenericInventoryHolderRelationship], none_type): An array of relationships to inventoryGenericInventoryHolder resources.. [optional]  # noqa: E501
            graphics_cards ([GraphicsCardRelationship], none_type): An array of relationships to graphicsCard resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            locator_led (EquipmentLocatorLedRelationship): [optional]  # noqa: E501
            memory_arrays ([MemoryArrayRelationship], none_type): An array of relationships to memoryArray resources.. [optional]  # noqa: E501
            pci_devices ([PciDeviceRelationship], none_type): An array of relationships to pciDevice resources.. [optional]  # noqa: E501
            pci_nodes ([PciNodeRelationship], none_type): An array of relationships to pciNode resources.. [optional]  # noqa: E501
            processors ([ProcessorUnitRelationship], none_type): An array of relationships to processorUnit resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            storage_controllers ([StorageControllerRelationship], none_type): An array of relationships to storageController resources.. [optional]  # noqa: E501
            storage_enclosures ([StorageEnclosureRelationship], none_type): An array of relationships to storageEnclosure resources.. [optional]  # noqa: E501
            top_system (TopSystemRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "compute.Blade")
        object_type = kwargs.get('object_type', "compute.Blade")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """ComputeBladeAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "compute.Blade", must be one of ["compute.Blade", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "compute.Blade", must be one of ["compute.Blade", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            chassis_id (str): The id of the chassis that the blade is discovered in.. [optional]  # noqa: E501
            scaled_mode (str): The mode of the server that determines it is scaled.. [optional]  # noqa: E501
            slot_id (int): The slot number in the chassis that the blade is discovered in.. [optional]  # noqa: E501
            adapters ([AdapterUnitRelationship], none_type): An array of relationships to adapterUnit resources.. [optional]  # noqa: E501
            bios_bootmode (BiosBootModeRelationship): [optional]  # noqa: E501
            bios_token_settings (BiosTokenSettingsRelationship): [optional]  # noqa: E501
            bios_units ([BiosUnitRelationship], none_type): An array of relationships to biosUnit resources.. [optional]  # noqa: E501
            bios_vf_select_memory_ras_configuration (BiosVfSelectMemoryRasConfigurationRelationship): [optional]  # noqa: E501
            bmc (ManagementControllerRelationship): [optional]  # noqa: E501
            board (ComputeBoardRelationship): [optional]  # noqa: E501
            boot_device_bootmode (BootDeviceBootModeRelationship): [optional]  # noqa: E501
            equipment_chassis (EquipmentChassisRelationship): [optional]  # noqa: E501
            equipment_io_expanders ([EquipmentIoExpanderRelationship], none_type): An array of relationships to equipmentIoExpander resources.. [optional]  # noqa: E501
            generic_inventory_holders ([InventoryGenericInventoryHolderRelationship], none_type): An array of relationships to inventoryGenericInventoryHolder resources.. [optional]  # noqa: E501
            graphics_cards ([GraphicsCardRelationship], none_type): An array of relationships to graphicsCard resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            locator_led (EquipmentLocatorLedRelationship): [optional]  # noqa: E501
            memory_arrays ([MemoryArrayRelationship], none_type): An array of relationships to memoryArray resources.. [optional]  # noqa: E501
            pci_devices ([PciDeviceRelationship], none_type): An array of relationships to pciDevice resources.. [optional]  # noqa: E501
            pci_nodes ([PciNodeRelationship], none_type): An array of relationships to pciNode resources.. [optional]  # noqa: E501
            processors ([ProcessorUnitRelationship], none_type): An array of relationships to processorUnit resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            storage_controllers ([StorageControllerRelationship], none_type): An array of relationships to storageController resources.. [optional]  # noqa: E501
            storage_enclosures ([StorageEnclosureRelationship], none_type): An array of relationships to storageEnclosure resources.. [optional]  # noqa: E501
            top_system (TopSystemRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "compute.Blade")
        object_type = kwargs.get('object_type', "compute.Blade")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
