"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-7766
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.cloud_availability_zone import CloudAvailabilityZone
    from intersight.model.cloud_aws_subnet import CloudAwsSubnet
    from intersight.model.cloud_aws_vpc_relationship import CloudAwsVpcRelationship
    from intersight.model.cloud_billing_unit import CloudBillingUnit
    from intersight.model.cloud_cloud_region import CloudCloudRegion
    from intersight.model.cloud_cloud_tag import CloudCloudTag
    from intersight.model.display_names import DisplayNames
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_mo_ref import MoMoRef
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['CloudAvailabilityZone'] = CloudAvailabilityZone
    globals()['CloudAwsSubnet'] = CloudAwsSubnet
    globals()['CloudAwsVpcRelationship'] = CloudAwsVpcRelationship
    globals()['CloudBillingUnit'] = CloudBillingUnit
    globals()['CloudCloudRegion'] = CloudCloudRegion
    globals()['CloudCloudTag'] = CloudCloudTag
    globals()['DisplayNames'] = DisplayNames
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoMoRef'] = MoMoRef
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext


class CloudAwsSubnetRelationship(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'MO.MOREF': "mo.MoRef",
        },
        ('object_type',): {
            'AAA.AUDITRECORD': "aaa.AuditRecord",
            'AAA.RETENTIONCONFIG': "aaa.RetentionConfig",
            'AAA.RETENTIONPOLICY': "aaa.RetentionPolicy",
            'ACCESS.POLICY': "access.Policy",
            'ACCESS.POLICYINVENTORY': "access.PolicyInventory",
            'ADAPTER.CONFIGPOLICY': "adapter.ConfigPolicy",
            'ADAPTER.EXTETHINTERFACE': "adapter.ExtEthInterface",
            'ADAPTER.HOSTETHINTERFACE': "adapter.HostEthInterface",
            'ADAPTER.HOSTFCINTERFACE': "adapter.HostFcInterface",
            'ADAPTER.HOSTISCSIINTERFACE': "adapter.HostIscsiInterface",
            'ADAPTER.UNIT': "adapter.Unit",
            'ADAPTER.UNITEXPANDER': "adapter.UnitExpander",
            'APPLIANCE.APPSTATUS': "appliance.AppStatus",
            'APPLIANCE.AUTORMAPOLICY': "appliance.AutoRmaPolicy",
            'APPLIANCE.BACKUP': "appliance.Backup",
            'APPLIANCE.BACKUPPOLICY': "appliance.BackupPolicy",
            'APPLIANCE.CERTIFICATESETTING': "appliance.CertificateSetting",
            'APPLIANCE.DATAEXPORTPOLICY': "appliance.DataExportPolicy",
            'APPLIANCE.DEVICECERTIFICATE': "appliance.DeviceCertificate",
            'APPLIANCE.DEVICECLAIM': "appliance.DeviceClaim",
            'APPLIANCE.DEVICEUPGRADEPOLICY': "appliance.DeviceUpgradePolicy",
            'APPLIANCE.DIAGSETTING': "appliance.DiagSetting",
            'APPLIANCE.EXTERNALSYSLOGSETTING': "appliance.ExternalSyslogSetting",
            'APPLIANCE.FILEGATEWAY': "appliance.FileGateway",
            'APPLIANCE.FILESYSTEMSTATUS': "appliance.FileSystemStatus",
            'APPLIANCE.GROUPSTATUS': "appliance.GroupStatus",
            'APPLIANCE.IMAGEBUNDLE': "appliance.ImageBundle",
            'APPLIANCE.METAMANIFEST': "appliance.MetaManifest",
            'APPLIANCE.NODEINFO': "appliance.NodeInfo",
            'APPLIANCE.NODESTATUS': "appliance.NodeStatus",
            'APPLIANCE.RELEASENOTE': "appliance.ReleaseNote",
            'APPLIANCE.REMOTEFILEIMPORT': "appliance.RemoteFileImport",
            'APPLIANCE.RESTORE': "appliance.Restore",
            'APPLIANCE.SETUPINFO': "appliance.SetupInfo",
            'APPLIANCE.SYSTEMINFO': "appliance.SystemInfo",
            'APPLIANCE.SYSTEMSTATUS': "appliance.SystemStatus",
            'APPLIANCE.UPGRADE': "appliance.Upgrade",
            'APPLIANCE.UPGRADEPOLICY': "appliance.UpgradePolicy",
            'ASSET.CLUSTERMEMBER': "asset.ClusterMember",
            'ASSET.DEPLOYMENT': "asset.Deployment",
            'ASSET.DEPLOYMENTDEVICE': "asset.DeploymentDevice",
            'ASSET.DEVICECLAIM': "asset.DeviceClaim",
            'ASSET.DEVICECONFIGURATION': "asset.DeviceConfiguration",
            'ASSET.DEVICECONNECTORMANAGER': "asset.DeviceConnectorManager",
            'ASSET.DEVICECONTRACTINFORMATION': "asset.DeviceContractInformation",
            'ASSET.DEVICECONTRACTNOTIFICATION': "asset.DeviceContractNotification",
            'ASSET.DEVICEREGISTRATION': "asset.DeviceRegistration",
            'ASSET.SUBSCRIPTION': "asset.Subscription",
            'ASSET.SUBSCRIPTIONACCOUNT': "asset.SubscriptionAccount",
            'ASSET.SUBSCRIPTIONDEVICECONTRACTINFORMATION': "asset.SubscriptionDeviceContractInformation",
            'ASSET.TARGET': "asset.Target",
            'BIOS.BOOTDEVICE': "bios.BootDevice",
            'BIOS.BOOTMODE': "bios.BootMode",
            'BIOS.POLICY': "bios.Policy",
            'BIOS.SYSTEMBOOTORDER': "bios.SystemBootOrder",
            'BIOS.TOKENSETTINGS': "bios.TokenSettings",
            'BIOS.UNIT': "bios.Unit",
            'BIOS.VFSELECTMEMORYRASCONFIGURATION': "bios.VfSelectMemoryRasConfiguration",
            'BOOT.CDDDEVICE': "boot.CddDevice",
            'BOOT.DEVICEBOOTMODE': "boot.DeviceBootMode",
            'BOOT.DEVICEBOOTSECURITY': "boot.DeviceBootSecurity",
            'BOOT.HDDDEVICE': "boot.HddDevice",
            'BOOT.ISCSIDEVICE': "boot.IscsiDevice",
            'BOOT.NVMEDEVICE': "boot.NvmeDevice",
            'BOOT.PCHSTORAGEDEVICE': "boot.PchStorageDevice",
            'BOOT.PRECISIONPOLICY': "boot.PrecisionPolicy",
            'BOOT.PXEDEVICE': "boot.PxeDevice",
            'BOOT.SANDEVICE': "boot.SanDevice",
            'BOOT.SDDEVICE': "boot.SdDevice",
            'BOOT.UEFISHELLDEVICE': "boot.UefiShellDevice",
            'BOOT.USBDEVICE': "boot.UsbDevice",
            'BOOT.VMEDIADEVICE': "boot.VmediaDevice",
            'BULK.EXPORT': "bulk.Export",
            'BULK.EXPORTEDITEM': "bulk.ExportedItem",
            'BULK.MOCLONER': "bulk.MoCloner",
            'BULK.MOMERGER': "bulk.MoMerger",
            'BULK.REQUEST': "bulk.Request",
            'BULK.SUBREQUESTOBJ': "bulk.SubRequestObj",
            'CAPABILITY.ADAPTERDEPRECATEDDEF': "capability.AdapterDeprecatedDef",
            'CAPABILITY.ADAPTERUNITDESCRIPTOR': "capability.AdapterUnitDescriptor",
            'CAPABILITY.CATALOG': "capability.Catalog",
            'CAPABILITY.CHASSISDESCRIPTOR': "capability.ChassisDescriptor",
            'CAPABILITY.CHASSISMANUFACTURINGDEF': "capability.ChassisManufacturingDef",
            'CAPABILITY.CIMCFIRMWAREDESCRIPTOR': "capability.CimcFirmwareDescriptor",
            'CAPABILITY.EQUIPMENTPHYSICALDEF': "capability.EquipmentPhysicalDef",
            'CAPABILITY.EQUIPMENTSLOTARRAY': "capability.EquipmentSlotArray",
            'CAPABILITY.FANMODULEDESCRIPTOR': "capability.FanModuleDescriptor",
            'CAPABILITY.FANMODULEMANUFACTURINGDEF': "capability.FanModuleManufacturingDef",
            'CAPABILITY.FEXDESCRIPTOR': "capability.FexDescriptor",
            'CAPABILITY.FEXMANUFACTURINGDEF': "capability.FexManufacturingDef",
            'CAPABILITY.IOCARDCAPABILITYDEF': "capability.IoCardCapabilityDef",
            'CAPABILITY.IOCARDDESCRIPTOR': "capability.IoCardDescriptor",
            'CAPABILITY.IOCARDMANUFACTURINGDEF': "capability.IoCardManufacturingDef",
            'CAPABILITY.PORTGROUPAGGREGATIONDEF': "capability.PortGroupAggregationDef",
            'CAPABILITY.PSUDESCRIPTOR': "capability.PsuDescriptor",
            'CAPABILITY.PSUMANUFACTURINGDEF': "capability.PsuManufacturingDef",
            'CAPABILITY.SERVERDESCRIPTOR': "capability.ServerDescriptor",
            'CAPABILITY.SERVERMODELSCAPABILITYDEF': "capability.ServerModelsCapabilityDef",
            'CAPABILITY.SERVERSCHEMADESCRIPTOR': "capability.ServerSchemaDescriptor",
            'CAPABILITY.SIOCMODULECAPABILITYDEF': "capability.SiocModuleCapabilityDef",
            'CAPABILITY.SIOCMODULEDESCRIPTOR': "capability.SiocModuleDescriptor",
            'CAPABILITY.SIOCMODULEMANUFACTURINGDEF': "capability.SiocModuleManufacturingDef",
            'CAPABILITY.SWITCHCAPABILITY': "capability.SwitchCapability",
            'CAPABILITY.SWITCHDESCRIPTOR': "capability.SwitchDescriptor",
            'CAPABILITY.SWITCHMANUFACTURINGDEF': "capability.SwitchManufacturingDef",
            'CERTIFICATEMANAGEMENT.POLICY': "certificatemanagement.Policy",
            'CERTIFICATEMANAGEMENT.POLICYINVENTORY': "certificatemanagement.PolicyInventory",
            'CHASSIS.CONFIGCHANGEDETAIL': "chassis.ConfigChangeDetail",
            'CHASSIS.CONFIGIMPORT': "chassis.ConfigImport",
            'CHASSIS.CONFIGRESULT': "chassis.ConfigResult",
            'CHASSIS.CONFIGRESULTENTRY': "chassis.ConfigResultEntry",
            'CHASSIS.IOMPROFILE': "chassis.IomProfile",
            'CHASSIS.PROFILE': "chassis.Profile",
            'CLOUD.AWSBILLINGUNIT': "cloud.AwsBillingUnit",
            'CLOUD.AWSKEYPAIR': "cloud.AwsKeyPair",
            'CLOUD.AWSNETWORKINTERFACE': "cloud.AwsNetworkInterface",
            'CLOUD.AWSORGANIZATIONALUNIT': "cloud.AwsOrganizationalUnit",
            'CLOUD.AWSSECURITYGROUP': "cloud.AwsSecurityGroup",
            'CLOUD.AWSSUBNET': "cloud.AwsSubnet",
            'CLOUD.AWSVIRTUALMACHINE': "cloud.AwsVirtualMachine",
            'CLOUD.AWSVOLUME': "cloud.AwsVolume",
            'CLOUD.AWSVPC': "cloud.AwsVpc",
            'CLOUD.COLLECTINVENTORY': "cloud.CollectInventory",
            'CLOUD.REGIONS': "cloud.Regions",
            'CLOUD.SKUCONTAINERTYPE': "cloud.SkuContainerType",
            'CLOUD.SKUDATABASETYPE': "cloud.SkuDatabaseType",
            'CLOUD.SKUINSTANCETYPE': "cloud.SkuInstanceType",
            'CLOUD.SKUNETWORKTYPE': "cloud.SkuNetworkType",
            'CLOUD.SKUREGIONRATECARDS': "cloud.SkuRegionRateCards",
            'CLOUD.SKUVOLUMETYPE': "cloud.SkuVolumeType",
            'CLOUD.TFCAGENTPOOL': "cloud.TfcAgentpool",
            'CLOUD.TFCORGANIZATION': "cloud.TfcOrganization",
            'CLOUD.TFCWORKSPACE': "cloud.TfcWorkspace",
            'COMM.HTTPPROXYPOLICY': "comm.HttpProxyPolicy",
            'COMPUTE.BLADE': "compute.Blade",
            'COMPUTE.BLADEIDENTITY': "compute.BladeIdentity",
            'COMPUTE.BOARD': "compute.Board",
            'COMPUTE.MAPPING': "compute.Mapping",
            'COMPUTE.PHYSICALSUMMARY': "compute.PhysicalSummary",
            'COMPUTE.RACKUNIT': "compute.RackUnit",
            'COMPUTE.RACKUNITIDENTITY': "compute.RackUnitIdentity",
            'COMPUTE.SERVERIDPOOL': "compute.ServerIdPool",
            'COMPUTE.SERVERPOWERPOLICY': "compute.ServerPowerPolicy",
            'COMPUTE.SERVERSETTING': "compute.ServerSetting",
            'COMPUTE.VMEDIA': "compute.Vmedia",
            'COND.ALARM': "cond.Alarm",
            'COND.ALARMAGGREGATION': "cond.AlarmAggregation",
            'COND.ALARMDEFINITION': "cond.AlarmDefinition",
            'COND.HCLSTATUS': "cond.HclStatus",
            'COND.HCLSTATUSDETAIL': "cond.HclStatusDetail",
            'COND.HCLSTATUSJOB': "cond.HclStatusJob",
            'CONNECTORPACK.CONNECTORPACKUPGRADE': "connectorpack.ConnectorPackUpgrade",
            'CONNECTORPACK.UPGRADEIMPACT': "connectorpack.UpgradeImpact",
            'CONSOLE.CONSOLECONFIG': "console.ConsoleConfig",
            'CONVERGEDINFRA.ADAPTERCOMPLIANCEDETAILS': "convergedinfra.AdapterComplianceDetails",
            'CONVERGEDINFRA.POD': "convergedinfra.Pod",
            'CONVERGEDINFRA.PODCOMPLIANCEINFO': "convergedinfra.PodComplianceInfo",
            'CONVERGEDINFRA.SERVERCOMPLIANCEDETAILS': "convergedinfra.ServerComplianceDetails",
            'CONVERGEDINFRA.STORAGECOMPLIANCEDETAILS': "convergedinfra.StorageComplianceDetails",
            'CONVERGEDINFRA.SWITCHCOMPLIANCEDETAILS': "convergedinfra.SwitchComplianceDetails",
            'CRD.CUSTOMRESOURCE': "crd.CustomResource",
            'DEVICECONNECTOR.POLICY': "deviceconnector.Policy",
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
            'EQUIPMENT.CHASSISIDPOOL': "equipment.ChassisIdPool",
            'EQUIPMENT.CHASSISIDENTITY': "equipment.ChassisIdentity",
            'EQUIPMENT.CHASSISOPERATION': "equipment.ChassisOperation",
            'EQUIPMENT.DEVICESUMMARY': "equipment.DeviceSummary",
            'EQUIPMENT.EXPANDERMODULE': "equipment.ExpanderModule",
            'EQUIPMENT.FAN': "equipment.Fan",
            'EQUIPMENT.FANCONTROL': "equipment.FanControl",
            'EQUIPMENT.FANMODULE': "equipment.FanModule",
            'EQUIPMENT.FEX': "equipment.Fex",
            'EQUIPMENT.FEXIDENTITY': "equipment.FexIdentity",
            'EQUIPMENT.FEXOPERATION': "equipment.FexOperation",
            'EQUIPMENT.FRU': "equipment.Fru",
            'EQUIPMENT.IDENTITYSUMMARY': "equipment.IdentitySummary",
            'EQUIPMENT.IOCARD': "equipment.IoCard",
            'EQUIPMENT.IOCARDOPERATION': "equipment.IoCardOperation",
            'EQUIPMENT.IOEXPANDER': "equipment.IoExpander",
            'EQUIPMENT.LOCATORLED': "equipment.LocatorLed",
            'EQUIPMENT.PSU': "equipment.Psu",
            'EQUIPMENT.PSUCONTROL': "equipment.PsuControl",
            'EQUIPMENT.RACKENCLOSURE': "equipment.RackEnclosure",
            'EQUIPMENT.RACKENCLOSURESLOT': "equipment.RackEnclosureSlot",
            'EQUIPMENT.SHAREDIOMODULE': "equipment.SharedIoModule",
            'EQUIPMENT.SWITCHCARD': "equipment.SwitchCard",
            'EQUIPMENT.SYSTEMIOCONTROLLER': "equipment.SystemIoController",
            'EQUIPMENT.TPM': "equipment.Tpm",
            'EQUIPMENT.TRANSCEIVER': "equipment.Transceiver",
            'ETHER.HOSTPORT': "ether.HostPort",
            'ETHER.NETWORKPORT': "ether.NetworkPort",
            'ETHER.PHYSICALPORT': "ether.PhysicalPort",
            'ETHER.PORTCHANNEL': "ether.PortChannel",
            'EXTERNALSITE.AUTHORIZATION': "externalsite.Authorization",
            'FABRIC.APPLIANCEPCROLE': "fabric.AppliancePcRole",
            'FABRIC.APPLIANCEROLE': "fabric.ApplianceRole",
            'FABRIC.CONFIGCHANGEDETAIL': "fabric.ConfigChangeDetail",
            'FABRIC.CONFIGRESULT': "fabric.ConfigResult",
            'FABRIC.CONFIGRESULTENTRY': "fabric.ConfigResultEntry",
            'FABRIC.ELEMENTIDENTITY': "fabric.ElementIdentity",
            'FABRIC.ESTIMATEIMPACT': "fabric.EstimateImpact",
            'FABRIC.ETHNETWORKCONTROLPOLICY': "fabric.EthNetworkControlPolicy",
            'FABRIC.ETHNETWORKCONTROLPOLICYINVENTORY': "fabric.EthNetworkControlPolicyInventory",
            'FABRIC.ETHNETWORKGROUPPOLICY': "fabric.EthNetworkGroupPolicy",
            'FABRIC.ETHNETWORKGROUPPOLICYINVENTORY': "fabric.EthNetworkGroupPolicyInventory",
            'FABRIC.ETHNETWORKPOLICY': "fabric.EthNetworkPolicy",
            'FABRIC.FCNETWORKPOLICY': "fabric.FcNetworkPolicy",
            'FABRIC.FCSTORAGEROLE': "fabric.FcStorageRole",
            'FABRIC.FCUPLINKPCROLE': "fabric.FcUplinkPcRole",
            'FABRIC.FCUPLINKROLE': "fabric.FcUplinkRole",
            'FABRIC.FCZONEPOLICY': "fabric.FcZonePolicy",
            'FABRIC.FCOEUPLINKPCROLE': "fabric.FcoeUplinkPcRole",
            'FABRIC.FCOEUPLINKROLE': "fabric.FcoeUplinkRole",
            'FABRIC.FLOWCONTROLPOLICY': "fabric.FlowControlPolicy",
            'FABRIC.LANPINGROUP': "fabric.LanPinGroup",
            'FABRIC.LINKAGGREGATIONPOLICY': "fabric.LinkAggregationPolicy",
            'FABRIC.LINKCONTROLPOLICY': "fabric.LinkControlPolicy",
            'FABRIC.MULTICASTPOLICY': "fabric.MulticastPolicy",
            'FABRIC.PCMEMBER': "fabric.PcMember",
            'FABRIC.PCOPERATION': "fabric.PcOperation",
            'FABRIC.PORTMODE': "fabric.PortMode",
            'FABRIC.PORTOPERATION': "fabric.PortOperation",
            'FABRIC.PORTPOLICY': "fabric.PortPolicy",
            'FABRIC.SANPINGROUP': "fabric.SanPinGroup",
            'FABRIC.SERVERROLE': "fabric.ServerRole",
            'FABRIC.SWITCHCLUSTERPROFILE': "fabric.SwitchClusterProfile",
            'FABRIC.SWITCHCONTROLPOLICY': "fabric.SwitchControlPolicy",
            'FABRIC.SWITCHPROFILE': "fabric.SwitchProfile",
            'FABRIC.SYSTEMQOSPOLICY': "fabric.SystemQosPolicy",
            'FABRIC.UPLINKPCROLE': "fabric.UplinkPcRole",
            'FABRIC.UPLINKROLE': "fabric.UplinkRole",
            'FABRIC.VLAN': "fabric.Vlan",
            'FABRIC.VLANINVENTORY': "fabric.VlanInventory",
            'FABRIC.VLANSET': "fabric.VlanSet",
            'FABRIC.VSAN': "fabric.Vsan",
            'FABRIC.VSANINVENTORY': "fabric.VsanInventory",
            'FAULT.INSTANCE': "fault.Instance",
            'FC.NEIGHBOR': "fc.Neighbor",
            'FC.PHYSICALPORT': "fc.PhysicalPort",
            'FC.PORTCHANNEL': "fc.PortChannel",
            'FCPOOL.FCBLOCK': "fcpool.FcBlock",
            'FCPOOL.LEASE': "fcpool.Lease",
            'FCPOOL.POOL': "fcpool.Pool",
            'FCPOOL.POOLMEMBER': "fcpool.PoolMember",
            'FCPOOL.UNIVERSE': "fcpool.Universe",
            'FEEDBACK.FEEDBACKPOST': "feedback.FeedbackPost",
            'FIRMWARE.BIOSDESCRIPTOR': "firmware.BiosDescriptor",
            'FIRMWARE.BOARDCONTROLLERDESCRIPTOR': "firmware.BoardControllerDescriptor",
            'FIRMWARE.CHASSISUPGRADE': "firmware.ChassisUpgrade",
            'FIRMWARE.CIMCDESCRIPTOR': "firmware.CimcDescriptor",
            'FIRMWARE.DIMMDESCRIPTOR': "firmware.DimmDescriptor",
            'FIRMWARE.DISTRIBUTABLE': "firmware.Distributable",
            'FIRMWARE.DISTRIBUTABLEMETA': "firmware.DistributableMeta",
            'FIRMWARE.DRIVEDESCRIPTOR': "firmware.DriveDescriptor",
            'FIRMWARE.DRIVERDISTRIBUTABLE': "firmware.DriverDistributable",
            'FIRMWARE.EULA': "firmware.Eula",
            'FIRMWARE.FIRMWARESUMMARY': "firmware.FirmwareSummary",
            'FIRMWARE.GPUDESCRIPTOR': "firmware.GpuDescriptor",
            'FIRMWARE.HBADESCRIPTOR': "firmware.HbaDescriptor",
            'FIRMWARE.IOMDESCRIPTOR': "firmware.IomDescriptor",
            'FIRMWARE.MSWITCHDESCRIPTOR': "firmware.MswitchDescriptor",
            'FIRMWARE.NXOSDESCRIPTOR': "firmware.NxosDescriptor",
            'FIRMWARE.PCIEDESCRIPTOR': "firmware.PcieDescriptor",
            'FIRMWARE.PSUDESCRIPTOR': "firmware.PsuDescriptor",
            'FIRMWARE.RUNNINGFIRMWARE': "firmware.RunningFirmware",
            'FIRMWARE.SASEXPANDERDESCRIPTOR': "firmware.SasExpanderDescriptor",
            'FIRMWARE.SERVERCONFIGURATIONUTILITYDISTRIBUTABLE': "firmware.ServerConfigurationUtilityDistributable",
            'FIRMWARE.STORAGECONTROLLERDESCRIPTOR': "firmware.StorageControllerDescriptor",
            'FIRMWARE.SWITCHUPGRADE': "firmware.SwitchUpgrade",
            'FIRMWARE.UNSUPPORTEDVERSIONUPGRADE': "firmware.UnsupportedVersionUpgrade",
            'FIRMWARE.UPGRADE': "firmware.Upgrade",
            'FIRMWARE.UPGRADEIMPACT': "firmware.UpgradeImpact",
            'FIRMWARE.UPGRADEIMPACTSTATUS': "firmware.UpgradeImpactStatus",
            'FIRMWARE.UPGRADESTATUS': "firmware.UpgradeStatus",
            'FIRMWARE.UPGRADEVALIDITY': "firmware.UpgradeValidity",
            'FORECAST.CATALOG': "forecast.Catalog",
            'FORECAST.DEFINITION': "forecast.Definition",
            'FORECAST.INSTANCE': "forecast.Instance",
            'GRAPHICS.CARD': "graphics.Card",
            'GRAPHICS.CONTROLLER': "graphics.Controller",
            'HCL.COMPATIBILITYSTATUS': "hcl.CompatibilityStatus",
            'HCL.DRIVERIMAGE': "hcl.DriverImage",
            'HCL.EXEMPTEDCATALOG': "hcl.ExemptedCatalog",
            'HCL.HYPERFLEXSOFTWARECOMPATIBILITYINFO': "hcl.HyperflexSoftwareCompatibilityInfo",
            'HCL.OPERATINGSYSTEM': "hcl.OperatingSystem",
            'HCL.OPERATINGSYSTEMVENDOR': "hcl.OperatingSystemVendor",
            'HCL.SUPPORTEDDRIVERNAME': "hcl.SupportedDriverName",
            'HYPERFLEX.ALARM': "hyperflex.Alarm",
            'HYPERFLEX.APPCATALOG': "hyperflex.AppCatalog",
            'HYPERFLEX.AUTOSUPPORTPOLICY': "hyperflex.AutoSupportPolicy",
            'HYPERFLEX.BACKUPCLUSTER': "hyperflex.BackupCluster",
            'HYPERFLEX.CAPABILITYINFO': "hyperflex.CapabilityInfo",
            'HYPERFLEX.CLUSTER': "hyperflex.Cluster",
            'HYPERFLEX.CLUSTERBACKUPPOLICY': "hyperflex.ClusterBackupPolicy",
            'HYPERFLEX.CLUSTERBACKUPPOLICYDEPLOYMENT': "hyperflex.ClusterBackupPolicyDeployment",
            'HYPERFLEX.CLUSTERBACKUPPOLICYINVENTORY': "hyperflex.ClusterBackupPolicyInventory",
            'HYPERFLEX.CLUSTERHEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.ClusterHealthCheckExecutionSnapshot",
            'HYPERFLEX.CLUSTERNETWORKPOLICY': "hyperflex.ClusterNetworkPolicy",
            'HYPERFLEX.CLUSTERPROFILE': "hyperflex.ClusterProfile",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICY': "hyperflex.ClusterReplicationNetworkPolicy",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICYDEPLOYMENT': "hyperflex.ClusterReplicationNetworkPolicyDeployment",
            'HYPERFLEX.CLUSTERSTORAGEPOLICY': "hyperflex.ClusterStoragePolicy",
            'HYPERFLEX.CONFIGRESULT': "hyperflex.ConfigResult",
            'HYPERFLEX.CONFIGRESULTENTRY': "hyperflex.ConfigResultEntry",
            'HYPERFLEX.DATAPROTECTIONPEER': "hyperflex.DataProtectionPeer",
            'HYPERFLEX.DATASTORESTATISTIC': "hyperflex.DatastoreStatistic",
            'HYPERFLEX.DEVICEPACKAGEDOWNLOADSTATE': "hyperflex.DevicePackageDownloadState",
            'HYPERFLEX.DRIVE': "hyperflex.Drive",
            'HYPERFLEX.ENCRYPTION': "hyperflex.Encryption",
            'HYPERFLEX.EXTFCSTORAGEPOLICY': "hyperflex.ExtFcStoragePolicy",
            'HYPERFLEX.EXTISCSISTORAGEPOLICY': "hyperflex.ExtIscsiStoragePolicy",
            'HYPERFLEX.FEATURELIMITEXTERNAL': "hyperflex.FeatureLimitExternal",
            'HYPERFLEX.FEATURELIMITINTERNAL': "hyperflex.FeatureLimitInternal",
            'HYPERFLEX.HEALTH': "hyperflex.Health",
            'HYPERFLEX.HEALTHCHECKDEFINITION': "hyperflex.HealthCheckDefinition",
            'HYPERFLEX.HEALTHCHECKEXECUTION': "hyperflex.HealthCheckExecution",
            'HYPERFLEX.HEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.HealthCheckExecutionSnapshot",
            'HYPERFLEX.HEALTHCHECKPACKAGECHECKSUM': "hyperflex.HealthCheckPackageChecksum",
            'HYPERFLEX.HXDPVERSION': "hyperflex.HxdpVersion",
            'HYPERFLEX.HYPERVISORHOST': "hyperflex.HypervisorHost",
            'HYPERFLEX.HYPERVISORVIRTUALMACHINE': "hyperflex.HypervisorVirtualMachine",
            'HYPERFLEX.KEYENCRYPTIONKEY': "hyperflex.KeyEncryptionKey",
            'HYPERFLEX.LICENSE': "hyperflex.License",
            'HYPERFLEX.LOCALCREDENTIALPOLICY': "hyperflex.LocalCredentialPolicy",
            'HYPERFLEX.NODE': "hyperflex.Node",
            'HYPERFLEX.NODECONFIGPOLICY': "hyperflex.NodeConfigPolicy",
            'HYPERFLEX.NODEPROFILE': "hyperflex.NodeProfile",
            'HYPERFLEX.PROTECTEDCLUSTER': "hyperflex.ProtectedCluster",
            'HYPERFLEX.PROXYSETTINGPOLICY': "hyperflex.ProxySettingPolicy",
            'HYPERFLEX.SERVERFIRMWAREVERSION': "hyperflex.ServerFirmwareVersion",
            'HYPERFLEX.SERVERFIRMWAREVERSIONENTRY': "hyperflex.ServerFirmwareVersionEntry",
            'HYPERFLEX.SERVERMODEL': "hyperflex.ServerModel",
            'HYPERFLEX.SERVICEAUTHTOKEN': "hyperflex.ServiceAuthToken",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONCOMPONENT': "hyperflex.SoftwareDistributionComponent",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONENTRY': "hyperflex.SoftwareDistributionEntry",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONVERSION': "hyperflex.SoftwareDistributionVersion",
            'HYPERFLEX.SOFTWAREVERSIONPOLICY': "hyperflex.SoftwareVersionPolicy",
            'HYPERFLEX.STORAGECONTAINER': "hyperflex.StorageContainer",
            'HYPERFLEX.SYSCONFIGPOLICY': "hyperflex.SysConfigPolicy",
            'HYPERFLEX.UCSMCONFIGPOLICY': "hyperflex.UcsmConfigPolicy",
            'HYPERFLEX.VCENTERCONFIGPOLICY': "hyperflex.VcenterConfigPolicy",
            'HYPERFLEX.VMBACKUPINFO': "hyperflex.VmBackupInfo",
            'HYPERFLEX.VMIMPORTOPERATION': "hyperflex.VmImportOperation",
            'HYPERFLEX.VMRESTOREOPERATION': "hyperflex.VmRestoreOperation",
            'HYPERFLEX.VMSNAPSHOTINFO': "hyperflex.VmSnapshotInfo",
            'HYPERFLEX.VOLUME': "hyperflex.Volume",
            'HYPERFLEX.WITNESSCONFIGURATION': "hyperflex.WitnessConfiguration",
            'IAAS.CONNECTORPACK': "iaas.ConnectorPack",
            'IAAS.CUSTOMTASKINFO': "iaas.CustomTaskInfo",
            'IAAS.DEVICESTATUS': "iaas.DeviceStatus",
            'IAAS.DIAGNOSTICMESSAGES': "iaas.DiagnosticMessages",
            'IAAS.LICENSEINFO': "iaas.LicenseInfo",
            'IAAS.MOSTRUNTASKS': "iaas.MostRunTasks",
            'IAAS.SERVICEREQUEST': "iaas.ServiceRequest",
            'IAAS.SYSTEMTASKINFO': "iaas.SystemTaskInfo",
            'IAAS.UCSDINFO': "iaas.UcsdInfo",
            'IAAS.UCSDMANAGEDINFRA': "iaas.UcsdManagedInfra",
            'IAAS.UCSDMESSAGES': "iaas.UcsdMessages",
            'IAM.ACCOUNT': "iam.Account",
            'IAM.ACCOUNTEXPERIENCE': "iam.AccountExperience",
            'IAM.APIKEY': "iam.ApiKey",
            'IAM.APPREGISTRATION': "iam.AppRegistration",
            'IAM.BANNERMESSAGE': "iam.BannerMessage",
            'IAM.CERTIFICATE': "iam.Certificate",
            'IAM.CERTIFICATEREQUEST': "iam.CertificateRequest",
            'IAM.DOMAINGROUP': "iam.DomainGroup",
            'IAM.DOMAINNAMEINFO': "iam.DomainNameInfo",
            'IAM.ENDPOINTPRIVILEGE': "iam.EndPointPrivilege",
            'IAM.ENDPOINTROLE': "iam.EndPointRole",
            'IAM.ENDPOINTUSER': "iam.EndPointUser",
            'IAM.ENDPOINTUSERINVENTORY': "iam.EndPointUserInventory",
            'IAM.ENDPOINTUSERPOLICY': "iam.EndPointUserPolicy",
            'IAM.ENDPOINTUSERPOLICYINVENTORY': "iam.EndPointUserPolicyInventory",
            'IAM.ENDPOINTUSERROLE': "iam.EndPointUserRole",
            'IAM.ENDPOINTUSERROLEINVENTORY': "iam.EndPointUserRoleInventory",
            'IAM.IDP': "iam.Idp",
            'IAM.IDPREFERENCE': "iam.IdpReference",
            'IAM.IPACCESSMANAGEMENT': "iam.IpAccessManagement",
            'IAM.IPADDRESS': "iam.IpAddress",
            'IAM.LDAPGROUP': "iam.LdapGroup",
            'IAM.LDAPPOLICY': "iam.LdapPolicy",
            'IAM.LDAPPROVIDER': "iam.LdapProvider",
            'IAM.LOCALUSERPASSWORD': "iam.LocalUserPassword",
            'IAM.LOCALUSERPASSWORDPOLICY': "iam.LocalUserPasswordPolicy",
            'IAM.OAUTHTOKEN': "iam.OAuthToken",
            'IAM.PERMISSION': "iam.Permission",
            'IAM.PRIVATEKEYSPEC': "iam.PrivateKeySpec",
            'IAM.PRIVILEGE': "iam.Privilege",
            'IAM.PRIVILEGESET': "iam.PrivilegeSet",
            'IAM.QUALIFIER': "iam.Qualifier",
            'IAM.RESOURCELIMITS': "iam.ResourceLimits",
            'IAM.RESOURCEPERMISSION': "iam.ResourcePermission",
            'IAM.RESOURCEROLES': "iam.ResourceRoles",
            'IAM.ROLE': "iam.Role",
            'IAM.SECURITYHOLDER': "iam.SecurityHolder",
            'IAM.SERVICEPROVIDER': "iam.ServiceProvider",
            'IAM.SESSION': "iam.Session",
            'IAM.SESSIONLIMITS': "iam.SessionLimits",
            'IAM.SYSTEM': "iam.System",
            'IAM.TRUSTPOINT': "iam.TrustPoint",
            'IAM.USER': "iam.User",
            'IAM.USERGROUP': "iam.UserGroup",
            'IAM.USERPREFERENCE': "iam.UserPreference",
            'INVENTORY.DEVICEINFO': "inventory.DeviceInfo",
            'INVENTORY.DNMOBINDING': "inventory.DnMoBinding",
            'INVENTORY.GENERICINVENTORY': "inventory.GenericInventory",
            'INVENTORY.GENERICINVENTORYHOLDER': "inventory.GenericInventoryHolder",
            'INVENTORY.REQUEST': "inventory.Request",
            'IPMIOVERLAN.POLICY': "ipmioverlan.Policy",
            'IPMIOVERLAN.POLICYINVENTORY': "ipmioverlan.PolicyInventory",
            'IPPOOL.BLOCKLEASE': "ippool.BlockLease",
            'IPPOOL.IPLEASE': "ippool.IpLease",
            'IPPOOL.POOL': "ippool.Pool",
            'IPPOOL.POOLMEMBER': "ippool.PoolMember",
            'IPPOOL.SHADOWBLOCK': "ippool.ShadowBlock",
            'IPPOOL.SHADOWPOOL': "ippool.ShadowPool",
            'IPPOOL.UNIVERSE': "ippool.Universe",
            'IQNPOOL.BLOCK': "iqnpool.Block",
            'IQNPOOL.LEASE': "iqnpool.Lease",
            'IQNPOOL.POOL': "iqnpool.Pool",
            'IQNPOOL.POOLMEMBER': "iqnpool.PoolMember",
            'IQNPOOL.UNIVERSE': "iqnpool.Universe",
            'IWOTENANT.TENANTSTATUS': "iwotenant.TenantStatus",
            'KUBERNETES.ACICNIAPIC': "kubernetes.AciCniApic",
            'KUBERNETES.ACICNIPROFILE': "kubernetes.AciCniProfile",
            'KUBERNETES.ACICNITENANTCLUSTERALLOCATION': "kubernetes.AciCniTenantClusterAllocation",
            'KUBERNETES.ADDONDEFINITION': "kubernetes.AddonDefinition",
            'KUBERNETES.ADDONPOLICY': "kubernetes.AddonPolicy",
            'KUBERNETES.ADDONREPOSITORY': "kubernetes.AddonRepository",
            'KUBERNETES.BAREMETALNODEPROFILE': "kubernetes.BaremetalNodeProfile",
            'KUBERNETES.CATALOG': "kubernetes.Catalog",
            'KUBERNETES.CLUSTER': "kubernetes.Cluster",
            'KUBERNETES.CLUSTERADDONPROFILE': "kubernetes.ClusterAddonProfile",
            'KUBERNETES.CLUSTERPROFILE': "kubernetes.ClusterProfile",
            'KUBERNETES.CONFIGRESULT': "kubernetes.ConfigResult",
            'KUBERNETES.CONFIGRESULTENTRY': "kubernetes.ConfigResultEntry",
            'KUBERNETES.CONTAINERRUNTIMEPOLICY': "kubernetes.ContainerRuntimePolicy",
            'KUBERNETES.DAEMONSET': "kubernetes.DaemonSet",
            'KUBERNETES.DEPLOYMENT': "kubernetes.Deployment",
            'KUBERNETES.HTTPPROXYPOLICY': "kubernetes.HttpProxyPolicy",
            'KUBERNETES.INGRESS': "kubernetes.Ingress",
            'KUBERNETES.NETWORKPOLICY': "kubernetes.NetworkPolicy",
            'KUBERNETES.NODE': "kubernetes.Node",
            'KUBERNETES.NODEGROUPPROFILE': "kubernetes.NodeGroupProfile",
            'KUBERNETES.NVIDIAGPUPRODUCT': "kubernetes.NvidiaGpuProduct",
            'KUBERNETES.POD': "kubernetes.Pod",
            'KUBERNETES.SERVICE': "kubernetes.Service",
            'KUBERNETES.STATEFULSET': "kubernetes.StatefulSet",
            'KUBERNETES.SYSCONFIGPOLICY': "kubernetes.SysConfigPolicy",
            'KUBERNETES.TRUSTEDREGISTRIESPOLICY': "kubernetes.TrustedRegistriesPolicy",
            'KUBERNETES.VERSION': "kubernetes.Version",
            'KUBERNETES.VERSIONPOLICY': "kubernetes.VersionPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRACONFIGPOLICY': "kubernetes.VirtualMachineInfraConfigPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRASTRUCTUREPROVIDER': "kubernetes.VirtualMachineInfrastructureProvider",
            'KUBERNETES.VIRTUALMACHINEINSTANCETYPE': "kubernetes.VirtualMachineInstanceType",
            'KUBERNETES.VIRTUALMACHINENODEPROFILE': "kubernetes.VirtualMachineNodeProfile",
            'KVM.POLICY': "kvm.Policy",
            'KVM.POLICYINVENTORY': "kvm.PolicyInventory",
            'KVM.SESSION': "kvm.Session",
            'KVM.TUNNEL': "kvm.Tunnel",
            'KVM.TUNNELEDKVMPOLICY': "kvm.TunneledKvmPolicy",
            'LICENSE.ACCOUNTLICENSEDATA': "license.AccountLicenseData",
            'LICENSE.CUSTOMEROP': "license.CustomerOp",
            'LICENSE.IKSCUSTOMEROP': "license.IksCustomerOp",
            'LICENSE.IKSLICENSECOUNT': "license.IksLicenseCount",
            'LICENSE.IWOCUSTOMEROP': "license.IwoCustomerOp",
            'LICENSE.IWOLICENSECOUNT': "license.IwoLicenseCount",
            'LICENSE.LICENSEINFO': "license.LicenseInfo",
            'LICENSE.LICENSERESERVATIONOP': "license.LicenseReservationOp",
            'LICENSE.SMARTLICENSETOKEN': "license.SmartlicenseToken",
            'LS.SERVICEPROFILE': "ls.ServiceProfile",
            'MACPOOL.IDBLOCK': "macpool.IdBlock",
            'MACPOOL.LEASE': "macpool.Lease",
            'MACPOOL.POOL': "macpool.Pool",
            'MACPOOL.POOLMEMBER': "macpool.PoolMember",
            'MACPOOL.UNIVERSE': "macpool.Universe",
            'MANAGEMENT.CONTROLLER': "management.Controller",
            'MANAGEMENT.ENTITY': "management.Entity",
            'MANAGEMENT.INTERFACE': "management.Interface",
            'MEMORY.ARRAY': "memory.Array",
            'MEMORY.PERSISTENTMEMORYCONFIGRESULT': "memory.PersistentMemoryConfigResult",
            'MEMORY.PERSISTENTMEMORYCONFIGURATION': "memory.PersistentMemoryConfiguration",
            'MEMORY.PERSISTENTMEMORYNAMESPACE': "memory.PersistentMemoryNamespace",
            'MEMORY.PERSISTENTMEMORYNAMESPACECONFIGRESULT': "memory.PersistentMemoryNamespaceConfigResult",
            'MEMORY.PERSISTENTMEMORYPOLICY': "memory.PersistentMemoryPolicy",
            'MEMORY.PERSISTENTMEMORYREGION': "memory.PersistentMemoryRegion",
            'MEMORY.PERSISTENTMEMORYUNIT': "memory.PersistentMemoryUnit",
            'MEMORY.UNIT': "memory.Unit",
            'META.DEFINITION': "meta.Definition",
            'MONITORING.HEALTHSTATUS': "monitoring.HealthStatus",
            'NETWORK.ELEMENT': "network.Element",
            'NETWORK.ELEMENTSUMMARY': "network.ElementSummary",
            'NETWORK.FCZONEINFO': "network.FcZoneInfo",
            'NETWORK.FEATURECONTROL': "network.FeatureControl",
            'NETWORK.INTERFACELIST': "network.InterfaceList",
            'NETWORK.LICENSEFILE': "network.LicenseFile",
            'NETWORK.SUPERVISORCARD': "network.SupervisorCard",
            'NETWORK.VLANPORTINFO': "network.VlanPortInfo",
            'NETWORK.VRF': "network.Vrf",
            'NETWORKCONFIG.POLICY': "networkconfig.Policy",
            'NETWORKCONFIG.POLICYINVENTORY': "networkconfig.PolicyInventory",
            'NIAAPI.APICCCOPOST': "niaapi.ApicCcoPost",
            'NIAAPI.APICFIELDNOTICE': "niaapi.ApicFieldNotice",
            'NIAAPI.APICHWEOL': "niaapi.ApicHweol",
            'NIAAPI.APICLATESTMAINTAINEDRELEASE': "niaapi.ApicLatestMaintainedRelease",
            'NIAAPI.APICRELEASERECOMMEND': "niaapi.ApicReleaseRecommend",
            'NIAAPI.APICSWEOL': "niaapi.ApicSweol",
            'NIAAPI.DCNMCCOPOST': "niaapi.DcnmCcoPost",
            'NIAAPI.DCNMFIELDNOTICE': "niaapi.DcnmFieldNotice",
            'NIAAPI.DCNMHWEOL': "niaapi.DcnmHweol",
            'NIAAPI.DCNMLATESTMAINTAINEDRELEASE': "niaapi.DcnmLatestMaintainedRelease",
            'NIAAPI.DCNMRELEASERECOMMEND': "niaapi.DcnmReleaseRecommend",
            'NIAAPI.DCNMSWEOL': "niaapi.DcnmSweol",
            'NIAAPI.FILEDOWNLOADER': "niaapi.FileDownloader",
            'NIAAPI.NIAMETADATA': "niaapi.NiaMetadata",
            'NIAAPI.NIBFILEDOWNLOADER': "niaapi.NibFileDownloader",
            'NIAAPI.NIBMETADATA': "niaapi.NibMetadata",
            'NIAAPI.VERSIONREGEX': "niaapi.VersionRegex",
            'NIATELEMETRY.AAALDAPPROVIDERDETAILS': "niatelemetry.AaaLdapProviderDetails",
            'NIATELEMETRY.AAARADIUSPROVIDERDETAILS': "niatelemetry.AaaRadiusProviderDetails",
            'NIATELEMETRY.AAATACACSPROVIDERDETAILS': "niatelemetry.AaaTacacsProviderDetails",
            'NIATELEMETRY.APICAPPPLUGINDETAILS': "niatelemetry.ApicAppPluginDetails",
            'NIATELEMETRY.APICCOREFILEDETAILS': "niatelemetry.ApicCoreFileDetails",
            'NIATELEMETRY.APICDBGEXPRSEXPORTDEST': "niatelemetry.ApicDbgexpRsExportDest",
            'NIATELEMETRY.APICDBGEXPRSTSSCHEDULER': "niatelemetry.ApicDbgexpRsTsScheduler",
            'NIATELEMETRY.APICFANDETAILS': "niatelemetry.ApicFanDetails",
            'NIATELEMETRY.APICFEXDETAILS': "niatelemetry.ApicFexDetails",
            'NIATELEMETRY.APICFLASHDETAILS': "niatelemetry.ApicFlashDetails",
            'NIATELEMETRY.APICNTPAUTH': "niatelemetry.ApicNtpAuth",
            'NIATELEMETRY.APICPERFORMANCEDATA': "niatelemetry.ApicPerformanceData",
            'NIATELEMETRY.APICPODDATA': "niatelemetry.ApicPodData",
            'NIATELEMETRY.APICPSUDETAILS': "niatelemetry.ApicPsuDetails",
            'NIATELEMETRY.APICREALMDETAILS': "niatelemetry.ApicRealmDetails",
            'NIATELEMETRY.APICSNMPCLIENTGRPDETAILS': "niatelemetry.ApicSnmpClientGrpDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYACCESSDETAILS': "niatelemetry.ApicSnmpCommunityAccessDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYDETAILS': "niatelemetry.ApicSnmpCommunityDetails",
            'NIATELEMETRY.APICSNMPTRAPDETAILS': "niatelemetry.ApicSnmpTrapDetails",
            'NIATELEMETRY.APICSNMPTRAPFWDSERVERDETAILS': "niatelemetry.ApicSnmpTrapFwdServerDetails",
            'NIATELEMETRY.APICSNMPVERSIONTHREEDETAILS': "niatelemetry.ApicSnmpVersionThreeDetails",
            'NIATELEMETRY.APICSYSLOGGRP': "niatelemetry.ApicSysLogGrp",
            'NIATELEMETRY.APICSYSLOGSRC': "niatelemetry.ApicSysLogSrc",
            'NIATELEMETRY.APICTRANSCEIVERDETAILS': "niatelemetry.ApicTransceiverDetails",
            'NIATELEMETRY.APICUIPAGECOUNTS': "niatelemetry.ApicUiPageCounts",
            'NIATELEMETRY.APPDETAILS': "niatelemetry.AppDetails",
            'NIATELEMETRY.CLOUDDETAILS': "niatelemetry.CloudDetails",
            'NIATELEMETRY.COMMONPOLICIES': "niatelemetry.CommonPolicies",
            'NIATELEMETRY.DCNMFANDETAILS': "niatelemetry.DcnmFanDetails",
            'NIATELEMETRY.DCNMFEXDETAILS': "niatelemetry.DcnmFexDetails",
            'NIATELEMETRY.DCNMMODULEDETAILS': "niatelemetry.DcnmModuleDetails",
            'NIATELEMETRY.DCNMPSUDETAILS': "niatelemetry.DcnmPsuDetails",
            'NIATELEMETRY.DCNMTRANSCEIVERDETAILS': "niatelemetry.DcnmTransceiverDetails",
            'NIATELEMETRY.EPG': "niatelemetry.Epg",
            'NIATELEMETRY.FABRICMODULEDETAILS': "niatelemetry.FabricModuleDetails",
            'NIATELEMETRY.FABRICNODECONTROLDETAILS': "niatelemetry.FabricNodeControlDetails",
            'NIATELEMETRY.FABRICPODPROFILE': "niatelemetry.FabricPodProfile",
            'NIATELEMETRY.FABRICPODSS': "niatelemetry.FabricPodSs",
            'NIATELEMETRY.FAULT': "niatelemetry.Fault",
            'NIATELEMETRY.HCLOUDDETAILS': "niatelemetry.HcloudDetails",
            'NIATELEMETRY.HEALTHINSIGHTSDATA': "niatelemetry.HealthInsightsData",
            'NIATELEMETRY.HTTPSACLCONTRACTDETAILS': "niatelemetry.HttpsAclContractDetails",
            'NIATELEMETRY.HTTPSACLCONTRACTFILTERMAP': "niatelemetry.HttpsAclContractFilterMap",
            'NIATELEMETRY.HTTPSACLEPGCONTRACTMAP': "niatelemetry.HttpsAclEpgContractMap",
            'NIATELEMETRY.HTTPSACLEPGDETAILS': "niatelemetry.HttpsAclEpgDetails",
            'NIATELEMETRY.HTTPSACLFILTERDETAILS': "niatelemetry.HttpsAclFilterDetails",
            'NIATELEMETRY.INSIGHTGROUPDETAILS': "niatelemetry.InsightGroupDetails",
            'NIATELEMETRY.LC': "niatelemetry.Lc",
            'NIATELEMETRY.LEAFPOLGRPDETAILS': "niatelemetry.LeafPolGrpDetails",
            'NIATELEMETRY.MSOCONTRACTDETAILS': "niatelemetry.MsoContractDetails",
            'NIATELEMETRY.MSOEPGDETAILS': "niatelemetry.MsoEpgDetails",
            'NIATELEMETRY.MSOSCHEMADETAILS': "niatelemetry.MsoSchemaDetails",
            'NIATELEMETRY.MSOSITEDETAILS': "niatelemetry.MsoSiteDetails",
            'NIATELEMETRY.MSOTENANTDETAILS': "niatelemetry.MsoTenantDetails",
            'NIATELEMETRY.NEXUSDASHBOARDCONTROLLERDETAILS': "niatelemetry.NexusDashboardControllerDetails",
            'NIATELEMETRY.NEXUSDASHBOARDDETAILS': "niatelemetry.NexusDashboardDetails",
            'NIATELEMETRY.NEXUSDASHBOARDMEMORYDETAILS': "niatelemetry.NexusDashboardMemoryDetails",
            'NIATELEMETRY.NEXUSDASHBOARDS': "niatelemetry.NexusDashboards",
            'NIATELEMETRY.NIAFEATUREUSAGE': "niatelemetry.NiaFeatureUsage",
            'NIATELEMETRY.NIAINVENTORY': "niatelemetry.NiaInventory",
            'NIATELEMETRY.NIAINVENTORYDCNM': "niatelemetry.NiaInventoryDcnm",
            'NIATELEMETRY.NIAINVENTORYFABRIC': "niatelemetry.NiaInventoryFabric",
            'NIATELEMETRY.NIALICENSESTATE': "niatelemetry.NiaLicenseState",
            'NIATELEMETRY.PASSWORDSTRENGTHCHECK': "niatelemetry.PasswordStrengthCheck",
            'NIATELEMETRY.PODCOMMPOLICIES': "niatelemetry.PodCommPolicies",
            'NIATELEMETRY.PODSNMPPOLICIES': "niatelemetry.PodSnmpPolicies",
            'NIATELEMETRY.PODTIMESERVERPOLICIES': "niatelemetry.PodTimeServerPolicies",
            'NIATELEMETRY.SITEINVENTORY': "niatelemetry.SiteInventory",
            'NIATELEMETRY.SNMPSRC': "niatelemetry.SnmpSrc",
            'NIATELEMETRY.SPINEPOLGRPDETAILS': "niatelemetry.SpinePolGrpDetails",
            'NIATELEMETRY.SSHVERSIONTWO': "niatelemetry.SshVersionTwo",
            'NIATELEMETRY.SUPERVISORMODULEDETAILS': "niatelemetry.SupervisorModuleDetails",
            'NIATELEMETRY.SYSLOGREMOTEDEST': "niatelemetry.SyslogRemoteDest",
            'NIATELEMETRY.SYSLOGSYSMSG': "niatelemetry.SyslogSysMsg",
            'NIATELEMETRY.SYSLOGSYSMSGFACFILTER': "niatelemetry.SyslogSysMsgFacFilter",
            'NIATELEMETRY.SYSTEMCONTROLLERDETAILS': "niatelemetry.SystemControllerDetails",
            'NIATELEMETRY.TENANT': "niatelemetry.Tenant",
            'NOTIFICATION.ACCOUNTSUBSCRIPTION': "notification.AccountSubscription",
            'NTP.NTPSERVER': "ntp.NtpServer",
            'NTP.POLICY': "ntp.Policy",
            'OAUTH.ACCESSTOKEN': "oauth.AccessToken",
            'OAUTH.AUTHORIZATION': "oauth.Authorization",
            'OPRS.DEPLOYMENT': "oprs.Deployment",
            'OPRS.SYNCTARGETLISTMESSAGE': "oprs.SyncTargetListMessage",
            'ORGANIZATION.ORGANIZATION': "organization.Organization",
            'OS.BULKINSTALLINFO': "os.BulkInstallInfo",
            'OS.CATALOG': "os.Catalog",
            'OS.CONFIGURATIONFILE': "os.ConfigurationFile",
            'OS.DISTRIBUTION': "os.Distribution",
            'OS.INSTALL': "os.Install",
            'OS.OSSUPPORT': "os.OsSupport",
            'OS.SUPPORTEDVERSION': "os.SupportedVersion",
            'OS.TEMPLATEFILE': "os.TemplateFile",
            'OS.VALIDINSTALLTARGET': "os.ValidInstallTarget",
            'PCI.COPROCESSORCARD': "pci.CoprocessorCard",
            'PCI.DEVICE': "pci.Device",
            'PCI.LINK': "pci.Link",
            'PCI.NODE': "pci.Node",
            'PCI.SWITCH': "pci.Switch",
            'PORT.GROUP': "port.Group",
            'PORT.MACBINDING': "port.MacBinding",
            'PORT.SUBGROUP': "port.SubGroup",
            'POWER.CONTROLSTATE': "power.ControlState",
            'POWER.POLICY': "power.Policy",
            'POWER.POLICYINVENTORY': "power.PolicyInventory",
            'PROCESSOR.UNIT': "processor.Unit",
            'RACK.UNITPERSONALITY': "rack.UnitPersonality",
            'RECOMMENDATION.CAPACITYRUNWAY': "recommendation.CapacityRunway",
            'RECOMMENDATION.PHYSICALITEM': "recommendation.PhysicalItem",
            'RECOVERY.BACKUPCONFIGPOLICY': "recovery.BackupConfigPolicy",
            'RECOVERY.BACKUPPROFILE': "recovery.BackupProfile",
            'RECOVERY.CONFIGRESULT': "recovery.ConfigResult",
            'RECOVERY.CONFIGRESULTENTRY': "recovery.ConfigResultEntry",
            'RECOVERY.ONDEMANDBACKUP': "recovery.OnDemandBackup",
            'RECOVERY.RESTORE': "recovery.Restore",
            'RECOVERY.SCHEDULECONFIGPOLICY': "recovery.ScheduleConfigPolicy",
            'RESOURCE.GROUP': "resource.Group",
            'RESOURCE.GROUPMEMBER': "resource.GroupMember",
            'RESOURCE.LICENSERESOURCECOUNT': "resource.LicenseResourceCount",
            'RESOURCE.MEMBERSHIP': "resource.Membership",
            'RESOURCE.MEMBERSHIPHOLDER': "resource.MembershipHolder",
            'RESOURCE.RESERVATION': "resource.Reservation",
            'RESOURCEPOOL.LEASE': "resourcepool.Lease",
            'RESOURCEPOOL.LEASERESOURCE': "resourcepool.LeaseResource",
            'RESOURCEPOOL.POOL': "resourcepool.Pool",
            'RESOURCEPOOL.POOLMEMBER': "resourcepool.PoolMember",
            'RESOURCEPOOL.UNIVERSE': "resourcepool.Universe",
            'RPROXY.REVERSEPROXY': "rproxy.ReverseProxy",
            'SDCARD.POLICY': "sdcard.Policy",
            'SDCARD.POLICYINVENTORY': "sdcard.PolicyInventory",
            'SEARCH.SEARCHITEM': "search.SearchItem",
            'SEARCH.TAGITEM': "search.TagItem",
            'SECURITY.UNIT': "security.Unit",
            'SERVER.CONFIGCHANGEDETAIL': "server.ConfigChangeDetail",
            'SERVER.CONFIGIMPORT': "server.ConfigImport",
            'SERVER.CONFIGRESULT': "server.ConfigResult",
            'SERVER.CONFIGRESULTENTRY': "server.ConfigResultEntry",
            'SERVER.PROFILE': "server.Profile",
            'SERVER.PROFILETEMPLATE': "server.ProfileTemplate",
            'SMTP.POLICY': "smtp.Policy",
            'SNMP.POLICY': "snmp.Policy",
            'SNMP.POLICYINVENTORY': "snmp.PolicyInventory",
            'SOFTWARE.APPLIANCEDISTRIBUTABLE': "software.ApplianceDistributable",
            'SOFTWARE.DOWNLOADHISTORY': "software.DownloadHistory",
            'SOFTWARE.HCLMETA': "software.HclMeta",
            'SOFTWARE.HYPERFLEXBUNDLEDISTRIBUTABLE': "software.HyperflexBundleDistributable",
            'SOFTWARE.HYPERFLEXDISTRIBUTABLE': "software.HyperflexDistributable",
            'SOFTWARE.IKSBUNDLEDISTRIBUTABLE': "software.IksBundleDistributable",
            'SOFTWARE.RELEASEMETA': "software.ReleaseMeta",
            'SOFTWARE.SOLUTIONDISTRIBUTABLE': "software.SolutionDistributable",
            'SOFTWARE.UCSDBUNDLEDISTRIBUTABLE': "software.UcsdBundleDistributable",
            'SOFTWARE.UCSDDISTRIBUTABLE': "software.UcsdDistributable",
            'SOFTWAREREPOSITORY.AUTHORIZATION': "softwarerepository.Authorization",
            'SOFTWAREREPOSITORY.CACHEDIMAGE': "softwarerepository.CachedImage",
            'SOFTWAREREPOSITORY.CATALOG': "softwarerepository.Catalog",
            'SOFTWAREREPOSITORY.CATEGORYMAPPER': "softwarerepository.CategoryMapper",
            'SOFTWAREREPOSITORY.CATEGORYMAPPERMODEL': "softwarerepository.CategoryMapperModel",
            'SOFTWAREREPOSITORY.CATEGORYSUPPORTCONSTRAINT': "softwarerepository.CategorySupportConstraint",
            'SOFTWAREREPOSITORY.DOWNLOADSPEC': "softwarerepository.DownloadSpec",
            'SOFTWAREREPOSITORY.OPERATINGSYSTEMFILE': "softwarerepository.OperatingSystemFile",
            'SOFTWAREREPOSITORY.RELEASE': "softwarerepository.Release",
            'SOL.POLICY': "sol.Policy",
            'SOL.POLICYINVENTORY': "sol.PolicyInventory",
            'SSH.POLICY': "ssh.Policy",
            'SSH.POLICYINVENTORY': "ssh.PolicyInventory",
            'STORAGE.BATTERYBACKUPUNIT': "storage.BatteryBackupUnit",
            'STORAGE.CONTROLLER': "storage.Controller",
            'STORAGE.DISKGROUP': "storage.DiskGroup",
            'STORAGE.DISKSLOT': "storage.DiskSlot",
            'STORAGE.DRIVEGROUP': "storage.DriveGroup",
            'STORAGE.ENCLOSURE': "storage.Enclosure",
            'STORAGE.ENCLOSUREDISK': "storage.EnclosureDisk",
            'STORAGE.ENCLOSUREDISKSLOTEP': "storage.EnclosureDiskSlotEp",
            'STORAGE.FLEXFLASHCONTROLLER': "storage.FlexFlashController",
            'STORAGE.FLEXFLASHCONTROLLERPROPS': "storage.FlexFlashControllerProps",
            'STORAGE.FLEXFLASHPHYSICALDRIVE': "storage.FlexFlashPhysicalDrive",
            'STORAGE.FLEXFLASHVIRTUALDRIVE': "storage.FlexFlashVirtualDrive",
            'STORAGE.FLEXUTILCONTROLLER': "storage.FlexUtilController",
            'STORAGE.FLEXUTILPHYSICALDRIVE': "storage.FlexUtilPhysicalDrive",
            'STORAGE.FLEXUTILVIRTUALDRIVE': "storage.FlexUtilVirtualDrive",
            'STORAGE.HITACHIARRAY': "storage.HitachiArray",
            'STORAGE.HITACHICONTROLLER': "storage.HitachiController",
            'STORAGE.HITACHIDISK': "storage.HitachiDisk",
            'STORAGE.HITACHIHOST': "storage.HitachiHost",
            'STORAGE.HITACHIHOSTLUN': "storage.HitachiHostLun",
            'STORAGE.HITACHIPARITYGROUP': "storage.HitachiParityGroup",
            'STORAGE.HITACHIPOOL': "storage.HitachiPool",
            'STORAGE.HITACHIPORT': "storage.HitachiPort",
            'STORAGE.HITACHISNAPSHOT': "storage.HitachiSnapshot",
            'STORAGE.HITACHIVOLUME': "storage.HitachiVolume",
            'STORAGE.HYPERFLEXSTORAGECONTAINER': "storage.HyperFlexStorageContainer",
            'STORAGE.HYPERFLEXVOLUME': "storage.HyperFlexVolume",
            'STORAGE.ITEM': "storage.Item",
            'STORAGE.NETAPPAGGREGATE': "storage.NetAppAggregate",
            'STORAGE.NETAPPAGGREGATEEVENT': "storage.NetAppAggregateEvent",
            'STORAGE.NETAPPBASEDISK': "storage.NetAppBaseDisk",
            'STORAGE.NETAPPCLUSTER': "storage.NetAppCluster",
            'STORAGE.NETAPPCLUSTEREVENT': "storage.NetAppClusterEvent",
            'STORAGE.NETAPPDATAIPINTERFACE': "storage.NetAppDataIpInterface",
            'STORAGE.NETAPPDATAIPINTERFACEEVENT': "storage.NetAppDataIpInterfaceEvent",
            'STORAGE.NETAPPDISKEVENT': "storage.NetAppDiskEvent",
            'STORAGE.NETAPPETHERNETPORT': "storage.NetAppEthernetPort",
            'STORAGE.NETAPPETHERNETPORTEVENT': "storage.NetAppEthernetPortEvent",
            'STORAGE.NETAPPEXPORTPOLICY': "storage.NetAppExportPolicy",
            'STORAGE.NETAPPFCINTERFACE': "storage.NetAppFcInterface",
            'STORAGE.NETAPPFCINTERFACEEVENT': "storage.NetAppFcInterfaceEvent",
            'STORAGE.NETAPPFCPORT': "storage.NetAppFcPort",
            'STORAGE.NETAPPFCPORTEVENT': "storage.NetAppFcPortEvent",
            'STORAGE.NETAPPINITIATORGROUP': "storage.NetAppInitiatorGroup",
            'STORAGE.NETAPPIPINTERFACE': "storage.NetAppIpInterface",
            'STORAGE.NETAPPIPINTERFACEEVENT': "storage.NetAppIpInterfaceEvent",
            'STORAGE.NETAPPISCSISERVICE': "storage.NetAppIscsiService",
            'STORAGE.NETAPPLICENSE': "storage.NetAppLicense",
            'STORAGE.NETAPPLUN': "storage.NetAppLun",
            'STORAGE.NETAPPLUNEVENT': "storage.NetAppLunEvent",
            'STORAGE.NETAPPLUNMAP': "storage.NetAppLunMap",
            'STORAGE.NETAPPNFSSERVICE': "storage.NetAppNfsService",
            'STORAGE.NETAPPNODE': "storage.NetAppNode",
            'STORAGE.NETAPPNODECDPNEIGHBOR': "storage.NetAppNodeCdpNeighbor",
            'STORAGE.NETAPPNODEEVENT': "storage.NetAppNodeEvent",
            'STORAGE.NETAPPNONDATAIPINTERFACE': "storage.NetAppNonDataIpInterface",
            'STORAGE.NETAPPNONDATAIPINTERFACEEVENT': "storage.NetAppNonDataIpInterfaceEvent",
            'STORAGE.NETAPPNTPSERVER': "storage.NetAppNtpServer",
            'STORAGE.NETAPPSCHEDULE': "storage.NetAppSchedule",
            'STORAGE.NETAPPSENSOR': "storage.NetAppSensor",
            'STORAGE.NETAPPSTORAGEVM': "storage.NetAppStorageVm",
            'STORAGE.NETAPPSVMEVENT': "storage.NetAppSvmEvent",
            'STORAGE.NETAPPVOLUME': "storage.NetAppVolume",
            'STORAGE.NETAPPVOLUMEEVENT': "storage.NetAppVolumeEvent",
            'STORAGE.NETAPPVOLUMESNAPSHOT': "storage.NetAppVolumeSnapshot",
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
            'STORAGE.PHYSICALDISKEXTENSION': "storage.PhysicalDiskExtension",
            'STORAGE.PHYSICALDISKUSAGE': "storage.PhysicalDiskUsage",
            'STORAGE.PUREARRAY': "storage.PureArray",
            'STORAGE.PURECONTROLLER': "storage.PureController",
            'STORAGE.PUREDISK': "storage.PureDisk",
            'STORAGE.PUREHOST': "storage.PureHost",
            'STORAGE.PUREHOSTGROUP': "storage.PureHostGroup",
            'STORAGE.PUREHOSTLUN': "storage.PureHostLun",
            'STORAGE.PUREPORT': "storage.PurePort",
            'STORAGE.PUREPROTECTIONGROUP': "storage.PureProtectionGroup",
            'STORAGE.PUREPROTECTIONGROUPSNAPSHOT': "storage.PureProtectionGroupSnapshot",
            'STORAGE.PUREREPLICATIONSCHEDULE': "storage.PureReplicationSchedule",
            'STORAGE.PURESNAPSHOTSCHEDULE': "storage.PureSnapshotSchedule",
            'STORAGE.PUREVOLUME': "storage.PureVolume",
            'STORAGE.PUREVOLUMESNAPSHOT': "storage.PureVolumeSnapshot",
            'STORAGE.SASEXPANDER': "storage.SasExpander",
            'STORAGE.SASPORT': "storage.SasPort",
            'STORAGE.SPAN': "storage.Span",
            'STORAGE.STORAGEPOLICY': "storage.StoragePolicy",
            'STORAGE.VDMEMBEREP': "storage.VdMemberEp",
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
            'STORAGE.VIRTUALDRIVECONTAINER': "storage.VirtualDriveContainer",
            'STORAGE.VIRTUALDRIVEEXTENSION': "storage.VirtualDriveExtension",
            'STORAGE.VIRTUALDRIVEIDENTITY': "storage.VirtualDriveIdentity",
            'SYSLOG.POLICY': "syslog.Policy",
            'SYSLOG.POLICYINVENTORY': "syslog.PolicyInventory",
            'TAM.ADVISORYCOUNT': "tam.AdvisoryCount",
            'TAM.ADVISORYDEFINITION': "tam.AdvisoryDefinition",
            'TAM.ADVISORYINFO': "tam.AdvisoryInfo",
            'TAM.ADVISORYINSTANCE': "tam.AdvisoryInstance",
            'TAM.SECURITYADVISORY': "tam.SecurityAdvisory",
            'TASK.FABRICMOSSCOPEDINVENTORY': "task.FabricMosScopedInventory",
            'TASK.HITACHISCOPEDINVENTORY': "task.HitachiScopedInventory",
            'TASK.HYPERFLEXMANAGEMENTSCOPEDINVENTORY': "task.HyperFlexManagementScopedInventory",
            'TASK.HYPERFLEXSCOPEDINVENTORY': "task.HyperflexScopedInventory",
            'TASK.IWESCOPEDINVENTORY': "task.IweScopedInventory",
            'TASK.MDSSCOPEDINVENTORY': "task.MdsScopedInventory",
            'TASK.MDSSYSTEMSCOPEDINVENTORY': "task.MdsSystemScopedInventory",
            'TASK.NETAPPSCOPEDINVENTORY': "task.NetAppScopedInventory",
            'TASK.NEXUSSCOPEDINVENTORY': "task.NexusScopedInventory",
            'TASK.NEXUSVLANSCOPEDINVENTORY': "task.NexusVlanScopedInventory",
            'TASK.PUBLICCLOUDSCOPEDINVENTORY': "task.PublicCloudScopedInventory",
            'TASK.PURESCOPEDINVENTORY': "task.PureScopedInventory",
            'TASK.SERVERSCOPEDINVENTORY': "task.ServerScopedInventory",
            'TECHSUPPORTMANAGEMENT.COLLECTIONCONTROLPOLICY': "techsupportmanagement.CollectionControlPolicy",
            'TECHSUPPORTMANAGEMENT.DOWNLOAD': "techsupportmanagement.Download",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTBUNDLE': "techsupportmanagement.TechSupportBundle",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTSTATUS': "techsupportmanagement.TechSupportStatus",
            'TERMINAL.AUDITLOG': "terminal.AuditLog",
            'TERRAFORM.EXECUTOR': "terraform.Executor",
            'THERMAL.POLICY': "thermal.Policy",
            'TOP.SYSTEM': "top.System",
            'UCSD.BACKUPINFO': "ucsd.BackupInfo",
            'UUIDPOOL.BLOCK': "uuidpool.Block",
            'UUIDPOOL.POOL': "uuidpool.Pool",
            'UUIDPOOL.POOLMEMBER': "uuidpool.PoolMember",
            'UUIDPOOL.UNIVERSE': "uuidpool.Universe",
            'UUIDPOOL.UUIDLEASE': "uuidpool.UuidLease",
            'VIEW.HEALTHSTATUS': "view.HealthStatus",
            'VIEW.SERVER': "view.Server",
            'VIRTUALIZATION.CISCOHYPERVISORMANAGER': "virtualization.CiscoHypervisorManager",
            'VIRTUALIZATION.ESXICONSOLE': "virtualization.EsxiConsole",
            'VIRTUALIZATION.HOST': "virtualization.Host",
            'VIRTUALIZATION.IWECLUSTER': "virtualization.IweCluster",
            'VIRTUALIZATION.IWEDATACENTER': "virtualization.IweDatacenter",
            'VIRTUALIZATION.IWEDVUPLINK': "virtualization.IweDvUplink",
            'VIRTUALIZATION.IWEDVSWITCH': "virtualization.IweDvswitch",
            'VIRTUALIZATION.IWEHOST': "virtualization.IweHost",
            'VIRTUALIZATION.IWEHOSTINTERFACE': "virtualization.IweHostInterface",
            'VIRTUALIZATION.IWEHOSTVSWITCH': "virtualization.IweHostVswitch",
            'VIRTUALIZATION.IWENETWORK': "virtualization.IweNetwork",
            'VIRTUALIZATION.IWEVIRTUALDISK': "virtualization.IweVirtualDisk",
            'VIRTUALIZATION.IWEVIRTUALMACHINE': "virtualization.IweVirtualMachine",
            'VIRTUALIZATION.IWEVIRTUALMACHINENETWORKINTERFACE': "virtualization.IweVirtualMachineNetworkInterface",
            'VIRTUALIZATION.VIRTUALDISK': "virtualization.VirtualDisk",
            'VIRTUALIZATION.VIRTUALMACHINE': "virtualization.VirtualMachine",
            'VIRTUALIZATION.VIRTUALNETWORK': "virtualization.VirtualNetwork",
            'VIRTUALIZATION.VMWARECLUSTER': "virtualization.VmwareCluster",
            'VIRTUALIZATION.VMWAREDATACENTER': "virtualization.VmwareDatacenter",
            'VIRTUALIZATION.VMWAREDATASTORE': "virtualization.VmwareDatastore",
            'VIRTUALIZATION.VMWAREDATASTORECLUSTER': "virtualization.VmwareDatastoreCluster",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDNETWORK': "virtualization.VmwareDistributedNetwork",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDSWITCH': "virtualization.VmwareDistributedSwitch",
            'VIRTUALIZATION.VMWAREFOLDER': "virtualization.VmwareFolder",
            'VIRTUALIZATION.VMWAREHOST': "virtualization.VmwareHost",
            'VIRTUALIZATION.VMWAREHOSTGPU': "virtualization.VmwareHostGpu",
            'VIRTUALIZATION.VMWAREKERNELNETWORK': "virtualization.VmwareKernelNetwork",
            'VIRTUALIZATION.VMWARENETWORK': "virtualization.VmwareNetwork",
            'VIRTUALIZATION.VMWAREPHYSICALNETWORKINTERFACE': "virtualization.VmwarePhysicalNetworkInterface",
            'VIRTUALIZATION.VMWAREUPLINKPORT': "virtualization.VmwareUplinkPort",
            'VIRTUALIZATION.VMWAREVCENTER': "virtualization.VmwareVcenter",
            'VIRTUALIZATION.VMWAREVIRTUALDISK': "virtualization.VmwareVirtualDisk",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINE': "virtualization.VmwareVirtualMachine",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINEGPU': "virtualization.VmwareVirtualMachineGpu",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINESNAPSHOT': "virtualization.VmwareVirtualMachineSnapshot",
            'VIRTUALIZATION.VMWAREVIRTUALNETWORKINTERFACE': "virtualization.VmwareVirtualNetworkInterface",
            'VIRTUALIZATION.VMWAREVIRTUALSWITCH': "virtualization.VmwareVirtualSwitch",
            'VMEDIA.POLICY': "vmedia.Policy",
            'VMEDIA.POLICYINVENTORY': "vmedia.PolicyInventory",
            'VMRC.CONSOLE': "vmrc.Console",
            'VNC.CONSOLE': "vnc.Console",
            'VNIC.ETHADAPTERPOLICY': "vnic.EthAdapterPolicy",
            'VNIC.ETHADAPTERPOLICYINVENTORY': "vnic.EthAdapterPolicyInventory",
            'VNIC.ETHIF': "vnic.EthIf",
            'VNIC.ETHIFINVENTORY': "vnic.EthIfInventory",
            'VNIC.ETHNETWORKPOLICY': "vnic.EthNetworkPolicy",
            'VNIC.ETHNETWORKPOLICYINVENTORY': "vnic.EthNetworkPolicyInventory",
            'VNIC.ETHQOSPOLICY': "vnic.EthQosPolicy",
            'VNIC.ETHQOSPOLICYINVENTORY': "vnic.EthQosPolicyInventory",
            'VNIC.ETHVETHINVENTORY': "vnic.EthVethInventory",
            'VNIC.ETHVNICINVENTORY': "vnic.EthVnicInventory",
            'VNIC.FCADAPTERPOLICY': "vnic.FcAdapterPolicy",
            'VNIC.FCADAPTERPOLICYINVENTORY': "vnic.FcAdapterPolicyInventory",
            'VNIC.FCIF': "vnic.FcIf",
            'VNIC.FCIFINVENTORY': "vnic.FcIfInventory",
            'VNIC.FCNETWORKPOLICY': "vnic.FcNetworkPolicy",
            'VNIC.FCNETWORKPOLICYINVENTORY': "vnic.FcNetworkPolicyInventory",
            'VNIC.FCQOSPOLICY': "vnic.FcQosPolicy",
            'VNIC.FCQOSPOLICYINVENTORY': "vnic.FcQosPolicyInventory",
            'VNIC.FCVETHINVENTORY': "vnic.FcVethInventory",
            'VNIC.FCVHBAPOLICYINVENTORY': "vnic.FcVhbaPolicyInventory",
            'VNIC.ISCSIADAPTERPOLICY': "vnic.IscsiAdapterPolicy",
            'VNIC.ISCSIADAPTERPOLICYINVENTORY': "vnic.IscsiAdapterPolicyInventory",
            'VNIC.ISCSIBOOTPOLICY': "vnic.IscsiBootPolicy",
            'VNIC.ISCSIBOOTPOLICYINVENTORY': "vnic.IscsiBootPolicyInventory",
            'VNIC.ISCSISTATICTARGETPOLICY': "vnic.IscsiStaticTargetPolicy",
            'VNIC.ISCSISTATICTARGETPOLICYINVENTORY': "vnic.IscsiStaticTargetPolicyInventory",
            'VNIC.LANCONNECTIVITYPOLICY': "vnic.LanConnectivityPolicy",
            'VNIC.LANCONNECTIVITYPOLICYINVENTORY': "vnic.LanConnectivityPolicyInventory",
            'VNIC.LCPSTATUS': "vnic.LcpStatus",
            'VNIC.SANCONNECTIVITYPOLICY': "vnic.SanConnectivityPolicy",
            'VNIC.SANCONNECTIVITYPOLICYINVENTORY': "vnic.SanConnectivityPolicyInventory",
            'VNIC.SCPSTATUS': "vnic.ScpStatus",
            'VRF.VRF': "vrf.Vrf",
            'WORKFLOW.ANSIBLEBATCHEXECUTOR': "workflow.AnsibleBatchExecutor",
            'WORKFLOW.BATCHAPIEXECUTOR': "workflow.BatchApiExecutor",
            'WORKFLOW.BUILDTASKMETA': "workflow.BuildTaskMeta",
            'WORKFLOW.BUILDTASKMETAOWNER': "workflow.BuildTaskMetaOwner",
            'WORKFLOW.CATALOG': "workflow.Catalog",
            'WORKFLOW.CUSTOMDATATYPEDEFINITION': "workflow.CustomDataTypeDefinition",
            'WORKFLOW.ERRORRESPONSEHANDLER': "workflow.ErrorResponseHandler",
            'WORKFLOW.PENDINGDYNAMICWORKFLOWINFO': "workflow.PendingDynamicWorkflowInfo",
            'WORKFLOW.POWERSHELLBATCHAPIEXECUTOR': "workflow.PowerShellBatchApiExecutor",
            'WORKFLOW.ROLLBACKWORKFLOW': "workflow.RollbackWorkflow",
            'WORKFLOW.SERVICEITEMACTIONDEFINITION': "workflow.ServiceItemActionDefinition",
            'WORKFLOW.SERVICEITEMACTIONINSTANCE': "workflow.ServiceItemActionInstance",
            'WORKFLOW.SERVICEITEMDEFINITION': "workflow.ServiceItemDefinition",
            'WORKFLOW.SERVICEITEMHEALTHCHECKDEFINITION': "workflow.ServiceItemHealthCheckDefinition",
            'WORKFLOW.SERVICEITEMHEALTHCHECKEXECUTION': "workflow.ServiceItemHealthCheckExecution",
            'WORKFLOW.SERVICEITEMINSTANCE': "workflow.ServiceItemInstance",
            'WORKFLOW.SERVICEITEMOUTPUT': "workflow.ServiceItemOutput",
            'WORKFLOW.SOLUTIONACTIONDEFINITION': "workflow.SolutionActionDefinition",
            'WORKFLOW.SOLUTIONACTIONINSTANCE': "workflow.SolutionActionInstance",
            'WORKFLOW.SOLUTIONDEFINITION': "workflow.SolutionDefinition",
            'WORKFLOW.SOLUTIONINSTANCE': "workflow.SolutionInstance",
            'WORKFLOW.SOLUTIONOUTPUT': "workflow.SolutionOutput",
            'WORKFLOW.SSHBATCHEXECUTOR': "workflow.SshBatchExecutor",
            'WORKFLOW.TASKDEBUGLOG': "workflow.TaskDebugLog",
            'WORKFLOW.TASKDEFINITION': "workflow.TaskDefinition",
            'WORKFLOW.TASKINFO': "workflow.TaskInfo",
            'WORKFLOW.TASKMETADATA': "workflow.TaskMetadata",
            'WORKFLOW.TASKNOTIFICATION': "workflow.TaskNotification",
            'WORKFLOW.TEMPLATEEVALUATION': "workflow.TemplateEvaluation",
            'WORKFLOW.TEMPLATEFUNCTIONMETA': "workflow.TemplateFunctionMeta",
            'WORKFLOW.TEMPLATEPARSER': "workflow.TemplateParser",
            'WORKFLOW.WORKFLOWDEFINITION': "workflow.WorkflowDefinition",
            'WORKFLOW.WORKFLOWINFO': "workflow.WorkflowInfo",
            'WORKFLOW.WORKFLOWMETA': "workflow.WorkflowMeta",
            'WORKFLOW.WORKFLOWMETADATA': "workflow.WorkflowMetadata",
            'WORKFLOW.WORKFLOWNOTIFICATION': "workflow.WorkflowNotification",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'selector': (str,),  # noqa: E501
            'link': (str,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'identity': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'billing_unit': (CloudBillingUnit,),  # noqa: E501
            'cidr': (str,),  # noqa: E501
            'region_info': (CloudCloudRegion,),  # noqa: E501
            'zone_info': (CloudAvailabilityZone,),  # noqa: E501
            'auto_assign_private_ip_v6': (bool,),  # noqa: E501
            'auto_assign_public_ip_v4': (bool,),  # noqa: E501
            'availability_zone_name': (str,),  # noqa: E501
            'ipv4_cidr': (str,),  # noqa: E501
            'ipv6_cidr': (str,),  # noqa: E501
            'is_default': (bool,),  # noqa: E501
            'state': (str,),  # noqa: E501
            'subnet_tags': ([CloudCloudTag], none_type,),  # noqa: E501
            'aws_vpc': (CloudAwsVpcRelationship,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'cloud.AwsSubnet': CloudAwsSubnet,
            'mo.MoRef': MoMoRef,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'selector': 'Selector',  # noqa: E501
        'link': 'link',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'identity': 'Identity',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'billing_unit': 'BillingUnit',  # noqa: E501
        'cidr': 'Cidr',  # noqa: E501
        'region_info': 'RegionInfo',  # noqa: E501
        'zone_info': 'ZoneInfo',  # noqa: E501
        'auto_assign_private_ip_v6': 'AutoAssignPrivateIpV6',  # noqa: E501
        'auto_assign_public_ip_v4': 'AutoAssignPublicIpV4',  # noqa: E501
        'availability_zone_name': 'AvailabilityZoneName',  # noqa: E501
        'ipv4_cidr': 'Ipv4Cidr',  # noqa: E501
        'ipv6_cidr': 'Ipv6Cidr',  # noqa: E501
        'is_default': 'IsDefault',  # noqa: E501
        'state': 'State',  # noqa: E501
        'subnet_tags': 'SubnetTags',  # noqa: E501
        'aws_vpc': 'AwsVpc',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
    }

    read_only_vars = {
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'cidr',  # noqa: E501
        'auto_assign_private_ip_v6',  # noqa: E501
        'auto_assign_public_ip_v4',  # noqa: E501
        'availability_zone_name',  # noqa: E501
        'ipv4_cidr',  # noqa: E501
        'ipv6_cidr',  # noqa: E501
        'is_default',  # noqa: E501
        'state',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """CloudAwsSubnetRelationship - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "mo.MoRef", must be one of ["mo.MoRef", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            moid (str): The Moid of the referenced REST resource.. [optional]  # noqa: E501
            selector (str): An OData $filter expression which describes the REST resource to be referenced. This field may be set instead of 'moid' by clients. 1. If 'moid' is set this field is ignored. 1. If 'selector' is set and 'moid' is empty/absent from the request, Intersight determines the Moid of the resource matching the filter expression and populates it in the MoRef that is part of the object instance being inserted/updated to fulfill the REST request. An error is returned if the filter matches zero or more than one REST resource. An example filter string is: Serial eq '3AA8B7T11'.. [optional]  # noqa: E501
            link (str): A URL to an instance of the 'mo.MoRef' class.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            identity (str): The internally generated identity of network. This entity cannot manipulated by users. It aids in uniquely identifying the network object. For VMware, this is MOR (managed object reference).. [optional]  # noqa: E501
            name (str): User-provided name to identify the portgroup.. [optional]  # noqa: E501
            billing_unit (CloudBillingUnit): [optional]  # noqa: E501
            cidr (str): CIDR scheme for defining an IP block.. [optional]  # noqa: E501
            region_info (CloudCloudRegion): [optional]  # noqa: E501
            zone_info (CloudAvailabilityZone): [optional]  # noqa: E501
            auto_assign_private_ip_v6 (bool): If true, Ipv4 address is assigned automatically.. [optional]  # noqa: E501
            auto_assign_public_ip_v4 (bool): If true, Ipv4 address is assigned automatically.. [optional]  # noqa: E501
            availability_zone_name (str): The Availability Zone name of the subnet.. [optional]  # noqa: E501
            ipv4_cidr (str): The IPv4 CIDR block assigned to the subnet... [optional]  # noqa: E501
            ipv6_cidr (str): The IPv6 CIDR block assigned to the subnet... [optional]  # noqa: E501
            is_default (bool): If true, indicates that this is default subnet.. [optional]  # noqa: E501
            state (str): The state of the subnet (pending | available).. [optional]  # noqa: E501
            subnet_tags ([CloudCloudTag], none_type): [optional]  # noqa: E501
            aws_vpc (CloudAwsVpcRelationship): [optional]  # noqa: E501
            object_type (str): The fully-qualified name of the remote type referred by this relationship.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "mo.MoRef")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """CloudAwsSubnetRelationship - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "mo.MoRef", must be one of ["mo.MoRef", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            moid (str): The Moid of the referenced REST resource.. [optional]  # noqa: E501
            selector (str): An OData $filter expression which describes the REST resource to be referenced. This field may be set instead of 'moid' by clients. 1. If 'moid' is set this field is ignored. 1. If 'selector' is set and 'moid' is empty/absent from the request, Intersight determines the Moid of the resource matching the filter expression and populates it in the MoRef that is part of the object instance being inserted/updated to fulfill the REST request. An error is returned if the filter matches zero or more than one REST resource. An example filter string is: Serial eq '3AA8B7T11'.. [optional]  # noqa: E501
            link (str): A URL to an instance of the 'mo.MoRef' class.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            identity (str): The internally generated identity of network. This entity cannot manipulated by users. It aids in uniquely identifying the network object. For VMware, this is MOR (managed object reference).. [optional]  # noqa: E501
            name (str): User-provided name to identify the portgroup.. [optional]  # noqa: E501
            billing_unit (CloudBillingUnit): [optional]  # noqa: E501
            cidr (str): CIDR scheme for defining an IP block.. [optional]  # noqa: E501
            region_info (CloudCloudRegion): [optional]  # noqa: E501
            zone_info (CloudAvailabilityZone): [optional]  # noqa: E501
            auto_assign_private_ip_v6 (bool): If true, Ipv4 address is assigned automatically.. [optional]  # noqa: E501
            auto_assign_public_ip_v4 (bool): If true, Ipv4 address is assigned automatically.. [optional]  # noqa: E501
            availability_zone_name (str): The Availability Zone name of the subnet.. [optional]  # noqa: E501
            ipv4_cidr (str): The IPv4 CIDR block assigned to the subnet... [optional]  # noqa: E501
            ipv6_cidr (str): The IPv6 CIDR block assigned to the subnet... [optional]  # noqa: E501
            is_default (bool): If true, indicates that this is default subnet.. [optional]  # noqa: E501
            state (str): The state of the subnet (pending | available).. [optional]  # noqa: E501
            subnet_tags ([CloudCloudTag], none_type): [optional]  # noqa: E501
            aws_vpc (CloudAwsVpcRelationship): [optional]  # noqa: E501
            object_type (str): The fully-qualified name of the remote type referred by this relationship.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "mo.MoRef")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
          ],
          'oneOf': [
              CloudAwsSubnet,
              MoMoRef,
              none_type,
          ],
        }
