"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-7766
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.api_client import ApiClient, Endpoint as _Endpoint
from intersight.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from intersight.model.telemetry_druid_data_source_metadata_request import TelemetryDruidDataSourceMetadataRequest
from intersight.model.telemetry_druid_data_source_metadata_result import TelemetryDruidDataSourceMetadataResult
from intersight.model.telemetry_druid_error import TelemetryDruidError
from intersight.model.telemetry_druid_group_by_request import TelemetryDruidGroupByRequest
from intersight.model.telemetry_druid_group_by_result import TelemetryDruidGroupByResult
from intersight.model.telemetry_druid_interval_result import TelemetryDruidIntervalResult
from intersight.model.telemetry_druid_scan_request import TelemetryDruidScanRequest
from intersight.model.telemetry_druid_scan_result import TelemetryDruidScanResult
from intersight.model.telemetry_druid_search_request import TelemetryDruidSearchRequest
from intersight.model.telemetry_druid_search_result import TelemetryDruidSearchResult
from intersight.model.telemetry_druid_segment_metadata_request import TelemetryDruidSegmentMetadataRequest
from intersight.model.telemetry_druid_segment_metadata_result import TelemetryDruidSegmentMetadataResult
from intersight.model.telemetry_druid_time_boundary_request import TelemetryDruidTimeBoundaryRequest
from intersight.model.telemetry_druid_time_boundary_result import TelemetryDruidTimeBoundaryResult
from intersight.model.telemetry_druid_time_series_request import TelemetryDruidTimeSeriesRequest
from intersight.model.telemetry_druid_top_n_request import TelemetryDruidTopNRequest
from intersight.model.telemetry_druid_top_n_result import TelemetryDruidTopNResult


class TelemetryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.query_telemetry_datasource_metadata_endpoint = _Endpoint(
            settings={
                'response_type': ([TelemetryDruidDataSourceMetadataResult],),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/telemetry/DataSourceMetadata',
                'operation_id': 'query_telemetry_datasource_metadata',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'telemetry_druid_data_source_metadata_request',
                ],
                'required': [
                    'telemetry_druid_data_source_metadata_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'telemetry_druid_data_source_metadata_request':
                        (TelemetryDruidDataSourceMetadataRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'telemetry_druid_data_source_metadata_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.query_telemetry_group_by_endpoint = _Endpoint(
            settings={
                'response_type': ([TelemetryDruidGroupByResult],),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/telemetry/GroupBys',
                'operation_id': 'query_telemetry_group_by',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'telemetry_druid_group_by_request',
                ],
                'required': [
                    'telemetry_druid_group_by_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'telemetry_druid_group_by_request':
                        (TelemetryDruidGroupByRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'telemetry_druid_group_by_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.query_telemetry_scan_endpoint = _Endpoint(
            settings={
                'response_type': ([TelemetryDruidScanResult],),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/telemetry/Scans',
                'operation_id': 'query_telemetry_scan',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'telemetry_druid_scan_request',
                ],
                'required': [
                    'telemetry_druid_scan_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'telemetry_druid_scan_request':
                        (TelemetryDruidScanRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'telemetry_druid_scan_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.query_telemetry_search_endpoint = _Endpoint(
            settings={
                'response_type': ([TelemetryDruidSearchResult],),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/telemetry/Searches',
                'operation_id': 'query_telemetry_search',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'telemetry_druid_search_request',
                ],
                'required': [
                    'telemetry_druid_search_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'telemetry_druid_search_request':
                        (TelemetryDruidSearchRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'telemetry_druid_search_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.query_telemetry_segment_metadata_endpoint = _Endpoint(
            settings={
                'response_type': ([TelemetryDruidSegmentMetadataResult],),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/telemetry/SegmentMetadata',
                'operation_id': 'query_telemetry_segment_metadata',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'telemetry_druid_segment_metadata_request',
                ],
                'required': [
                    'telemetry_druid_segment_metadata_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'telemetry_druid_segment_metadata_request':
                        (TelemetryDruidSegmentMetadataRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'telemetry_druid_segment_metadata_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.query_telemetry_time_boundary_endpoint = _Endpoint(
            settings={
                'response_type': ([TelemetryDruidTimeBoundaryResult],),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/telemetry/TimeBoundaries',
                'operation_id': 'query_telemetry_time_boundary',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'telemetry_druid_time_boundary_request',
                ],
                'required': [
                    'telemetry_druid_time_boundary_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'telemetry_druid_time_boundary_request':
                        (TelemetryDruidTimeBoundaryRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'telemetry_druid_time_boundary_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.query_telemetry_time_series_endpoint = _Endpoint(
            settings={
                'response_type': ([TelemetryDruidIntervalResult],),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/telemetry/TimeSeries',
                'operation_id': 'query_telemetry_time_series',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'telemetry_druid_time_series_request',
                ],
                'required': [
                    'telemetry_druid_time_series_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'telemetry_druid_time_series_request':
                        (TelemetryDruidTimeSeriesRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'telemetry_druid_time_series_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.query_telemetry_top_n_endpoint = _Endpoint(
            settings={
                'response_type': ([TelemetryDruidTopNResult],),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/telemetry/Topns',
                'operation_id': 'query_telemetry_top_n',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'telemetry_druid_top_n_request',
                ],
                'required': [
                    'telemetry_druid_top_n_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'telemetry_druid_top_n_request':
                        (TelemetryDruidTopNRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'telemetry_druid_top_n_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def query_telemetry_datasource_metadata(
        self,
        telemetry_druid_data_source_metadata_request,
        **kwargs
    ):
        """Perform a Druid DatasourceMetadata request.  # noqa: E501

        Endpoint that exposes Druid DatasourceMetadata requests for time series data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_telemetry_datasource_metadata(telemetry_druid_data_source_metadata_request, async_req=True)
        >>> result = thread.get()

        Args:
            telemetry_druid_data_source_metadata_request (TelemetryDruidDataSourceMetadataRequest): The Druid request schema for time series queries.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TelemetryDruidDataSourceMetadataResult]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['telemetry_druid_data_source_metadata_request'] = \
            telemetry_druid_data_source_metadata_request
        return self.query_telemetry_datasource_metadata_endpoint.call_with_http_info(**kwargs)

    def query_telemetry_group_by(
        self,
        telemetry_druid_group_by_request,
        **kwargs
    ):
        """Perform a Druid GroupBy request.  # noqa: E501

        Endpoint that exposes Druid GroupBy requests for time series data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_telemetry_group_by(telemetry_druid_group_by_request, async_req=True)
        >>> result = thread.get()

        Args:
            telemetry_druid_group_by_request (TelemetryDruidGroupByRequest): The Druid request schema for time series queries.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TelemetryDruidGroupByResult]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['telemetry_druid_group_by_request'] = \
            telemetry_druid_group_by_request
        return self.query_telemetry_group_by_endpoint.call_with_http_info(**kwargs)

    def query_telemetry_scan(
        self,
        telemetry_druid_scan_request,
        **kwargs
    ):
        """Perform a Druid Scan request.  # noqa: E501

        Endpoint that exposes Druid Scan requests for time series data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_telemetry_scan(telemetry_druid_scan_request, async_req=True)
        >>> result = thread.get()

        Args:
            telemetry_druid_scan_request (TelemetryDruidScanRequest): The Druid request schema for time series queries.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TelemetryDruidScanResult]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['telemetry_druid_scan_request'] = \
            telemetry_druid_scan_request
        return self.query_telemetry_scan_endpoint.call_with_http_info(**kwargs)

    def query_telemetry_search(
        self,
        telemetry_druid_search_request,
        **kwargs
    ):
        """Perform a Druid Search request.  # noqa: E501

        Endpoint that exposes Druid Search requests for time series data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_telemetry_search(telemetry_druid_search_request, async_req=True)
        >>> result = thread.get()

        Args:
            telemetry_druid_search_request (TelemetryDruidSearchRequest): The Druid request schema for time series queries.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TelemetryDruidSearchResult]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['telemetry_druid_search_request'] = \
            telemetry_druid_search_request
        return self.query_telemetry_search_endpoint.call_with_http_info(**kwargs)

    def query_telemetry_segment_metadata(
        self,
        telemetry_druid_segment_metadata_request,
        **kwargs
    ):
        """Perform a Druid SegmentMetadata request.  # noqa: E501

        Endpoint that exposes Druid SegmentMetadata requests for time series data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_telemetry_segment_metadata(telemetry_druid_segment_metadata_request, async_req=True)
        >>> result = thread.get()

        Args:
            telemetry_druid_segment_metadata_request (TelemetryDruidSegmentMetadataRequest): The Druid request schema for time series queries.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TelemetryDruidSegmentMetadataResult]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['telemetry_druid_segment_metadata_request'] = \
            telemetry_druid_segment_metadata_request
        return self.query_telemetry_segment_metadata_endpoint.call_with_http_info(**kwargs)

    def query_telemetry_time_boundary(
        self,
        telemetry_druid_time_boundary_request,
        **kwargs
    ):
        """Perform a Druid TimeBoundary request.  # noqa: E501

        Endpoint that exposes Druid TimeBoundary requests for time series data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_telemetry_time_boundary(telemetry_druid_time_boundary_request, async_req=True)
        >>> result = thread.get()

        Args:
            telemetry_druid_time_boundary_request (TelemetryDruidTimeBoundaryRequest): The Druid request schema for time series queries.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TelemetryDruidTimeBoundaryResult]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['telemetry_druid_time_boundary_request'] = \
            telemetry_druid_time_boundary_request
        return self.query_telemetry_time_boundary_endpoint.call_with_http_info(**kwargs)

    def query_telemetry_time_series(
        self,
        telemetry_druid_time_series_request,
        **kwargs
    ):
        """Perform a Druid TimeSeries request.  # noqa: E501

        Endpoint that exposes Druid requests for time series data. This endpoint exposes specifically TimeSeries requests and broker information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_telemetry_time_series(telemetry_druid_time_series_request, async_req=True)
        >>> result = thread.get()

        Args:
            telemetry_druid_time_series_request (TelemetryDruidTimeSeriesRequest): The Druid request schema for time series queries.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TelemetryDruidIntervalResult]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['telemetry_druid_time_series_request'] = \
            telemetry_druid_time_series_request
        return self.query_telemetry_time_series_endpoint.call_with_http_info(**kwargs)

    def query_telemetry_top_n(
        self,
        telemetry_druid_top_n_request,
        **kwargs
    ):
        """Perform a Druid TopN request.  # noqa: E501

        Endpoint that exposes Druid TopN requests for time series data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_telemetry_top_n(telemetry_druid_top_n_request, async_req=True)
        >>> result = thread.get()

        Args:
            telemetry_druid_top_n_request (TelemetryDruidTopNRequest): The Druid request schema for time series queries.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TelemetryDruidTopNResult]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['telemetry_druid_top_n_request'] = \
            telemetry_druid_top_n_request
        return self.query_telemetry_top_n_endpoint.call_with_http_info(**kwargs)

