"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Authorize WebSocket Api routes via a lambda function
 */
class WebSocketLambdaAuthorizer {
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_WebSocketLambdaAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketLambdaAuthorizer);
            }
            throw error;
        }
    }
    bind(options) {
        if (this.webSocketApi && (this.webSocketApi.apiId !== options.route.webSocketApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            this.webSocketApi = options.route.webSocketApi;
            this.authorizer = new aws_apigatewayv2_alpha_1.WebSocketAuthorizer(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                identitySource: this.props.identitySource ?? [
                    'route.request.header.Authorization',
                ],
                type: aws_apigatewayv2_alpha_1.WebSocketAuthorizerType.LAMBDA,
                authorizerName: this.props.authorizerName ?? this.id,
                authorizerUri: lambdaAuthorizerArn(this.handler),
            });
            this.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: aws_cdk_lib_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.webSocketApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.WebSocketLambdaAuthorizer = WebSocketLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.WebSocketLambdaAuthorizer", version: "2.61.1-alpha.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${aws_cdk_lib_1.Stack.of(handler).partition}:apigateway:${aws_cdk_lib_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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