"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rule = exports.RuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "RuleProperty", { enumerable: true, get: function () { return iot_generated_1.RosRule; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::Rule`
 */
class Rule extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::Rule`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRule = new iot_generated_1.RosRule(this, id, {
            topicType: props.topicType,
            iotInstanceId: props.iotInstanceId,
            resourceGroupId: props.resourceGroupId,
            ruleAction: props.ruleAction,
            shortTopic: props.shortTopic,
            select: props.select,
            startRule: props.startRule,
            dataType: props.dataType,
            ruleDesc: props.ruleDesc,
            where: props.where,
            productKey: props.productKey,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRule;
        this.attrActionId = rosRule.attrActionId;
        this.attrRuleId = rosRule.attrRuleId;
    }
}
exports.Rule = Rule;
//# sourceMappingURL=data:application/json;base64,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