"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Device = exports.DeviceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "DeviceProperty", { enumerable: true, get: function () { return iot_generated_1.RosDevice; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::Device`
 */
class Device extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::Device`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDevice = new iot_generated_1.RosDevice(this, id, {
            iotInstanceId: props.iotInstanceId,
            devEui: props.devEui,
            productKey: props.productKey,
            deviceName: props.deviceName,
            pinCode: props.pinCode,
            nickname: props.nickname,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDevice;
        this.attrDeviceName = rosDevice.attrDeviceName;
        this.attrDeviceSecret = rosDevice.attrDeviceSecret;
        this.attrIotId = rosDevice.attrIotId;
        this.attrIotInstanceId = rosDevice.attrIotInstanceId;
        this.attrIpAddress = rosDevice.attrIpAddress;
        this.attrNickName = rosDevice.attrNickName;
        this.attrNodeType = rosDevice.attrNodeType;
        this.attrProductKey = rosDevice.attrProductKey;
        this.attrProductName = rosDevice.attrProductName;
    }
}
exports.Device = Device;
//# sourceMappingURL=data:application/json;base64,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