/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.callbacks;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xcsp.common.Condition;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.predicates.EvaluationManager;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.XParser;
import org.xcsp.parser.callbacks.XCallbacks;
import org.xcsp.parser.callbacks.XCallbacks2;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XObjectives;
import org.xcsp.parser.entries.XVariables;

public final class SolutionChecker
implements XCallbacks2 {
    private static final int MAX_DISPLAY_STRING_SIZE = 2000;
    private XCallbacks.Implem implem = new XCallbacks.Implem(this);
    private boolean competitionMode;
    private BigInteger competitionComputedCost;
    private Solution solution;
    private XConstraints.XCtr currCtr;
    private XObjectives.XObj currObj;
    private int numCtr;
    private int numObj;
    public List<String> violatedCtrs;
    public List<String> invalidObjs;
    private Map<String, Integer> mapOfSymbols = new HashMap<String, Integer>();

    public static void main(String[] args) throws Exception {
        boolean competitionMode = args.length > 0 && args[0].equals("-cm");
        String[] stringArray = args = competitionMode ? Arrays.copyOfRange(args, 1, args.length) : args;
        if (args.length != 1 && args.length != 2) {
            System.out.println("Usage: " + SolutionChecker.class.getName() + " [-cm] <instanceFilename> [ <solutionFileName> ]");
        } else {
            new SolutionChecker(competitionMode, args[0], args.length == 1 ? System.in : (args[1].charAt(0) == '<' ? new ByteArrayInputStream(args[1].getBytes()) : new FileInputStream(args[1])));
        }
    }

    @Override
    public XCallbacks.Implem implem() {
        return this.implem;
    }

    public SolutionChecker(boolean competitionMode, String fileName, InputStream solutionStream) throws Exception {
        this.competitionMode = competitionMode;
        this.implem().rawParameters();
        Scanner scanner = new Scanner(solutionStream);
        if (competitionMode) {
            String vline;
            ArrayList<String> vlines = new ArrayList<String>();
            ArrayList<String> slines = new ArrayList<String>();
            while (scanner.hasNext()) {
                String line = scanner.nextLine();
                if (line.startsWith("s ")) {
                    slines.add(line);
                    continue;
                }
                if (!line.startsWith("v ")) continue;
                vlines.add(line);
            }
            scanner.close();
            String string = vline = vlines.size() == 0 ? null : vlines.stream().map(s -> s.substring(2)).collect(Collectors.joining(" ")).trim();
            if (slines.size() != 1) {
                System.out.println("One s line expected");
            } else if (((String)slines.get(0)).startsWith("s SATISFIABLE") || ((String)slines.get(0)).startsWith("s OPTIMUM")) {
                if (vline == null || !vline.endsWith("</instantiation>")) {
                    System.out.println("ERROR: no instantiation found");
                } else {
                    try {
                        Element elt = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(vline.getBytes())).getDocumentElement();
                        this.solution = new Solution(elt);
                        this.loadInstance(fileName, new String[0]);
                        if (this.violatedCtrs.size() == 0 && this.invalidObjs.size() == 0) {
                            System.out.println("OK\t" + (this.competitionComputedCost != null ? this.competitionComputedCost : ""));
                        } else {
                            System.out.println("INVALID Solution! (" + (this.violatedCtrs.size() + this.invalidObjs.size()) + " errors)");
                            if (this.violatedCtrs.size() > 0) {
                                System.out.println("  Violated Constraint " + this.violatedCtrs.get(0));
                            }
                            if (this.invalidObjs.size() > 0) {
                                System.out.println("  Invalid Objective " + this.invalidObjs.get(0));
                            }
                        }
                    }
                    catch (Exception e) {
                        System.out.println("ERROR: the instantiation cannot be checked " + e);
                        e.printStackTrace();
                    }
                }
            }
        } else {
            String s2 = scanner.useDelimiter("\\A").next();
            scanner.close();
            while (true) {
                this.implem().allIds.clear();
                int start = s2.indexOf("<instantiation");
                int end = s2.indexOf("</instantiation>", start);
                if (start == -1 || end == -1) break;
                String sol = s2.substring(start, end + "</instantiation>".length());
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(sol.getBytes()));
                this.solution = new Solution(doc.getDocumentElement());
                this.loadInstance(fileName, new String[0]);
                s2 = s2.substring(end + "</instantiation>".length());
            }
        }
    }

    protected void controlConstraint(boolean condition) {
        if (!condition) {
            String s = this.currCtr.toString();
            this.violatedCtrs.add(String.valueOf(this.currCtr.id) + " : " + (s.length() > 2000 ? s.substring(0, 2000) : s));
        }
    }

    protected void controlObjective(BigInteger computedCost) {
        this.competitionComputedCost = computedCost;
        if (!this.competitionMode && this.solution.costs != null && this.solution.costs[this.numObj] != null && !computedCost.equals(this.solution.costs[this.numObj])) {
            System.out.println(computedCost + " vs " + this.solution.costs[this.numObj]);
            String s = this.currObj.toString();
            this.invalidObjs.add(String.valueOf(this.currObj.id) + " : " + (s.length() > 2000 ? s.substring(0, 2000) : s));
        }
    }

    @Override
    public void loadVariables(XParser parser) {
        if (!this.competitionMode) {
            System.out.println("LOG: Check variables");
        }
        XCallbacks2.super.loadVariables(parser);
        this.solution.parseVariablesAndValues(parser);
    }

    @Override
    public void loadConstraints(XParser parser) {
        if (!this.competitionMode) {
            System.out.println("LOG: Check constraints");
        }
        this.violatedCtrs = new ArrayList<String>();
        this.numCtr = -1;
        XCallbacks2.super.loadConstraints(parser);
    }

    @Override
    public void loadCtr(XConstraints.XCtr c) {
        XVariables.XVar[] xVarArray = c.vars();
        int n = xVarArray.length;
        int n2 = 0;
        while (n2 < n) {
            XVariables.XVar x = xVarArray[n2];
            Object obj = this.solution.map.get(x);
            Utilities.control(obj != null, x + "is not given a value although it is involved in one constraint ");
            Utilities.control(!(obj instanceof String) || !((String)obj).equals("*"), x + " cannot be assigned the value * because it has not degree 0");
            ++n2;
        }
        this.currCtr = c;
        ++this.numCtr;
        XCallbacks2.super.loadCtr(c);
    }

    @Override
    public void loadObjectives(XParser parser) {
        this.invalidObjs = new ArrayList<String>();
        if (parser.oEntries.size() > 0) {
            if (!this.competitionMode) {
                System.out.println("LOG: Check objectives");
            }
            this.numObj = -1;
            XCallbacks2.super.loadObjectives(parser);
        }
    }

    @Override
    public void loadObj(XObjectives.XObj o) {
        Utilities.control(o.type != Types.TypeObjective.LEX, "Currently, objectives of type lex are not managed by this checker.");
        this.currObj = o;
        ++this.numObj;
        XCallbacks2.super.loadObj(o);
    }

    @Override
    public void endInstance() {
        if (!this.competitionMode) {
            if (this.violatedCtrs.size() == 0 && this.invalidObjs.size() == 0) {
                System.out.println("OK\t" + (this.competitionComputedCost != null ? this.competitionComputedCost : ""));
            } else {
                System.out.println("INVALID Solution! (" + (this.violatedCtrs.size() + this.invalidObjs.size()) + " errors)");
                this.violatedCtrs.stream().forEach(c -> System.out.println("  Violated Constraint " + c));
                this.invalidObjs.stream().forEach(o -> System.out.println("  Invalid Objective " + o));
            }
        }
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int minValue, int maxValue) {
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int[] values) {
    }

    private long[] valuesOfTrees(XNode<XVariables.XVarInteger>[] trees, int[] coeffs) {
        XVariables.XVarInteger[][] scopes = (XVariables.XVarInteger[][])Stream.of(trees).map(t -> (XVariables.XVarInteger[])t.vars()).toArray(n -> new XVariables.XVarInteger[n][]);
        return IntStream.range(0, trees.length).mapToLong(i -> new EvaluationManager(trees[i]).evaluate(this.solution.intValuesOf(scopes[i])) * (long)(coeffs == null ? 1 : coeffs[i])).toArray();
    }

    @Override
    public void buildCtrIntension(String id, XVariables.XVarInteger[] scope, XNodeParent<XVariables.XVarInteger> tree) {
        Utilities.control(tree.exactlyVars(scope), "Pb with scope");
        this.controlConstraint(new EvaluationManager(tree).evaluate(this.solution.intValuesOf(scope)) == 1L);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger x, int[] values, boolean positive, Set<Types.TypeFlag> flags) {
        this.controlConstraint(Utilities.contains(values, this.solution.intValueOf(x)) == positive);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger[] list, int[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        int[] tuple = this.solution.intValuesOf(list);
        boolean found = ((Stream)Stream.of(tuples).parallel()).anyMatch(t -> IntStream.range(0, ((int[])t).length).allMatch(i -> t[i] == 0x7FFFFFFE || t[i] == tuple[i]));
        this.controlConstraint(found == positive);
    }

    private String reachedState(String startState, XVariables.XVarInteger[] list, Object[][] transitions) {
        HashMap map = new HashMap();
        Stream.of(transitions).forEach(tr -> {
            String string = map.put(tr[0] + ":" + tr[1], "" + tr[2]);
        });
        String current = startState;
        XVariables.XVarInteger[] xVarIntegerArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            XVariables.XVarInteger x = xVarIntegerArray[n2];
            String next = (String)map.get(String.valueOf(current) + ":" + this.solution.intValueOf(x));
            if (next == null) {
                return null;
            }
            current = next;
            ++n2;
        }
        return current;
    }

    @Override
    public void buildCtrRegular(String id, XVariables.XVarInteger[] list, Object[][] transitions, String startState, String[] finalStates) {
        String state = this.reachedState(startState, list, transitions);
        this.controlConstraint(state != null && Arrays.stream(finalStates).anyMatch(v -> v.equals(state)));
    }

    @Override
    public void buildCtrMDD(String id, XVariables.XVarInteger[] list, Object[][] transitions) {
        String state = this.reachedState((String)transitions[0][0], list, transitions);
        this.controlConstraint(state != null);
    }

    @Override
    public void buildCtrAllDifferent(String id, XVariables.XVarInteger[] list) {
        this.controlConstraint(IntStream.of(this.solution.intValuesOf(list)).distinct().count() == (long)list.length);
    }

    @Override
    public void buildCtrAllDifferentExcept(String id, XVariables.XVarInteger[] list, int[] except) {
        XVariables.XVarInteger[] sublist = (XVariables.XVarInteger[])Stream.of(list).filter(x -> !Utilities.contains(except, this.solution.intValueOf(x))).toArray(XVariables.XVarInteger[]::new);
        this.controlConstraint(IntStream.of(this.solution.intValuesOf(sublist)).distinct().count() == (long)sublist.length);
    }

    private boolean distinctVectors(int[] v1, int[] v2) {
        assert (v1.length == v2.length);
        return IntStream.range(0, v1.length).anyMatch(i -> v1[i] != v2[i]);
    }

    @Override
    public void buildCtrAllDifferentList(String id, XVariables.XVarInteger[][] lists) {
        int[][] tuples = this.solution.intValuesOf(lists);
        this.controlConstraint(IntStream.range(0, tuples.length).allMatch(i -> IntStream.range(i + 1, tuples.length).allMatch(j -> this.distinctVectors(tuples[i], tuples[j]))));
    }

    @Override
    public void buildCtrAllDifferentMatrix(String id, XVariables.XVarInteger[][] matrix) {
        int[][] tuples = this.solution.intValuesOf(matrix);
        this.controlConstraint(IntStream.range(0, tuples.length).allMatch(i -> IntStream.of(tuples[i]).distinct().count() == (long)tuples[i].length));
        int[][] transposedTuples = (int[][])IntStream.range(0, tuples.length).mapToObj(i -> IntStream.range(0, tuples[0].length).map(j -> tuples[j][i]).toArray()).toArray(n -> new int[n][]);
        this.controlConstraint(IntStream.range(0, transposedTuples.length).allMatch(i -> IntStream.of(transposedTuples[i]).distinct().count() == (long)transposedTuples[i].length));
    }

    @Override
    public void buildCtrAllDifferent(String id, XNode<XVariables.XVarInteger>[] trees) {
        long[] t = this.valuesOfTrees(trees, null);
        this.controlConstraint(LongStream.of(t).distinct().count() == (long)trees.length);
    }

    @Override
    public void buildCtrAllEqual(String id, XVariables.XVarInteger[] list) {
        this.controlConstraint(IntStream.of(this.solution.intValuesOf(list)).distinct().count() == 1L);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, Types.TypeOperatorRel operator) {
        int[] tuple = this.solution.intValuesOf(list);
        this.controlConstraint(IntStream.range(0, tuple.length - 1).allMatch(i -> operator.isValidFor(tuple[i], tuple[i + 1])));
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, int[] lengths, Types.TypeOperatorRel operator) {
        int[] tuple = this.solution.intValuesOf(list);
        this.controlConstraint(IntStream.range(0, tuple.length - 1).allMatch(i -> operator.isValidFor(tuple[i] + lengths[i], tuple[i + 1])));
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] lengths, Types.TypeOperatorRel operator) {
        int[] ls = this.solution.intValuesOf(list);
        int[] lg = this.solution.intValuesOf(lengths);
        this.controlConstraint(IntStream.range(0, ls.length - 1).allMatch(i -> operator.isValidFor(ls[i] + lg[i], ls[i + 1])));
    }

    private boolean orderedVectors(int[] v1, int[] v2, Types.TypeOperatorRel operator) {
        assert (v1.length == v2.length);
        int i = 0;
        while (i < v1.length) {
            if (operator == Types.TypeOperatorRel.LE || operator == Types.TypeOperatorRel.LT) {
                if (v1[i] < v2[i]) {
                    return true;
                }
                if (v1[i] > v2[i]) {
                    return false;
                }
            } else if (operator == Types.TypeOperatorRel.GE || operator == Types.TypeOperatorRel.GT) {
                if (v1[i] > v2[i]) {
                    return true;
                }
                if (v1[i] < v2[i]) {
                    return false;
                }
            }
            ++i;
        }
        return operator == Types.TypeOperatorRel.LE || operator == Types.TypeOperatorRel.GE;
    }

    @Override
    public void buildCtrLex(String id, XVariables.XVarInteger[][] lists, Types.TypeOperatorRel operator) {
        int[][] tuples = this.solution.intValuesOf(lists);
        this.controlConstraint(IntStream.range(0, tuples.length).allMatch(i -> IntStream.range(i + 1, tuples.length).allMatch(j -> this.orderedVectors(tuples[i], tuples[j], operator))));
    }

    @Override
    public void buildCtrLexMatrix(String id, XVariables.XVarInteger[][] matrix, Types.TypeOperatorRel operator) {
        int[][] tuples = this.solution.intValuesOf(matrix);
        this.controlConstraint(IntStream.range(0, tuples.length).allMatch(i -> IntStream.range(i + 1, tuples.length).allMatch(j -> this.orderedVectors(tuples[i], tuples[j], operator))));
        int[][] transposedTuples = (int[][])IntStream.range(0, tuples[0].length).mapToObj(i -> IntStream.range(0, tuples.length).map(j -> tuples[j][i]).toArray()).toArray(n -> new int[n][]);
        this.controlConstraint(IntStream.range(0, transposedTuples.length).allMatch(i -> IntStream.range(i + 1, transposedTuples.length).allMatch(j -> this.orderedVectors(transposedTuples[i], transposedTuples[j], operator))));
    }

    protected void checkCondition(int value, Condition condition) {
        if (condition instanceof Condition.ConditionVar) {
            this.controlConstraint(((Condition.ConditionVar)condition).operator.isValidFor(value, this.solution.intValueOf((XVariables.XVarInteger)((Condition.ConditionVar)condition).x)));
        } else if (condition instanceof Condition.ConditionVal) {
            this.controlConstraint(((Condition.ConditionVal)condition).operator.isValidFor(value, ((Condition.ConditionVal)condition).k));
        } else if (condition instanceof Condition.ConditionIntvl) {
            this.controlConstraint(((Condition.ConditionIntvl)condition).operator.isValidFor(value, ((Condition.ConditionIntvl)condition).min, ((Condition.ConditionIntvl)condition).max));
        } else if (condition instanceof Condition.ConditionIntset) {
            this.controlConstraint(((Condition.ConditionIntset)condition).operator.isValidFor(value, ((Condition.ConditionIntset)condition).t));
        }
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.checkCondition(IntStream.of(this.solution.intValuesOf(list)).sum(), condition);
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, int[] coeffs, Condition condition) {
        this.checkCondition(IntStream.range(0, list.length).map(i -> this.solution.intValueOf(list[i]) * coeffs[i]).sum(), condition);
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] coeffs, Condition condition) {
        this.checkCondition(IntStream.range(0, list.length).map(i -> this.solution.intValueOf(list[i]) * this.solution.intValueOf(coeffs[i])).sum(), condition);
    }

    @Override
    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        long[] t = this.valuesOfTrees(trees, null);
        BigInteger b = BigInteger.ZERO;
        long[] lArray = t;
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            b = b.add(BigInteger.valueOf(v));
            ++n2;
        }
        this.checkCondition(b.intValueExact(), condition);
    }

    @Override
    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, int[] coeffs, Condition condition) {
        long[] t = this.valuesOfTrees(trees, coeffs);
        BigInteger b = BigInteger.ZERO;
        long[] lArray = t;
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            b = b.add(BigInteger.valueOf(v));
            ++n2;
        }
        this.checkCondition(b.intValueExact(), condition);
    }

    @Override
    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, XVariables.XVarInteger[] coeffs, Condition condition) {
        XVariables.XVarInteger[][] scopes = (XVariables.XVarInteger[][])Stream.of(trees).map(t -> (XVariables.XVarInteger[])t.vars()).toArray(n -> new XVariables.XVarInteger[n][]);
        long[] t2 = IntStream.range(0, trees.length).mapToLong(i -> new EvaluationManager(trees[i]).evaluate(this.solution.intValuesOf(scopes[i])) * (long)this.solution.intValueOf(coeffs[i])).toArray();
        BigInteger b = BigInteger.ZERO;
        long[] lArray = t2;
        int n2 = t2.length;
        int n3 = 0;
        while (n3 < n2) {
            long v = lArray[n3];
            b = b.add(BigInteger.valueOf(v));
            ++n3;
        }
        this.checkCondition(b.intValueExact(), condition);
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        this.checkCondition((int)IntStream.of(this.solution.intValuesOf(list)).filter(v -> Utilities.contains(values, v)).count(), condition);
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] values, Condition condition) {
        this.buildCtrCount(id, list, this.solution.intValuesOf(values), condition);
    }

    @Override
    public void buildCtrNValuesExcept(String id, XVariables.XVarInteger[] list, int[] except, Condition condition) {
        this.checkCondition((int)IntStream.of(this.solution.intValuesOf(list)).filter(v -> !Utilities.contains(except, v)).distinct().count(), condition);
    }

    @Override
    public void buildCtrNValues(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.buildCtrNValuesExcept(id, list, new int[0], condition);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occurs) {
        int[] tuple = this.solution.intValuesOf(list);
        this.controlConstraint(IntStream.range(0, values.length).allMatch(i -> IntStream.of(tuple).filter(v -> v == values[i]).count() == (long)occurs[i]));
        this.controlConstraint(!closed || IntStream.of(tuple).allMatch(v -> Utilities.contains(values, v)));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, XVariables.XVarInteger[] occurs) {
        this.buildCtrCardinality(id, list, closed, values, this.solution.intValuesOf(occurs));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, XVariables.XVarInteger[] occurs) {
        this.buildCtrCardinality(id, list, closed, this.solution.intValuesOf(values), this.solution.intValuesOf(occurs));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occurs) {
        this.buildCtrCardinality(id, list, closed, this.solution.intValuesOf(values), occurs);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occursMin, int[] occursMax) {
        int[] tuple = this.solution.intValuesOf(list);
        this.controlConstraint(IntStream.range(0, values.length).allMatch(i -> {
            int nb = (int)IntStream.of(tuple).filter(v -> v == values[i]).count();
            return occursMin[i] <= nb && nb <= occursMax[i];
        }));
        this.controlConstraint(!closed || IntStream.of(tuple).allMatch(v -> Utilities.contains(values, v)));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occursMin, int[] occursMax) {
        this.buildCtrCardinality(id, list, closed, this.solution.intValuesOf(values), occursMin, occursMax);
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.checkCondition(IntStream.of(this.solution.intValuesOf(list)).max().getAsInt(), condition);
    }

    @Override
    public void buildCtrMaximum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        long[] t = this.valuesOfTrees(trees, null);
        this.checkCondition(Utilities.safeLong2Int(LongStream.of(t).max().getAsLong(), true), condition);
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.checkCondition(IntStream.of(this.solution.intValuesOf(list)).min().getAsInt(), condition);
    }

    @Override
    public void buildCtrMinimum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        long[] t = this.valuesOfTrees(trees, null);
        this.checkCondition(Utilities.safeLong2Int(LongStream.of(t).min().getAsLong(), true), condition);
    }

    private void checkArgMin(String id, int[] tuple, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition, int value) {
        int i = this.solution.intValueOf(index) - startIndex;
        this.controlConstraint(tuple[i] == value);
        this.controlConstraint(rank != Types.TypeRank.FIRST || !Utilities.contains(tuple, value, 0, i - 1));
        this.controlConstraint(rank != Types.TypeRank.LAST || !Utilities.contains(tuple, value, i + 1, tuple.length - 1));
        if (condition != null) {
            this.checkCondition(value, condition);
        }
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        int[] tuple = this.solution.intValuesOf(list);
        this.checkArgMin(id, tuple, startIndex, index, rank, condition, IntStream.of(tuple).max().getAsInt());
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        int[] tuple = this.solution.intValuesOf(list);
        this.checkArgMin(id, tuple, startIndex, index, rank, condition, IntStream.of(tuple).min().getAsInt());
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex) {
        this.controlConstraint(IntStream.range(0, list.length).allMatch(i -> {
            int j = this.solution.intValueOf(list[i]) - startIndex;
            return j >= 0 && j < list.length && this.solution.intValueOf(list[j]) == i + startIndex;
        }));
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list1, int startIndex1, XVariables.XVarInteger[] list2, int startIndex2) {
        int[] t1 = this.solution.intValuesOf(list1);
        int[] t2 = this.solution.intValuesOf(list2);
        this.controlConstraint(IntStream.range(0, t1.length).allMatch(i -> {
            int j = t1[i] - startIndex2;
            return j >= 0 && j < t2.length && t2[j] - startIndex1 == i;
        }));
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger value) {
        int[] tuple = this.solution.intValuesOf(list);
        this.controlConstraint(IntStream.of(tuple).filter(v -> v == 1).count() == 1L);
        int pos = this.solution.intValueOf(value) - startIndex;
        this.controlConstraint(pos >= 0 && pos < list.length && tuple[pos] == 1);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int value) {
        this.controlConstraint(Utilities.contains(this.solution.intValuesOf(list), value));
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger value) {
        this.buildCtrElement(id, list, this.solution.intValueOf(value));
    }

    private void controlElement(String id, int[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, int value) {
        int i = this.solution.intValueOf(index) - startIndex;
        this.controlConstraint(list[i] == value);
        this.controlConstraint(rank != Types.TypeRank.FIRST || !Utilities.contains(list, value, 0, i - 1));
        this.controlConstraint(rank != Types.TypeRank.LAST || !Utilities.contains(list, value, i + 1, list.length - 1));
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, int value) {
        this.controlElement(id, this.solution.intValuesOf(list), startIndex, index, rank, value);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        this.buildCtrElement(id, list, startIndex, index, rank, this.solution.intValueOf(value));
    }

    @Override
    public void buildCtrElement(String id, int[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        this.controlElement(id, list, startIndex, index, rank, this.solution.intValueOf(value));
    }

    @Override
    public void buildCtrElement(String id, int[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, int value) {
        int j;
        int i = this.solution.intValueOf(rowIndex) - startRowIndex;
        this.controlConstraint(matrix[i][j = this.solution.intValueOf(colIndex) - startColIndex] == value);
    }

    @Override
    public void buildCtrElement(String id, int[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, XVariables.XVarInteger value) {
        this.buildCtrElement(id, matrix, startRowIndex, rowIndex, startColIndex, colIndex, this.solution.intValueOf(value));
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, int value) {
        this.buildCtrElement(id, this.solution.intValuesOf(matrix), startRowIndex, rowIndex, startColIndex, colIndex, value);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, XVariables.XVarInteger value) {
        this.buildCtrElement(id, matrix, startRowIndex, rowIndex, startColIndex, colIndex, this.solution.intValueOf(value));
    }

    @Override
    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax) {
        int[] tuple = this.solution.intValuesOf(list);
        int i = 0;
        while (i < tuple.length) {
            int v = tuple[i];
            int j = i + 1;
            while (j < tuple.length && tuple[j] == v) {
                ++j;
            }
            int width = j - i;
            int pos = IntStream.range(0, values.length).filter(p -> values[p] == v).findFirst().getAsInt();
            this.controlConstraint(widthsMin[pos] <= width && width <= widthsMax[pos]);
            i = j;
        }
    }

    @Override
    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        this.buildCtrStretch(id, list, values, widthsMin, widthsMax);
        int[] tuple = this.solution.intValuesOf(list);
        this.controlConstraint(IntStream.range(0, tuple.length - 1).noneMatch(i -> tuple[i] != tuple[i + 1] && Stream.of(patterns).anyMatch(t -> t[0] == tuple[i] && t[1] == tuple[i + 1])));
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, int[] lengths, boolean zeroIgnored) {
        int[] tuple = this.solution.intValuesOf(origins);
        int[] sublist = IntStream.range(0, origins.length).filter(i -> !zeroIgnored || lengths[i] != 0).toArray();
        this.controlConstraint(IntStream.range(0, sublist.length).allMatch(i -> IntStream.range(0, sublist.length).filter(j -> j > i).allMatch(j -> tuple[sublist[i]] + lengths[sublist[i]] <= tuple[sublist[j]] || tuple[sublist[j]] + lengths[sublist[j]] <= tuple[sublist[i]])));
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, boolean zeroIgnored) {
        this.buildCtrNoOverlap(id, origins, this.solution.intValuesOf(lengths), zeroIgnored);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, int[][] lengths, boolean zeroIgnored) {
        int[][] tuples = this.solution.intValuesOf(origins);
        int[] sublist = IntStream.range(0, origins.length).filter(i -> !zeroIgnored || IntStream.of(lengths[i]).allMatch(l -> l != 0)).toArray();
        this.controlConstraint(IntStream.range(0, sublist.length).allMatch(i -> IntStream.range(0, sublist.length).filter(j -> j > i).allMatch(j -> IntStream.range(0, origins[0].length).anyMatch(k -> tuples[sublist[i]][k] + lengths[sublist[i]][k] <= tuples[sublist[j]][k] || tuples[sublist[j]][k] + lengths[sublist[j]][k] <= tuples[sublist[i]][k]))));
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, XVariables.XVarInteger[][] lengths, boolean zeroIgnored) {
        this.buildCtrNoOverlap(id, origins, this.solution.intValuesOf(lengths), zeroIgnored);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, int[] heights, Condition condition) {
        int[] tuple = this.solution.intValuesOf(origins);
        int min = IntStream.of(tuple).min().getAsInt();
        int max = IntStream.range(0, tuple.length).map(i -> tuple[i] + lengths[i]).max().getAsInt();
        IntStream.rangeClosed(min, max).forEach(t -> {
            int h = IntStream.range(0, tuple.length).filter(i -> tuple[i] <= t && t < tuple[i] + lengths[i]).map(i -> heights[i]).sum();
            this.checkCondition(h, condition);
        });
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.buildCtrCumulative(id, origins, lengths, this.solution.intValuesOf(heights), condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, int[] heights, Condition condition) {
        this.buildCtrCumulative(id, origins, this.solution.intValuesOf(lengths), heights, condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.buildCtrCumulative(id, origins, this.solution.intValuesOf(lengths), this.solution.intValuesOf(heights), condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.buildCtrCumulative(id, origins, lengths, heights, condition);
        this.controlConstraint(IntStream.range(0, origins.length).allMatch(i -> this.solution.intValueOf(origins[i]) + lengths[i] == this.solution.intValueOf(ends[i])));
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.buildCtrCumulative(id, origins, lengths, ends, this.solution.intValuesOf(heights), condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.buildCtrCumulative(id, origins, this.solution.intValuesOf(lengths), ends, heights, condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.buildCtrCumulative(id, origins, this.solution.intValuesOf(lengths), ends, this.solution.intValuesOf(heights), condition);
    }

    @Override
    public void buildCtrInstantiation(String id, XVariables.XVarInteger[] list, int[] values) {
        this.controlConstraint(IntStream.range(0, list.length).allMatch(i -> this.solution.intValueOf(list[i]) == values[i]));
    }

    @Override
    public void buildCtrClause(String id, XVariables.XVarInteger[] pos, XVariables.XVarInteger[] neg) {
        this.controlConstraint(IntStream.of(this.solution.intValuesOf(pos)).anyMatch(p -> p == 1) || IntStream.of(this.solution.intValuesOf(neg)).anyMatch(p -> p == 0));
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex) {
        Utilities.control(startIndex == 0, "Other cases currently not implemented");
        int[] tuple = this.solution.intValuesOf(list);
        this.controlConstraint(IntStream.of(tuple).distinct().count() == (long)list.length);
        int nbLoops = (int)IntStream.range(0, list.length).filter(i -> tuple[i] == i).count();
        this.controlConstraint(nbLoops != list.length);
        int i2 = 0;
        while (i2 < list.length && tuple[i2] == i2) {
            ++i2;
        }
        TreeSet<Integer> s = new TreeSet<Integer>();
        while (tuple[i2] != i2 && !s.contains(tuple[i2])) {
            s.add(tuple[i2]);
            i2 = tuple[i2];
        }
        this.controlConstraint(s.size() == tuple.length - nbLoops);
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex, int size) {
        this.buildCtrCircuit(id, list, startIndex);
        int nbLoops = (int)IntStream.range(0, list.length).filter(i -> this.solution.intValueOf(list[i]) == i).count();
        this.controlConstraint(size == list.length - nbLoops);
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger size) {
        this.buildCtrCircuit(id, list, startIndex, this.solution.intValueOf(size));
    }

    @Override
    public void buildObjToMinimize(String id, XVariables.XVarInteger x) {
        this.controlObjective(BigInteger.valueOf(this.solution.intValueOf(x)));
    }

    @Override
    public void buildObjToMaximize(String id, XVariables.XVarInteger x) {
        this.buildObjToMinimize(id, x);
    }

    @Override
    public void buildObjToMinimize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        this.controlObjective(BigInteger.valueOf(new EvaluationManager(tree).evaluate(this.solution.intValuesOf((XVariables.XVarInteger[])tree.vars()))));
    }

    @Override
    public void buildObjToMaximize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        this.buildObjToMinimize(id, tree);
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.buildObjToMinimize(id, type, list, null);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.buildObjToMinimize(id, type, list, null);
    }

    private void computeObjective(String id, Types.TypeObjective type, BigInteger[] list, int[] coeffs) {
        BigInteger[] bis;
        BigInteger[] bigIntegerArray = bis = coeffs == null ? list : (BigInteger[])IntStream.range(0, list.length).mapToObj(i -> list[i].multiply(BigInteger.valueOf(coeffs[i]))).toArray(BigInteger[]::new);
        if (type == Types.TypeObjective.NVALUES) {
            this.controlObjective(BigInteger.valueOf(Stream.of(bis).distinct().count()));
        } else {
            assert (type != Types.TypeObjective.LEX);
            BigInteger computedCost = bis[0];
            int i2 = 1;
            while (i2 < list.length) {
                if (type == Types.TypeObjective.SUM) {
                    computedCost = computedCost.add(bis[i2]);
                }
                if (type == Types.TypeObjective.PRODUCT) {
                    computedCost = computedCost.multiply(bis[i2]);
                }
                if (type == Types.TypeObjective.MINIMUM) {
                    computedCost = computedCost.min(bis[i2]);
                }
                if (type == Types.TypeObjective.MAXIMUM) {
                    computedCost = computedCost.max(bis[i2]);
                }
                ++i2;
            }
            this.controlObjective(computedCost);
        }
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.computeObjective(id, type, (BigInteger[])Stream.of(list).map(x -> BigInteger.valueOf(this.solution.intValueOf(x))).toArray(BigInteger[]::new), coeffs);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.buildObjToMinimize(id, type, list, coeffs);
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees) {
        this.buildObjToMinimize(id, type, trees, null);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees) {
        this.buildObjToMinimize(id, type, trees);
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees, int[] coeffs) {
        long[] t = this.valuesOfTrees(trees, null);
        this.computeObjective(id, type, (BigInteger[])IntStream.range(0, t.length).mapToObj(i -> BigInteger.valueOf(t[i])).toArray(BigInteger[]::new), coeffs);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees, int[] coeffs) {
        this.buildObjToMinimize(id, type, trees, coeffs);
    }

    @Override
    public void buildVarSymbolic(XVariables.XVarSymbolic x, String[] values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            if (this.mapOfSymbols.get(v) == null) {
                this.mapOfSymbols.put(v, this.mapOfSymbols.size());
            }
            ++n2;
        }
    }

    @Override
    public void buildCtrIntension(String id, XVariables.XVarSymbolic[] scope, XNodeParent<XVariables.XVarSymbolic> tree) {
        Utilities.control(tree.exactlyVars(scope), "Pb with scope");
        this.controlConstraint(new EvaluationManager(tree, this.mapOfSymbols).evaluate(Stream.of(this.solution.symbolicValuesOf(scope)).mapToInt(s -> this.mapOfSymbols.get(s)).toArray()) == 1L);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarSymbolic x, String[] values, boolean positive, Set<Types.TypeFlag> flags) {
        this.controlConstraint(Stream.of(values).anyMatch(v -> v.equals(this.solution.symbolicValueOf(x))) == positive);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarSymbolic[] list, String[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        String[] tuple = this.solution.symbolicValuesOf(list);
        boolean found = Stream.of(tuples).anyMatch(t -> IntStream.range(0, ((String[])t).length).allMatch(i -> t[i].equals("*") || t[i].equals(tuple[i])));
        this.controlConstraint(found == positive);
    }

    @Override
    public void buildCtrAllDifferent(String id, XVariables.XVarSymbolic[] list) {
        this.controlConstraint(Stream.of(this.solution.symbolicValuesOf(list)).distinct().count() == (long)list.length);
    }

    private class Solution {
        private Element root;
        private Object[] variables;
        private Object[] values;
        private BigInteger[] costs;
        private Map<XVariables.XVar, Object> map = new HashMap<XVariables.XVar, Object>();

        private int intValueOf(XVariables.XVarInteger x) {
            Utilities.control(this.map.containsKey(x), "The variable " + x + " is not assigned a value");
            Object value = this.map.get(x);
            if (value instanceof String && ((String)value).equals("*")) {
                Utilities.control(((Domains.Dom)x.dom).nValues() == 1L, "* is accepted when there is only one value");
                value = x.firstValue();
            }
            return Utilities.safeLong2Int((Number)value, true);
        }

        private int[] intValuesOf(XVariables.XVarInteger[] list) {
            return Stream.of(list).mapToInt(x -> this.intValueOf((XVariables.XVarInteger)x)).toArray();
        }

        private int[][] intValuesOf(XVariables.XVarInteger[][] lists) {
            return (int[][])Stream.of(lists).map(t -> this.intValuesOf((XVariables.XVarInteger[])t)).toArray(n -> new int[n][]);
        }

        private String symbolicValueOf(XVariables.XVarSymbolic x) {
            Utilities.control(this.map.containsKey(x), "The variable " + x + " is not assigned a value");
            return (String)this.map.get(x);
        }

        private String[] symbolicValuesOf(XVariables.XVarSymbolic[] list) {
            return (String[])Stream.of(list).map(x -> this.symbolicValueOf((XVariables.XVarSymbolic)x)).toArray(String[]::new);
        }

        private Solution(Element root) {
            this.root = root;
            Element[] childs = Utilities.childElementsOf(this.root);
            Utilities.control(Utilities.isTag(childs[0], Types.TypeChild.list) && Utilities.isTag(childs[1], Types.TypeChild.values), "Badly formed solution/instantiation");
        }

        private void parseVariablesAndValues(XParser parser) {
            Element[] childs = Utilities.childElementsOf(this.root);
            Object[] objectArray = this.variables = parser.parseSequence(childs[0].getTextContent().trim(), "\\s+");
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                Object x = objectArray[n2];
                Utilities.control(x == null || x instanceof XVariables.XVarInteger || x instanceof XVariables.XVarSymbolic, x + " " + " is not an integer or symbolic variable. Currently, only these types of variables are supported.");
                ++n2;
            }
            this.values = parser.parseSequence(childs[1].getTextContent().trim(), "\\s+");
            Utilities.control(this.variables.length == this.values.length, "list and values must be of the same size");
            int i = 0;
            while (i < this.variables.length) {
                if (this.variables[i] == null) {
                    Utilities.control(this.values[i] instanceof String && ((String)this.values[i]).equals("*"), "* must be necessarily associated with a null variable (corresponding to a hole in an array)");
                } else {
                    XVariables.XVar x = (XVariables.XVar)this.variables[i];
                    this.map.put(x, this.values[i]);
                    if (!(this.values[i] instanceof String) || !((String)this.values[i]).equals("*")) {
                        if (x instanceof XVariables.XVarInteger) {
                            Utilities.control(((Domains.Dom)x.dom).contains(this.intValueOf((XVariables.XVarInteger)x)), "Wrong value for variable " + x);
                        } else if (x instanceof XVariables.XVarSymbolic) {
                            Utilities.control(((Domains.DomSymbolic)x.dom).contains(this.symbolicValueOf((XVariables.XVarSymbolic)x)), "Wrong value for variable " + x);
                        } else {
                            SolutionChecker.this.unimplementedCase(new Object[0]);
                        }
                    }
                }
                ++i;
            }
            this.costs = this.root.getAttribute(Types.TypeAtt.cost.name()).length() == 0 ? null : (BigInteger[])Stream.of(this.root.getAttribute(Types.TypeAtt.cost.name()).split("\\s+")).map(s -> new BigInteger((String)s)).toArray(BigInteger[]::new);
            Utilities.control(this.costs == null || this.costs.length == parser.oEntries.size(), "Either you indicate no cost at all or you indicate a long cost for each objective.");
        }
    }
}

