/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.predicates;

import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;

public interface MatcherInterface {
    public static final XNodeLeaf<IVar> any = XNode.specialLeaf("any");
    public static final XNodeLeaf<IVar> anyc = XNode.specialLeaf("anyc");
    public static final XNodeLeaf<IVar> var = XNode.specialLeaf("var");
    public static final XNodeLeaf<IVar> val = XNode.specialLeaf("val");
    public static final XNodeLeaf<IVar> varOrVal = XNode.specialLeaf("var-or-val");
    public static final XNodeLeaf<IVar> any_add_val = XNode.specialLeaf("any-add-val");
    public static final XNodeLeaf<IVar> var_add_val = XNode.specialLeaf("var-add-val");
    public static final XNodeLeaf<IVar> sub = XNode.specialLeaf("sub");
    public static final XNodeLeaf<IVar> not = XNode.specialLeaf("not");
    public static final XNodeLeaf<IVar> set_vals = XNode.specialLeaf("set-vals");
    public static final XNodeLeaf<IVar> min_vars = XNode.specialLeaf("min-vars");
    public static final XNodeLeaf<IVar> max_vars = XNode.specialLeaf("max-vars");
    public static final XNodeLeaf<IVar> logic_vars = XNode.specialLeaf("logic-vars");
    public static final XNodeLeaf<IVar> add_vars = XNode.specialLeaf("add-vars");
    public static final XNodeLeaf<IVar> add_mul_vals = XNode.specialLeaf("add-mul-vals");
    public static final XNodeLeaf<IVar> add_mul_vars = XNode.specialLeaf("add-mul-vars");
    public static final Matcher x_mul_k = new Matcher(XNode.node(Types.TypeExpr.MUL, var, val));
    public static final Matcher x_mul_y = new Matcher(XNode.node(Types.TypeExpr.MUL, var, var));
    public static final Matcher k_mul_x = new Matcher(XNode.node(Types.TypeExpr.MUL, val, var));

    public XNode<IVar> target();

    public boolean validForSpecialTargetNode(XNode<? extends IVar> var1, int var2);

    default public boolean matching(XNode<? extends IVar> source, XNode<IVar> target, int level) {
        if (target == any) {
            return true;
        }
        if (target == anyc) {
            return this.validForSpecialTargetNode(source, level);
        }
        if (target == var) {
            return source.type == Types.TypeExpr.VAR;
        }
        if (target == val) {
            return source.type == Types.TypeExpr.LONG;
        }
        if (target == varOrVal) {
            return source.type == Types.TypeExpr.VAR || source.type == Types.TypeExpr.LONG;
        }
        if (target == any_add_val) {
            return source.type == Types.TypeExpr.ADD && source.sons.length == 2 && source.sons[1].type == Types.TypeExpr.LONG;
        }
        if (target == var_add_val) {
            return source.type == Types.TypeExpr.ADD && source.sons.length == 2 && source.sons[0].type == Types.TypeExpr.VAR && source.sons[1].type == Types.TypeExpr.LONG;
        }
        if (target == sub) {
            return source.type == Types.TypeExpr.SUB;
        }
        if (target == not) {
            return source.type == Types.TypeExpr.NOT;
        }
        if (target == set_vals) {
            return source.type == Types.TypeExpr.SET && (source instanceof XNodeLeaf || Stream.of(source.sons).allMatch(s -> s.type == Types.TypeExpr.LONG));
        }
        if (target == min_vars) {
            return source.type == Types.TypeExpr.MIN && source.sons.length >= 2 && Stream.of(source.sons).allMatch(s -> s.type == Types.TypeExpr.VAR);
        }
        if (target == max_vars) {
            return source.type == Types.TypeExpr.MAX && source.sons.length >= 2 && Stream.of(source.sons).allMatch(s -> s.type == Types.TypeExpr.VAR);
        }
        if (target == logic_vars) {
            return source.type.isLogicalOperator() && source.sons.length >= 2 && Stream.of(source.sons).allMatch(s -> s.type == Types.TypeExpr.VAR);
        }
        if (target == add_vars) {
            return source.type == Types.TypeExpr.ADD && source.sons.length >= 2 && Stream.of(source.sons).allMatch(s -> s.type == Types.TypeExpr.VAR);
        }
        if (target == add_mul_vals) {
            return source.type == Types.TypeExpr.ADD && source.sons.length >= 2 && Stream.of(source.sons).allMatch(s -> s.type == Types.TypeExpr.VAR || x_mul_k.matches((XNode<? extends IVar>)s));
        }
        if (target == add_mul_vars) {
            return source.type == Types.TypeExpr.ADD && source.sons.length >= 2 && Stream.of(source.sons).allMatch(s -> x_mul_y.matches((XNode<? extends IVar>)s));
        }
        if (target instanceof XNodeLeaf != source instanceof XNodeLeaf) {
            return false;
        }
        if (target.type == Types.TypeExpr.SPECIAL && !this.validForSpecialTargetNode(source, level) || target.type != Types.TypeExpr.SPECIAL && target.type != source.type) {
            return false;
        }
        return target instanceof XNodeLeaf || target.sons.length == source.sons.length && IntStream.range(0, target.sons.length).allMatch(i -> this.matching(xNode.sons[i], xNode2.sons[i], level + 1));
    }

    default public boolean matches(XNode<? extends IVar> tree) {
        return this.matching(tree, this.target(), 0);
    }

    public static enum AbstractOperation {
        ariop,
        relop,
        setop,
        unaop,
        logop,
        symop;

    }

    public static class Matcher
    implements MatcherInterface {
        private final XNode<IVar> target;
        private final BiPredicate<XNode<? extends IVar>, Integer> p;

        @Override
        public XNode<IVar> target() {
            return this.target;
        }

        public Matcher(XNode<IVar> target, BiPredicate<XNode<? extends IVar>, Integer> p) {
            this.target = target;
            this.p = p;
        }

        public Matcher(XNode<IVar> target) {
            this(target, (node, level) -> level == 0 && node.type.isRelationalOperator() || level == 1 && node.type.isArithmeticOperator());
        }

        @Override
        public boolean validForSpecialTargetNode(XNode<? extends IVar> node, int level) {
            return this.p.test(node, level);
        }
    }
}

