/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.predicates;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.common.predicates.XNode;

public class EvaluationManager {
    private static final Map<String, Class<?>> classMap = new HashMap();
    private static final Map<String, Integer> arityMap = new HashMap<String, Integer>();
    private static final Set<String> symmetricEvaluators = new HashSet<String>();
    private static final Set<String> associativeEvaluators = new HashSet<String>();
    public static final int SAMPLING_LIMIT = 1000;
    private XNode<? extends IVar> tree;
    public Evaluator[] evaluators;
    private int top = -1;
    private long[] stack;
    private int[] shortCircuits;
    private int[] values;
    private int[] tmp = new int[1];
    Integer arity;

    static {
        Class[] classArray = (Class[])Stream.of(EvaluationManager.class.getDeclaredClasses()).filter(c -> Evaluator.class.isAssignableFrom((Class<?>)c) && !Modifier.isAbstract(c.getModifiers())).toArray(Class[]::new);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class cl = classArray[n2];
            String evaluatorToken = String.valueOf(cl.getSimpleName().substring(0, 1).toLowerCase()) + cl.getSimpleName().substring(1, cl.getSimpleName().lastIndexOf(Evaluator.class.getSimpleName()));
            classMap.put(evaluatorToken, cl);
            int arity = -1;
            try {
                if (TagArity0.class.isAssignableFrom(cl)) {
                    arity = 0;
                }
                if (TagArity1.class.isAssignableFrom(cl)) {
                    arity = 1;
                }
                if (TagArity2.class.isAssignableFrom(cl)) {
                    arity = 2;
                }
                if (TagArity3.class.isAssignableFrom(cl)) {
                    arity = 3;
                }
                if (TagArityX.class.isAssignableFrom(cl)) {
                    arity = Integer.MAX_VALUE;
                }
                if (TagSymmetric.class.isAssignableFrom(cl)) {
                    symmetricEvaluators.add(evaluatorToken);
                }
                if (TagAssociative.class.isAssignableFrom(cl)) {
                    associativeEvaluators.add(evaluatorToken);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            Utilities.control(arity != -1, "Pb with arity");
            arityMap.put(evaluatorToken, arity);
            ++n2;
        }
    }

    public static Class<?> classOf(String tok) {
        return classMap.get(tok);
    }

    public static int arityOf(String tok) {
        Integer a = arityMap.get(tok);
        if (a != null) {
            return a;
        }
        int pos = IntStream.range(0, tok.length()).filter(i -> !Character.isDigit(tok.charAt(i))).findFirst().orElse(tok.length()) - 1;
        return pos == -1 || pos == tok.length() - 1 ? -1 : Integer.parseInt(tok.substring(0, pos + 1));
    }

    public static boolean isSymmetric(String tok) {
        return symmetricEvaluators.contains(tok);
    }

    public static boolean isAssociative(String tok) {
        return associativeEvaluators.contains(tok);
    }

    public boolean isBoolean() {
        return this.evaluators[this.evaluators.length - 1] instanceof TagBoolean;
    }

    public boolean isInteger() {
        return this.evaluators[this.evaluators.length - 1] instanceof TagInteger;
    }

    private Evaluator buildEvaluator(String tok, List<String> varNames) {
        try {
            if (tok.matches("^(-?)\\d+$")) {
                return new LongEvaluator(Long.parseLong(tok));
            }
            if (tok.startsWith("%")) {
                return new VariableEvaluator(Integer.parseInt(tok.substring(1)));
            }
            if (EvaluationManager.classOf(tok) != null) {
                return (Evaluator)EvaluationManager.classOf(tok).getDeclaredConstructor(EvaluationManager.class).newInstance(this);
            }
            int pos = IntStream.range(0, tok.length()).filter(i -> !Character.isDigit(tok.charAt(i))).findFirst().orElse(tok.length()) - 1;
            if (pos == -1) {
                int varPos = varNames.indexOf(tok);
                if (varPos == -1) {
                    varPos = varNames.size();
                    varNames.add(tok);
                }
                return new VariableEvaluator(varPos);
            }
            Evaluator evaluator = (Evaluator)EvaluationManager.classOf(String.valueOf(tok.substring(pos + 1)) + "x").getDeclaredConstructor(EvaluationManager.class).newInstance(this);
            evaluator.arity = Integer.parseInt(tok.substring(0, pos + 1));
            return evaluator;
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    private void dealWithShortCircuits() {
        boolean useShortCircuits = true;
        if (!useShortCircuits) {
            return;
        }
        this.shortCircuits = new int[this.evaluators.length];
        useShortCircuits = false;
        int i = 0;
        while (i < this.evaluators.length - 1) {
            if (!(this.evaluators[i] instanceof TagInteger)) {
                int j = i + 1;
                int nbStackedElements = 1;
                while (j < this.evaluators.length) {
                    if ((nbStackedElements += 1 - this.evaluators[j].arity) <= 1) break;
                    ++j;
                }
                if (j != i + 1) {
                    if (this.evaluators[j] instanceof OrEvaluator) {
                        this.shortCircuits[i] = j + 1;
                        useShortCircuits = true;
                    } else if (this.evaluators[j] instanceof AndEvaluator) {
                        this.shortCircuits[i] = -j - 1;
                        useShortCircuits = true;
                    }
                }
            }
            ++i;
        }
        if (!useShortCircuits) {
            this.shortCircuits = null;
        }
    }

    private void buildEvaluators() {
        ArrayList varNames = new ArrayList();
        this.evaluators = (Evaluator[])Stream.of(this.tree.toPostfixExpression(this.tree.vars()).split("\\s+")).map(s -> this.buildEvaluator((String)s, varNames)).peek(e -> e.fixArity()).toArray(Evaluator[]::new);
        this.dealWithShortCircuits();
        this.stack = new long[this.evaluators.length];
        assert (this.evaluators.length > 0);
        int[] allPositions = Stream.of(this.evaluators).filter(e -> e instanceof VariableEvaluator).mapToInt(e -> ((VariableEvaluator)e).position).distinct().sorted().toArray();
        Utilities.control(IntStream.range(0, allPositions.length).allMatch(i -> i == allPositions[i]), "");
        this.arity = allPositions.length;
    }

    public EvaluationManager(XNode<? extends IVar> tree) {
        this.tree = tree;
        this.buildEvaluators();
    }

    public EvaluationManager(XNode<? extends IVar> tree, Map<String, Integer> mapOfSymbols) {
        this(mapOfSymbols == null ? tree : tree.replaceSymbols(mapOfSymbols));
    }

    public final long evaluate(int[] values) {
        this.values = values;
        this.top = -1;
        if (this.shortCircuits == null) {
            Evaluator[] evaluatorArray = this.evaluators;
            int n = this.evaluators.length;
            int n2 = 0;
            while (n2 < n) {
                Evaluator evaluator = evaluatorArray[n2];
                evaluator.evaluate();
                ++n2;
            }
        } else {
            int i = 0;
            while (i < this.evaluators.length) {
                this.evaluators[i].evaluate();
                if (this.shortCircuits[i] == 0) {
                    ++i;
                    continue;
                }
                if (this.shortCircuits[i] > 0) {
                    i = this.stack[this.top] == 1L ? this.shortCircuits[i] : i + 1;
                    continue;
                }
                int n = i = this.stack[this.top] == 0L ? -this.shortCircuits[i] : i + 1;
            }
        }
        assert (this.top == 0) : "" + this.top;
        return this.stack[this.top];
    }

    public final int[] generatePossibleValues(int[][] domValues) {
        if (this.isBoolean()) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            return nArray;
        }
        HashSet set = new HashSet();
        new EnumerationCartesian(domValues).execute(tuple -> {
            boolean bl = set.add(this.evaluate((int[])tuple));
        });
        return set.stream().peek(i -> {
            boolean bl = Utilities.isSafeInt(i);
        }).mapToInt(i -> i.intValue()).sorted().toArray();
    }

    public final int[][] generateTuples(int[][] domValues, Utilities.ModifiableBoolean positive, int limit) {
        ArrayList<int[]> supports = new ArrayList<int[]>();
        ArrayList<int[]> conflicts = new ArrayList<int[]>();
        int[] tupleIdx = new int[domValues.length];
        int[] tupleVal = new int[domValues.length];
        int cnt = 0;
        boolean hasNext = true;
        while (hasNext) {
            boolean consistent;
            int i = 0;
            while (i < tupleVal.length) {
                tupleVal[i] = domValues[i][tupleIdx[i]];
                ++i;
            }
            boolean bl = consistent = this.evaluate(tupleVal) == 1L;
            if (consistent && positive.value != Boolean.FALSE) {
                supports.add((int[])tupleVal.clone());
            }
            if (!consistent && positive.value != Boolean.TRUE) {
                conflicts.add((int[])tupleVal.clone());
            }
            if (positive.value == null && ++cnt > limit) {
                positive.value = supports.size() <= conflicts.size() ? Boolean.TRUE : Boolean.FALSE;
            }
            hasNext = false;
            int i2 = 0;
            while (!hasNext && i2 < tupleIdx.length) {
                if (tupleIdx[i2] + 1 < domValues[i2].length) {
                    int n = i2;
                    tupleIdx[n] = tupleIdx[n] + 1;
                    hasNext = true;
                } else {
                    tupleIdx[i2] = 0;
                }
                ++i2;
            }
        }
        if (positive.value == null) {
            positive.value = supports.size() <= conflicts.size() ? Boolean.TRUE : Boolean.FALSE;
        }
        return positive.value != false ? (int[][])supports.toArray((T[])new int[0][]) : (int[][])conflicts.toArray((T[])new int[0][]);
    }

    public final int[][] generateTuples(int[][] domValues, Utilities.ModifiableBoolean positive) {
        return this.generateTuples(domValues, positive, 1000);
    }

    public final int[][] generateSupports(int[][] domValues) {
        return this.generateTuples(domValues, new Utilities.ModifiableBoolean(true));
    }

    public final int[][] generateConflicts(int[][] domValues) {
        return this.generateTuples(domValues, new Utilities.ModifiableBoolean(false));
    }

    public final long evaluate(int value) {
        this.tmp[0] = value;
        return this.evaluate(this.tmp);
    }

    public boolean controlArityOfEvaluators() {
        return Stream.of(this.evaluators).mapToInt(e -> 1 - e.arity).sum() == 1;
    }

    public boolean controlTypeOfEvaluators(boolean booleanType) {
        if (booleanType && !this.isBoolean()) {
            return false;
        }
        if (!booleanType && !this.isInteger()) {
            return false;
        }
        boolean[] booleanTypes = new boolean[this.evaluators.length];
        int top = -1;
        Evaluator[] evaluatorArray = this.evaluators;
        int n = this.evaluators.length;
        int n2 = 0;
        while (n2 < n) {
            int j;
            Evaluator evaluator = evaluatorArray[n2];
            if (evaluator instanceof TagArithmetic) {
                if (evaluator instanceof IfEvaluator) {
                    if (!booleanTypes[top] || booleanTypes[top - 1] || booleanTypes[top - 2]) {
                        return false;
                    }
                    top -= 3;
                } else {
                    j = 0;
                    while (j < evaluator.arity) {
                        if (booleanTypes[top]) {
                            return false;
                        }
                        --top;
                        ++j;
                    }
                }
            } else if (evaluator instanceof TagLogical) {
                j = 0;
                while (j < evaluator.arity) {
                    if (!booleanTypes[top]) {
                        return false;
                    }
                    --top;
                    ++j;
                }
            } else if (evaluator instanceof TagRelational) {
                j = 0;
                while (j < evaluator.arity) {
                    if (booleanTypes[top]) {
                        return false;
                    }
                    --top;
                    ++j;
                }
            }
            booleanTypes[++top] = evaluator instanceof TagBoolean;
            ++n2;
        }
        return true;
    }

    public class AbsEvaluator
    extends Evaluator
    implements TagArity1,
    TagArithmetic {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.abs(EvaluationManager.this.stack[EvaluationManager.this.top]);
        }
    }

    public class AddEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] + EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public class AddxEvaluator
    extends Evaluator
    implements TagArityX,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            long sum = EvaluationManager.this.stack[EvaluationManager.this.top];
            int i = 1;
            while (i < this.arity) {
                sum += EvaluationManager.this.stack[EvaluationManager.this.top + i];
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = sum;
        }
    }

    public class AndEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.min(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class AndxEvaluator
    extends Evaluator
    implements TagArityX,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            int i = 0;
            while (i < this.arity) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] == 0L) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class DistEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.abs(EvaluationManager.this.stack[EvaluationManager.this.top] - EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class DivEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] / EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public class EqEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] == EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class EqxEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            long value = EvaluationManager.this.stack[EvaluationManager.this.top];
            int i = 1;
            while (i < this.arity) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] != value) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public abstract class Evaluator {
        public int arity = -1;

        public void fixArity() {
            Utilities.control(this.arity == -1 || this instanceof TagArityX, "Pb with arity");
            if (this.arity == -1) {
                this.arity = this instanceof TagArity0 ? 0 : (this instanceof TagArity1 ? 1 : (this instanceof TagArity2 ? 2 : (this instanceof TagArity3 ? 3 : -1)));
            }
        }

        public abstract void evaluate();

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static interface ExternFunctionArity1 {
        public long evaluate(long var1);
    }

    public static interface ExternFunctionArity2 {
        public long evaluate(long var1, long var3);
    }

    public class F1Evaluator
    extends Evaluator
    implements TagArity1,
    TagArithmetic {
        public ExternFunctionArity1 function;

        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = this.function.evaluate(EvaluationManager.this.stack[EvaluationManager.this.top]);
        }
    }

    public class F2Evaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        public ExternFunctionArity2 function;

        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = this.function.evaluate(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class FalseEvaluator
    extends Evaluator
    implements TagArity0,
    TagTerminal,
    TagBoolean {
        @Override
        public void evaluate() {
            long[] lArray = EvaluationManager.this.stack;
            EvaluationManager evaluationManager = EvaluationManager.this;
            int n = evaluationManager.top + 1;
            evaluationManager.top = n;
            lArray[n] = 0L;
        }
    }

    public class GeEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] >= EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class GexEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            int i = 1;
            while (i < this.arity) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i - 1] < EvaluationManager.this.stack[EvaluationManager.this.top + i]) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class GtEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] > EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class GtxEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            int i = 1;
            while (i < this.arity) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i - 1] <= EvaluationManager.this.stack[EvaluationManager.this.top + i]) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class IfEvaluator
    extends Evaluator
    implements TagArity3,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 2;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] == 1L ? EvaluationManager.this.stack[EvaluationManager.this.top + 1] : EvaluationManager.this.stack[EvaluationManager.this.top + 2];
        }
    }

    public class IffEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] == EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class IffxEvaluator
    extends Evaluator
    implements TagArityX,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            long value = EvaluationManager.this.stack[EvaluationManager.this.top];
            int i = 1;
            while (i < this.arity) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] != value) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class ImpEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] == 0L || EvaluationManager.this.stack[EvaluationManager.this.top + 1] == 1L ? 1 : 0;
        }
    }

    public class InEvaluator
    extends Evaluator
    implements TagArity2,
    TagSet,
    TagBoolean {
        @Override
        public void evaluate() {
            long[] lArray = EvaluationManager.this.stack;
            EvaluationManager evaluationManager = EvaluationManager.this;
            int n = evaluationManager.top;
            evaluationManager.top = n - 1;
            int arity = (int)lArray[n];
            EvaluationManager evaluationManager2 = EvaluationManager.this;
            evaluationManager2.top = evaluationManager2.top - arity;
            long value = EvaluationManager.this.stack[EvaluationManager.this.top];
            int i = 1;
            while (i < arity + 1) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] == value) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
        }
    }

    public class LeEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] <= EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class LexEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            int i = 1;
            while (i < this.arity) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i - 1] > EvaluationManager.this.stack[EvaluationManager.this.top + i]) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class LongEvaluator
    extends Evaluator
    implements TagArity0,
    TagTerminal,
    TagInteger {
        public final long value;

        public LongEvaluator(long value) {
            this.value = value;
        }

        @Override
        public void evaluate() {
            long[] lArray = EvaluationManager.this.stack;
            EvaluationManager evaluationManager = EvaluationManager.this;
            int n = evaluationManager.top + 1;
            evaluationManager.top = n;
            lArray[n] = this.value;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "(" + this.value + ")";
        }
    }

    public class LtEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] < EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class LtxEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            int i = 1;
            while (i < this.arity) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i - 1] >= EvaluationManager.this.stack[EvaluationManager.this.top + i]) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class MaxEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.max(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class MaxxEvaluator
    extends Evaluator
    implements TagArityX,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            long max = EvaluationManager.this.stack[EvaluationManager.this.top];
            int i = 1;
            while (i < this.arity) {
                max = Math.max(max, EvaluationManager.this.stack[EvaluationManager.this.top + i]);
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = max;
        }
    }

    public class MinEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.min(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class MinxEvaluator
    extends Evaluator
    implements TagArityX,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            long min = EvaluationManager.this.stack[EvaluationManager.this.top];
            int i = 1;
            while (i < this.arity) {
                min = Math.min(min, EvaluationManager.this.stack[EvaluationManager.this.top + i]);
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = min;
        }
    }

    public class ModEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] % EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public class MulEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] * EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public class MulxEvaluator
    extends Evaluator
    implements TagArityX,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            long product = EvaluationManager.this.stack[EvaluationManager.this.top];
            int i = 1;
            while (i < this.arity) {
                product *= EvaluationManager.this.stack[EvaluationManager.this.top + i];
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = product;
        }
    }

    public class NeEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] != EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class NegEvaluator
    extends Evaluator
    implements TagArity1,
    TagArithmetic {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = -EvaluationManager.this.stack[EvaluationManager.this.top];
        }
    }

    public class NexEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            int i = this.arity - 1;
            while (i > 0) {
                int j = i - 1;
                while (j >= 0) {
                    if (EvaluationManager.this.stack[EvaluationManager.this.top + i] == EvaluationManager.this.stack[EvaluationManager.this.top + j]) {
                        ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                        return;
                    }
                    --j;
                }
                --i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class NotEvaluator
    extends Evaluator
    implements TagArity1 {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L - EvaluationManager.this.stack[EvaluationManager.this.top];
        }
    }

    public class NotinEvaluator
    extends Evaluator
    implements TagArity2,
    TagSet,
    TagBoolean {
        @Override
        public void evaluate() {
            long[] lArray = EvaluationManager.this.stack;
            EvaluationManager evaluationManager = EvaluationManager.this;
            int n = evaluationManager.top;
            evaluationManager.top = n - 1;
            int arity = (int)lArray[n];
            EvaluationManager evaluationManager2 = EvaluationManager.this;
            evaluationManager2.top = evaluationManager2.top - arity;
            long value = EvaluationManager.this.stack[EvaluationManager.this.top];
            int i = 1;
            while (i < arity + 1) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] == value) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class OrEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.max(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class OrxEvaluator
    extends Evaluator
    implements TagArityX,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            int i = 0;
            while (i < this.arity) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] == 1L) {
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
                    return;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
        }
    }

    public class PowEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = (long)Math.pow(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class SetxEvaluator
    extends Evaluator
    implements TagArityX,
    TagSet {
        @Override
        public void evaluate() {
            long[] lArray = EvaluationManager.this.stack;
            EvaluationManager evaluationManager = EvaluationManager.this;
            int n = evaluationManager.top + 1;
            evaluationManager.top = n;
            lArray[n] = this.arity;
        }
    }

    public class SqrEvaluator
    extends Evaluator
    implements TagArity1,
    TagArithmetic {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] * EvaluationManager.this.stack[EvaluationManager.this.top];
        }
    }

    public class SubEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] - EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public static interface TagArithmetic
    extends TagInteger {
    }

    public static interface TagArity0 {
    }

    public static interface TagArity1 {
    }

    public static interface TagArity2 {
    }

    public static interface TagArity3 {
    }

    public static interface TagArityX {
    }

    public static interface TagAssociative {
    }

    public static interface TagBoolean {
    }

    public static interface TagInteger {
    }

    public static interface TagLogical
    extends TagBoolean {
    }

    public static interface TagRelational
    extends TagBoolean {
    }

    public static interface TagSet {
    }

    public static interface TagSymmetric {
    }

    public static interface TagTerminal {
    }

    public class TrueEvaluator
    extends Evaluator
    implements TagArity0,
    TagTerminal,
    TagBoolean {
        @Override
        public void evaluate() {
            long[] lArray = EvaluationManager.this.stack;
            EvaluationManager evaluationManager = EvaluationManager.this;
            int n = evaluationManager.top + 1;
            evaluationManager.top = n;
            lArray[n] = 1L;
        }
    }

    public class VariableEvaluator
    extends Evaluator
    implements TagArity0,
    TagTerminal,
    TagInteger {
        public final int position;

        public VariableEvaluator(int position) {
            this.position = position;
        }

        @Override
        public void evaluate() {
            long[] lArray = EvaluationManager.this.stack;
            EvaluationManager evaluationManager = EvaluationManager.this;
            int n = evaluationManager.top + 1;
            evaluationManager.top = n;
            lArray[n] = EvaluationManager.this.values[this.position];
        }
    }

    public class XorEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - 1;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] + EvaluationManager.this.stack[EvaluationManager.this.top + 1] == 1L ? 1 : 0;
        }
    }

    public class XorxEvaluator
    extends Evaluator
    implements TagArityX,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager evaluationManager = EvaluationManager.this;
            evaluationManager.top = evaluationManager.top - (this.arity - 1);
            int cnt = 0;
            int i = 0;
            while (i < this.arity) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] == 1L) {
                    ++cnt;
                }
                ++i;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = cnt % 2;
        }
    }
}

