/*
 * Decompiled with CFR 0.152.
 */
package variables.domains;

import java.util.stream.IntStream;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.domains.LinkedSet;

public final class LinkedSetUnordered
implements LinkedSet {
    private static final int UNITIALIZED = -2;
    private int[] sparse;
    private int[] dense;
    private int initLimit;
    private int limit;
    private int[] limits;
    private int currLevel;
    private int positionOfLastMovedElement;
    protected int mark;
    protected int[] marks;
    private int markLevel;
    private int[] markLevels;
    protected int nLevels;

    @Override
    public void finalizeConstructionWith(int nLevels) {
        this.nLevels = nLevels;
        this.limits = IntStream.range(0, nLevels).map(i -> -2).toArray();
        this.initLimit = this.limit;
    }

    public LinkedSetUnordered(int initSize) {
        Kit.control(0 < initSize && (long)initSize <= 0x7FFFFFF5L, () -> "Pb with initSize=" + initSize);
        this.sparse = Kit.range(initSize);
        this.dense = Kit.range(initSize);
        this.initLimit = this.sparse.length - 1;
        this.limit = this.sparse.length - 1;
        this.currLevel = -1;
        this.mark = -1;
    }

    public LinkedSetUnordered(int initSize, int nLevels) {
        this(initSize);
        this.finalizeConstructionWith(nLevels);
    }

    @Override
    public int initSize() {
        return this.dense.length;
    }

    @Override
    public int size() {
        return this.limit + 1;
    }

    @Override
    public boolean isPresent(int a) {
        return this.sparse[a] <= this.limit;
    }

    @Override
    public int first() {
        return this.limit == -1 ? -1 : this.dense[0];
    }

    @Override
    public int next(int a) {
        int i = this.sparse[a];
        if (i < this.limit) {
            return this.dense[i + 1];
        }
        if (i == this.limit + 1) {
            return this.positionOfLastMovedElement == i ? -1 : this.dense[this.positionOfLastMovedElement];
        }
        assert (i == this.limit);
        return -1;
    }

    @Override
    public int last() {
        return this.limit == -1 ? -1 : this.dense[this.limit];
    }

    @Override
    public int prev(int a) {
        int i = this.sparse[a];
        if (i == 0) {
            return -1;
        }
        if (i == this.limit + 1) {
            return this.positionOfLastMovedElement == 0 ? -1 : this.dense[this.positionOfLastMovedElement - 1];
        }
        assert (i <= this.limit);
        return this.dense[i - 1];
    }

    @Override
    public int get(int i) {
        return this.dense[i];
    }

    @Override
    public int lastRemoved() {
        if (this.limit == this.initLimit) {
            return -1;
        }
        assert (this.limit < this.initLimit);
        return this.dense[this.limit + 1];
    }

    @Override
    public int prevRemoved(int a) {
        int i = this.sparse[a];
        if (i == this.initLimit) {
            return -1;
        }
        assert (!this.isPresent(a) && this.limit < i && i < this.initLimit);
        return this.dense[i + 1];
    }

    @Override
    public int lastRemovedLevel() {
        return this.currLevel;
    }

    @Override
    public boolean isRemovedAtLevel(int a, int level) {
        if (this.limits[level] == -2) {
            return false;
        }
        int i = this.sparse[a];
        if (this.limits[level] < i) {
            return false;
        }
        int left = -1;
        for (int j = level + 1; left == -1 && j <= this.currLevel; ++j) {
            if (this.limits[j] == -2) continue;
            left = this.limits[j];
        }
        return left < i;
    }

    @Override
    public int getRemovedLevelOf(int a) {
        throw new MissingImplementationException();
    }

    private void swap(int i, int j) {
        int f;
        int e = this.dense[i];
        this.dense[i] = f = this.dense[j];
        this.dense[j] = e;
        this.sparse[e] = j;
        this.sparse[f] = i;
    }

    @Override
    public void remove(int a, int level) {
        assert (level >= 0 && this.isPresent(a)) : "level = " + level + " present element = " + a;
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
            this.currLevel = level;
        }
        this.positionOfLastMovedElement = this.sparse[a];
        if (this.positionOfLastMovedElement != this.limit) {
            this.swap(this.positionOfLastMovedElement, this.limit);
        }
        --this.limit;
        assert (this.controlStructures());
    }

    @Override
    public int reduceTo(int a, int level) {
        assert (level >= 0 && this.isPresent(a));
        if (this.limit == 0) {
            return 0;
        }
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
            this.currLevel = level;
        }
        int limitBefore = this.limit;
        this.positionOfLastMovedElement = this.sparse[a];
        if (this.positionOfLastMovedElement != 0) {
            this.swap(0, this.positionOfLastMovedElement);
        }
        this.limit = 0;
        return limitBefore;
    }

    @Override
    public void restoreBefore(int level) {
        int i;
        if (this.limits[level] == -2) {
            return;
        }
        assert (this.limit < this.limits[level] && this.currLevel == level);
        this.limit = this.limits[level];
        this.limits[level] = -2;
        for (i = level - 1; i >= 0 && this.limits[i] == -2; --i) {
        }
        this.currLevel = i;
        assert (this.controlStructures());
    }

    @Override
    public void setMark() {
        this.mark = this.limit;
        this.markLevel = this.currLevel;
    }

    @Override
    public void restoreAtMark() {
        this.limit = this.mark;
        for (int i = this.currLevel; i > this.markLevel; --i) {
            this.limits[i] = -2;
        }
        this.currLevel = this.markLevel;
        this.mark = -1;
    }

    @Override
    public void setMark(int level) {
        assert (this.marks == null || this.marks[level] == -1);
        if (this.marks == null) {
            this.marks = Kit.repeat(-1, this.nLevels);
            this.markLevels = Kit.repeat(-1, this.nLevels);
        }
        this.marks[level] = this.limit;
        this.markLevels[level] = this.currLevel;
    }

    @Override
    public void restoreAtMark(int level) {
        this.limit = this.marks[level];
        for (int i = this.currLevel; i > this.markLevels[level]; --i) {
            this.limits[i] = -2;
        }
        this.currLevel = this.markLevels[level];
        this.marks[level] = -1;
    }

    @Override
    public int indexAtMark() {
        return this.mark == -1 ? -1 : this.dense[this.mark];
    }

    @Override
    public long[] binaryRepresentation() {
        return null;
    }

    @Override
    public int[] indexes() {
        return IntStream.range(0, this.size()).map(i -> this.dense[i]).toArray();
    }

    @Override
    public String stringOfStructures() {
        String s = LinkedSet.super.stringOfStructures();
        StringBuilder sb = new StringBuilder().append("Levels: ");
        for (int i = this.currLevel; i >= 0; --i) {
            if (this.limits[i] == -2) continue;
            sb.append(this.dense[this.limits[i]] + "@" + i + " ");
        }
        return s + "\n" + sb.toString();
    }

    @Override
    public boolean controlStructures() {
        if (IntStream.range(0, this.sparse.length).anyMatch(i -> this.dense[this.sparse[i]] != i) || IntStream.range(this.currLevel + 1, this.limits.length).anyMatch(i -> this.limits[i] != -2)) {
            return false;
        }
        int last = Integer.MAX_VALUE;
        for (int i2 = 0; i2 <= this.currLevel; ++i2) {
            if (this.limits[i2] == -2) continue;
            if (this.limits[i2] >= last) {
                return false;
            }
            last = this.limits[i2];
        }
        return true;
    }
}

