/*
 * Decompiled with CFR 0.152.
 */
package variables.domains;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import search.Solver;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;
import variables.domains.LinkedSetOrdered;

public abstract class DomainInteger
extends LinkedSetOrdered.LinkedSetOrderedWithBits
implements Domain {
    private Variable var;
    private Integer typeIdentifier;
    private Solver solver;
    private Boolean indexesMatchValues;

    public boolean equals(Object obj) {
        if (!(obj instanceof DomainInteger)) {
            return false;
        }
        DomainInteger d = (DomainInteger)obj;
        if (this.size != d.size) {
            return false;
        }
        int a = this.first;
        while (a != -1) {
            if (!d.isPresent(a)) {
                return false;
            }
            a = this.next(a);
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public final Variable var() {
        return this.var;
    }

    protected abstract int computeTypeIdentifier();

    @Override
    public final int typeIdentifier() {
        return this.typeIdentifier != null ? this.typeIdentifier : (this.typeIdentifier = Integer.valueOf(this.computeTypeIdentifier()));
    }

    @Override
    public final Solver solver() {
        return this.solver;
    }

    @Override
    public final void setSolver(Solver solver) {
        this.solver = solver;
    }

    @Override
    public final boolean indexesMatchValues() {
        return this.indexesMatchValues != null ? this.indexesMatchValues : (this.indexesMatchValues = Boolean.valueOf(IntStream.range(0, this.initSize()).noneMatch(a -> a != this.toVal(a))));
    }

    public DomainInteger(Variable var, int initSize) {
        super(initSize);
        this.var = var;
        Kit.control(0 < initSize && (long)initSize <= 0x7FFFFFF5L);
    }

    public String toString() {
        return "dom(" + this.var().id() + ")";
    }

    public static final class DomainSymbols
    extends DomainValues {
        public final String[] symbols;

        @Override
        protected int computeTypeIdentifier() {
            return this.typeIdentifierFor(Utilities.collectInt((Object[])new Object[]{this.values, 0x7FFFFFFE}));
        }

        public DomainSymbols(Variable var, int[] vals, String[] symbols) {
            super(var, vals);
            Kit.control(symbols != null && symbols.length > 0 && vals.length == symbols.length, () -> "badly formed set of symbols for variable " + var);
            this.symbols = (String[])Arrays.stream(Kit.buildMapping(this.values, vals)).mapToObj(i -> symbols[i]).toArray(String[]::new);
        }

        @Override
        public String prettyValueOf(int a) {
            return this.symbols[a];
        }

        @Override
        public String stringListOfValues() {
            StringBuilder sb = new StringBuilder();
            int a = this.first();
            while (a != -1) {
                sb.append(a != this.first() ? Character.valueOf(' ') : "").append(this.symbols[a]);
                a = this.next(a);
            }
            return sb.toString();
        }

        public int toIdx(String v) {
            return Utilities.indexOf((String)v, (String[])this.symbols);
        }
    }

    public static class DomainValues
    extends DomainInteger {
        public final int[] values;

        @Override
        protected int computeTypeIdentifier() {
            return this.typeIdentifierFor(this.values);
        }

        public DomainValues(Variable var, int ... vals) {
            super(var, vals.length);
            this.values = IntStream.of(vals).sorted().distinct().toArray();
            Kit.control(-2147483638L <= (long)this.values[0] && (long)this.values[this.values.length - 1] <= 0x7FFFFFF5L);
        }

        @Override
        public int toIdx(int v) {
            return Arrays.binarySearch(this.values, v);
        }

        @Override
        public final int toVal(int a) {
            return this.values[a];
        }
    }

    public static final class DomainRange
    extends DomainInteger {
        public final int min;
        public final int max;

        @Override
        protected int computeTypeIdentifier() {
            return this.typeIdentifierFor(new int[]{this.min, this.max, Integer.MAX_VALUE});
        }

        public DomainRange(Variable var, int min, int max) {
            super(var, max - min + 1);
            this.min = min;
            this.max = max;
            Kit.control(-2147483638L <= (long)min && min <= max && (long)max <= 0x7FFFFFF5L, () -> "badly formed domain for variable " + var);
        }

        @Override
        public int toIdx(int v) {
            return v < this.min || v > this.max ? -1 : v - this.min;
        }

        @Override
        public int toVal(int a) {
            return a + this.min <= this.max ? a + this.min : -1;
        }
    }
}

