/*
 * Decompiled with CFR 0.152.
 */
package variables.domains;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import search.Solver;
import utility.Kit;
import utility.observers.ObserverDomainReduction;
import utility.sets.SetDense;
import variables.Variable;
import variables.domains.LinkedSet;

public interface Domain
extends LinkedSet {
    public static final int TAG_RANGE = Integer.MAX_VALUE;
    public static final int TAG_SYMBOLS = 0x7FFFFFFE;

    public static boolean similarDomains(Domain[] doms1, Domain[] doms2) {
        return doms1.length == doms2.length && IntStream.range(0, doms1.length).allMatch(i -> doms1[i].typeIdentifier() == doms2[i].typeIdentifier());
    }

    default public int typeIdentifierFor(int[] values) {
        List<int[]> domainTypes = this.var().pb.domainTypes;
        int j = IntStream.range(0, domainTypes.size()).filter(i -> Arrays.equals(values, (int[])domainTypes.get(i))).findFirst().orElse(-1);
        if (j != -1) {
            return j;
        }
        domainTypes.add(values);
        return domainTypes.size() - 1;
    }

    default public boolean areInitValuesExactly(Range range) {
        int min = range.startInclusive;
        return this.initSize() == range.length() && IntStream.range(0, this.initSize()).allMatch(a -> this.toVal(a) == min + a);
    }

    default public boolean areInitValuesSubsetOf(int[] values) {
        return this.initSize() <= values.length && IntStream.range(0, this.initSize()).allMatch(a -> Kit.isPresent(this.toVal(a), values));
    }

    public Variable var();

    public int typeIdentifier();

    public Solver solver();

    public void setSolver(Solver var1);

    public boolean indexesMatchValues();

    default public String typeName() {
        return "D" + this.typeIdentifier();
    }

    public int toIdx(int var1);

    public int toVal(int var1);

    default public int toPresentIdx(int v) {
        int a = this.toIdx(v);
        return a < 0 || !this.isPresent(a) ? -1 : a;
    }

    default public boolean isPresentValue(int v) {
        int a = this.toIdx(v);
        return a >= 0 && this.isPresent(a);
    }

    default public boolean onlyContains(int a) {
        return this.size() == 1 && this.isPresent(a);
    }

    default public boolean onlyContainsValue(int v) {
        return this.size() == 1 && this.toPresentIdx(v) >= 0;
    }

    default public int unique() {
        if (!1.$assertionsDisabled && this.size() != 1) {
            throw new AssertionError((Object)("Current size = " + this.size()));
        }
        return this.first();
    }

    default public int random() {
        return this.get(this.solver().rs.random.nextInt(this.size()));
    }

    default public int firstValue() {
        return this.toVal(this.first());
    }

    default public int lastValue() {
        return this.toVal(this.last());
    }

    default public int uniqueValue() {
        return this.toVal(this.unique());
    }

    default public boolean isModifiedAtCurrentDepth() {
        return this.lastRemovedLevel() == this.solver().depth();
    }

    default public void storeRemovedIn(SetDense set, int frontier) {
        int a = this.lastRemoved();
        while (a != frontier) {
            set.add(a);
            a = this.prevRemoved(a);
        }
    }

    default public void executeOnValues(Consumer<Integer> consumer) {
        int a = this.first();
        while (a != -1) {
            consumer.accept(this.toVal(a));
            a = this.next(a);
        }
    }

    default public void removeValueAtConstructionTime(int v) {
        Kit.control(this.var().pb.solver == null, () -> "Must be called before the solver being built.");
        this.remove(this.toIdx(v), 0);
        ++this.var().pb.nValuesRemoved;
        ++this.var().pb.stuff.nValuesRemovedAtConstructionTime;
    }

    default public void reduceToValueAtConstructionTime(int v) {
        int a = this.first();
        while (a != -1) {
            if (this.toVal(a) != v) {
                this.removeValueAtConstructionTime(this.toVal(a));
            }
            a = this.next(a);
        }
    }

    default public boolean afterElementaryCalls(int sizeBefore) {
        return this.size() == sizeBefore ? true : (this.size() == 0 ? this.fail() : this.solver().propagation.handleReductionSafely(this.var()));
    }

    default public boolean afterElementaryCalls() {
        return this.size() == 0 ? this.fail() : this.solver().propagation.handleReductionSafely(this.var());
    }

    default public void removeElementary(int a) {
        int depth = this.solver().depth();
        if (!(1.$assertionsDisabled || !this.var().isAssigned() && this.isPresent(a) && this.lastRemovedLevel() <= depth)) {
            throw new AssertionError((Object)(this.var() + " " + this.var().isAssigned() + " " + this.isPresent(a)));
        }
        if (this.lastRemovedLevel() != depth) {
            this.solver().pushVariable(this.var());
        }
        this.remove(a, depth);
        ++this.var().pb.nValuesRemoved;
        for (ObserverDomainReduction observer : this.var().pb.observersDomainReduction) {
            observer.actAfterRemoval(this.var(), a);
        }
        this.var().pb.rs.observerRemote.onRemoved(this.var(), a);
    }

    default public void removeSafely(int a) {
        if (!(1.$assertionsDisabled || this.isPresent(a) && this.size() > 1)) {
            throw new AssertionError();
        }
        this.removeElementary(a);
        this.solver().propagation.handleReductionSafely(this.var());
    }

    default public boolean remove(int a) {
        if (!1.$assertionsDisabled && !this.isPresent(a)) {
            throw new AssertionError();
        }
        if (this.size() == 1) {
            return this.fail();
        }
        this.removeElementary(a);
        return this.solver().propagation.handleReductionSafely(this.var());
    }

    default public boolean remove(int a, boolean agressive) {
        return this.isPresent(a) ? this.remove(a) : !agressive || this.fail();
    }

    default public boolean remove(int from, int to, boolean agressive) {
        for (int a = from; a <= to; ++a) {
            if (this.remove(a, agressive)) continue;
            return false;
        }
        return true;
    }

    default public boolean remove(boolean[] flags, int nRemovals) {
        if (!(1.$assertionsDisabled || 0 < nRemovals && nRemovals <= this.size() && flags.length == this.initSize() && IntStream.range(0, this.initSize()).filter(a -> this.isPresent(a) && !flags[a]).count() == (long)nRemovals)) {
            throw new AssertionError();
        }
        if (this.size() == nRemovals) {
            return this.fail();
        }
        int cnt = 0;
        int a2 = this.first();
        while (cnt < nRemovals) {
            if (!flags[a2]) {
                this.removeElementary(a2);
                ++cnt;
            }
            a2 = this.next(a2);
        }
        return this.solver().propagation.handleReductionSafely(this.var());
    }

    default public boolean remove(SetDense idxs, boolean testPresence) {
        if (testPresence) {
            if (this.size() == 1) {
                for (int i2 = idxs.limit; i2 >= 0; --i2) {
                    if (!this.isPresent(idxs.dense[i2])) continue;
                    return this.fail();
                }
                return true;
            }
            int sizeBefore = this.size();
            for (int i3 = idxs.limit; i3 >= 0; --i3) {
                if (!this.isPresent(idxs.dense[i3])) continue;
                this.removeElementary(idxs.dense[i3]);
            }
            return this.afterElementaryCalls(sizeBefore);
        }
        if (!1.$assertionsDisabled && !IntStream.range(0, idxs.size()).allMatch(i -> this.isPresent(idxs.dense[i]))) {
            throw new AssertionError();
        }
        if (idxs.size() == 0) {
            return true;
        }
        if (this.size() == idxs.size()) {
            return this.fail();
        }
        for (int i4 = idxs.limit; i4 >= 0; --i4) {
            this.removeElementary(idxs.dense[i4]);
        }
        return this.solver().propagation.handleReductionSafely(this.var());
    }

    default public boolean remove(SetDense idxs) {
        return this.remove(idxs, false);
    }

    default public int reduceToElementary(int a) {
        if (!1.$assertionsDisabled && !this.isPresent(a)) {
            throw new AssertionError((Object)(this.var() + " has lost " + a));
        }
        if (this.size() == 1) {
            return 0;
        }
        int depth = this.solver().depth();
        if (this.lastRemovedLevel() != depth) {
            this.solver().pushVariable(this.var());
        }
        int nRemovals = this.reduceTo(a, depth);
        this.var().pb.nValuesRemoved += nRemovals;
        for (ObserverDomainReduction observer : this.var().pb.observersDomainReduction) {
            observer.actAfterRemovals(this.var(), nRemovals);
        }
        if (!(1.$assertionsDisabled || nRemovals >= 0 && this.size() == 1)) {
            throw new AssertionError();
        }
        return nRemovals;
    }

    default public boolean reduceTo(int a) {
        return !this.isPresent(a) ? this.fail() : this.reduceToElementary(a) == 0 || this.solver().propagation.handleReductionSafely(this.var());
    }

    default public void notifyReduction() {
        if (!1.$assertionsDisabled && this.size() <= 0) {
            throw new AssertionError();
        }
        this.solver().propagation.handleReductionSafely(this.var());
    }

    default public boolean fail() {
        return this.solver().propagation.handleReduction(this.var(), 0);
    }

    default public boolean removeValue(int v) {
        int a = this.toPresentIdx(v);
        if (!1.$assertionsDisabled && a == -1) {
            throw new AssertionError();
        }
        return this.remove(a);
    }

    default public boolean removeValue(int v, boolean agressive) {
        int a = this.toPresentIdx(v);
        return a != -1 ? this.remove(a) : !agressive || this.fail();
    }

    default public void removeValueSafelyIfPresent(int v) {
        if (!1.$assertionsDisabled && this.size() <= 1) {
            throw new AssertionError();
        }
        int a = this.toPresentIdx(v);
        if (a != -1) {
            this.remove(a);
        }
    }

    default public boolean reduceToValue(int v) {
        int a = this.toPresentIdx(v);
        return a == -1 ? this.fail() : this.reduceToElementary(a) == 0 || this.solver().propagation.handleReductionSafely(this.var());
    }

    default public boolean removeValues(Types.TypeOperatorRel type, int limit) {
        int sizeBefore = this.size();
        switch (type) {
            case LT: {
                limit = limit != Integer.MIN_VALUE ? limit - 1 : limit;
            }
            case LE: {
                if (this.lastValue() <= limit) {
                    return this.fail();
                }
                int a = this.first();
                while (a != -1 && this.toVal(a) <= limit) {
                    this.removeElementary(a);
                    a = this.next(a);
                }
                break;
            }
            case GT: {
                limit = limit != Integer.MAX_VALUE ? limit + 1 : limit;
            }
            case GE: {
                if (this.firstValue() >= limit) {
                    return this.fail();
                }
                int a = this.last();
                while (a != -1 && this.toVal(a) >= limit) {
                    this.removeElementary(a);
                    a = this.prev(a);
                }
                break;
            }
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValues(Types.TypeOperatorRel type, long limit) {
        return this.removeValues(type, limit <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (limit >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)limit));
    }

    default public boolean removeValues(Types.TypeOperatorRel type, long limit, int coeff) {
        if (!1.$assertionsDisabled && coeff == 0) {
            throw new AssertionError();
        }
        int sizeBefore = this.size();
        switch (type) {
            case LT: {
                limit = limit != Long.MIN_VALUE ? limit - 1L : limit;
            }
            case LE: {
                if (this.size() == 1) {
                    return (long)(coeff * this.firstValue()) <= limit ? this.fail() : true;
                }
                if (coeff > 0) {
                    int a = this.first();
                    while (a != -1 && (long)(coeff * this.toVal(a)) <= limit) {
                        this.removeElementary(a);
                        a = this.next(a);
                    }
                } else {
                    int a = this.last();
                    while (a != -1 && (long)(coeff * this.toVal(a)) <= limit) {
                        this.removeElementary(a);
                        a = this.prev(a);
                    }
                }
                break;
            }
            case GT: {
                limit = limit != Long.MAX_VALUE ? limit + 1L : limit;
            }
            case GE: {
                if (this.size() == 1) {
                    return (long)(coeff * this.firstValue()) >= limit ? this.fail() : true;
                }
                if (coeff > 0) {
                    int a = this.last();
                    while (a != -1 && (long)(coeff * this.toVal(a)) >= limit) {
                        this.removeElementary(a);
                        a = this.prev(a);
                    }
                } else {
                    int a = this.first();
                    while (a != -1 && (long)(coeff * this.toVal(a)) >= limit) {
                        this.removeElementary(a);
                        a = this.next(a);
                    }
                }
                break;
            }
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValues(Types.TypeConditionOperatorSet type, Domain dom, int offset) {
        boolean present;
        if (!1.$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        boolean bl = present = type == Types.TypeConditionOperatorSet.IN;
        if (this.size() == 1) {
            return dom.isPresentValue(this.firstValue() - offset) == present ? this.fail() : true;
        }
        int sizeBefore = this.size();
        int a = this.first();
        while (a != -1) {
            if (dom.isPresentValue(this.toVal(a) - offset) == present) {
                this.removeElementary(a);
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValues(Types.TypeConditionOperatorSet type, Domain dom) {
        boolean present;
        if (!1.$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        boolean bl = present = type == Types.TypeConditionOperatorSet.IN;
        if (this.size() == 1) {
            return dom.isPresentValue(this.firstValue()) == present ? this.fail() : true;
        }
        int sizeBefore = this.size();
        int a = this.first();
        while (a != -1) {
            if (dom.isPresentValue(this.toVal(a)) == present) {
                this.removeElementary(a);
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValues(Types.TypeConditionOperatorSet type, Set<Integer> set) {
        boolean present;
        if (!1.$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        boolean bl = present = type == Types.TypeConditionOperatorSet.IN;
        if (this.size() == 1) {
            return set.contains(this.firstValue()) == present ? this.fail() : true;
        }
        int sizeBefore = this.size();
        int a = this.first();
        while (a != -1) {
            if (set.contains(this.toVal(a)) == present) {
                this.removeElementary(a);
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeIndexesChecking(Predicate<Integer> p) {
        if (this.size() == 1) {
            return p.test(this.first()) ? this.fail() : true;
        }
        int sizeBefore = this.size();
        int a = this.first();
        while (a != -1) {
            if (p.test(a)) {
                this.removeElementary(a);
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean iterateStoppingWhen(Predicate<Integer> p) {
        int a = this.first();
        while (a != -1) {
            if (p.test(a)) {
                return true;
            }
            a = this.next(a);
        }
        return false;
    }

    default public boolean iterateOnValuesStoppingWhen(Predicate<Integer> p) {
        int a = this.first();
        while (a != -1) {
            if (p.test(this.toVal(a))) {
                return true;
            }
            a = this.next(a);
        }
        return false;
    }

    default public boolean subsetOf(Domain dom) {
        int a = this.first();
        while (a != -1) {
            if (!dom.isPresentValue(this.toVal(a))) {
                return false;
            }
            a = this.next(a);
        }
        return true;
    }

    default public boolean overlapWith(Domain dom) {
        int a = this.first();
        while (a != -1) {
            if (dom.isPresentValue(this.toVal(a))) {
                return true;
            }
            a = this.next(a);
        }
        return false;
    }

    default public int[] values() {
        return IntStream.of(this.indexes()).map(a -> this.toVal(a)).toArray();
    }

    default public Object prettyValueOf(int a) {
        return this.toVal(a);
    }

    default public void display(boolean exhaustively) {
        Kit.log.fine("  Domain " + this + " (ivs=" + this.indexesMatchValues() + ", domainType=" + this.typeIdentifier() + ")");
        Kit.log.fine("\t initSize = " + this.initSize() + " and size = " + this.size());
        Kit.log.fine("\t first=" + this.first() + " and last=" + this.last());
        if (this.size() != 0) {
            Kit.log.fine("\t first value = " + this.firstValue() + " and last value = " + this.lastValue());
        }
        if (exhaustively) {
            Kit.log.fine("\t values = {" + this.stringListOfValues() + "}\nStructures\n" + this.stringOfStructures());
        }
    }

    default public String stringListOfValues() {
        int prevVal;
        if (this.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int startInterval = prevVal = this.firstValue();
        int a = this.next(this.first());
        while (a != -1) {
            int currVal = this.toVal(a);
            if (currVal != prevVal + 1) {
                sb.append(prevVal == startInterval ? Integer.valueOf(prevVal) : startInterval + (prevVal == startInterval + 1 ? " " : "..") + prevVal).append(" ");
                startInterval = currVal;
            }
            prevVal = currVal;
            a = this.next(a);
        }
        return sb.append(prevVal == startInterval ? Integer.valueOf(prevVal) : startInterval + (prevVal == startInterval + 1 ? " " : "..") + prevVal).toString();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

