/*
 * Decompiled with CFR 0.152.
 */
package utility.sets;

import java.util.Arrays;
import java.util.stream.IntStream;
import utility.Kit;
import utility.sets.SetDenseReversible;

public class SetSparseReversible
extends SetDenseReversible {
    public int[] sparse;

    public SetSparseReversible(int capacity, boolean initiallyFull, int nLevels) {
        super(capacity, initiallyFull, nLevels);
        this.sparse = IntStream.range(0, capacity).toArray();
        Kit.control(Arrays.equals(this.dense, this.sparse));
    }

    public SetSparseReversible(int capacity, int nLevels) {
        this(capacity, true, nLevels);
    }

    @Override
    public boolean isPresent(int e) {
        return this.sparse[e] <= this.limit;
    }

    @Override
    public boolean add(int e) {
        assert (!this.isPresent(e)) : this.sparse[e] + " " + this.limit;
        int i = this.sparse[e];
        ++this.limit;
        if (i > this.limit) {
            int f;
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[f] = i;
            this.sparse[e] = this.limit;
        }
        return true;
    }

    public void add(int e, int level) {
        assert (!this.isPresent(e)) : this.sparse[e] + " " + this.limit;
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
        }
        int i = this.sparse[e];
        ++this.limit;
        if (i > this.limit) {
            int f;
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[f] = i;
            this.sparse[e] = this.limit;
        }
    }

    public void remove(int e) {
        assert (this.isPresent(e)) : this.sparse[e] + " " + this.limit;
        int i = this.sparse[e];
        if (i != this.limit) {
            int f;
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[f] = i;
            this.sparse[e] = this.limit;
        }
        --this.limit;
    }

    public void removeIfPresent(int e) {
        if (this.sparse[e] <= this.limit) {
            this.remove(e);
        }
    }

    public void remove(int e, int level) {
        int i;
        assert (this.isPresent(e)) : this.sparse[e] + " " + this.limit;
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
        }
        if ((i = this.sparse[e]) != this.limit) {
            int f;
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[f] = i;
            this.sparse[e] = this.limit;
        }
        --this.limit;
    }

    @Override
    public void removeAtPosition(int i, int level) {
        assert (0 <= i && i <= this.limit);
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
        }
        if (i != this.limit) {
            int f;
            int e = this.dense[i];
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[f] = i;
            this.sparse[e] = this.limit;
        }
        --this.limit;
    }

    @Override
    public void swapAtPositions(int i, int j) {
        int f;
        int e = this.dense[i];
        this.dense[i] = f = this.dense[j];
        this.dense[j] = e;
        this.sparse[f] = i;
        this.sparse[e] = j;
    }
}

