/*
 * Decompiled with CFR 0.152.
 */
package utility.sets;

import utility.Kit;
import utility.operations.Calculator;
import utility.sets.SetSparse;

public class SetSparseMapLong
extends SetSparse {
    public long[] values;
    public long sumValues;

    public SetSparseMapLong(int capacity, boolean initiallyFull) {
        super(capacity, initiallyFull);
        this.values = Kit.range((long)capacity);
    }

    @Override
    public void clear() {
        super.clear();
        this.sumValues = 0L;
    }

    @Override
    public final boolean add(int e) {
        throw new RuntimeException("Must not be called without a second argument");
    }

    public boolean add(int e, long value) {
        boolean added = super.add(e);
        this.sumValues = Calculator.add(this.sumValues, added ? value : value - this.values[e]);
        this.values[e] = value;
        return added;
    }

    @Override
    public boolean remove(int e) {
        boolean deleted = super.remove(e);
        if (deleted) {
            this.sumValues = Calculator.add(this.sumValues, -this.values[e]);
        }
        return deleted;
    }

    public void incrementPresentEntry(int e, long valueIncrement) {
        assert (this.isPresent(e));
        this.sumValues = Calculator.add(this.sumValues, valueIncrement);
        Calculator.add(this.values, e, valueIncrement);
    }
}

