/*
 * Decompiled with CFR 0.152.
 */
package utility.sets;

import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import utility.Kit;
import utility.sets.SetDense;

public class SetSparse
extends SetDense {
    public int[] sparse;

    public static final SetSparse[] factoryArray(IntFunction<Integer> capacityFunction, int arraySize) {
        return (SetSparse[])IntStream.range(0, arraySize).mapToObj(i -> new SetSparse((Integer)capacityFunction.apply(i))).toArray(SetSparse[]::new);
    }

    public static final SetSparse[] factoryArray(int capacity, int arraySize) {
        return SetSparse.factoryArray(i -> capacity, arraySize);
    }

    public SetSparse(int capacity, boolean initiallyFull) {
        super(capacity, initiallyFull);
        this.sparse = Kit.range(capacity);
        Kit.control(Arrays.equals(this.dense, this.sparse));
    }

    public SetSparse(int capacity) {
        this(capacity, false);
    }

    @Override
    public void increaseCapacity() {
        super.increaseCapacity();
        this.sparse = IntStream.range(0, this.dense.length).map(i -> i < this.sparse.length ? this.sparse[i] : i).toArray();
    }

    public SetSparse fill() {
        this.limit = this.dense.length - 1;
        return this;
    }

    public void resetTo(SetSparse set) {
        Kit.control(this.getClass() == SetSparse.class, () -> "Should only be used with the base class");
        Kit.control(set.capacity() == this.capacity());
        this.clear();
        for (int i = 0; i <= set.limit; ++i) {
            this.add(set.dense[i]);
        }
    }

    @Override
    public boolean isPresent(int e) {
        return this.sparse[e] <= this.limit;
    }

    @Override
    public boolean add(int e) {
        int i = this.sparse[e];
        if (i <= this.limit) {
            return false;
        }
        ++this.limit;
        if (i > this.limit) {
            int f;
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[e] = this.limit;
            this.sparse[f] = i;
        }
        return true;
    }

    @Override
    public void removeAtPosition(int i) {
        assert (0 <= i && i <= this.limit);
        if (i != this.limit) {
            int f;
            int e = this.dense[i];
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[e] = this.limit;
            this.sparse[f] = i;
        }
        --this.limit;
    }

    @Override
    public int shift() {
        assert (this.limit >= 0);
        int e = this.dense[0];
        if (this.limit != 0) {
            int f = this.dense[this.limit];
            this.dense[0] = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[e] = this.limit;
            this.sparse[f] = 0;
        }
        --this.limit;
        return e;
    }

    @Override
    public void swapAtPositions(int i, int j) {
        int f;
        int e = this.dense[i];
        this.dense[i] = f = this.dense[j];
        this.dense[j] = e;
        this.sparse[e] = j;
        this.sparse[f] = i;
    }

    public boolean remove(int e) {
        int i = this.sparse[e];
        if (i > this.limit) {
            return false;
        }
        if (i != this.limit) {
            int f;
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[e] = this.limit;
            this.sparse[f] = i;
        }
        --this.limit;
        return true;
    }

    public final void swap(int e, int f) {
        int i = this.sparse[e];
        int j = this.sparse[f];
        this.dense[i] = f;
        this.dense[j] = e;
        this.sparse[e] = j;
        this.sparse[f] = i;
    }

    public final void moveElementsAt(int oldTailLimit) {
        int nSwaps = Math.min(this.limit + 1, oldTailLimit - this.limit);
        int i = 0;
        while (i < nSwaps) {
            int f;
            int j = oldTailLimit - i;
            int e = this.dense[i];
            this.dense[i] = f = this.dense[j];
            this.dense[j] = e;
            this.sparse[e] = j;
            this.sparse[f] = i++;
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\nsparse={" + IntStream.range(0, this.size()).mapToObj(i -> this.sparse[i] + "").collect(Collectors.joining(",")) + "}";
    }
}

