/*
 * Decompiled with CFR 0.152.
 */
package utility.operations;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import utility.Kit;

public class GraphSimpleUndirected {
    public final int nNodes;
    public final int nEdges;
    public final long[][] adjacency;
    public int[][] nodesAtDistance1;
    public int[][] nodesAtDistance2;
    public int[][] nodesAtDistance1And2;
    private int[] cacheDegrees;
    private int[] visited;
    private int[] stack;
    private int top = -1;
    private int[] tmp;
    private List<int[]> cycles;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GraphSimpleUndirected loadGraph(String fileName) {
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            GraphSimpleUndirected g;
            int nbNodes = Integer.parseInt(in.readLine());
            ArrayList<int[]> edges = new ArrayList<int[]>();
            for (int i = 0; i < nbNodes; ++i) {
                StringTokenizer st = new StringTokenizer(in.readLine());
                int nbNeighbours = Integer.parseInt(st.nextToken());
                for (int cnt = 0; cnt < nbNeighbours; ++cnt) {
                    edges.add(new int[]{i, Integer.parseInt(st.nextToken())});
                }
            }
            GraphSimpleUndirected graphSimpleUndirected = g = new GraphSimpleUndirected(nbNodes, edges);
            return graphSimpleUndirected;
        }
        catch (Exception e) {
            return (GraphSimpleUndirected)Kit.exit(e);
        }
    }

    public static int determinant(int[][] matrix) {
        if (matrix.length == 1) {
            return matrix[0][0];
        }
        int determinantValue = 0;
        for (int i = 0; i < matrix.length; ++i) {
            int[][] smaller = new int[matrix.length - 1][matrix.length - 1];
            for (int a = 1; a < matrix.length; ++a) {
                for (int b = 0; b < matrix.length; ++b) {
                    if (b < i) {
                        smaller[a - 1][b] = matrix[a][b];
                        continue;
                    }
                    if (b <= i) continue;
                    smaller[a - 1][b - 1] = matrix[a][b];
                }
            }
            determinantValue += (i % 2 == 0 ? 1 : -1) * matrix[0][i] * GraphSimpleUndirected.determinant(smaller);
        }
        return determinantValue;
    }

    public static long[][] product(long[][] m1, long[][] m2) {
        int n = m2.length;
        Kit.control(m1[0].length == n);
        long[][] m = new long[m1.length][m2[0].length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                int sum = 0;
                for (int k = 0; k < n; ++k) {
                    sum = (int)((long)sum + m1[i][k] * m2[k][j]);
                }
                m[i][j] = sum;
            }
        }
        return m;
    }

    public static int[][] transposee(int[][] m) {
        int[][] p = new int[m[0].length][m.length];
        for (int i = 0; i < p.length; ++i) {
            for (int j = 0; j < p[i].length; ++j) {
                p[i][j] = m[j][i];
            }
        }
        return p;
    }

    public static int[][] quadratique1(int[][] m) {
        int[][] p = new int[m.length][m.length];
        for (int i = 0; i < p.length; ++i) {
            for (int j = 0; j < p[i].length; ++j) {
                int sum = 0;
                for (int k = 0; k < m[0].length; ++k) {
                    sum += m[i][k] * m[j][k];
                }
                m[i][j] = sum;
            }
        }
        return p;
    }

    public static int[][] quadratique2(int[][] m) {
        int[][] p = new int[m[0].length][m[0].length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                int sum = 0;
                for (int k = 0; k < m[0].length; ++k) {
                    sum += m[k][i] * m[k][j];
                }
                m[i][j] = sum;
            }
        }
        return p;
    }

    public int[] degrees() {
        if (this.cacheDegrees == null) {
            this.cacheDegrees = IntStream.range(0, this.nNodes).map(i -> (int)IntStream.range(0, this.nNodes).filter(j -> this.adjacency[i][j] == 1L).count()).toArray();
        }
        return this.cacheDegrees;
    }

    public int[] getNodesWithDegreeLT(int v) {
        return IntStream.range(0, this.nNodes).filter(i -> this.degrees()[i] < v).toArray();
    }

    public GraphSimpleUndirected(int nNodes, long[][] adjacency) {
        this.nNodes = nNodes;
        this.adjacency = adjacency;
        this.nEdges = -1;
    }

    public GraphSimpleUndirected(int nNodes, List<int[]> edges) {
        this.nNodes = nNodes;
        this.nEdges = edges.size();
        this.adjacency = new long[nNodes][nNodes];
        for (int[] t : edges) {
            this.adjacency[t[0]][t[1]] = 1L;
            this.adjacency[t[1]][t[0]] = 1L;
        }
    }

    public GraphSimpleUndirected(GraphSimpleUndirected g1, GraphSimpleUndirected g2) {
        Kit.control(g1.nNodes == g2.nNodes);
        this.nNodes = g1.nNodes;
        this.adjacency = new long[this.nNodes][this.nNodes];
        long[][] m1 = g1.adjacency;
        long[][] m2 = g2.adjacency;
        for (int i = 0; i < this.nNodes; ++i) {
            for (int j = 0; j <= i; ++j) {
                int sum = 0;
                for (int k : g1.nodesAtDistance1[i]) {
                    sum = (int)((long)sum + m1[i][k] * m2[k][j]);
                }
                long l = sum;
                this.adjacency[j][i] = l;
                this.adjacency[i][j] = l;
            }
        }
        this.nEdges = -1;
    }

    public int[][] computeNodesAtDistance1() {
        this.nodesAtDistance1 = new int[this.nNodes][];
        for (int i = 0; i < this.nNodes; ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int j = 0; j < this.nNodes; ++j) {
                if (i == j || this.adjacency[i][j] == 0L) continue;
                list.add(j);
            }
            this.nodesAtDistance1[i] = Kit.intArray(list);
        }
        return this.nodesAtDistance1;
    }

    public int[][] computeNodesAtDistance2() {
        this.nodesAtDistance2 = new int[this.nNodes][];
        for (int i = 0; i < this.nNodes; ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            block1: for (int j = 0; j < this.nNodes; ++j) {
                if (i == j) continue;
                for (int k = 0; k < this.nNodes; ++k) {
                    if (k == i || k == j || this.adjacency[i][k] == 0L || this.adjacency[j][k] == 0L) continue;
                    list.add(j);
                    continue block1;
                }
            }
            this.nodesAtDistance2[i] = Kit.intArray(list);
        }
        return this.nodesAtDistance2;
    }

    public int[][] computeNodesAtDistance1And2() {
        this.nodesAtDistance1And2 = new int[this.nNodes][];
        for (int i = 0; i < this.nNodes; ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            block1: for (int j = 0; j < this.nNodes; ++j) {
                if (i == j || this.adjacency[i][j] == 0L) continue;
                for (int k = 0; k < this.nNodes; ++k) {
                    if (k == i || k == j || this.adjacency[i][k] == 0L || this.adjacency[j][k] == 0L) continue;
                    list.add(j);
                    continue block1;
                }
            }
            this.nodesAtDistance1And2[i] = Kit.intArray(list);
        }
        return this.nodesAtDistance1And2;
    }

    public GraphSimpleUndirected copy() {
        return new GraphSimpleUndirected(this.nNodes, (long[][])Stream.of(this.adjacency).map(t -> (long[])t.clone()).toArray(x$0 -> new long[x$0][]));
    }

    public int[][] edges(boolean includingSymmetrical) {
        return (int[][])IntStream.range(0, this.nNodes).mapToObj(i -> IntStream.range(includingSymmetrical ? 0 : i + 1, this.nNodes).filter(j -> i != j && this.adjacency[i][j] == 1L).mapToObj(j -> new int[]{i, j})).flatMap(s -> s).toArray(x$0 -> new int[x$0][]);
    }

    public int[] selfLoops() {
        return IntStream.range(0, this.nNodes).filter(i -> this.adjacency[i][i] == 1L).toArray();
    }

    public int[] neighborsOf(int i) {
        return IntStream.range(0, this.nNodes).filter(j -> this.adjacency[i][j] == 1L).toArray();
    }

    public String toString() {
        return this.nNodes + " \n" + Kit.join((Object)this.adjacency, new String[0]) + "\n" + IntStream.range(0, this.nNodes).mapToObj(i -> "Node " + i + " : " + Utilities.join((Object)this.neighborsOf(i))).collect(Collectors.joining("\n"));
    }

    void visit(int node, int parent) {
        this.visited[node] = 1;
        this.stack[++this.top] = node;
        for (int i = 0; i < this.adjacency[node].length; ++i) {
            if (this.adjacency[node][i] != 1L || this.visited[i] == 2 || i == parent) continue;
            if (this.visited[i] == 1) {
                int nbCycleNodes = 0;
                this.tmp[nbCycleNodes++] = this.stack[this.top];
                for (int j = this.top - 1; j >= 0; --j) {
                    this.tmp[nbCycleNodes++] = this.stack[j];
                    if (this.stack[j] == i) break;
                }
                int[] cycle = new int[nbCycleNodes];
                System.arraycopy(this.tmp, 0, cycle, 0, nbCycleNodes);
                this.cycles.add(cycle);
                continue;
            }
            this.visit(i, node);
        }
        this.visited[node] = 2;
        --this.top;
    }

    public void cycles() {
        this.tmp = new int[this.nNodes];
        this.stack = new int[this.nNodes];
        this.visited = new int[this.nNodes];
        this.cycles = new ArrayList<int[]>();
        for (int i = 0; i < this.nNodes; ++i) {
            if (this.visited[i] != 0) continue;
            this.visit(i, -1);
        }
        Kit.log.finest(() -> Kit.join((Object)Kit.intArray2D(this.cycles), new String[0]));
    }
}

