/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.panels;

import executables.Resolution;
import heuristics.values.HeuristicValues;
import heuristics.values.HeuristicValuesDirect;
import heuristics.values.HeuristicValuesDynamic;
import heuristics.values.HeuristicValuesFixed;
import heuristics.values.direct.First;
import heuristics.values.dynamic.SumMinCosts;
import heuristics.values.fixed.SampledConflicts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.xcsp.common.Types;
import search.backtrack.SolverBacktrack;
import tools.remote.Remote;
import utility.Reflector;
import variables.Variable;

public class PanelHeuristicsVal
extends JPanel {
    private static final String HEURISTIC = "Value Heuristic :";
    private static final String SELECT_ALL = "Select all";
    private static final String SELECT_NONE = "Select none";
    private static final String STATIC = "Static Heuristic";
    private static final String DYNAMIC = "Dynamic Heuristic";
    private static final String RAW = "Raw Heuristic";
    private static final String OPTIMIZATION_TYPE = "Optimization Type :";
    private static final String APPLY = "Apply";
    private Remote remote;
    private JRadioButton staticRadio;
    private JRadioButton dynamicRadio;
    private JRadioButton rawRadio;
    private JComboBox<String> hrsCombo;
    private JComboBox<Types.TypeOptimization> optCombo;
    private JPanel variablesPanel;
    private JCheckBox[] checks;
    private JCheckBox allCheck;
    private JCheckBox noneCheck;
    private String[] staticList = Remote.getArrayFrom(SampledConflicts.class, HeuristicValuesFixed.class.getName(), false);
    private String[] dynamicList = Remote.getArrayFrom(SumMinCosts.class, HeuristicValuesDynamic.class.getName(), false);
    private String[] rawList = Remote.getArrayFrom(First.class, HeuristicValuesDirect.class.getName(), false);

    public PanelHeuristicsVal(Remote remote) {
        this.remote = remote;
        this.setLayout(new BoxLayout(this, 1));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(1, 2));
        JPanel variablePanel = new JPanel(new BorderLayout());
        variablePanel.setBorder(new TitledBorder("Variables"));
        this.variablesPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(this.variablesPanel, 22, 30);
        this.variablesPanel.setLayout(new BoxLayout(this.variablesPanel, 1));
        variablePanel.add((Component)scrollPane, "Center");
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new GridLayout(2, 1));
        this.allCheck = new JCheckBox(SELECT_ALL);
        selectPanel.add(this.allCheck);
        this.noneCheck = new JCheckBox(SELECT_NONE);
        selectPanel.add(this.noneCheck);
        this.allCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PanelHeuristicsVal.this.checks != null) {
                    for (JCheckBox check : PanelHeuristicsVal.this.checks) {
                        check.setSelected(true);
                    }
                }
                if (PanelHeuristicsVal.this.allCheck.isSelected()) {
                    PanelHeuristicsVal.this.noneCheck.setSelected(false);
                }
            }
        });
        this.noneCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PanelHeuristicsVal.this.checks != null) {
                    for (JCheckBox check : PanelHeuristicsVal.this.checks) {
                        check.setSelected(false);
                    }
                }
                if (PanelHeuristicsVal.this.noneCheck.isSelected()) {
                    PanelHeuristicsVal.this.allCheck.setSelected(false);
                }
            }
        });
        variablePanel.add((Component)selectPanel, "South");
        mainPanel.add(variablePanel);
        JPanel heuristicPanel = new JPanel(new BorderLayout());
        heuristicPanel.setBorder(new TitledBorder("Heuristic"));
        JPanel radioPanel = new JPanel();
        ButtonGroup g = new ButtonGroup();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PanelHeuristicsVal.this.updateListOfHeuristics();
            }
        };
        this.staticRadio = Remote.addRadio(STATIC, g, radioPanel, listener);
        this.dynamicRadio = Remote.addRadio(DYNAMIC, g, radioPanel, listener);
        this.rawRadio = Remote.addRadio(RAW, g, radioPanel, listener);
        this.dynamicRadio.setSelected(true);
        heuristicPanel.add((Component)radioPanel, "North");
        JPanel hrsPanel = new JPanel();
        hrsPanel.add(new JLabel(HEURISTIC));
        this.hrsCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.dynamicList));
        hrsPanel.add(this.hrsCombo);
        heuristicPanel.add((Component)hrsPanel, "Center");
        JPanel optPanel = new JPanel();
        optPanel.add(new JLabel(OPTIMIZATION_TYPE));
        this.optCombo = new JComboBox<Types.TypeOptimization>(new DefaultComboBoxModel<Types.TypeOptimization>(Types.TypeOptimization.values()));
        optPanel.add(this.optCombo);
        heuristicPanel.add((Component)optPanel, "South");
        mainPanel.add(heuristicPanel);
        this.add(mainPanel);
        JPanel applyPanel = new JPanel();
        ((JButton)applyPanel.add(new JButton(APPLY))).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PanelHeuristicsVal.this.applyChanges();
            }
        });
        this.add(applyPanel);
    }

    public void applyChanges() {
        Resolution resolution = this.remote.resolution;
        if (resolution != null && resolution.solver instanceof SolverBacktrack) {
            resolution.cp.valh.classForValHeuristic = this.hrsCombo.getSelectedItem().toString();
            for (int i = 0; i < this.checks.length; ++i) {
                Variable var = resolution.solver.pb.variables[i];
                if (!this.checks[i].isSelected()) continue;
                HeuristicValues newH = Reflector.buildObject(resolution.cp.valh.classForValHeuristic, HeuristicValues.class, var, false);
                System.out.println("\n   MODIF : Value Heuristics for variable " + var + " is now " + this.hrsCombo.getSelectedItem() + " with " + this.optCombo.getSelectedItem());
                var.heuristicVal = newH;
            }
        }
    }

    public void solverStarted() {
        Resolution resolution = this.remote.resolution;
        if (resolution != null && resolution.solver instanceof SolverBacktrack) {
            Variable[] vars = resolution.solver.pb.variables;
            this.checks = new JCheckBox[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                this.checks[i] = new JCheckBox(vars[i].id());
                this.checks[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        PanelHeuristicsVal.this.allCheck.setSelected(false);
                        PanelHeuristicsVal.this.noneCheck.setSelected(false);
                    }
                });
                this.variablesPanel.add(this.checks[i]);
            }
            HeuristicValues hrs = vars[0].heuristicVal;
            JRadioButton radio = hrs instanceof HeuristicValuesFixed ? this.staticRadio : (hrs instanceof HeuristicValuesDynamic ? this.dynamicRadio : this.rawRadio);
            radio.setSelected(true);
            this.hrsCombo.setSelectedItem(hrs.getClass().getSimpleName());
            this.repaint();
        }
    }

    public void updateListOfHeuristics() {
        this.hrsCombo.setModel(new DefaultComboBoxModel<String>(this.staticRadio.isSelected() ? this.staticList : (this.dynamicRadio.isSelected() ? this.dynamicList : this.rawList)));
        this.repaint();
    }
}

