/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.panels;

import constraints.Constraint;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.stream.Stream;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import tools.remote.Remote;

public class PanelConstraints
extends JPanel {
    private static final String ACTIVE_CONSTRAINTS = "Active constraints";
    private static final String INACTIVE_CONSTRAINTS = "Inactive constraints";
    private static final String DESACTIVATE = ">";
    private static final String REACTIVATE = "<";
    private Remote remote;
    private DefaultListModel<Constraint> activeModel = new DefaultListModel();
    private DefaultListModel<Constraint> inactiveModel = new DefaultListModel();
    private JList<Constraint> activeList = new JList<Constraint>(this.activeModel);
    private JList<Constraint> inactiveList = new JList<Constraint>(this.inactiveModel);

    public PanelConstraints(Remote remote) {
        this.remote = remote;
        JPanel activePanel = new JPanel();
        activePanel.setBorder(new TitledBorder(ACTIVE_CONSTRAINTS));
        activePanel.add(new JScrollPane(this.activeList)).setPreferredSize(new Dimension(200, 200));
        this.add(activePanel);
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 10, 10));
        ((JButton)buttonPanel.add(new JButton(DESACTIVATE))).addActionListener(arg0 -> {
            for (int index : this.activeList.getSelectedIndices()) {
                Constraint c = this.activeModel.getElementAt(index);
                c.ignored = true;
                this.activeModel.removeElement(c);
                this.inactiveModel.addElement(c);
                System.out.println("\nMODIF : Desactivated constraint " + c);
            }
        });
        ((JButton)buttonPanel.add(new JButton(REACTIVATE))).addActionListener(arg0 -> {
            for (int index : this.inactiveList.getSelectedIndices()) {
                Constraint c = this.inactiveModel.getElementAt(index);
                c.ignored = false;
                this.inactiveModel.removeElement(c);
                this.activeModel.addElement(c);
                System.out.println("\nMODIF : Activated constraint " + c);
            }
        });
        this.add(buttonPanel);
        JPanel inactivePanel = new JPanel();
        inactivePanel.setBorder(new TitledBorder(INACTIVE_CONSTRAINTS));
        inactivePanel.add(new JScrollPane(this.inactiveList)).setPreferredSize(new Dimension(200, 200));
        this.add(inactivePanel);
    }

    public void solverStarted() {
        if (this.remote.resolution != null) {
            Stream.of(this.remote.resolution.problem.constraints).forEach(c -> this.activeModel.addElement((Constraint)c));
        }
    }
}

