/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.listeners;

import executables.Resolution;
import java.awt.Color;
import tools.remote.listeners.ObserverRemoteVoid;
import tools.remote.visualization.Tracing;
import variables.Variable;

public class ObserverDomains
extends ObserverRemoteVoid {
    private Resolution resolution;
    private Tracing tracingPositive;
    private Tracing tracingNegative;

    public ObserverDomains(Tracing tracingPositive, Tracing tracingNegative, Resolution resolution) {
        this.resolution = resolution;
        this.tracingPositive = tracingPositive;
        this.tracingNegative = tracingNegative;
    }

    @Override
    public void onRemoved(Variable x, int a) {
        this.tracingPositive.removePoint(x.num, a);
        double ratio = Math.log((double)this.resolution.solver.depth() / (double)this.resolution.problem.variables.length + 1.0) / Math.log(2.0);
        int red = 122 + (int)(255.0 * ratio / 2.0);
        int green = (int)(255.0 - 255.0 * ratio) / 3;
        int blue = (int)(255.0 - 255.0 * ratio);
        this.tracingNegative.addPoint(x.num, a, new Color(red, green, blue));
    }

    @Override
    public void onAssigned(Variable x, int a) {
        for (int i = 0; i < x.dom.initSize(); ++i) {
            this.tracingNegative.removePoint(x.num, i);
            this.tracingPositive.removePoint(x.num, i);
        }
        this.tracingPositive.addPoint(x.num, a);
    }

    @Override
    public void onBacktrack() {
        this.resolution.solver.futVars.execute(x -> {
            int a = x.dom.first();
            while (a != -1) {
                this.tracingNegative.removePoint(x.num, a);
                a = x.dom.next(a);
            }
        });
    }

    @Override
    public void onSolutionFound() {
        this.tracingNegative.clean();
        this.tracingPositive.clean();
        int[] model = this.resolution.solver.solManager.lastSolution;
        for (int i = 0; i < model.length; ++i) {
            this.tracingPositive.addPoint(i, model[i]);
        }
    }
}

