/*
 * Decompiled with CFR 0.152.
 */
package tools.output;

import constraints.Constraint;
import constraints.CtrHard;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Scanner;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import problems.xcsp2.XCSP2;
import search.backtrack.DecisionRecorder;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;

public class Graphviz {
    private static final String EMPTY_LABEL = " [label=\"\",width=.4,height=.4,fillcolor=lightblue,style=filled] ;";
    private static String GREEN = "green2";
    private static String RED = "red";
    private static String GREY = "grey90";
    private static String[] BLUES = new String[]{"aquamarine2", "aquamarine4", "blue2", "blue4", "cyan2", "cyan4", "purple1", "purple4", "royalblue1", "royalblue3"};
    private static GraphType graphType = GraphType.PRIMAL;
    private static FilterType filterType = FilterType.NEATO;
    private static int countdown = 1;
    private static boolean displayAll = true;
    private static boolean automaticSave = true;
    private static int automaticIncrementCountdown = 1;
    private static int automaticCnt = 0;
    private static int[] variableIndices;

    private static String computeColorFrom(long weight) {
        if (weight == 0L) {
            return "\"#FFFFFF\",color=white";
        }
        if (weight > 255L) {
            return "\"#0000FF\"";
        }
        weight = 255L - weight;
        String convertion = Long.toHexString(weight);
        String s = weight > 255L ? "FF" : (weight < 15L ? "0" + convertion : convertion);
        return "\"#" + s + s + "FF\"";
    }

    private static long computeWeightColorOf(Variable x) {
        return (int)x.wdeg - x.staticDegree();
    }

    private static void constraintGraph(Problem pb, PrintWriter out) {
        Kit.control(Stream.of(pb.constraints).allMatch(c -> c.scp.length == 2), () -> "Must be applied on binary CNs");
        boolean weightVisualisation = false;
        out.println("graph G {");
        out.println("rankdir=TB ;");
        out.println("ranksep=1 ;");
        for (Variable variable : pb.variables) {
            if (variable.isAssigned() && !displayAll) continue;
            if (weightVisualisation) {
                out.println("  " + variable.defaultId() + " [style=filled,fillcolor=" + Graphviz.computeColorFrom(Graphviz.computeWeightColorOf(variable)) + "] ;");
                continue;
            }
            out.println("  " + variable.defaultId() + " [style=filled,fillcolor=" + (variable.isAssigned() ? GREEN + ",label=\"" + variable + "=" + variable.dom.uniqueValue() + "\"" : "white") + "] ;");
        }
        for (Comparable<Variable> comparable : pb.constraints) {
            Variable x = ((Constraint)comparable).scp[0].num < ((Constraint)comparable).scp[1].num ? ((Constraint)comparable).scp[0] : ((Constraint)comparable).scp[1];
            Variable y = ((Constraint)comparable).scp[0] == x ? ((Constraint)comparable).scp[1] : ((Constraint)comparable).scp[0];
            String edge = "  " + x.defaultId() + " -- " + y.defaultId();
            if (weightVisualisation && Graphviz.computeWeightColorOf(x) == 0L && Graphviz.computeWeightColorOf(y) == 0L) {
                out.println(edge + "[color=white,fillcolor=white];");
                continue;
            }
            out.println(edge + ";");
        }
        out.println("}");
    }

    private static boolean isSelectedVariable(Variable x) {
        return variableIndices == null || IntStream.of(variableIndices).anyMatch(num -> num == x.num);
    }

    private static void interGraph(Problem pb, PrintWriter out) {
        out.println("graph G {");
        out.println("compound=true ;");
        out.println("ranksep=1 ;");
        for (Variable x : pb.variables) {
            int a;
            if (!Graphviz.isSelectedVariable(x)) continue;
            out.println("subgraph cluster" + x.num + " {");
            out.println("label=" + x);
            out.println("labeljust=l");
            out.println("style=filled");
            out.println("color=" + GREY);
            if (variableIndices != null) {
                a = x.dom.first();
                while (a != -1) {
                    out.println("  " + x + "_" + a + " [label=" + a + ",style=filled,fillcolor=lightblue] ;");
                    a = x.dom.next(a);
                }
            } else {
                for (a = 0; a < x.dom.initSize(); ++a) {
                    String node = "  " + x + "_" + a + " [label=" + a + ",style=filled,fillcolor=";
                    if (x.dom.isPresent(a)) {
                        out.println(node + (x.isAssigned() ? GREEN : "white") + "] ;");
                        continue;
                    }
                    if (!displayAll) continue;
                    out.println(node + (x.dom.isRemovedAtLevel(a, 0) ? RED : "orange") + "] ;");
                }
            }
            out.println("}");
        }
        if (variableIndices != null) {
            for (int i = 0; i < variableIndices.length; ++i) {
                Variable x = pb.variables[variableIndices[i]];
                for (int j = i + 1; j < variableIndices.length; ++j) {
                    Variable y = pb.variables[variableIndices[j]];
                    if (!x.isNeighbourOf(y)) continue;
                    String s1 = "cluster" + x.num;
                    String s2 = "cluster" + y.num;
                    out.println(" " + x + "_" + x.dom.first() + " -- " + y + "_" + y.dom.first() + " [ltail=" + s1 + ",lhead=" + s2 + "] ;");
                }
            }
        } else {
            for (int i = 0; i < pb.variables.length; ++i) {
                for (int j = i + 1; j < pb.variables.length; ++j) {
                    if (!pb.variables[i].isNeighbourOf(pb.variables[j])) continue;
                    String s1 = "cluster" + pb.variables[i].num;
                    String s2 = "cluster" + pb.variables[j].num;
                    out.println(" " + pb.variables[i] + "_" + 0 + " -- " + pb.variables[j] + "_" + 0 + " [ltail=" + s1 + ",lhead=" + s2 + "] ;");
                }
            }
        }
        out.println("}");
    }

    private static void primalGraph(Problem pb, PrintWriter out) {
        boolean weightVisualisation = false;
        out.println("graph G {");
        out.println("rankdir=TB ;");
        out.println("ranksep=1 ;");
        for (Variable variable : pb.variables) {
            System.out.println(variable);
            if (variable.isAssigned() && !displayAll) continue;
            if (weightVisualisation) {
                out.println("  " + variable.defaultId() + " [style=filled,fillcolor=" + Graphviz.computeColorFrom((int)variable.wdeg - variable.staticDegree()) + "] ;");
                continue;
            }
            out.println("  " + variable.defaultId() + " [style=filled,fillcolor=" + (variable.isAssigned() ? GREEN + ",label=\"" + variable.defaultId() + "=" + variable.dom.uniqueValue() + "\"" : "white") + "] ;");
        }
        for (Comparable<Variable> comparable : pb.constraints) {
            for (int i = 0; i < ((Constraint)comparable).scp.length - 1; ++i) {
                for (int j = i + 1; j < ((Constraint)comparable).scp.length; ++j) {
                    Variable x = ((Constraint)comparable).scp[i].num < ((Constraint)comparable).scp[j].num ? ((Constraint)comparable).scp[i] : ((Constraint)comparable).scp[j];
                    Variable y = ((Constraint)comparable).scp[i] == x ? ((Constraint)comparable).scp[j] : ((Constraint)comparable).scp[i];
                    String edge = "  " + x.defaultId() + " -- " + y.defaultId();
                    if (weightVisualisation || ((Constraint)comparable).futvars.size() == ((Constraint)comparable).scp.length) {
                        out.println(edge + ";");
                        continue;
                    }
                    if (!displayAll) continue;
                    out.println(edge + "[style=invis] ;");
                }
            }
        }
        out.println("}");
    }

    private static String varName(Problem pb, Variable x) {
        return pb.variables.length > 6 ? x.toString() : (pb.variables.length == 2 ? (x.num == 0 ? "x" : "y") : "" + (char)(122 - (pb.variables.length - x.num - 1)));
    }

    private static void compatibilityGraph(Problem pb, PrintWriter out) {
        Kit.control(Stream.of(pb.constraints).allMatch(c -> c.scp.length == 2), () -> "Must be applied on binary CNs");
        out.println("graph G {");
        out.println("ranksep=1 ;");
        for (Variable x : pb.variables) {
            out.println("subgraph cluster" + x.num + " {");
            out.println("label=" + Graphviz.varName(pb, x));
            out.println("labeljust=l");
            out.println("style=filled");
            out.println("color=" + GREY);
            for (int a = 0; a < x.dom.initSize(); ++a) {
                String node = "  " + Graphviz.varName(pb, x) + "_" + a + " [label=" + a + ",style=filled,fillcolor=";
                if (x.dom.isPresent(a)) {
                    out.println(node + (x.isAssigned() ? GREEN : "white") + "] ;");
                    continue;
                }
                if (!displayAll) continue;
                node = "  " + Graphviz.varName(pb, x) + "_" + a + " [label=" + a + ",style=dotted,fillcolor=";
                out.println(node + (x.dom.isRemovedAtLevel(a, 0) ? RED : "orange") + "] ;");
            }
            out.println("}");
        }
        int cnt = 0;
        for (Constraint c2 : pb.constraints) {
            if (c2.futvars.size() != c2.scp.length && !displayAll || !(c2 instanceof CtrHard)) continue;
            ++cnt;
            Variable x = c2.scp[0];
            Variable y = c2.scp[1];
            for (int a = 0; a < x.dom.initSize(); ++a) {
                for (int b = 0; b < y.dom.initSize(); ++b) {
                    if (!((CtrHard)c2).seekFirstSupportWith(0, a, 1, b)) continue;
                    String edge = "  " + Graphviz.varName(pb, x) + "_" + a + " -- " + Graphviz.varName(pb, y) + "_" + b;
                    if (x.dom.isPresent(a) && y.dom.isPresent(b)) {
                        out.println(edge + (pb.constraints.length < BLUES.length ? " [color=" + BLUES[cnt] + "]  " : "") + ";");
                        continue;
                    }
                    if (!displayAll) continue;
                    out.println(edge + " [style=dotted] ;");
                }
            }
        }
        out.println("}");
    }

    private static void recordDecisions(Problem pb, PrintWriter out) {
        DecisionRecorder dr = ((SolverBacktrack)pb.solver).dr;
        out.println("digraph G {");
        out.println("rankdir=TB ;");
        String previousNode = "root";
        out.println(previousNode + EMPTY_LABEL);
        for (int i = dr.decisions.limit; i >= 0; --i) {
            int dec = dr.decisions.dense[i];
            Variable x = dr.varIn(dec);
            int a = dr.idxIn(dec);
            String currentNode = x.toString() + a;
            String positiveLabel = "\" " + x + " = " + a + "\"";
            if (dec < 0) {
                String currentNodeBis = currentNode + "bis";
                if (dr.isFailedAssignment(i)) {
                    out.println(currentNodeBis + " [shape=plaintext,fontcolor=red,fontname=Helvetica,label=\"X\",fontsize=20] ;");
                } else {
                    out.println(currentNodeBis + " [shape=triangle,fillcolor=orangered,style=filled,labelfloat=true,label=\"...\",width=.6,height=.6] ;");
                }
                out.println("  " + previousNode + " -> " + currentNodeBis + " [label=" + positiveLabel + ",fontsize=12] ;");
                out.println(currentNode + EMPTY_LABEL);
                String negativeLabel = "\" " + x + " != " + a + "\"";
                out.println("  " + previousNode + " -> " + currentNode + " [label=" + negativeLabel + ",fontsize=12] ;");
            } else {
                out.println(currentNode + EMPTY_LABEL);
                out.println("  " + previousNode + " -> " + currentNode + " [label=" + positiveLabel + ",fontsize=12] ;");
            }
            previousNode = currentNode;
        }
        out.println("}");
    }

    public static void saveGraph(Problem pb, String patternForSaving) {
        Throwable throwable;
        if (--countdown != 0) {
            return;
        }
        String prefix = "toto";
        if (pb.api instanceof XCSP2) {
            String s = ((XCSP2)pb.api).name();
            prefix = s.substring(s.lastIndexOf(File.separatorChar) + 1, s.lastIndexOf(".")) + (automaticSave ? "-" + automaticCnt++ : "");
        }
        String dotFileName = prefix + ".dot";
        try {
            throwable = null;
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(dotFileName)));){
                if (graphType == GraphType.INTER) {
                    Graphviz.interGraph(pb, out);
                } else if (graphType == GraphType.PRIMAL) {
                    Graphviz.primalGraph(pb, out);
                } else if (graphType == GraphType.CONSTRAINT) {
                    Graphviz.constraintGraph(pb, out);
                } else if (graphType == GraphType.COMPATIBILITY) {
                    Graphviz.compatibilityGraph(pb, out);
                } else if (graphType == GraphType.DECISIONS) {
                    Graphviz.recordDecisions(pb, out);
                }
                String epsFileName = prefix + ".eps";
                String command = filterType.toString().toLowerCase() + " -Tps " + dotFileName + " -o " + epsFileName;
                Process p = Runtime.getRuntime().exec(command);
                System.out.println("waiting for command: " + command);
                p.waitFor();
                p.exitValue();
                command = "epstopdf " + epsFileName;
                p = Runtime.getRuntime().exec(command);
                p.waitFor();
                p.exitValue();
            }
            catch (Throwable epsFileName) {
                throwable = epsFileName;
                throw epsFileName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!automaticSave) {
            System.out.print("waiting...");
            try {
                throwable = null;
                try (Scanner scanner = new Scanner(System.in);){
                    String s = scanner.nextLine().trim();
                    countdown = s.equals("") ? 1 : Integer.parseInt(s);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            countdown = automaticIncrementCountdown;
        }
    }

    static enum FilterType {
        DOT,
        NEATO,
        TWOPI,
        CIRCO,
        FDP;

    }

    static enum GraphType {
        INTER,
        PRIMAL,
        CONSTRAINT,
        COMPATIBILITY,
        DECISIONS;

    }
}

