/*
 * Decompiled with CFR 0.152.
 */
package search.local.neighborHeuristics;

import org.xcsp.common.Types;
import search.local.SolverLocal;
import search.local.neighborHeuristics.HeuristicNeighbors;
import search.local.neighborHeuristics.TabuManager;
import utility.Reflector;
import variables.Variable;
import variables.domains.Domain;

public abstract class HeuristicNeighborsUnit
extends HeuristicNeighbors {
    protected final TabuManager tabuManager;
    protected final int[] counters;
    protected Variable bestVariable;
    protected int bestIndex;
    protected int bestEvolution;
    protected int localBestEvolution;
    protected Long currentCost = new Long(0L);
    protected long bestCost;
    protected Variable lastAssignedVariable;

    public HeuristicNeighborsUnit(SolverLocal solver) {
        super(solver);
        this.tabuManager = Reflector.buildObject(solver.rs.cp.nghh.classForTabu, TabuManager.class, solver, solver.rs.cp.nghh.tabuListSize);
        this.counters = new int[solver.pb.variables.length];
    }

    protected int selectIndexWithLowestEvolution(Variable x, int evolutionLimit) {
        int tieSize = 0;
        int bestIndex = -1;
        this.localBestEvolution = evolutionLimit;
        this.bestCost = Long.MAX_VALUE;
        Domain dom = x.dom;
        int a = dom.first();
        while (a != -1) {
            block15: {
                int evolution;
                block17: {
                    block16: {
                        evolution = this.solverLocal.conflictManager.computeEvolutionFor(x, a, this.localBestEvolution, this.currentCost);
                        if (evolution > this.localBestEvolution) break block15;
                        if (this.solverLocal.conflictManager.currEvaluation() + evolution >= this.bestEvaluationEverSeen) break block16;
                        this.bestEvaluationEverSeen = this.solverLocal.conflictManager.currEvaluation() + evolution;
                        break block17;
                    }
                    if (this.tabuManager.isTabu(x, a)) break block15;
                }
                if (evolution < this.localBestEvolution) {
                    tieSize = 1;
                    bestIndex = a;
                    this.localBestEvolution = evolution;
                    if (this.solverLocal.pb.framework == Types.TypeFramework.COP) {
                        this.bestCost = this.currentCost;
                    }
                } else {
                    assert (evolution == this.localBestEvolution);
                    if (this.solverLocal.pb.framework == Types.TypeFramework.COP) {
                        if (this.currentCost <= this.bestCost) {
                            if (this.currentCost < this.bestCost) {
                                this.bestCost = this.currentCost;
                                tieSize = 1;
                                bestIndex = a;
                                this.localBestEvolution = evolution;
                            } else {
                                ++tieSize;
                                if (this.random.nextDouble() < 1.0 / (double)tieSize) {
                                    bestIndex = a;
                                }
                            }
                        }
                    } else {
                        ++tieSize;
                        if (this.random.nextDouble() < 1.0 / (double)tieSize) {
                            bestIndex = a;
                        }
                    }
                }
            }
            a = dom.next(a);
        }
        this.currentCost = this.bestCost;
        return bestIndex;
    }

    public abstract void selectNeighbor();

    @Override
    public void setBestNeighbor() {
        this.selectNeighbor();
        this.solverLocal.propagateDependentVariables();
        this.tabuManager.push(this.bestVariable, this.bestIndex);
        this.lastAssignedVariable = this.bestVariable;
        int n = this.bestVariable.num;
        this.counters[n] = this.counters[n] + 1;
        this.solverLocal.conflictManager.recomputeEvaluations();
        assert (this.solverLocal.conflictManager.checkConflictingConstraints());
    }
}

