/*
 * Decompiled with CFR 0.152.
 */
package search.local.neighborHeuristics;

import search.local.SolverLocal;
import search.local.neighborHeuristics.HeuristicNeighborsUnit;
import variables.Variable;

public class BestLocal
extends HeuristicNeighborsUnit {
    public BestLocal(SolverLocal solver) {
        super(solver);
    }

    private Variable selectVariableWithLowestEvaluation() {
        int tieSize = 0;
        Variable bestVariable = null;
        int bestEvaluation = Integer.MAX_VALUE;
        for (Variable x : this.solverLocal.pb.variables) {
            if (x == this.lastAssignedVariable) continue;
            int evaluation = this.solverLocal.conflictManager.currEvaluationOf(x);
            if (evaluation < bestEvaluation) {
                tieSize = 1;
                bestVariable = x;
                bestEvaluation = evaluation;
                continue;
            }
            if (evaluation != bestEvaluation) continue;
            ++tieSize;
            if (!(this.random.nextDouble() < 1.0 / (double)tieSize)) continue;
            bestVariable = x;
        }
        return bestVariable;
    }

    protected boolean randomlySelectNeighbor() {
        if ((double)this.random.nextFloat() < this.solverLocal.rs.cp.nghh.thresholdForRandomVariableSelection) {
            Variable[] variables = this.solverLocal.pb.variables;
            this.bestVariable = variables[this.random.nextInt(variables.length)];
            if ((double)this.random.nextFloat() < this.solverLocal.rs.cp.nghh.thresholdForRandomValueSelection) {
                this.bestIndex = this.bestVariable.dom.random();
                int evaluation = this.solverLocal.conflictManager.currEvaluation() + this.solverLocal.conflictManager.computeEvolutionFor(this.bestVariable, this.bestIndex);
                if (evaluation < this.bestEvaluationEverSeen) {
                    this.bestEvaluationEverSeen = evaluation;
                }
                return !this.tabuManager.isTabu(this.bestVariable, this.bestIndex);
            }
            this.bestIndex = this.selectIndexWithLowestEvolution(this.bestVariable, Integer.MAX_VALUE);
            return true;
        }
        return false;
    }

    @Override
    public void selectNeighbor() {
        if (!this.randomlySelectNeighbor()) {
            this.bestVariable = this.selectVariableWithLowestEvaluation();
            this.bestIndex = this.selectIndexWithLowestEvolution(this.bestVariable, Integer.MAX_VALUE);
        }
    }
}

